<?php

class __shaun_gethere_acp {

	/*
	 creates new menu under settings tab
	 */
	function acp_menu(){
		extract($this->args);
		add_submenu_page('options-general.php', 'Mobile Site', 'Mobile Site', 'switch_themes', $slug, array($this, 'displayoptions'));
	}
	
	
	/*
	 adds the page required to display theme options
	 */
	function displayoptions(){
		$this->get_header();
		$this->get_page();
		$this->get_footer();
	}
	
	
	/*
	 calls the header
	 */
	function get_header(){
		extract($this->args);
		$header	= $dir.DS.'/admin/header.php';
		if(file_exists($header)){
			include($header);
		}
	}
	
	
	/*
	 calls the footer
	 */
	function get_footer(){
		extract($this->args);
		$footer	= $dir.DS.'/admin/footer.php';
		if(file_exists($footer)){
			include($footer);
		}
	}
	
	
	/*
	 calls the theme options page
	  */
	 function get_page(){
	 	extract($this->args);
	 	$list	= array('__getthere' => 'options');
	 	$page	= $dir.DS.'admin'.DS.$list[$_REQUEST['page']].'.php';
		if(file_exists($page)){
			include($page);
		}
		else{
			echo 'No Available Module';
		}
	 }
	 
	 
	/*
	 returns the current value of request option
	 */
	function get_value($name){
		$settings	= $this->args['options'];
		$ret		= trim(stripslashes($settings[$name]));
		return $ret;
	}
	 
	 
	/*
	 creates an input field
	 */
	function input($method, $name, $title, $desc, $options=false){
		$value	= $this->get_value($name);
		$value=htmlspecialchars($value, ENT_QUOTES);

		$pre	= '<li><b>'.$title.'</b><small>'.$desc.'</small>';
		$post	= '</li>';

		switch($method){
			case 'text':
				$ret	= '<input type="text" name="settings['.$name.']" id="'.$name.'" value="'.$value.'" />';
			break;

			case 'textarea':
				$ret	= '<textarea rows="4" cols="20" name="settings['.$name.']" id="'.$name.'" >'.$value.'</textarea>';
			break;
			
			case 'active':
				$ret	= '';
					    $checked='checked';
					    $ret .= '<input type="radio" id="'.$name.'" NAME="settings['.$name.']" VALUE="1" ';
					    if ($value=='1') { $ret .= $checked; }
					    $ret .= '> Yes &nbsp;&nbsp;&nbsp;&nbsp;';
					    $ret .= '<input type="radio" id="'.$name.'" NAME="settings['.$name.']" VALUE="0" ';
					    if ($value=='0') { $ret .= $checked; }
					    $ret .= '> No';
			break;

			case 'themelist':
				$ret	= '<select name=settings['.$name.']" id="'.$name.'">';
				foreach($this->args['themes'] as $val){
					$selected	= ($value == $val) ? ' selected="selected"' : false;
					$ret		.= '<option value="'.$val.'"'.$selected.'>'.ucwords($val).'</option>';
				}
				$ret	.='</select>';
			break;
		}
		
		echo $pre.$ret.$post;
	}
	
	
	/*
	 save or update the settings
	 */
	function process_settings(){
		$post		= $_POST;

		$settings	= array();
		if(isset($post['gethere-settings'])){
			foreach($post['settings'] as $key=>$value){
				$settings[$key] = trim(stripslashes($value));
			}
			update_option('__shaun__gt_settings', $post['settings']);
			
			header("Location: options-general.php?page=__getthere");
			die();
		}
	}
	 
	 
	/*
	 inserts necessary js and css files for acp
	 */
	function enqueue(){
		extract($this->args);
		$u = get_option('siteurl');
		$file_dir=get_bloginfo('template_directory');
		echo "<link rel='stylesheet' id='".$slug."'  href='".$file_dir."/functions/mobile/admin/style.css?ver=".$ver."' type='text/css' media='all' />";
	}
	
	/*
	 inserts hooks and filters
	  */
	function add_hooks(){
		add_action('admin_menu', array($this, 'acp_menu'));
		add_filter('admin_head', array($this, 'enqueue'));
		add_action('admin_init', array($this, 'process_settings'));
	}

	/*
	 default call when class is initialized
	  */
	function __construct($var){
		$this->args	= $var;
		$this->add_hooks();
	}
}
?>