<?php
//mobile section include
require_once('functions/mobile/index.php');

function remove_some_wp_widgets(){
unregister_widget('WP_Widget_Search'); // removes the search widget
unregister_widget('WP_Widget_Recent_Comments'); // removes recent comments widget 
}

add_action('widgets_init','remove_some_wp_widgets', 1);

// header image media upload scripts
if(!defined('WP_THEME_URL')) {
define( 'WP_THEME_URL', get_bloginfo('stylesheet_directory'));
}
function plg_header_upload_admin_scripts() {
	wp_enqueue_script('jquery');
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_register_script('header-upload', WP_THEME_URL.'/upload-header-img.js', array('jquery','media-upload','thickbox'));
	wp_enqueue_script('header-upload');
	wp_enqueue_style('thickbox');
}

if (isset($_GET['page']) && ($_GET['page'] == 'theme-options.php')){
	add_action('admin_print_scripts', 'plg_header_upload_admin_scripts');
}

/*******************************
  CONTACT FORM 
********************************/

 function hexstr($hexstr) {
  $hexstr = str_replace(' ', '', $hexstr);
  $hexstr = str_replace('\x', '', $hexstr);
  $retstr = pack('H*', $hexstr);
  return $retstr;
}

function strhex($string) {
  $hexstr = unpack('H*', $string);
  return array_shift($hexstr);
}

// Testimonials section

class testimonial_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'testimonial_widget', // Base ID
			'Rockstar Testimonials', // Name
			array( 'description' => __( 'A place to put all your rocking testimonials!', 'text_domain' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
?><!-- testimonals begin-->
<div class="widget_top"><h2>Testimonials</h2></div>
<div class="widget_middle" style="min-height:220px;">
<div id="testimonial_rotator">
		<?php query_posts( array ('post_type' => 'testimonial', 'showposts' => 3));if (have_posts()) : while (have_posts()) : the_post(); ?>
			<div class="el">
				<h3><?php the_title();?></h3>
				<span style="float:left;border:5px #fff solid;margin:0 7px 7px 0;"><?php the_post_thumbnail( 'single-post-thumbnail' ); ?></span><?php the_content();?><br style="clear:both;" />
			</div>
			<?php endwhile; endif; wp_reset_query();?>
		</div>
</div>
<div class="clear"></div>
<div class="widget_bottom"></div>
<!-- testimonals end-->
<?php }

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = strip_tags( $new_instance['title'] );

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		
	}

} // class testimonial_Widget

// register testimonial_Widget widget
add_action( 'widgets_init', create_function( '', 'register_widget( "testimonial_widget" );' ) );

add_theme_support( 'post-thumbnails' );
add_image_size( 'single-post-thumbnail', 75, 75 );
add_action('init', 'lwp_custom_init');
function lwp_custom_init() 
{
  $labels = array(
    'name' => _x('Testimonials', 'post type general name'),
    'singular_name' => _x('Testimonial', 'post type singular name'),
    'add_new' => _x('Add New', 'testimonial'),
    'add_new_item' => __('Add New Testimonial'),
    'edit_item' => __('Edit Testimonial'),
    'new_item' => __('New Testimonial'),
    'view_item' => __('View Testimonial'),
    'search_items' => __('Search Testimonials'),
    'not_found' =>  __('No testimonials found'),
    'not_found_in_trash' => __('No testimonials found in Trash'), 
    'parent_item_colon' => ''
  );
  $args = array(
    'labels' => $labels,
    'public' => true,
    'publicly_queryable' => true,
    'show_ui' => true, 
    'query_var' => true,
    'rewrite' => true,
    'capability_type' => 'post',
    'hierarchical' => false,
    'menu_position' => 8.2,
    'supports' => array('title','editor','thumbnail')
  ); 
  register_post_type('testimonial',$args);
}

//add filter to insure the text Testimonial, or testimonial, is displayed when user updates a testimonial 
add_filter('post_updated_messages', 'testimonial_updated_messages');
function testimonial_updated_messages( $messages ) {
  global $post, $post_ID;

  $messages['testimonial'] = array(
    0 => '', // Unused. Messages start at index 1.
    1 => sprintf( __('Testimonial updated. <a href="%s">View testimonial</a>'), esc_url( get_permalink($post_ID) ) ),
    2 => __('Custom field updated.'),
    3 => __('Custom field deleted.'),
    4 => __('Testimonial updated.'),
    /* translators: %s: date and time of the revision */
    5 => isset($_GET['revision']) ? sprintf( __('Testimonial restored to revision from %s'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
    6 => sprintf( __('Testimonial published. <a href="%s">View testimonial</a>'), esc_url( get_permalink($post_ID) ) ),
    7 => __('Testimonial saved.'),
    8 => sprintf( __('Testimonial submitted. <a target="_blank" href="%s">Preview testimonial</a>'), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
    9 => sprintf( __('Testimonial scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview testimonial</a>'),
      // translators: Publish box date format, see http://php.net/date
      date_i18n( __( 'M j, Y @ G:i' ), strtotime( $post->post_date ) ), esc_url( get_permalink($post_ID) ) ),
    10 => sprintf( __('Testimonial draft updated. <a target="_blank" href="%s">Preview testimonial</a>'), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
  );

  return $messages;
}
//display contextual help for Testimonials
add_action( 'contextual_help', 'add_help_text', 10, 3 );
function add_help_text($contextual_help, $screen_id, $screen) { 
  //$contextual_help .= var_dump($screen); // use this to help determine $screen->id
  if ('testimonial' == $screen->id ) {
    $contextual_help =
      '<p>' . __('Things to remember when adding or editing a testimonial:') . '</p>' .
      '<ul>' .
      '<li>' . __('Specify the correct manufacturer such as Mystery, or Historic.') . '</li>' .
      '<li>' . __('Specify the correct testimonial_type of the testimonial.  Remember that the Author module refers to you, the author of this testimonial review.') . '</li>' .
      '</ul>' .
      '<p>' . __('If you want to schedule the testimonial review to be published in the future:') . '</p>' .
      '<ul>' .
      '<li>' . __('Under the Publish module, click on the Edit link next to Publish.') . '</li>' .
      '<li>' . __('Change the date to the date to actual publish this article, then click on Ok.') . '</li>' .
      '</ul>' .
      '<p><strong>' . __('For more information:') . '</strong></p>' .
      '<p>' . __('<a href="http://codex.wordpress.org/Posts_Edit_SubPanel" target="_blank">Edit Posts Documentation</a>') . '</p>' .
      '<p>' . __('<a href="http://wordpress.org/support/" target="_blank">Support Forums</a>') . '</p>' ;
  } elseif ( 'edit-testimonial' == $screen->id ) {
    $contextual_help = 
      '<p>' . __('This is the help screen displaying the table of testimonials.') . '</p>' ;
  }
  return $contextual_help;
}

function get_testimonial_search_query(){}

//end testimonials section


// Widget Titles

function parse_html_widget_title( $text ) {
    if ($text=='') {
       return '&nbsp;';
    } else {
       return $text;
    }
}
add_filter('widget_title', 'parse_html_widget_title', 11);

// End Widget Titles


// Custom Menu

add_action('init', 'register_custom_menu');
 
function register_custom_menu() {
  register_nav_menus(array (
	'custom_menu' => 'Custom Menu',
	'custom_footer_menu' => 'Custom Footer Menu'
) );

}





// Copyright Link... Automatically updates

function dg_copyright($text, $year = '') {
    // We need to know the current year so we can compare it to the start
    $current    = date('Y');
 
    // Figure out what the year part of the message should be
    if(empty($year)) {
        $year   = $current;
    } else if($year != $current) {
        $year   = "$year-$current";
    }
 
    return sprintf($text, $year);
}

// Register Sidebar

if ( function_exists('register_sidebars') )
register_sidebar(array(
	'name'=>'Sidebar',
	'id'=>'Sidebar',
	'description' => 'Sidebar',
	'before_widget' => '',
	'after_widget' => '						</div>
							<div class="widget_bottom"></div><div class="clear"></div>',
	'before_title' => '<div class="widget_top">
								<h2>',
	'after_title' => '</h2>
							</div>
								<div class="widget_middle">
						',
));

// Theme options

$functions_path = TEMPLATEPATH . '/functions/';
//Theme Options
require_once ($functions_path . 'theme-options.php');


?>