jQuery( document ).ready(function( $ ) {

	$( '#p1cm_significant-words-count' ).hide(0);
	
	$( '#p1cm_cb-text-content-process' ).click(function() {
		jQuery.post( ajaxurl, {
			action : 'p1cm-content-builder-process',
			content : $( '#p1cm_cb-text-content' ).val(),
			primary_keywords : $( '#p1cm-primary-keywords' ).val(),
			secondary_keywords1 : $( '#p1cm-secondary-keywords1' ).val(),
			secondary_keywords2 : $( '#p1cm-secondary-keywords2' ).val(),
			secondary_keywords3 : $( '#p1cm-secondary-keywords3' ).val(),
			secondary_keywords4 : $( '#p1cm-secondary-keywords4' ).val()
		}, function( response ) {
            var data = jQuery.parseJSON( response );
            console.log(data);
            
            $( '#p1cm_significant-words-count strong' ).html( data.words_count );

            if ( data.primary_keywords_count != false ) {
            	$( '#p1cm-primary-keywords-count' ).html( data.primary_keywords_count );
            } else {
            	$( '#p1cm-primary-keywords-count' ).html( '' );
            }
            
            if ( data.secondary_keywords1_count != false ) {
            	$( '#p1cm-secondary-keywords1-count' ).html( data.secondary_keywords1_count );
            } else {
            	$( '#p1cm-secondary-keywords1-count' ).html( '' );
            }
            
            if ( data.secondary_keywords2_count != false ) {
            	$( '#p1cm-secondary-keywords2-count' ).html( data.secondary_keywords2_count );
            } else {
            	$( '#p1cm-secondary-keywords2-count' ).html( '' );
            }
            
            if ( data.secondary_keywords3_count != false ) {
            	$( '#p1cm-secondary-keywords3-count' ).html( data.secondary_keywords3_count );
            } else {
            	$( '#p1cm-secondary-keywords3-count' ).html( '' );
            }
            
            if ( data.secondary_keywords4_count != false ) {
            	$( '#p1cm-secondary-keywords4-count' ).html( data.secondary_keywords4_count );
            } else {
            	$( '#p1cm-secondary-keywords4-count' ).html( '' );
            }
            
            var $sig_table_body = $( '#p1cm-significance-table' ).find ( 'tbody' );
            $sig_table_body.empty();
            
            for ( var index = 0; index < 10; ++index ) {
            	$row = $( '<tr></tr' );
            	
            	if ( index < data.words_list.length ) {
            		$row.append( $( '<td>' + data.words_list[ index ].keyword + '</td><td>' + data.words_list[ index ].count + '</td>' ) );
            	} else {
            		$row.append( $( '<td></td><td></td>' ) );
            	}
            	
            	if ( index < data.suggested_words_list.length ) {
            		$row.append( $( '<td>' + data.suggested_words_list[ index ].keyword + '</td><td>' + data.suggested_words_list[ index ].count + '</td>' ) );
            	} else {
            		$row.append( $( '<td></td><td></td>' ) );
            	}
            	
            	$sig_table_body.append( $row );
            }
		});
	});
	
	$( '#p1cm-cb-reset' ).click(function() {
		$( '#p1cm-cb-confirm-reset-modal' ).modal( 'show' );
	});
	
	$( '#p1cm-cb-confirm-reset' ).click(function() {
		$( '#p1cm_cb-text-content' ).val( '' );
		
		$( '#p1cm-primary-keywords' ).val( '' );
		$( '#p1cm-secondary-keywords1' ).val( '' );
		$( '#p1cm-secondary-keywords2' ).val( '' );
		$( '#p1cm-secondary-keywords3' ).val( '' );
		$( '#p1cm-secondary-keywords4' ).val( '' );
		
		$( '#p1cm-primary-keywords-count' ).html( '' );
		$( '#p1cm-secondary-keywords1-count' ).html( '' );
		$( '#p1cm-secondary-keywords2-count' ).html( '' );
		$( '#p1cm-secondary-keywords3-count' ).html( '' );
		$( '#p1cm-secondary-keywords4-count' ).html( '' );
		
		$( '#p1cm-significance-table' ).find( 'tbody' ).empty();
		
		$( '#p1cm-cb-confirm-reset-modal' ).modal( 'hide' );
	});
	
});
