<?php

define( 'DASHNEX_VIEW_DIR', dirname( __FILE__ ) . '/views/configure/' );

add_action( 'admin_menu', 'dashnex_admin_menu' );
function dashnex_admin_menu() {
	add_menu_page(
		'DashNex',
		'DashNex',
		'manage_options',
		'dashnex',
		'dashnex_configure'
	);
}

add_action( 'admin_enqueue_scripts', 'dashnex_admin_enqueue_scripts' );
function dashnex_admin_enqueue_scripts() {
	if ( isSet( $_GET[ 'page' ] ) && $_GET[ 'page' ] == 'dashnex' ) {
		// Namespaced bootstrap scripts and styles are added along with plain version to maintain backwards compatibility
		// Namespaced scripts and styles should be added after plain version

		wp_register_style( 'dashnex-bootstrap', plugins_url( '/assets/vendor/bootstrap/bootstrap.css', __FILE__ ) );
		wp_register_style( 'dashnex-bootstrap-ns', plugins_url( '/assets/vendor/bootstrap/bootstrap-ns.css', __FILE__ ) );
		wp_register_style( 'dashnex-configure', plugins_url( '/assets/css/configure.css', __FILE__ ) );
		wp_enqueue_style( 'dashnex-bootstrap' );
		wp_enqueue_style( 'dashnex-bootstrap-ns' );
		wp_enqueue_style( 'dashnex-configure' );
	}
}

function dashnex_render( $view, $_data = array() ) {
	extract( $_data );
	require( DASHNEX_CONFIGURE_VIEW_DIR . '/' . $view . '.php' );
}

function dashnex_configure() {
	$version_check = version_compare( PHP_VERSION, '5.3.0', '>=' );

        $loaded_extensions = array_map( 'strtolower', get_loaded_extensions() );

	$curl_check = in_array( strtolower( 'curl' ), $loaded_extensions );
	$ioncube_check = in_array( strtolower( 'IonCube Loader' ), $loaded_extensions );
	$extension_check = in_array( strtolower( 'json' ), $loaded_extensions ) &&
            in_array( strtolower( 'PDO' ), $loaded_extensions ) &&
            in_array( strtolower( 'pdo_mysql' ), $loaded_extensions );
	
	$ioncube_version = '';
	if ( $ioncube_check ) {
		if ( ! defined( 'DASHNEX_ENV' ) || DASHNEX_ENV != 'dev' ) {
			$ioncube_check = version_compare( ioncube_loader_version(), '4.4', '>=' );
			$ioncube_version = ioncube_loader_version();
		}
	}

	if ( file_exists( DASHNEX_DATA_DIR ) ) {
		$datadir_check = is_writable( DASHNEX_DATA_DIR );
	} else {
		$datadir_check = is_writable( WP_CONTENT_DIR . '/plugins' );
	}

    // mysql permissions check
    global $wpdb;
    $results = $wpdb->get_results( 'SHOW GRANTS FOR CURRENT_USER', ARRAY_N );
    $mysql_permissions_check = false;
    $dbNameCheck = DB_NAME;
	$dbNameCheckAlt = '`' . str_replace('_', '\_', $dbNameCheck) . '`';

    foreach ($results as $result){

        $isGrantedForThisDatabase =
            strpos( $result[0], "*.*") !== false ||
            strpos( $result[0], "ON $dbNameCheck") !== false ||
            strpos( $result[0], "ON $dbNameCheckAlt") !== false
        ;

        $isGrantedPrivileges =
            strpos($result[0], "ALL PRIVILEGES") !== false ||
            (
                strpos($result[0], "ALTER") !== false &&
                strpos($result[0], "CREATE") !== false
            );

        if ($isGrantedPrivileges && $isGrantedForThisDatabase) {
            $mysql_permissions_check = true;
            break;
        }
    }

	$success = $version_check &&
        $datadir_check &&
        $curl_check &&
        $extension_check  &&
        $mysql_permissions_check
    ;
	
	if ( ! defined( 'DASHNEX_ENV' ) || DASHNEX_ENV != 'dev' ) {
		$success = $success && $ioncube_check;
	}
	
	if ( $success ) {
		dashnex_install();
	}
	
	dashnex_render( 'main', array(
		'success' => $success,
		'version_check' => $version_check,
		'version' => PHP_VERSION,
		'datadir_check' => $datadir_check,
		'data_dir' => DASHNEX_DATA_DIR,
		'ioncube_check' => $ioncube_check,
		'ioncube_version' => $ioncube_version,
		'curl_check' => $curl_check,
		'extension_check' => $extension_check,
        'mysql_permissions_check' => $mysql_permissions_check
	));
}

function dashnex_install() {
	global $wpdb;

	if ( ! file_exists( DASHNEX_CACHE_DIR ) ) {
		mkdir( DASHNEX_CACHE_DIR, 0777, true );
	}
		
	file_put_contents( DASHNEX_DATA_DIR . '/dashnex.php', '<?php define( \'DASHNEX_CONFIGURED\', true );' );
}
