jQuery( document ).ready(function( $ ) {

    // init select2
    var data = $('#keywords').attr('init');
    var chosen = $('#keywords').attr('chosen');

    var select = $('#keywords').select2({
        placeholder: "Select Keyword",
        data: { results: $.parseJSON(data) }
    });

    $(select).on('change', function(){
        $('#keyword-id').val($(select).select2('val'));
    });

    var $assignBox = $('.assign-box');
    var $unAssignBox = $('.unassign-box');

    $assignBox.find('#assign').on('click', function(e) {
        e.preventDefault();

        if ($(select).select2('val')) {
            $assignBox.find('.spinner').show();

            $.ajax({
                url : ajaxurl,
                data: {
                    action: $assignBox.data('action'),
                    post_id : $assignBox.data('postId'),
                    keyword_id: $(select).select2('val')
                },
                type: $assignBox.data('method') || 'post',
                success: function(response) {
                    if (response.success) {

                        var categoryId = response.categoryId || 1;

                        $('#categorydiv input:checked').prop('checked', false);
                        $('#category-' + categoryId + ' input').prop('checked', true);
                        $('#in-popular-category-' + categoryId + ' input').prop('checked', true);

                        $assignBox.addClass('hide');
                        $unAssignBox.removeClass('hide');
                        $unAssignBox.find('.keyword').text(response.node.keyword);
                    }
                },
                complete: function() {
                    $assignBox.find('.spinner').hide()
                }
            });
        }
    });
    
    $unAssignBox.find('#unassign').on('click',function(e){
        e.preventDefault();

        $unAssignBox.find('.spinner').show();

        $.ajax({
            url : ajaxurl,
            data: $.extend({
                action: $unAssignBox.data('action'),
                post_id : $unAssignBox.data('postId')
            }, getFormData($unAssignBox)),
            type: $assignBox.data('method') || 'post',
            success: function(response) {
                if (response.success) {
                    $unAssignBox.addClass('hide');
                    $('#categorydiv input:checked').prop('checked', false);
                    $assignBox.removeClass('hide');
                    $('#keyword-id').val('')
                }
            },
            complete: function() {
                $unAssignBox.find('.spinner').hide()
            }
        });
        
    });

    var getFormData = function($form) {
        var result = {};
        $form.find('[type=hidden], [type=radio]:checked').each(function(key, element){
            var name = $(element).attr('name');
            var value = $(element).val();

            if (name && value) {
                result[name] = value;
            }
        });
        return result;
    }
});
