angular.module('dashnex')

    .directive('select2', function () {
        return {
            scope: {
                select2Data: '=',
                select2Model: '=',
                select2Change: '&'
            },
            restrict: 'ECA',

            link: function (scope, element) {

                element.select2({
                    placeholder: "Select Node",
                    data: function() {
                        return { results: scope.select2Data }
                    }
                });

                element.on('change', function(e) {

                    scope.select2Model = e.val;

                    scope.select2Change({
                        id : e.val
                    });

                    scope.$apply();
                });

                scope.$watch(function() { return scope.select2Model ; }, function(newValue) {
                    element.select2('val', newValue)
                });
            }
        };
    });
