<?php

namespace DashNex\SiteManager\Model;

use \Doctrine\ORM\Mapping as ORM;
use \DashNex\SiteManager\Model\CategoryKeywordNode;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_content_keyword_node")
 * @ORM\HasLifecycleCallbacks
 */
class ContentKeywordNode extends SMActionCaller
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string",unique=true)
     */
    protected $keyword;

    /**
     * @ORM\Column(type="integer",nullable=true)
     */
    protected $wp_post_id;

    /**
     * @ORM\ManyToOne(targetEntity="CategoryKeywordNode",inversedBy="content_keywords",cascade={"persist"})
     * @ORM\JoinColumn(name="category_keyword_node_id",referencedColumnName="id", onDelete="CASCADE")
     */
    protected $category_keyword;

    private $wp_post;

    public function __construct()
    {

    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    
        return $this;
    }

    public function getKeyword()
    {
        return $this->keyword;
    }

    public function setKeyword($keyword)
    {
        $this->keyword = $keyword;
    
        return $this;
    }

    public function getWPPostId()
    {
        return $this->wp_post_id;
    }

    public function setWPPostId($id)
    {
        $this->wp_post_id = $id;
        $this->wp_post = null;
    
        return $this;
    }

    /**
     * @return CategoryKeywordNode|null
     */
    public function getCategoryKeyword()
    {
        return $this->category_keyword;
    }

    public function setCategoryKeyword($categoryKeyword)
    {
        if ($categoryKeyword instanceof CategoryKeywordNode) {
            $this->category_keyword = $categoryKeyword;
        }

        return $this;
    }

    public function getWPPost($output = 'OBJECT')
    {
        if ($this->wp_post === null && $this->GetWPPostId() > 0) {
            $this->wp_post = get_post($this->GetWPPostId(), $output);
        } else if (!$this->GetWPPostId() && $this->wp_post) {
            $this->wp_post = null;
        }

        return $this->wp_post;
    }

    /**
     * @ORM\PreRemove
     */
    public function deleteIndicators()
    {
        global $dashnex_service_manager;
        $indicatorIds = $this->GetIndicators(true);
        $indicatorMgr = $dashnex_service_manager->getService('dashnex-indicator-manager');
        $indicatorMgr->Disable($indicatorIds, $this->GetCallerType(), $this->GetId(), true);
    }

    /**
     * @ORM\PostRemove
     */
    public function deleteWPPost()
    {
        if (!$this->GetWPPostId()) {
            return;
        }

        wp_delete_post($this->GetWPPostId(), true);
    }

    // ActionCaller interface methods

    public function getCallerType()
    {
        return 'content-keyword';
    }

    public function getDataArray()
    {
        $data = parent::GetDataArray();
        $data['category_keyword_node_id'] = $this->GetCategoryKeyword()
            ? $this->GetCategoryKeyword()->GetId()
            : null
        ;

        return $data;
    }

    // ActionCaller interface methods END
}
