<?php

namespace DashNex\SiteManager\Model;

class BogusPKNode extends SMActionCaller {

	const OPT_NAME = '_dashnex-bogus-pk-node';

	protected $label;

	protected $primary_keyword;

	public function __construct() {
		$this->init();
	}

	public function GetLabel() {
		return $this->label;
	}

	public function SetLabel($label) {
		$this->label = $label;
		return $this;
	}

	public function GetPrimaryKeyword() {
		return $this->primary_keyword;
	}

	public function SetPrimaryKeyword($keywordNode) {
		if($keywordNode == null || $keywordNode instanceof PrimaryKeywordNode) {
			$this->primary_keyword = $keywordNode;
		}
		return $this;
	}

	// ActionCaller interface methods

	public function GetCallerType() {
		return 'bogus-pk';
	}

	// ActionCaller interface methods END

	public function LoadDataArray($data) {
		if( ! is_array($data)) {
			return;
		}

		if(isset($data['label'])) {
			$this->SetLabel($data['label']);
		}
	}

	public function Save() {
		$data = $this->GetDataArray();
		update_option(self::OPT_NAME, $data);
	}

	protected function init() {
		$opts = get_option(self::OPT_NAME, array());
		$this->LoadDataArray($opts);
		$this->SetPrimaryKeyword(new PrimaryKeywordNode());
	}

}