<?php

namespace DashNex\SiteManager\Model;

class ActionResponse {

	const SIGNAL_SUCCESS 			= 'success';
	const SIGNAL_FAILURE 			= 'failure';
	const SIGNAL_INFO 				= 'info';
	const SIGNAL_REFRESH_TREE		= 'refresh-tree';
	const SIGNAL_REFRESH_DETAILS	= 'refresh-details';
	const SIGNAL_REMOVE				= 'remove';
	const SIGNAL_CREATE				= 'create';
	const SIGNAL_REDIRECT 			= 'redirect';
	const SIGNAL_REFRESH_DATA		= 'refresh-data';
	const SIGNAL_WARNING			= 'warning';
	const SIGNAL_AFTER_CALLBACK		= 'after-callback';
	const SIGNAL_ENABLE_INDICATOR	= 'enable-indicator';
	const SIGNAL_DISABLE_INDICATOR 	= 'disable-indicator';

	public static function GetValidSignals() {
		return array(
			self::SIGNAL_SUCCESS,
			self::SIGNAL_FAILURE,
			self::SIGNAL_INFO,
			self::SIGNAL_REFRESH_TREE,
			self::SIGNAL_REFRESH_DETAILS,
			self::SIGNAL_REMOVE,
			self::SIGNAL_CREATE,
			self::SIGNAL_REDIRECT,
			self::SIGNAL_REFRESH_DATA,
			self::SIGNAL_WARNING,
			self::SIGNAL_AFTER_CALLBACK,
			self::SIGNAL_ENABLE_INDICATOR,
			self::SIGNAL_DISABLE_INDICATOR
		);
	}

	public static function IsSignalValid($signal) {
		return in_array($signal, self::GetValidSignals());
	}

    /** @deprecated use new SuccesResponse() instead */
	public static function CreateSuccessResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_SUCCESS, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new FailureResponse() instead */
	public static function CreateFailureResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_FAILURE, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new InfoResponse() instead */
	public static function CreateInfoResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_INFO, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new RefreshTreeResponse() instead */
	public static function CreateRefreshTreeResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_REFRESH_TREE, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new RefreshDetailsResponse() instead */
	public static function CreateRefreshDetailsResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_REFRESH_DETAILS, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new RemoveResponse() instead */
	public static function CreateRemoveResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_REMOVE, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new CreateResponse() instead */
	public static function CreateCreateResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_CREATE, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new RedirectResponse() instead */
	public static function CreateRedirectResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_REDIRECT, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new RefreshDataResponse() instead */
	public static function CreateRefreshDataResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_REFRESH_DATA, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new WarningResponse() instead */
	public static function CreateWarningResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_WARNING, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new AfterCallbackResponse() instead */
	public static function CreateAfterCallbackResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_AFTER_CALLBACK, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new EnableIndicatorResponse() instead */
	public static function CreateEnableIndicatorResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_ENABLE_INDICATOR, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

    /** @deprecated use new DisableIndicatorResponse() instead */
	public static function CreateDisableIndicatorResponse($message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		return new self(self::SIGNAL_DISABLE_INDICATOR, $message, $data, $callbackActionId, $callbackActionCaller, $callbackActionData);
	}

	public static function IsSuccess($data) {
		if($data instanceof self) {
			return $data->GetSignal() == self::SIGNAL_SUCCESS;
		}
		if(is_array($data)) {
			foreach($data as $res) {
				if($res->GetSignal() == self::SIGNAL_SUCCESS) {
					return true;
				}
			}
		}
		return false;
	}

	public static function IsFailure($data) {
		if($data instanceof self) {
			return $data->GetSignal() == self::SIGNAL_FAILURE;
		}
		if(is_array($data)) {
			foreach($data as $res) {
				if($res->GetSignal() == self::SIGNAL_FAILURE) {
					return true;
				}
			}
		}
		return false;
	}

	protected $signal;
	protected $message;
	protected $data;
	protected $callbackActionId;
	protected $callbackActionCaller;
	protected $callbackActionData;

	public function __construct($signal, $message = '', $data = null, $callbackActionId = '', $callbackActionCaller = null, $callbackActionData = null) {
		$this->SetSignal($signal);
		$this->SetMessage($message);
		$this->SetData($data);
		$this->SetCallbackActionId($callbackActionId);
		$this->SetCallbackActionCaller($callbackActionCaller);
		$this->SetCallbackActionData($callbackActionData);
	}

	public function GetSignal() {
		return $this->signal;
	}

	public function SetSignal($signal) {
		if(self::IsSignalValid($signal)) {
			$this->signal = $signal;
		}

		return $this;
	}

	public function GetMessage() {
		return $this->message;
	}

	public function SetMessage($message) {
		if(is_string($message)) {
			$this->message = $message;
		}

		return $this;
	}

	public function GetData() {
		return $this->data;
	}

	public function SetData($data) {
		$this->data = $data;

		return $this;
	}

	public function GetCallbackActionId() {
		return $this->callbackActionId;
	}

	public function SetCallbackActionId($id) {
		if(is_string($id)) {
			$this->callbackActionId = $id;
		}

		return $this;
	}

	public function GetCallbackActionCaller() {
		return $this->callbackActionCaller;
	}

	public function SetCallbackActionCaller($caller) {
		if($caller === null || $caller instanceof \DashNex\SiteManager\Model\Interfaces\ActionCaller) {
			$this->callbackActionCaller = $caller;
		}

		return $this;
	}

	public function GetCallbackActionData() {
		return $this->callbackActionData;
	}

	public function SetCallbackActionData($data) {
		if(is_array($data)) {
			$this->callbackActionData = $data;
		}

		return $this;
	}

	public function GetDataArray() {
		$data = array(
			'signal'				=> $this->GetSignal(),
			'message' 				=> $this->GetMessage(),
			'data'					=> $this->GetData(),
			'callback_action_id'	=> $this->GetCallbackActionId(),
			'callback_action_caller'=> $this->GetCallbackActionCaller() ? $this->GetCallbackActionCaller()->GetDataArray() : null,
			'callback_action_data'	=> $this->GetCallbackActionData()
		);
		return $data;
	}

}