<?php

namespace DashNex\SiteManager\Model;

class ActionGroup {

	protected $id;
	protected $label;

	private $actions;

	public function __construct($id, $label = '') {
		$this->SetId($id);
		$this->SetLabel($label);
	}

	public function GetId() {
		return $this->id;
	}

	public function SetId($id) {
		if(is_string($id)) {
			$this->id = $id;
		}

		return $this;
	}

	public function GetLabel() {
		return $this->label;
	}

	public function SetLabel($label) {
		if(is_string($label)) {
			$this->label = $label;
		}

		return $this;
	}

	public function GetActions() {
		return $this->actions;
	}

	public function SetActions($actions) {
		$this->actions = $actions;

		return $this;
	}

	public function GetActionsByCallerType($type) {
		$result = array();
		if(is_array($this->actions) && count($this->actions) > 0) {
			foreach($this->actions as $action) {
				if(in_array($type, $action->GetAllowedCallerTypes())) {
					$result[] = $action;
				}
			}
		}

		return $result;
	}

}