<?php

namespace DashNex\SiteManager\Model;

use DashNex\SiteManager\Model\ActionResponse\FailureResponse;

class Action {

	protected $id;
	protected $label;
	protected $icon;
	protected $shortDescription;
	protected $handler;
	protected $allowedCallerTypes;
	protected $groupId;

	public function __construct() {}

	public function GetId() {
		return $this->id;
	}

	public function SetId($id) {
		if(is_string($id)) {
			$this->id = $id;
		}

		return $this;
	}

	public function GetLabel() {
		return $this->label;
	}

	public function SetLabel($label) {
		if(is_string($label)) {
			$this->label = $label;
		}

		return $this;
	}

	public function GetIcon() {
		return $this->icon;
	}

	public function SetIcon($icon) {
		if(is_string($icon)) {
			$this->icon = $icon;
		}

		return $this;
	}

	public function GetShortDescription() {
		return $this->shortDescription;
	}

	public function SetShortDescription($description) {
		if(is_string($description)) {
			$this->shortDescription = $description;
		}

		return $this;
	}

	public function GetHandler() {
		return $this->handler;
	}

	public function SetHandler(array $handler) {
		if(is_array($handler) && 
			isset($handler['service']) && 
			! empty($handler['service']) && 
			isset($handler['method']) &&
			! empty($handler['method'])) {
				$this->handler = $handler;
		}

		return $this;
	}

	public function GetAllowedCallerTypes() {
		return $this->allowedCallerTypes;
	}

	public function SetAllowedCallerTypes(array $types) {
		$this->allowedCallerTypes = $types;

		return $this;
	}

	public function GetGroupId() {
		return $this->groupId;
	}

	public function SetGroupId($id) {
		if(is_string($id)) {
			$this->groupId = $id;
		}

		return $this;
	}

	public function CallHandler($caller, $data = array()) {
		global $dashnex_service_manager;
		if( ! $this->isHandlerValid()) {
			return array(new FailureResponse('Invalid action handler!'));
		}

		$handler = $dashnex_service_manager->getService($this->handler['service']);
		if( ! $handler) {
			return array(new FailureResponse('Action handler service not found!'));
		}
		$method = $this->handler['method'];

		return $handler->$method($caller, $data);
	}

	protected function isHandlerValid() {
		return is_array($this->GetHandler()) &&
				isset($this->handler['service']) &&
				isset($this->handler['method']);
	}

}