<?php

namespace DashNex\Model;

use \Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_proxy_block", uniqueConstraints={@ORM\UniqueConstraint(name="dnc_proxy_service_block", columns={"proxy_id", "service_id"})})
 */
class ProxyBlock
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\ManyToOne(targetEntity="Proxy")
     * @ORM\JoinColumn(name="proxy_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $proxy;

    /**
     * @ORM\Column(type="string")
     */
    protected $service_id;

    /**
     * @ORM\Column(type="datetime")
     */
    protected $created_at;

    public function __construct()
    {
        if ($this->created_at === null) {
            $this->created_at = new \DateTime();
        }
    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    public function getProxy()
    {
        return $this->proxy;
    }

    public function setProxy($proxy)
    {
        if ($proxy === null || $proxy instanceof Proxy) {
            $this->proxy = $proxy;
        }

        return $this;
    }

    public function getServiceId()
    {
        return $this->service_id;
    }

    public function setServiceId($id)
    {
        $this->service_id = $id;

        return $this;
    }

    public function getCreatedAt()
    {
        if ($this->created_at === null) {
            $this->created_at = new \DateTime();
        }

        return $this->created_at;
    }

    public function setCreatedAt($at)
    {
        if ($at === null || $at instanceof \DateTime) {
            $this->created_at = $at;
        }

        return $this;
    }
}
