<?php

namespace DashNex\Model;

use Doctrine\ORM\Mapping AS ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_google_keyword")
 */
class GoogleKeyword
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="AUTO")
	 */
	protected $id;
	
	/**
	 * @ORM\Column(type="string", length=255)
	 */
	protected $name;

    /**
     * @ORM\Column(type="string", length=255)
     */
    protected $trafficVolume;

    /**
     * @ORM\Column(type="string", length=255)
     */
    protected $costPerClick;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $competitionStrength;

	/**
	 * @ORM\ManyToOne(targetEntity="GoogleKeywordGroup", inversedBy="keywords")
	 */
	protected $group;
	
	public function __construct() {
	}

    /**
     * @return mixed
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * @param mixed
     * @return GoogleKeyword
     */
    public function setGroup($group)
    {
        $this->group = $group;

        if (!$this->group->getKeywords()->contains($this))
            $this->group->getKeywords()->add($this);

        return $this;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    public function getCostPerClick()
    {
        return $this->costPerClick;
    }

    public function setCostPerClick($costPerClick)
    {
        $this->costPerClick = $costPerClick;
        return $this;
    }

    public function getTrafficVolume()
    {
        return $this->trafficVolume;
    }

    public function setTrafficVolume($trafficVolume)
    {
        $this->trafficVolume = $trafficVolume;
        return $this;
    }

    public function toJsonObject() {
        $object = new \stdClass();

        $object->id = $this->id;
        $object->name = $this->name;
        $object->trafficVolume = $this->trafficVolume;
        $object->costPerClick = $this->costPerClick;
        $object->competitionStrength = $this->competitionStrength;
        $object->groupId = $this->getGroup()->getId();

        return $object;
    }

    /**
     * @return mixed
     */
    public function getCompetitionStrength()
    {
        return $this->competitionStrength;
    }

    /**
     * @param mixed $competitionStrength
     * @return GoogleKeyword
     */
    public function setCompetitionStrength($competitionStrength)
    {
        $this->competitionStrength = $competitionStrength;

        return $this;
    }


}
